/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.builder.comms.GeneralTransmission;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.LetterFormatHelper;
import gov.va.med.esr.service.FinancialsHelperService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class EnrollTransmission
extends GeneralTransmission {
    private boolean isEgtSet = false;
    private EnrollmentDetermination currentEnrollmentDetermination = null;
    private String mostRecentNonNullPriorityLevel = null;
    private EGTSetting egt = null;
    private boolean isPrimaryVaFacilitySet = false;
    private boolean isPreferredFacilitySet = false;
    private EGTSetting localEgtSetting;
    private IncomeTest localIncomeTest;
    private Address localPimaryVAFacilityAddress;
    private Address localPreferredFacilityAddress;
    private String todaysDatePlus14;
    private String todaysDatePlus21;
    private String todaysDatePlus30;
    private String todaysDatePlus40;
    private String todaysDatePlus60;
    private String todaysDatePlus70;
    private String letter601C60DayDate;
    private String letter624A30DayDate;
    private String letter624A60DayDate;
    private String letter625A30DayDate;
    private String letter625A60DayDate;
    private String effectiveDateOfChange;
    private String egtEffectiveDate;
    private String egtType;
    private String egtSetting;
    private String eligibilityCode;
    private String enrollmentApplicationDate;
    private String enrollmentCategoryCode;
    private String enrollmentEndDate;
    private String currentEnrollmentPriorityLevel;
    private String priorEnrollmentPriorityLevel;
    private String veteranErrorMessage;
    private String rxCopayRequiredText;
    private String gmtCopayRequiredText;
    private String mtCopayRequiredText;
    private String mtDateTimeCompleted;
    private String primaryVACareFacilityNumber = null;
    private IncomeThreshold incomeThreshold;
    private String currentIncomeThresholdYear;
    private String specialCopay;
    private String primiaryCopay;
    private String additional90DaysHospitalCopay;
    private String additional90DaysHospitalMedicareDeductible;
    private String medicareDeductible;
    private String additional90DaysHospitalCopay_20percent;
    private String additional90DaysHospitalMedicareDeductible_20percent;
    private String medicareDeductible_20percent;
    private String rxCopayRate;
    private String incomeYearPropertyThreshold;
    private String primaryVACareFacilityAddrLine1;
    private String primaryVACareFacilityAddrLine2;
    private String primaryVACareFacilityAddrCity;
    private String primaryVACareFacilityAddrState;
    private String primaryVACareFacilityAddrZip;
    private String primaryVACareFacilityAddrCountry;
    private String primaryVACareFacilityAddr;
    private String primaryVACareFacilityName;
    private String preferredFacilityAddrLine1;
    private String preferredFacilityAddrLine2;
    private String preferredFacilityAddrCity;
    private String preferredFacilityAddrState;
    private String preferredFacilityAddrZip;
    private String preferredFacilityAddrCountry;
    private String preferredFacility;
    private String preferredFacilityNumber;
    private String preferredFacilityAddr;
    private FinancialsHelperService financialsHelperService;
    private boolean isIncomeTestSet = false;
    private boolean isRxCopayNonExempt;
    private boolean isMTCopayRequired;
    private boolean isGMTCopayRequired;

    public EnrollTransmission(Person veteran, BigDecimal workflowCaseId) {
        super(veteran, null, workflowCaseId);
    }

    public EnrollTransmission() {
    }

    @Override
    public boolean validate() {
        return super.validate();
    }

    public String externalizeAsXML() {
        return super.externalizeAsXml();
    }

    @Override
    public String getVeteranSsn() {
        this.veteranSsn = super.getVeteranSsn();
        if (this.veteranSsn != null) {
            this.veteranSsn = this.FormatSSN(this.veteranSsn);
        }
        return EnrollTransmission.getString(this.veteranSsn);
    }

    public String getTodayPlus14() {
        if (this.todaysDatePlus14 == null) {
            this.todaysDatePlus14 = LetterFormatHelper.addDays(this.todayDt, 14, sdf);
        }
        return EnrollTransmission.getString(this.todaysDatePlus14);
    }

    public void setTodayPlus14(String todayPlus14) {
        this.todaysDatePlus14 = todayPlus14;
    }

    public String getTodayPlus21() {
        if (this.todaysDatePlus21 == null) {
            this.todaysDatePlus21 = LetterFormatHelper.addDays(this.todayDt, 21, sdf);
        }
        return EnrollTransmission.getString(this.todaysDatePlus21);
    }

    public void setTodayPlus21(String todayPlus21) {
        this.todaysDatePlus21 = todayPlus21;
    }

    public String getTodayPlus30() {
        if (this.todaysDatePlus30 == null) {
            this.todaysDatePlus30 = LetterFormatHelper.addDays(this.todayDt, 30, sdf);
        }
        return EnrollTransmission.getString(this.todaysDatePlus30);
    }

    public void setTodayPlus30(String todayPlus30) {
        this.todaysDatePlus30 = todayPlus30;
    }

    public String getTodayPlus40() {
        if (this.todaysDatePlus40 == null) {
            this.todaysDatePlus40 = LetterFormatHelper.addDays(this.todayDt, 40, sdf);
        }
        return EnrollTransmission.getString(this.todaysDatePlus40);
    }

    public void setTodayPlus40(String todayPlus40) {
        this.todaysDatePlus40 = todayPlus40;
    }

    public String getTodayPlus60() {
        if (this.todaysDatePlus60 == null) {
            this.todaysDatePlus60 = LetterFormatHelper.addDays(this.todayDt, 60, sdf);
        }
        return EnrollTransmission.getString(this.todaysDatePlus60);
    }

    public void setTodayPlus60(String todayPlus60) {
        this.todaysDatePlus60 = todayPlus60;
    }

    public String getTodayPlus70() {
        if (this.todaysDatePlus70 == null) {
            this.todaysDatePlus70 = LetterFormatHelper.addDays(this.todayDt, 70, sdf);
        }
        return EnrollTransmission.getString(this.todaysDatePlus70);
    }

    public void setTodayPlus70(String todayPlus70) {
        this.todaysDatePlus70 = todayPlus70;
    }

    public String getLetter601C60DayDate() {
        CommsLogEntry entry;
        if (this.letter601C60DayDate == null && this.logs != null && this.logs.size() > 0 && (entry = this.getLatestMailingEntryForForm(ComLetterTemplateType.FORM_NUMBER_601C.getCode(), this.logs)) != null) {
            this.letter601C60DayDate = LetterFormatHelper.addDays(entry.getModifiedOn(), 60, sdf);
        }
        return EnrollTransmission.getString(this.letter601C60DayDate);
    }

    public void setLetter601C60DayDate(String dt) {
        this.letter601C60DayDate = dt;
    }

    public String getLetter624A30DayDate() {
        CommsLogEntry entry;
        if (this.letter624A30DayDate == null && this.logs != null && this.logs.size() > 0 && (entry = this.getLatestMailingEntryForForm(ComLetterTemplateType.FORM_NUMBER_624A.getCode(), this.logs)) != null) {
            this.letter624A30DayDate = LetterFormatHelper.addDays(entry.getModifiedOn(), 30, sdf);
        }
        return EnrollTransmission.getString(this.letter624A30DayDate);
    }

    public void setLetter624A30DayDate(String dt) {
        this.letter624A30DayDate = dt;
    }

    public String getLetter624A60DayDate() {
        CommsLogEntry entry;
        if (this.letter624A60DayDate == null && this.logs != null && this.logs.size() > 0 && (entry = this.getLatestMailingEntryForForm(ComLetterTemplateType.FORM_NUMBER_624A.getCode(), this.logs)) != null) {
            this.letter624A60DayDate = LetterFormatHelper.addDays(entry.getModifiedOn(), 60, sdf);
        }
        return EnrollTransmission.getString(this.letter624A60DayDate);
    }

    public void setLetter624A60DayDate(String dt) {
        this.letter624A60DayDate = dt;
    }

    public String getLetter625A30DayDate() {
        CommsLogEntry entry;
        if (this.letter625A30DayDate == null && this.logs != null && this.logs.size() > 0 && (entry = this.getLatestMailingEntryForForm(ComLetterTemplateType.FORM_NUMBER_625A.getCode(), this.logs)) != null) {
            this.letter625A30DayDate = LetterFormatHelper.addDays(entry.getModifiedOn(), 30, sdf);
        }
        return EnrollTransmission.getString(this.letter625A30DayDate);
    }

    public void setLetter625A30DayDate(String dt) {
        this.letter625A30DayDate = dt;
    }

    public String getLetter625A60DayDate() {
        CommsLogEntry entry;
        if (this.letter625A60DayDate == null && this.logs != null && this.logs.size() > 0 && (entry = this.getLatestMailingEntryForForm(ComLetterTemplateType.FORM_NUMBER_625A.getCode(), this.logs)) != null) {
            this.letter625A60DayDate = LetterFormatHelper.addDays(entry.getModifiedOn(), 60, sdf);
        }
        return EnrollTransmission.getString(this.letter625A60DayDate);
    }

    public void setLetter625A60DayDate(String dt) {
        this.letter625A60DayDate = dt;
    }

    private CommsLogEntry getLatestMailingEntryForForm(String formNumber, List logLst) {
        if (formNumber == null || formNumber.length() == 0 || logLst == null || logLst.size() == 0) {
            return null;
        }
        CommsLogEntry entry = null;
        for (int i = 0; i < logLst.size(); ++i) {
            entry = (CommsLogEntry)((Object)logLst.get(i));
            if (entry.getFormNumber() == null || !entry.getFormNumber().equals(formNumber)) continue;
            return entry;
        }
        return null;
    }

    protected EnrollmentDetermination getCurrentEnrollmentDetermination() {
        if (this.vet == null) {
            return null;
        }
        if (this.currentEnrollmentDetermination == null) {
            this.currentEnrollmentDetermination = this.vet.getEnrollmentDetermination();
        }
        return this.currentEnrollmentDetermination;
    }

    public String getEffectiveChangeDate() {
        if (this.effectiveDateOfChange == null && this.getCurrentEnrollmentDetermination() != null && this.currentEnrollmentDetermination.getEffectiveDate() != null) {
            this.effectiveDateOfChange = sdf.format(this.currentEnrollmentDetermination.getEffectiveDate());
        }
        return EnrollTransmission.getString(this.effectiveDateOfChange);
    }

    public void setEffectiveChangeDate(String dt) {
        this.effectiveDateOfChange = dt;
    }

    private EGTSetting getEgt() {
        if (this.isEgtSet) {
            return this.egt;
        }
        if (this.getCurrentEnrollmentDetermination() != null) {
            this.egt = this.getCurrentEnrollmentDetermination().getEgtSetting();
        }
        this.isEgtSet = true;
        return this.egt;
    }

    public String getEgtEffectiveDate() {
        if (this.getEgt() != null) {
            if (this.egt.getEffectiveDate() != null) {
                return sdf.format(this.egt.getEffectiveDate());
            }
            if (!this.isEgtSet) {
                this.egt = this.getEgt();
                if (this.egt != null && this.egt.getEffectiveDate() != null) {
                    return sdf.format(this.egt.getEffectiveDate());
                }
            }
        }
        return "";
    }

    public void setEgtEffectiveDate(String dt) {
        this.egtEffectiveDate = dt;
    }

    public String getEgtSetting() {
        String priority;
        if (this.egtSetting == null && this.getEgt() != null && (priority = this.egt.getPriorityGroup().getCode()) != null && priority.length() > 0) {
            String subGrpDesc;
            this.egtSetting = priority.replaceAll("0", "");
            if (this.egt.getPrioritySubGroup() != null && (subGrpDesc = this.egt.getPrioritySubGroup().getDescription()) != null && subGrpDesc.length() > 0) {
                this.egtSetting = this.egtSetting + this.getSubGroupCode(subGrpDesc);
            }
        }
        return EnrollTransmission.getString(this.egtSetting);
    }

    private String getSubGroupCode(String subGrpDesc) {
        if (StringUtils.isBlank((String)subGrpDesc)) {
            return "";
        }
        if (subGrpDesc.indexOf("'") > -1) {
            return subGrpDesc.substring(subGrpDesc.indexOf("'") + 1, subGrpDesc.indexOf("'") + 2);
        }
        return subGrpDesc;
    }

    public void setEgtSetting(String egtSetting) {
        this.egtSetting = egtSetting;
    }

    public String getEgtType() {
        if (this.egtType == null && this.egt != null && this.egt.getType() != null) {
            this.egtType = this.egt.getType().getName();
        }
        return EnrollTransmission.getString(this.egtType);
    }

    public void setEgpType(String type) {
        this.egtType = type;
    }

    public String getEligibilityCode() {
        Eligibility elig;
        if (this.eligibilityCode == null && this.getCurrentEnrollmentDetermination() != null && (elig = this.currentEnrollmentDetermination.getPrimaryEligibility()) != null && elig.getType() != null) {
            this.eligibilityCode = elig.getType().getCode();
        }
        return EnrollTransmission.getString(this.eligibilityCode);
    }

    public void setEligibilityCode(String code) {
        this.eligibilityCode = code;
    }

    public String getEnrollmentApplicationDate() {
        if (this.enrollmentApplicationDate == null && this.vet.getApplication() != null && this.vet.getApplication().getApplicationDate() != null) {
            this.enrollmentApplicationDate = sdf.format(this.vet.getApplication().getApplicationDate());
        }
        return EnrollTransmission.getString(this.enrollmentApplicationDate);
    }

    public void setEnrollmentApplicationDate(String dt) {
        this.enrollmentApplicationDate = dt;
    }

    public String getEnrollmentCategoryCode() {
        if (this.enrollmentCategoryCode == null) {
            this.enrollmentCategoryCode = this.getCurrentEnrollmentDetermination() != null && this.currentEnrollmentDetermination != null && this.currentEnrollmentDetermination.getEnrollmentStatus() != null ? this.currentEnrollmentDetermination.getEnrollmentStatus().getCode() : "";
        }
        return this.enrollmentCategoryCode;
    }

    public void setEnrollmentCategoryCode(String code) {
        this.enrollmentCategoryCode = code;
    }

    public String getEnrollmentEndDate() {
        if (this.enrollmentEndDate == null && this.getCurrentEnrollmentDetermination() != null && this.currentEnrollmentDetermination.getEndDate() != null) {
            this.enrollmentEndDate = sdf.format(this.currentEnrollmentDetermination.getEndDate());
        }
        return EnrollTransmission.getString(this.enrollmentEndDate);
    }

    public void setEnrollmentEndDate(String dt) {
        this.enrollmentEndDate = dt;
    }

    public String getCurrentEnrollmentPriorityLevel() {
        if (this.currentEnrollmentPriorityLevel != null) {
            return this.currentEnrollmentPriorityLevel;
        }
        if (this.getCurrentEnrollmentDetermination() == null) {
            return EnrollTransmission.getString(null);
        }
        if (this.getCurrentEnrollmentDetermination().getPriorityGroup() != null) {
            this.currentEnrollmentPriorityLevel = this.getCurrentEnrollmentDetermination().getPriorityGroup().getCode();
        }
        if (this.getCurrentEnrollmentDetermination().getPrioritySubGroup() != null) {
            this.currentEnrollmentPriorityLevel = this.currentEnrollmentPriorityLevel + this.getSubGroupCode(this.getCurrentEnrollmentDetermination().getPrioritySubGroup().getDescription());
        }
        return EnrollTransmission.getString(this.currentEnrollmentPriorityLevel);
    }

    @Override
    public String getVisn() {
        return "";
    }

    public String getCurrentIncomeThresholdYear() {
        if (this.currentIncomeThresholdYear == null) {
            this.currentIncomeThresholdYear = this.getIncomeYear();
        }
        return EnrollTransmission.getString(this.currentIncomeThresholdYear);
    }

    public void setCurrentIncomeThresholdYear(String yr) {
        this.currentIncomeThresholdYear = yr;
    }

    private IncomeTestStatus getIncomeTestStatus(String type, Set incomeTestStatuses) {
        if (type == null || incomeTestStatuses == null || incomeTestStatuses.size() == 0) {
            return null;
        }
        IncomeTestStatus status2 = null;
        for (IncomeTestStatus status2 : incomeTestStatuses) {
            if (!status2.getType().getCode().equals(type)) continue;
            return status2;
        }
        return null;
    }

    public String getMTDateTimeCompleted() {
        IncomeTestStatus status;
        if (this.mtDateTimeCompleted == null && this.getLocalIncomeTest() != null && this.getLocalIncomeTest().getStatuses() != null && (status = this.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST.getCode(), this.getLocalIncomeTest().getStatuses())) != null && status.getCompletedDate() != null) {
            this.mtDateTimeCompleted = sdf.format(status.getCompletedDate());
        }
        return EnrollTransmission.getString(this.mtDateTimeCompleted);
    }

    public void setMTDateTimeCompleted(String value) {
        this.mtDateTimeCompleted = value;
    }

    private String getRxCopayRequiredText() {
        if (this.rxCopayRequiredText == null && this.getLocalIncomeTest() != null) {
            this.rxCopayRequiredText = this.getLocalIncomeTest().getIncomeVerificationStatus().getDescription();
        }
        return EnrollTransmission.getString(this.rxCopayRequiredText);
    }

    private void setRxCopayRequiredText(String value) {
        this.rxCopayRequiredText = value;
    }

    private String getMTCopayRequiredText() {
        if (this.mtCopayRequiredText == null && this.getLocalIncomeTest() != null) {
            this.mtCopayRequiredText = this.getLocalIncomeTest().getIncomeVerificationStatus().getDescription();
        }
        return EnrollTransmission.getString(this.mtCopayRequiredText);
    }

    private void setMTCopayRequiredText(String value) {
        this.mtCopayRequiredText = value;
    }

    private String getGMTCopayRequiredText() {
        if (this.gmtCopayRequiredText == null && this.getLocalIncomeTest() != null) {
            this.gmtCopayRequiredText = this.getLocalIncomeTest().getIncomeVerificationStatus().getDescription();
        }
        return EnrollTransmission.getString(this.gmtCopayRequiredText);
    }

    private void setGMTCopayRequiredText(String value) {
        this.gmtCopayRequiredText = value;
    }

    public String getPrimaryVACareFacilityName() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityName);
    }

    public void setPrimaryVACareFacilityName(String value) {
        this.primaryVACareFacilityName = value;
    }

    public String getPrimaryVACareFacilityNumber() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityNumber);
    }

    public void setPrimaryVACareFacilityNumber(String value) {
        this.primaryVACareFacilityNumber = value;
    }

    private void initPrimaryVAFacility(IncomeTest incomeTest) {
        if (this.isPrimaryVaFacilitySet || this.isHistoricalCopy()) {
            return;
        }
        if (incomeTest == null || incomeTest.getSiteConductingTest() == null) {
            this.isPrimaryVaFacilitySet = true;
            return;
        }
        VAFacility facility = incomeTest.getSiteConductingTest();
        this.primaryVACareFacilityName = facility.getName();
        this.primaryVACareFacilityNumber = facility.getStationNumber();
        VAFacility.VAFacilityAddress addr = facility.getStreetAddress();
        if (addr != null) {
            this.primaryVACareFacilityAddrLine1 = addr.getLine1();
            this.primaryVACareFacilityAddrLine2 = addr.getLine2();
            this.primaryVACareFacilityAddrCity = addr.getCity();
            this.primaryVACareFacilityAddrState = addr.getState().getCode();
            this.primaryVACareFacilityAddrZip = addr.getZipCode();
            this.primaryVACareFacilityAddrCountry = addr.getState().getCountry().getShortName();
            if (this.primaryVACareFacilityAddrLine1 != null && this.primaryVACareFacilityAddrLine1.length() > 0) {
                this.primaryVACareFacilityAddr = this.primaryVACareFacilityAddrLine1;
            }
            if (this.primaryVACareFacilityAddrLine2 != null && this.primaryVACareFacilityAddrLine2.length() > 0) {
                this.primaryVACareFacilityAddr = this.primaryVACareFacilityAddr + this.primaryVACareFacilityAddrLine2 + "\n";
            }
            if (addr.getLine3() != null && addr.getLine3().length() > 0) {
                this.primaryVACareFacilityAddr = this.primaryVACareFacilityAddr + addr.getLine3() + "\n";
            }
        }
        this.isPrimaryVaFacilitySet = true;
    }

    public String getPrimaryVACareFacilityAddr() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddr);
    }

    public void setPrimaryVACareFacilityAddr(String value) {
        this.primaryVACareFacilityAddr = value;
    }

    public String getPrimaryVACareFacilityAddrLine1() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddrLine1);
    }

    public void setPrimaryVACareFacilityAddrLine1(String value) {
        this.primaryVACareFacilityAddrLine1 = value;
    }

    public String getPrimaryVACareFacilityAddrLine2() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddrLine2);
    }

    public void setPrimaryVACareFacilityAddrLine2(String value) {
        this.primaryVACareFacilityAddrLine2 = value;
    }

    public String getPrimaryVACareFacilityAddrCity() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddrCity);
    }

    public void setPrimaryVACareFacilityAddrCity(String value) {
        this.primaryVACareFacilityAddrCity = value;
    }

    public String getPrimaryVACareFacilityAddrState() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddrState);
    }

    public void setPrimaryVACareFacilityAddrState(String value) {
        this.primaryVACareFacilityAddrState = value;
    }

    public String getPrimaryVACareFacilityAddrZip() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddrZip);
    }

    public void setPrimaryVACareFacilityAddrZip(String value) {
        this.primaryVACareFacilityAddrZip = value;
    }

    public String getPrimaryVACareFacilityAddrCountry() {
        this.initPrimaryVAFacility(this.getLocalIncomeTest());
        return EnrollTransmission.getString(this.primaryVACareFacilityAddrCountry);
    }

    public void setPrimaryVACareFacilityAddrCountry(String value) {
        this.primaryVACareFacilityAddrCountry = value;
    }

    public String getPreferredFacility() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacility);
    }

    public void setPreferredFacility(String facility) {
        this.preferredFacility = facility;
    }

    public String getPreferredFacilityNumber() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityNumber);
    }

    public void setPreferredFacilityNumber(String num) {
        this.preferredFacilityNumber = num;
    }

    private void initPreferredFacility(Person person) {
        if (this.isPreferredFacilitySet || this.isHistoricalCopy() || person == null) {
            return;
        }
        VAFacility facility = person.getMostRecentPreferredFacility();
        if (facility == null) {
            this.isPreferredFacilitySet = true;
            return;
        }
        this.preferredFacility = facility.getName();
        this.preferredFacilityNumber = facility.getStationNumber();
        this.isPreferredFacilitySet = true;
    }

    public String getPreferredFacilityAddr() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddr);
    }

    public void setPreferredFacilityAddr(String value) {
        this.preferredFacilityAddr = value;
    }

    public String getPreferredFacilityAddrLine1() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddrLine1);
    }

    public void setPreferredFacilityAddrLine1(String value) {
        this.preferredFacilityAddrLine1 = value;
    }

    public String getPreferredFacilityAddrLine2() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddrLine2);
    }

    public void setPreferredFacilityAddrLine2(String value) {
        this.preferredFacilityAddrLine2 = value;
    }

    public String getPreferredFacilityAddrCity() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddrCity);
    }

    public void setPreferredFacilityAddrCity(String value) {
        this.preferredFacilityAddrCity = value;
    }

    public String getPreferredFacilityAddrState() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddrState);
    }

    public void setPreferredFacilityAddrState(String value) {
        this.preferredFacilityAddrState = value;
    }

    public String getPreferredFacilityAddrZip() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddrZip);
    }

    public void setPreferredFacilityAddrZip(String value) {
        this.preferredFacilityAddrZip = value;
    }

    public String getPreferredFacilityAddrCountry() {
        this.initPreferredFacility(this.vet);
        return EnrollTransmission.getString(this.preferredFacilityAddrCountry);
    }

    public void setPreferredFacilityAddrCountry(String value) {
        this.preferredFacilityAddrCountry = value;
    }

    public boolean isRxCopayNonExempt() {
        if (this.isHistoricalCopy()) {
            return this.isRxCopayNonExempt;
        }
        return this.isIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST, MeansTestStatus.MT_STATUS_NON_EXEMPT);
    }

    public void setRxCopayNonExempt(boolean value) {
        this.isRxCopayNonExempt = value;
    }

    public boolean isMTCopayRequired() {
        if (this.isHistoricalCopy()) {
            return this.isMTCopayRequired;
        }
        boolean result = this.isIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST, MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED);
        if (!result && this.isIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST, MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION) && this.getLocalIncomeTest() != null && this.getLocalIncomeTest().getGmtThresholdAmount() != null && this.getLocalIncomeTest().getThresholdA() != null && this.getLocalIncomeTest().getGmtThresholdAmount().doubleValue() <= this.getLocalIncomeTest().getThresholdA().doubleValue()) {
            result = true;
        }
        return result;
    }

    public void setMTCopayRequired(boolean value) {
        this.isMTCopayRequired = value;
    }

    public void setGMTCopayRequired(boolean value) {
        this.isGMTCopayRequired = value;
    }

    public boolean isGMTCopayRequired() {
        if (this.isHistoricalCopy()) {
            return this.isGMTCopayRequired;
        }
        boolean result = this.isIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST, MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED);
        if (!result && this.isIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST, MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION) && this.getLocalIncomeTest() != null && this.getLocalIncomeTest().getGmtThresholdAmount() != null && this.getLocalIncomeTest().getThresholdA() != null && this.getLocalIncomeTest().getGmtThresholdAmount().doubleValue() > this.getLocalIncomeTest().getThresholdA().doubleValue()) {
            result = true;
        }
        return result;
    }

    private boolean isIncomeTestStatus(IncomeTestType.Code itType, MeansTestStatus.Code meansTestStatus) {
        IncomeTestStatus status;
        boolean result = false;
        IncomeTest target = this.getLocalIncomeTest();
        if (target != null && itType != null && meansTestStatus != null && (status = target.getIncomeTestStatus(itType)) != null && status.getStatus() != null && status.getStatus().getCode().equals(meansTestStatus.getCode())) {
            result = true;
        }
        return result;
    }

    public IncomeTest getLocalIncomeTest() {
        if (this.isIncomeTestSet || this.isHistoricalCopy() || this.vet == null) {
            return this.localIncomeTest;
        }
        this.localIncomeTest = this.vet.getIncomeTest(new Integer(this.getIncomeYear()));
        this.isIncomeTestSet = true;
        return this.localIncomeTest;
    }

    public void setLocalIncomeTest(IncomeTest incomeTest) {
        this.isIncomeTestSet = true;
        if (incomeTest == null) {
            this.localIncomeTest = null;
            this.setIncomeYear(null);
        } else {
            this.localIncomeTest = incomeTest;
            this.setIncomeYear(incomeTest.getIncomeYear() != null ? incomeTest.getIncomeYear().toString() : null);
        }
    }

    private IncomeThreshold getIncomeThreshold() {
        return this.incomeThreshold;
    }

    public void setIncomeThreshold(IncomeThreshold incomeThreshold) {
        this.incomeThreshold = incomeThreshold;
    }

    public String getMedicationCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getMedicationCopay(), 2, 1);
    }

    public String getFirst90daysHospitalCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getNinetyDayHospitalCopay(), 2, 1);
    }

    public String getAdditional90DaysHospitalCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getAdd90DayHospitalDeductible(), 2, 1);
    }

    public String getOutpatientPreventiveCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getOutpatientPreventiveCopay(), 2, 1);
    }

    public String getGmtInpatientFirst90DayCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getGmtInpatient90DayCopay(), 2, 1);
    }

    public String getGmtInpatientAdd90DayCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getGmtInpatientAdd90DayCopay(), 2, 1);
    }

    public String getGmtPerDiem() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getGmtInpatientPerDiem(), 2, 1);
    }

    public String getOutpatientCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getOutpatientCopay(), 2, 1);
    }

    public String getInpatientPerDiem() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getInpatientPerDiem(), 2, 1);
    }

    public String getSpecialCopay() {
        if (this.incomeThreshold == null) {
            return "";
        }
        return LetterFormatHelper.ToDollarAmount(this.incomeThreshold.getOutpatientSpecialtyCopay(), 2, 1);
    }

    private int getCurrentFiscalYear() {
        Date today = new Date();
        int currentFiscalYear = this.cal.get(1);
        Date date1 = new GregorianCalendar(currentFiscalYear, 9, 1).getTime();
        Date date2 = new GregorianCalendar(currentFiscalYear + 1, 0, 1).getTime();
        if (today.compareTo(date1) >= 0 && today.compareTo(date2) < 0) {
            ++currentFiscalYear;
        }
        return currentFiscalYear;
    }

    private EGTSetting getLocalEgtSetting() {
        if (this.localEgtSetting == null && !this.isHistoricalCopy() && this.getCurrentEnrollmentDetermination() != null) {
            this.localEgtSetting = this.getCurrentEnrollmentDetermination().getEgtSetting();
        }
        return this.localEgtSetting;
    }

    public FinancialsHelperService getFinancialsHelperService() {
        return this.financialsHelperService;
    }

    public void setFinancialsHelperService(FinancialsHelperService financialsHelperService) {
        this.financialsHelperService = financialsHelperService;
    }

    public void setCurrentEnrollmentDetermination(EnrollmentDetermination currentEnrollmentDetermination) {
        this.currentEnrollmentDetermination = currentEnrollmentDetermination;
    }

    public String getMostRecentNonNullPriorityLevel() {
        return this.mostRecentNonNullPriorityLevel;
    }

    public void setMostRecentNonNullPriorityLevel(String mostRecentNonNullPriorityLevel) {
        this.mostRecentNonNullPriorityLevel = mostRecentNonNullPriorityLevel;
    }
}

