/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.AbstractDataSynchronizationProducerProcess;
import gov.va.med.esr.common.batchprocess.datasync.DataSynchronizationProducerStatistics;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ExceptionWriterProcessCompletedHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class IVMDataSynchronizationProducerProcessCompletedHandler
extends ExceptionWriterProcessCompletedHandler {
    private static String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final String EXCEPTIONFILENAMESUFFIXDATA = "exceptionfilenamesuffixdata";

    protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
        DataSynchronizationProducerStatistics stats = (DataSynchronizationProducerStatistics)((Object)context.getContextData().get(AbstractDataSynchronizationProducerProcess.CONTEXT_FILE_STATS));
        if (stats == null) {
            return new Date();
        }
        String inputFileName = stats.getFileName();
        String root = new StringTokenizer(inputFileName, ".").nextToken();
        StringTokenizer st = new StringTokenizer(root, "_");
        String date = null;
        while (st.hasMoreTokens()) {
            date = st.nextToken();
        }
        date = StringUtils.rightPad((String)date, (int)DATE_FORMAT.length(), (char)'0');
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("File name [" + inputFileName + "] does not contain a date that is parsable to " + DATE_FORMAT);
        }
    }

    public void dataProcessingComplete(DataProcessExecutionContext context) {
        this.appendExceptionData(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendExceptionData(DataProcessExecutionContext context) {
        List exceptionData = context.getExceptionData();
        if (exceptionData != null && !exceptionData.isEmpty()) {
            ArrayList currentExceptionData = new ArrayList(exceptionData);
            List list = exceptionData;
            synchronized (list) {
                exceptionData.clear();
            }
            Object exceptionFileNameSuffixData = context.getContextData().get(EXCEPTIONFILENAMESUFFIXDATA);
            if (exceptionFileNameSuffixData == null) {
                exceptionFileNameSuffixData = this.getExceptionFileNameSuffixData(context);
                context.getContextData().put(EXCEPTIONFILENAMESUFFIXDATA, exceptionFileNameSuffixData);
            }
            this.getFileWriter().appendData(currentExceptionData, exceptionFileNameSuffixData);
        }
    }
}

