/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.AbstractDataSynchronizationProducerProcess;
import gov.va.med.esr.common.batchprocess.datasync.DataSynchronizationProducerStatistics;
import gov.va.med.esr.common.batchprocess.datasync.IVMDataSynchronizationProducer;
import gov.va.med.esr.common.batchprocess.datasync.IVMDataSynchronizationProducerProcessCompletedHandler;
import gov.va.med.esr.common.batchprocess.datasync.IVMExtractDateProcessor;
import gov.va.med.esr.common.batchprocess.datasync.PersonLoaderProcess;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ivmdm.IVMDMExtractBatch;
import gov.va.med.esr.common.model.ivmdm.IVMDMExtractRecord;
import gov.va.med.esr.common.model.lookup.IVMDMType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.batchprocess.ConcurrentProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StopWatchLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class IVMDataSynchronizationProducerProcess
extends AbstractDataSynchronizationProducerProcess {
    private static final String KEY_LAST_EXTRACTED_PERSON = "LAST_EXTRACTED_PERSON";
    private static final String KEY_BATCH_PERSON_HASH_TABLE = "KEY_BATCH_PERSON_HASH_TABLE";
    private static final String KEY_BATCH_PERSON_SITES_HASH_TABLE = "KEY_BATCH_PERSON_SITES_HASH_TABLE";
    public static final String EXTRACTSTARTDATEARG = "-extractstartdate=";
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    private PSDelegateService psDelegateService = null;
    private SystemParameterService systemParameterService = null;
    private LookupService lookupService = null;
    private IVMDMType ivmDmType = null;
    private IVMDataSynchronizationProducer ivmDataSyncProducer = null;
    private IVMDMService ivmDMService;
    private ConcurrentProcess personLoader = null;
    private int batchSize = 1000;
    private int numberofprocesses = 10;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_NUM_PROCESSES = 10;

    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        String startDateStr;
        Date extractStartDate;
        this.setEntityCountPerFile(this.getIvmMaxRecordsPerFile());
        String[] args = null;
        if (context.getExecutionArguments() != null) {
            args = context.getExecutionArguments() instanceof String[] ? (String[])context.getExecutionArguments() : new String[]{(String)context.getExecutionArguments()};
        }
        if (args != null && args.length > 0 && (extractStartDate = new SimpleDateFormat("yyyyMMddHHmmss").parse(startDateStr = args[0].substring(EXTRACTSTARTDATEARG.length()))) != null) {
            context.getContextData().put(EXTRACTSTARTDATEARG, extractStartDate);
        }
        return super.executeQuery(context);
    }

    @Override
    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        Iterator itr = acquiredData.iterator();
        Object acquiredObject2 = null;
        Object processedObject = null;
        Object transformedData = null;
        ArrayList data = new ArrayList();
        ArrayList shouldProcessAquiredObjects = new ArrayList();
        HashSet<String> personKeys = new HashSet<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processData() start acquiredData size : " + acquiredData.size()));
        }
        while (itr.hasNext()) {
            acquiredObject2 = itr.next();
            String personKey = (String)((Object[])acquiredObject2)[3];
            try {
                boolean shouldProcessAcquiredObject = this.shouldProcessAcquiredObject(context, acquiredObject2);
                if (!shouldProcessAcquiredObject) continue;
                personKeys.add(personKey);
                shouldProcessAquiredObjects.add(acquiredObject2);
            }
            catch (Exception e) {
                this.handleFailure(context, acquiredObject2, "Exception in shouldProcessAcquiredObject:", e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processData() finished should process step with size :" + shouldProcessAquiredObjects.size() + " outof total :" + acquiredData.size()));
        }
        int batchId = 0;
        while (shouldProcessAquiredObjects.size() > 0) {
            boolean isComplete;
            StopWatchLogger watch;
            String perfId;
            Hashtable personSites;
            Hashtable personsMap;
            HashSet<PersonLoaderProcess> processes;
            ArrayList currBatchOfAquiredObjects;
            block24: {
                currBatchOfAquiredObjects = new ArrayList();
                HashSet<String> personKeysSet = new HashSet<String>();
                if (shouldProcessAquiredObjects.size() > this.batchSize) {
                    currBatchOfAquiredObjects.addAll(shouldProcessAquiredObjects.subList(0, this.batchSize));
                } else {
                    currBatchOfAquiredObjects.addAll(shouldProcessAquiredObjects);
                }
                shouldProcessAquiredObjects.removeAll(currBatchOfAquiredObjects);
                for (Object acquiredObject2 : currBatchOfAquiredObjects) {
                    String personKey = (String)((Object[])acquiredObject2)[0];
                    personKeysSet.add(personKey);
                }
                int numPerProcess = personKeysSet.size() / this.numberofprocesses;
                processes = new HashSet<PersonLoaderProcess>(this.numberofprocesses);
                personsMap = new Hashtable();
                personSites = new Hashtable();
                ArrayList<String> personKeysArray = new ArrayList<String>();
                personKeysArray.addAll(personKeysSet);
                perfId = "Start processing the batch : " + batchId;
                watch = new StopWatchLogger(perfId);
                watch.start();
                for (int i = 0; i < this.numberofprocesses; ++i) {
                    PersonLoaderProcess loadProcess = new PersonLoaderProcess();
                    loadProcess.setPersonService(this.getPersonService());
                    loadProcess.setPsDelegateService(this.getPsDelegateService());
                    loadProcess.setPersons(personsMap);
                    loadProcess.setPersonSites(personSites);
                    if (numPerProcess > 0) {
                        int startPos = i * numPerProcess;
                        int endPos = startPos + numPerProcess;
                        if (i == this.numberofprocesses - 1) {
                            endPos = personKeysSet.size();
                        }
                        loadProcess.setPersonKeys(new HashSet(personKeysArray.subList(startPos, endPos)));
                    } else if (i < personKeysArray.size()) {
                        loadProcess.setPersonKeys(new HashSet(personKeysArray.subList(i, i)));
                    }
                    loadProcess.setProcessId(i);
                    loadProcess.setAuditId("BatchId :" + batchId + " ProcessId :" + i);
                    processes.add(loadProcess);
                }
                this.getPersonLoader().setProcesses(processes);
                try {
                    this.getPersonLoader().invoke(new ScheduledProcessInvocationContext());
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block24;
                    this.logger.error((Object)"Exception in invoking the PersonLoaderProcess: ", (Throwable)e);
                }
            }
            block12: do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                isComplete = true;
                for (PersonLoaderProcess pesonLoader : processes) {
                    if (pesonLoader.isComplete()) continue;
                    isComplete = false;
                    continue block12;
                }
            } while (!isComplete);
            watch.stopAndLog(perfId);
            context.getContextData().put(KEY_BATCH_PERSON_HASH_TABLE, personsMap);
            context.getContextData().put(KEY_BATCH_PERSON_SITES_HASH_TABLE, personSites);
            ++batchId;
            Iterator currBatchItr = currBatchOfAquiredObjects.iterator();
            this.resetPersonYearStats(context);
            while (currBatchItr.hasNext()) {
                acquiredObject2 = currBatchItr.next();
                try {
                    this.populatePersonStats(context, acquiredObject2);
                    processedObject = this.getProcessedObject(context, acquiredObject2);
                    if (processedObject == null) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)"Unable to retrieve processed object for data sync...it was retrieved as null....ignoring this entry");
                        continue;
                    }
                    transformedData = this.transformObject(context, processedObject, acquiredObject2);
                    this.writeToFile(context, transformedData, data, processedObject, acquiredObject2);
                }
                catch (Exception e) {
                    this.handleFailure(context, acquiredObject2, "Exception while wrting to the File", e);
                    data.clear();
                }
                if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
                this.updateJobResult((DataProcessExecutionContext)context);
            }
            shouldProcessAquiredObjects.remove(currBatchOfAquiredObjects);
        }
    }

    private void populatePersonStats(DataQueryProcessExecutionContext context, Object acquiredObject) {
        PersonYearStats personYearStats = this.getPersonYearStats(context);
        PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.getPersonIdFromAcquiredObject(acquiredObject));
        Set years = this.getAllIncomeYearsFromAcquiredObject(acquiredObject);
        personYearStats.getYearsToProcess().clear();
        if (personYearStats.getPersonKey() == null || !personKey.getKeyValueAsString().equals(personYearStats.getPersonKey().getKeyValueAsString())) {
            personYearStats.setPersonKey(personKey);
            personYearStats.getProcessedYears().clear();
            personYearStats.getYearsToProcess().addAll(years);
        } else {
            for (Integer year : years) {
                if (personYearStats.getProcessedYears().contains(year)) continue;
                personYearStats.getYearsToProcess().add(year);
            }
        }
    }

    protected void prepareDataQueryDetail(DataQueryProcessExecutionContext context, DataQueryDetail query) {
        if (query.getQuery().getParamNames() != null) {
            Date lastExtractDate = IVMExtractDateProcessor.getLastExtractTime((DataProcessExecutionContext)context);
            Date extractStartTime = IVMExtractDateProcessor.getExtractStartTime((DataProcessExecutionContext)context);
            query.getQuery().setParamValues(new Object[]{lastExtractDate, extractStartTime});
        }
    }

    @Override
    protected boolean shouldProcessAcquiredObject(DataQueryProcessExecutionContext context, Object acquiredObject) {
        PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.getPersonIdFromAcquiredObject(acquiredObject));
        boolean process = false;
        PersonYearStats personYearStats = this.getPersonYearStats(context);
        if (this.isRemigrate(acquiredObject)) {
            process = true;
        } else {
            Integer incomeYear = (Integer)this.getIncomeYearFromAcquiredObject(acquiredObject);
            try {
                VPIDEntityKey vpidKey = CommonEntityKeyFactory.createVPIDEntityKey(this.getVpidValueFromAcquiredObject(acquiredObject));
                Set incomeYears = this.ivmDMService.findExtractIncomeYears(personKey, incomeYear, vpidKey);
                if (incomeYears.size() == 0) {
                    return false;
                }
                if (incomeYear == null) {
                    ((Object[])acquiredObject)[1] = incomeYears;
                }
                process = true;
            }
            catch (ServiceException ex) {
                IllegalStateException newEx = new IllegalStateException("Error while checking the ivm selection criteria.");
                newEx.initCause(ex);
                throw newEx;
            }
        }
        if (process) {
            Set years = this.getAllIncomeYearsFromAcquiredObject(acquiredObject);
            personYearStats.getYearsToProcess().clear();
            if (personYearStats.getPersonKey() == null || !personKey.getKeyValueAsString().equals(personYearStats.getPersonKey().getKeyValueAsString())) {
                personYearStats.setPersonKey(personKey);
                personYearStats.getProcessedYears().clear();
                personYearStats.getYearsToProcess().addAll(years);
                personYearStats.getProcessedYears().addAll(years);
            } else {
                for (Integer year : years) {
                    if (personYearStats.getProcessedYears().contains(year)) continue;
                    personYearStats.getYearsToProcess().add(year);
                    personYearStats.getProcessedYears().add(year);
                }
            }
            return personYearStats.getYearsToProcess().size() > 0;
        }
        return process;
    }

    @Override
    protected Object getProcessedObject(DataQueryProcessExecutionContext context, Object acquiredObject) throws ServiceException {
        PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.getPersonIdFromAcquiredObject(acquiredObject));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Synchronizing data for Person: " + personKey.getKeyValueAsString()));
        }
        return this.getPersonYearStats(context).getPerson((Hashtable)context.getContextData().get(KEY_BATCH_PERSON_HASH_TABLE));
    }

    @Override
    protected Object transformObject(DataQueryProcessExecutionContext context, Object processedObject, Object acquiredObject) throws ServiceException {
        PersonYearStats personYearStats = this.getPersonYearStats(context);
        Person person = personYearStats.getPerson((Hashtable)context.getContextData().get(KEY_BATCH_PERSON_HASH_TABLE));
        Set incomeYears = personYearStats.getYearsToProcess();
        ArrayList data = new ArrayList();
        for (Integer year : incomeYears) {
            if (personYearStats.getProcessedYears().contains(year)) continue;
            Set sites = this.getSitesFromContext(context, person.getVPIDEntityKey());
            data.addAll(this.ivmDataSyncProducer.getIVMRawData(person, year, sites));
            personYearStats.getProcessedYears().add(year);
        }
        return data;
    }

    private Set getSitesFromContext(DataQueryProcessExecutionContext context, VPIDEntityKey vpEntityKey) throws ServiceException {
        Hashtable personSitesHashtable = (Hashtable)context.getContextData().get(KEY_BATCH_PERSON_SITES_HASH_TABLE);
        Set sites = null;
        if (personSitesHashtable != null) {
            sites = (Set)personSitesHashtable.get(vpEntityKey);
        }
        if (sites == null) {
            sites = this.psDelegateService.getSites(vpEntityKey);
        }
        return sites;
    }

    @Override
    protected void postProcessDataFile(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats) {
        this.changeFileExtensions("TMP", "TXT");
        List fileData = stats.getFileData();
        if (fileData == null || fileData.size() == 0) {
            return;
        }
        IVMDMExtractBatch ivmBatch = new IVMDMExtractBatch();
        ivmBatch.setMigrationType(this.getIVMDMType());
        ivmBatch.setExtractFileName(stats.getFileName());
        ivmBatch.setExtractStartDate(IVMExtractDateProcessor.getExtractStartTime((DataProcessExecutionContext)context));
        ivmBatch.setExtractEndDate(stats.getEndTime());
        ivmBatch.setExtractRecordCount(new Integer(stats.getEntityCount()));
        for (IVMDMExtractRecord extractRecord : fileData) {
            ivmBatch.addExtractRecord(extractRecord);
        }
        try {
            this.ivmDMService.saveIVMDMExtractBatch(ivmBatch);
        }
        catch (ServiceException ex) {
            throw new IllegalArgumentException("Error saving the IVM Extract statistics. Reason: " + ex.getMessage());
        }
    }

    @Override
    protected void postProcessAcquiredObject(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats, Object processedObject, Object acquiredObject) {
        Person person = (Person)((Object)processedObject);
        Set incomeYears = this.getPersonYearStats(context).getYearsToProcess();
        for (Integer year : incomeYears) {
            Date extractStartTime = IVMExtractDateProcessor.getExtractStartTime((DataProcessExecutionContext)context);
            String icn = person.getVPIDEntityKey().getShortVPID();
            PersonEntityKey personKey = person.getPersonEntityKey();
            try {
                this.ivmDMService.saveIVMMigration(extractStartTime, personKey, icn, year);
            }
            catch (ServiceException ex) {
                throw new IllegalArgumentException("Error saving the IVM Extract. Reason: " + ex.getMessage());
            }
        }
    }

    @Override
    protected void addFileData(DataQueryProcessExecutionContext context, DataSynchronizationProducerStatistics stats, Object processedObject, Object acquiredObject) {
        Person person = (Person)((Object)processedObject);
        Set incomeYears = this.getPersonYearStats(context).getYearsToProcess();
        String icn = person.getVPIDEntityKey().getShortVPID();
        for (Integer year : incomeYears) {
            IVMDMExtractRecord ivmRecord = new IVMDMExtractRecord();
            ivmRecord.setIcn(icn);
            ivmRecord.setIncomeYear(year);
            stats.addFileData((Object)ivmRecord);
        }
    }

    private void handleFailure(DataQueryProcessExecutionContext context, Object acquiredObject, String errorMessage, Exception e) {
        try {
            Object exceptionText = null;
            this.logger.error((Object)"handleFailure ", (Throwable)e);
            StringBuffer identityData = new StringBuffer();
            identityData.append("Current TimeStamp :").append(new Date());
            identityData.append("\tPersonId :").append(this.getPersonIdFromAcquiredObject(acquiredObject));
            identityData.append("\tVpidValue :").append(this.getVpidValueFromAcquiredObject(acquiredObject));
            try {
                Object incomeYearObj = this.getIncomeYearFromAcquiredObject(acquiredObject);
                Integer incomeYear = null;
                if (incomeYearObj instanceof Integer) {
                    incomeYear = (Integer)incomeYearObj;
                }
                identityData.append("\tIncome Year :").append(incomeYear);
            }
            catch (Exception debugEx) {
                this.logger.error((Object)"is This class Cast Exception ", (Throwable)debugEx);
            }
            if (this.logger.isErrorEnabled()) {
                this.logger.error(exceptionText);
                this.logger.error((Object)("Unable to synchronize Entity: " + identityData.toString() + " due to exception"), (Throwable)e);
            }
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            context.getExceptionData().add(identityData.toString());
            if (e != null) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String trackTrace = sw.toString();
                context.getExceptionData().add(trackTrace);
            }
            if (this.shouldWriteExceptionData(context)) {
                ((IVMDataSynchronizationProducerProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
        }
        catch (Exception eX) {
            // empty catch block
        }
    }

    private boolean shouldWriteExceptionData(DataQueryProcessExecutionContext context) {
        int exceptionDataSize;
        int n = exceptionDataSize = context.getExceptionData() == null ? 0 : context.getExceptionData().size();
        return exceptionDataSize != 0 ? exceptionDataSize % 20 == 0 : false;
    }

    private PersonYearStats getPersonYearStats(DataQueryProcessExecutionContext context) {
        PersonYearStats personStats = (PersonYearStats)context.getContextData().get(KEY_LAST_EXTRACTED_PERSON);
        if (personStats == null) {
            personStats = new PersonYearStats();
            context.getContextData().put(KEY_LAST_EXTRACTED_PERSON, personStats);
        }
        return personStats;
    }

    private String getPersonIdFromAcquiredObject(Object acquiredObject) {
        return (String)((Object[])acquiredObject)[0];
    }

    private Object getIncomeYearFromAcquiredObject(Object acquiredObject) {
        return ((Object[])acquiredObject)[1];
    }

    private Set getAllIncomeYearsFromAcquiredObject(Object acquiredObject) {
        HashSet<Object> years = new HashSet<Object>();
        Object obj = ((Object[])acquiredObject)[1];
        if (obj instanceof Set) {
            years.addAll((Set)obj);
        } else {
            years.add(obj);
        }
        return years;
    }

    private boolean isRemigrate(Object acquiredObject) {
        return Boolean.TRUE.equals((Boolean)((Object[])acquiredObject)[2]);
    }

    private String getVpidValueFromAcquiredObject(Object acquiredObject) {
        return (String)((Object[])acquiredObject)[3];
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public IVMDataSynchronizationProducer getIvmDataSyncProducer() {
        return this.ivmDataSyncProducer;
    }

    public void setIvmDataSyncProducer(IVMDataSynchronizationProducer ivmDataSyncProducer) {
        this.ivmDataSyncProducer = ivmDataSyncProducer;
    }

    public IVMDMService getIvmDMService() {
        return this.ivmDMService;
    }

    public void setIvmDMService(IVMDMService ivmDMService) {
        this.ivmDMService = ivmDMService;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumberofprocesses() {
        return this.numberofprocesses;
    }

    public void setNumberofprocesses(int numberofprocesses) {
        this.numberofprocesses = numberofprocesses;
    }

    public ConcurrentProcess getPersonLoader() {
        return this.personLoader;
    }

    public void setPersonLoader(ConcurrentProcess personLoader) {
        this.personLoader = personLoader;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.psDelegateService, (String)"PSDelegateService is required.");
        Validate.notNull((Object)this.lookupService, (String)"LookupService is required.");
        Validate.notNull((Object)this.systemParameterService, (String)"SystemParameterService is required.");
        Validate.notNull((Object)this.ivmDMService, (String)"IVMDMService is required.");
        Validate.notNull((Object)((Object)this.ivmDataSyncProducer), (String)"IVMDataSynchronizationProducer is required.");
        Validate.notNull((Object)this.personLoader, (String)"personLoader is required");
        this.setDefaultsConcurrentProps();
    }

    private void setDefaultsConcurrentProps() {
        if (this.batchSize <= 0) {
            this.setBatchSize(1000);
        }
        if (this.numberofprocesses <= 0) {
            this.setNumberofprocesses(10);
        }
    }

    private IVMDMType getIVMDMType() {
        if (this.ivmDmType == null) {
            try {
                this.ivmDmType = (IVMDMType)this.lookupService.getByCode(IVMDMType.class, IVMDMType.ONGOING.getCode());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Missing IVM DM type " + IVMDMType.ONGOING.getCode() + " Reason: " + ex.getMessage());
            }
        }
        return this.ivmDmType;
    }

    private int getIvmMaxRecordsPerFile() {
        int ivmRecordsPerFile = 0;
        try {
            SystemParameter ivmMaxRecords = this.systemParameterService.getByName("IVM DM Exporter Maximum Records");
            if (ivmMaxRecords != null && ivmMaxRecords.getValue() != null) {
                ivmRecordsPerFile = Integer.parseInt(ivmMaxRecords.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ivmRecordsPerFile;
    }

    private void resetPersonYearStats(DataQueryProcessExecutionContext context) {
        HashMap contextData = (HashMap)context.getContextData();
        contextData.put(KEY_LAST_EXTRACTED_PERSON, null);
    }

    private class PersonYearStats {
        private PersonEntityKey personKey = null;
        private Person person = null;
        private Set processedYears = new HashSet();
        private Set yearsToProcess = new HashSet();

        private PersonYearStats() {
        }

        public PersonEntityKey getPersonKey() {
            return this.personKey;
        }

        public void setPersonKey(PersonEntityKey personKey) {
            this.personKey = personKey;
            if (this.person != null && !this.person.getEntityKey().getKeyValueAsString().equals(personKey.getKeyValueAsString())) {
                this.person = null;
            }
        }

        public Person getPerson(Hashtable personsMap) throws ServiceException {
            if (this.person == null) {
                if (personsMap != null) {
                    this.person = (Person)((Object)personsMap.get(this.personKey.getKeyValueAsString()));
                }
                if (this.person == null) {
                    this.person = IVMDataSynchronizationProducerProcess.this.getPersonService().getPerson(this.personKey);
                }
            }
            return this.person;
        }

        public Set getProcessedYears() {
            return this.processedYears;
        }

        public Set getYearsToProcess() {
            return this.yearsToProcess;
        }
    }
}

