/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.service.IVMDMService;
import gov.va.med.fw.batchprocess.AbstractDataFileProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

public class IVMDataSynchronizationExceptionConsumerProcess
extends AbstractDataFileProcess {
    private IVMDMService ivmDMService;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.ivmDMService, (String)"IVMDMService is required.");
    }

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        Integer incomeYear = null;
        Iterator iter = acquiredData.iterator();
        while (iter.hasNext()) {
            try {
                String errorReason;
                String date;
                String icn;
                RawFileDataList fileRow = (RawFileDataList)iter.next();
                if (incomeYear == null) {
                    String id = fileRow.size() > 0 ? (String)fileRow.get(0) : null;
                    if (!StringUtils.isNotEmpty((String)id)) continue;
                    incomeYear = new Integer(id);
                    continue;
                }
                if (fileRow.size() >= 3 && this.ivmDMService.updateErrorReasonData(incomeYear, icn = (String)fileRow.get(0), date = (String)fileRow.get(1), errorReason = (String)fileRow.get(2))) {
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    continue;
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            catch (Exception ex) {
                context.getExceptionData().add(ex);
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
        }
    }

    public IVMDMService getIvmDMService() {
        return this.ivmDMService;
    }

    public void setIvmDMService(IVMDMService ivmDMService) {
        this.ivmDMService = ivmDMService;
    }
}

