/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import java.util.Date;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HECLegacyCombatFileData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = -6281462425623056157L;
    private ConflictLocation conflictLocation;
    private ImpreciseDate combatFromDate;
    private ImpreciseDate combatToDate;
    private String hostileFireImminentDangerIndicator;
    private String ctzeIndicator;
    private OEFOIFSource dataSource;
    private VAFacility facility;
    private Date lastUpdated;

    protected void buildToString(ToStringBuilder builder) {
        builder.append("conflictLocation", (Object)this.conflictLocation);
    }

    public ConflictLocation getConflictLocation() {
        return this.conflictLocation;
    }

    public void setConflictLocation(ConflictLocation conflictLocation) {
        this.conflictLocation = conflictLocation;
    }

    public String getCtzeIndicator() {
        return this.ctzeIndicator;
    }

    public void setCtzeIndicator(String ctzeIndicator) {
        this.ctzeIndicator = ctzeIndicator;
    }

    public OEFOIFSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(OEFOIFSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getHostileFireImminentDangerIndicator() {
        return this.hostileFireImminentDangerIndicator;
    }

    public void setHostileFireImminentDangerIndicator(String hostileFireImminentDangerIndicator) {
        this.hostileFireImminentDangerIndicator = hostileFireImminentDangerIndicator;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        int i = 1;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"conflictLocation", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"combatFromDate", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"combatToDate", (String)parsedRow.getString(i++));
        this.hostileFireImminentDangerIndicator = parsedRow.getString(i++);
        this.ctzeIndicator = parsedRow.getString(i++);
        String[] dataSourceAndFacility = RawFileDataContainerUtils.parseMultipleValues((String)parsedRow.getString(i++), (String)"|").toArray(new String[2]);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"dataSource", (String)dataSourceAndFacility[0]);
        if (dataSourceAndFacility.length == 2) {
            RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"facility", (String)dataSourceAndFacility[1]);
        }
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"lastUpdated", (String)parsedRow.getString(i++));
    }

    public OrderedMap getRawFileData() throws Exception {
        ListOrderedMap map = new ListOrderedMap();
        map.put((Object)"header", (Object)"CMB");
        map.put((Object)"conflictLocation", (Object)this.conflictLocation);
        map.put((Object)"combatFromDate", (Object)this.combatFromDate);
        map.put((Object)"combatToDate", (Object)this.combatToDate);
        map.put((Object)"hostileFireImminentDangerIndicator", (Object)this.hostileFireImminentDangerIndicator);
        map.put((Object)"ctzeIndicator", (Object)this.ctzeIndicator);
        if (this.dataSource != null && OEFOIFSource.CODE_VAMC.getCode().equals(this.dataSource.getCode()) && this.facility != null) {
            map.put((Object)"dataSource", (Object)(this.dataSource.getCode() + "|" + this.facility.getStationNumber()));
        } else {
            map.put((Object)"dataSource", (Object)this.dataSource);
        }
        map.put((Object)"lastUpdated", (Object)this.lastUpdated);
        return map;
    }

    public ImpreciseDate getCombatFromDate() {
        return this.combatFromDate;
    }

    public void setCombatFromDate(ImpreciseDate combatFromDate) {
        this.combatFromDate = combatFromDate;
    }

    public ImpreciseDate getCombatToDate() {
        return this.combatToDate;
    }

    public void setCombatToDate(ImpreciseDate combatToDate) {
        this.combatToDate = combatToDate;
    }

    public VAFacility getFacility() {
        return this.facility;
    }

    public void setFacility(VAFacility facility) {
        this.facility = facility;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

