/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class HECLegacyAssociationRelationshipFieldTransformer
extends AbstractComponent
implements FieldTransformer {
    private LookupService lookupService;
    private Map relationshipNameToCodeCache;

    public Object transformData(String fieldName, Object data) throws Exception {
        String incomingRelationshipText = (String)data;
        if (StringUtils.isBlank((String)incomingRelationshipText)) {
            return "";
        }
        Object code = this.getRelationshipNameToCodeCache().get(incomingRelationshipText.toUpperCase());
        if (code == null) {
            code = Relationship.CODE_OTHER.getCode();
        }
        return code;
    }

    private synchronized Map getRelationshipNameToCodeCache() throws ServiceException {
        if (this.relationshipNameToCodeCache == null) {
            this.relationshipNameToCodeCache = new HashMap();
            List list = this.lookupService.findAll(Relationship.class);
            Iterator itr = list.iterator();
            Relationship rel = null;
            while (itr.hasNext()) {
                rel = (Relationship)((Object)itr.next());
                this.relationshipNameToCodeCache.put(this.getRelationshipName(rel).toUpperCase(), rel.getCode());
            }
        }
        return this.relationshipNameToCodeCache;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.lookupService, (String)"A lookupService is required");
    }

    private String getRelationshipName(Relationship rel) {
        return StringUtils.isNotBlank((String)rel.getName()) ? rel.getName() : rel.getDescription();
    }
}

