/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CpeMecFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.IRSTransmissionService;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.FailedRecordWriterProcessCompletedHandler;
import gov.va.med.fw.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.FileSystemResource;

public class TransmitFileDataToIRSProcess
extends AbstractDataFileSingleRowIncrementProcess {
    private static IRSTransmissionService irsTransmissionService = null;
    private SystemParameterService systemParameterService = null;
    private final String SEP = "=";
    private final String EMPTY_STRING = "";
    private static String BATCH_TYPE = "B";
    private static String CORRECTION_IND = "O";
    private static String calendarYear;
    int maxBatchSize;
    CpeMecFileData dataRecord = null;
    private PersonMergeService personMergeService;
    private PersonService personService;
    static ArrayList<IRS1095B> batch;

    protected List doAcquireData(DataProcessExecutionContext context, FileSystemResource fileSystemResource) throws Exception {
        ArrayList<String> xmlFile = new ArrayList<String>();
        String args = (String)context.getExecutionArguments();
        if (StringUtils.isEmpty((String)args)) {
            return super.doAcquireData(context, fileSystemResource);
        }
        String rs = args;
        xmlFile.add(rs);
        return xmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCustomDataFile(DataFileProcessExecutionContext context, List acquiredData) {
        FileInputStream fis = null;
        try {
            String[] params;
            File xmlFile = new File((String)acquiredData.get(0));
            String correctionInd = "O";
            String args = (String)context.getExecutionArguments();
            if (!StringUtils.isEmpty((String)args) && (params = args.split(",")) != null && params.length == 2) {
                xmlFile = new File(params[0]);
                correctionInd = params[1].trim();
            }
            fis = new FileInputStream(xmlFile);
            byte[] data = IOUtils.toByteArray((InputStream)fis);
            String content = new String(data);
            this.getIrsTransmissionService().submitCustomFile(content, correctionInd);
            context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            if (fis == null) return;
        }
        catch (IOException e) {
            try {
                this.logger.error((Object)("Failed to read custom data file object" + e.getMessage()));
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                if (fis == null) return;
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (!StringUtils.isEmpty((String)((String)context.getExecutionArguments()))) {
            this.processCustomDataFile(context, acquiredData);
        } else {
            block20: {
                String[] types = context.getCurrentFile().getName().split("_");
                if (types == null || types.length != 6) {
                    this.logger.error((Object)("Invalid file name for MEC_DataExtract:" + context.getCurrentFile().getName()));
                    return;
                }
                BATCH_TYPE = types[4];
                CORRECTION_IND = types[2];
                calendarYear = types[3];
                try {
                    this.maxBatchSize = new Integer(this.getSystemParameterService().getByName("IRS Transmission Size").getValue());
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block20;
                    this.logger.error((Object)"Error during CPE batch transfer to IRS, cannot read system parameters", (Throwable)e);
                }
            }
            for (int i = 0; i < acquiredData.size(); ++i) {
                block21: {
                    this.dataRecord = (CpeMecFileData)((Object)acquiredData.get(i));
                    if (BATCH_TYPE.equalsIgnoreCase("V")) {
                        try {
                            PersonIdEntityKey id;
                            String shortVpid = "";
                            if (this.dataRecord.getVpid().length() == 30) {
                                shortVpid = this.dataRecord.getVpid().substring(6, 23);
                            }
                            if ((id = this.getPersonService().getPersonIdByVPID(CommonEntityKeyFactory.createVPIDEntityKey(shortVpid))) != null && this.getPersonMergeService().hasDeprecatedRecord(id)) {
                                this.logger.error((Object)("Ignoring deprecated record in IRS File data process for id:" + id.getKeyValueAsString()));
                            }
                            break block21;
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Exception during person retrieval" + e));
                        }
                        continue;
                    }
                }
                IRS1095B beneRecord = new IRS1095B();
                try {
                    beneRecord = this.buildLine(beneRecord, this.dataRecord);
                    batch.add(beneRecord);
                    if (!CORRECTION_IND.equalsIgnoreCase("O")) {
                        this.getIrsTransmissionService().sendSubmit(batch, BATCH_TYPE, CORRECTION_IND, calendarYear);
                        batch.clear();
                    } else if (batch.size() == this.maxBatchSize) {
                        this.getIrsTransmissionService().sendSubmit(batch, BATCH_TYPE, CORRECTION_IND, calendarYear);
                        batch.clear();
                    }
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    continue;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)("Error during CPE batch transfer to IRS for vpid " + this.dataRecord.getVpid()), (Throwable)e);
                    }
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    context.getExceptionData().add((Object)((Object)this.dataRecord) + "^" + e.getMessage());
                    continue;
                }
                finally {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
            }
        }
        FailedRecordWriterProcessCompletedHandler dataFileCompletedHandler = (FailedRecordWriterProcessCompletedHandler)this.getDataProcessCompletedHandler();
        dataFileCompletedHandler.writeExceptionData((DataProcessExecutionContext)context);
        dataFileCompletedHandler.writeFailedData((DataProcessExecutionContext)context);
    }

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        return false;
    }

    public IRSTransmissionService getIrsTransmissionService() {
        return irsTransmissionService;
    }

    public void setIrsTransmissionService(IRSTransmissionService irsTransmissionService) {
        TransmitFileDataToIRSProcess.irsTransmissionService = irsTransmissionService;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    private IRS1095B buildLine(IRS1095B beneRecord, CpeMecFileData dataRecord) {
        beneRecord.setNamePrefix(dataRecord.getNamePrefix().split("=").length < 2 ? "" : dataRecord.getNamePrefix().split("=")[1]);
        beneRecord.setFirstName(dataRecord.getFirstName().split("=").length < 2 ? "" : dataRecord.getFirstName().split("=")[1]);
        beneRecord.setMiddleName(dataRecord.getMiddleName().split("=").length < 2 ? "" : dataRecord.getMiddleName().split("=")[1]);
        beneRecord.setLastName(dataRecord.getLastName().split("=").length < 2 ? "" : dataRecord.getLastName().split("=")[1]);
        beneRecord.setNameSuffix(dataRecord.getNameSuffix().split("=").length < 2 ? "" : dataRecord.getNameSuffix().split("=")[1]);
        beneRecord.setGender(dataRecord.getGender().split("=").length < 2 ? "" : dataRecord.getGender().split("=")[1]);
        beneRecord.setIEN(dataRecord.getVpid().split("=").length < 2 ? "" : dataRecord.getVpid().split("=")[1]);
        beneRecord.setSSN(dataRecord.getSsn().split("=").length < 2 ? "" : dataRecord.getSsn().split("=")[1]);
        beneRecord.setDOB(dataRecord.getDateOfBirth().split("=").length < 2 ? "" : dataRecord.getDateOfBirth().split("=")[1]);
        SimpleAddress beneAddress = new SimpleAddress();
        beneAddress.setLine1(dataRecord.getAddressLine1().split("=").length < 2 ? "" : dataRecord.getAddressLine1().split("=")[1]);
        beneAddress.setLine2(dataRecord.getAddressLine2().split("=").length < 2 ? "" : dataRecord.getAddressLine2().split("=")[1]);
        beneAddress.setLine3(dataRecord.getAddressLine3().split("=").length < 2 ? "" : dataRecord.getAddressLine3().split("=")[1]);
        beneAddress.setCity(dataRecord.getCity().split("=").length < 2 ? "" : dataRecord.getCity().split("=")[1]);
        beneAddress.setState(dataRecord.getState().split("=").length < 2 ? "" : dataRecord.getState().split("=")[1]);
        beneAddress.setCountry(dataRecord.getCountryCode().split("=").length < 2 ? "" : dataRecord.getCountryCode().split("=")[1]);
        beneAddress.setZipCode(dataRecord.getZipCode().split("=").length < 2 ? "" : dataRecord.getZipCode().split("=")[1]);
        beneAddress.setPostalCode(dataRecord.getPostalCode().split("=").length < 2 ? "" : dataRecord.getPostalCode().split("=")[1]);
        beneAddress.setCounty(dataRecord.getCounty().split("=").length < 2 ? "" : dataRecord.getCounty().split("=")[1]);
        beneAddress.setProvince(dataRecord.getProvince().split("=").length < 2 ? "" : dataRecord.getProvince().split("=")[1]);
        beneRecord.setAddress(beneAddress);
        MECPeriod benePeriod = new MECPeriod();
        benePeriod.setCoveredAll12Months(dataRecord.getCoveredAllYear().split("=").length == 2 && dataRecord.getCoveredAllYear().split("=")[1].equalsIgnoreCase("Y"));
        HashMap<String, Boolean> coverageMap = new HashMap<String, Boolean>();
        coverageMap.put("1", dataRecord.getCoveredJan().split("=").length == 2 && dataRecord.getCoveredJan().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("2", dataRecord.getCoveredFeb().split("=").length == 2 && dataRecord.getCoveredFeb().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("3", dataRecord.getCoveredMar().split("=").length == 2 && dataRecord.getCoveredMar().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("4", dataRecord.getCoveredApr().split("=").length == 2 && dataRecord.getCoveredApr().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("5", dataRecord.getCoveredMay().split("=").length == 2 && dataRecord.getCoveredMay().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("6", dataRecord.getCoveredJun().split("=").length == 2 && dataRecord.getCoveredJun().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("7", dataRecord.getCoveredJul().split("=").length == 2 && dataRecord.getCoveredJul().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("8", dataRecord.getCoveredAug().split("=").length == 2 && dataRecord.getCoveredAug().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("9", dataRecord.getCoveredSep().split("=").length == 2 && dataRecord.getCoveredSep().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("10", dataRecord.getCoveredOct().split("=").length == 2 && dataRecord.getCoveredOct().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("11", dataRecord.getCoveredNov().split("=").length == 2 && dataRecord.getCoveredNov().split("=")[1].equalsIgnoreCase("Y"));
        coverageMap.put("12", dataRecord.getCoveredDec().split("=").length == 2 && dataRecord.getCoveredDec().split("=")[1].equalsIgnoreCase("Y"));
        benePeriod.setCoverageMonths(coverageMap);
        beneRecord.setMecPeriod(benePeriod);
        return beneRecord;
    }

    public PersonMergeService getPersonMergeService() {
        return this.personMergeService;
    }

    public void setPersonMergeService(PersonMergeService personMergeService) {
        this.personMergeService = personMergeService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    static {
        batch = new ArrayList();
    }

    public static class IRSFileProcessCompletedHandler
    extends FailedRecordWriterProcessCompletedHandler {
        IRSFileProcessCompletedHandler() {
        }

        public void dataProcessingComplete(DataProcessExecutionContext context) {
            block3: {
                if (batch.size() > 0) {
                    try {
                        irsTransmissionService.sendSubmit(batch, BATCH_TYPE, CORRECTION_IND, calendarYear);
                        batch.clear();
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    }
                    catch (Exception e) {
                        if (!this.logger.isErrorEnabled()) break block3;
                        this.logger.error((Object)("Unhandled Error during remainder CPE batch transfer to IRS for batch " + batch.toString()), (Throwable)e);
                    }
                }
            }
            super.dataProcessingComplete(context);
        }
    }
}

