/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.NCOAAddressVerificationFileData;
import gov.va.med.esr.common.batchprocess.NCOAAddressVerificationFileProcessStatistics;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;

public class SendNCOAAddressVerificationFileProcess
extends AbstractDataQueryIncrementalProcess {
    private static final String FORM_ID = "NCOA";
    private FormattedFileWriter outputFileWriter;
    private PSDelegateService psDelegateService;
    private PersonHelperService personHelperService;

    public FormattedFileWriter getOutputFileWriter() {
        return this.outputFileWriter;
    }

    public void setOutputFileWriter(FormattedFileWriter outputFileWriter) {
        this.outputFileWriter = outputFileWriter;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new NCOAAddressVerificationFileProcessStatistics();
    }

    protected void processData(DataQueryProcessExecutionContext executionContext, List data) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("NCOA Number of records to process=" + (data == null ? 0 : data.size())));
        }
        List outputFileData = new ArrayList();
        try {
            outputFileData = this.createFileOutputData(executionContext, data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("NCOA Number of records to write to file=" + (outputFileData == null ? 0 : outputFileData.size())));
            }
            this.outputFileWriter.appendData(outputFileData);
            executionContext.getProcessStatistics().setNumberOfSuccessfulRecords(executionContext.getProcessStatistics().getNumberOfSuccessfulRecords() + outputFileData.size());
        }
        catch (Exception e) {
            this.recordExceptionInContext(executionContext, e, outputFileData.size());
        }
        executionContext.getProcessStatistics().setNumberOfTotalRecords(executionContext.getProcessStatistics().getNumberOfTotalRecords() + outputFileData.size());
    }

    private void recordExceptionInContext(DataQueryProcessExecutionContext executionContext, Exception e, int nbrErrorRecs) {
        executionContext.getProcessStatistics().setNumberOfErrorRecords(executionContext.getProcessStatistics().getNumberOfErrorRecords() + nbrErrorRecs);
        String errorMessage = "Error writing data to file during Send NCOA Address file Verification batch process : Reason: " + e.getMessage();
        executionContext.getExceptionData().add(errorMessage);
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)errorMessage, (Throwable)e);
        }
    }

    private List createFileOutputData(DataQueryProcessExecutionContext executionContext, List data) {
        ArrayList<NCOAAddressVerificationFileData> verificationData = new ArrayList<NCOAAddressVerificationFileData>();
        for (Object[] dataRow : data) {
            String VPIDValue = (String)dataRow[0];
            String addressLine1 = (String)dataRow[1];
            String addressLine2 = (String)dataRow[2];
            String city = (String)dataRow[3];
            String stateCode = (String)dataRow[4];
            String zipCode = (String)dataRow[5];
            String zipPlus4 = (String)dataRow[6];
            Date dateLastUpdated = (Date)dataRow[7];
            VPIDEntityKey VPIDKey = CommonEntityKeyFactory.createVPIDEntityKey(VPIDValue);
            try {
                PersonTraits personTraits = this.getIdentityTraits(VPIDValue, VPIDKey, executionContext);
                if (personTraits == null) continue;
                NCOAAddressVerificationFileData addressVerificationData = new NCOAAddressVerificationFileData();
                addressVerificationData.setAddressLine1(addressLine1);
                addressVerificationData.setAddressLine2(addressLine2);
                addressVerificationData.setCity(city);
                State state = null;
                try {
                    state = this.personHelperService.getStateFromCodeOrName(stateCode);
                }
                catch (ServiceException e) {
                    throw new RuntimeException("Could not get identity traits for VPID value " + VPIDValue, e);
                }
                addressVerificationData.setState(state == null ? null : state.getCode());
                addressVerificationData.setZipCode(zipCode);
                addressVerificationData.setZipPlus4(zipPlus4);
                addressVerificationData.setDateLastUpdated(dateLastUpdated);
                addressVerificationData.setLastName(personTraits.getFamilyName());
                addressVerificationData.setFirstName(personTraits.getGivenName());
                addressVerificationData.setMiddleInitial(personTraits.getMiddleName());
                addressVerificationData.setSsn(personTraits.getSsn());
                addressVerificationData.setGender(personTraits.getGender());
                addressVerificationData.setDateOfBirth(new ImpreciseDate(personTraits.getBirthDate()));
                addressVerificationData.setFormID(FORM_ID);
                addressVerificationData.setICN(this.personHelperService.getICNChecksum(VPIDValue));
                verificationData.add(addressVerificationData);
            }
            catch (Exception e) {
                this.recordExceptionInContext(executionContext, e, 1);
            }
        }
        return verificationData;
    }

    private PersonTraits getIdentityTraits(String VPIDValue, VPIDEntityKey VPIDKey, DataQueryProcessExecutionContext executionContext) {
        PersonTraits personTraits = null;
        try {
            personTraits = this.personHelperService.getPersonTraitsByVPID(VPIDKey.getVPID());
            if (personTraits == null) {
                ((NCOAAddressVerificationFileProcessStatistics)executionContext.getProcessStatistics()).incrementNumberOfNoIdentityTraitsRecords();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("PSIM returned: " + (Object)((Object)personTraits)));
            }
        }
        catch (ServiceException e) {
            throw new RuntimeException("Could not get identity traits for VPID value " + VPIDValue, e);
        }
        return personTraits;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.outputFileWriter, (String)"A File Writer is needed");
        Validate.notNull((Object)this.psDelegateService, (String)"A PSDelegateService is needed");
        Validate.notNull((Object)this.personHelperService, (String)"A PersonHelperService is needed");
    }
}

