/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;

public class ResetComMailingBarcodeSequenceProcess
extends AbstractScheduledProcess
implements InitializingBean {
    private String sequenceName = null;
    private Properties hibernateProperties = null;
    private DataSource dataSource = null;
    private String[] updateSequenceSql = null;

    protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.batchUpdate(this.updateSequenceSql);
    }

    public void afterPropertiesSet() {
        int i;
        super.afterPropertiesSet();
        Dialect dialect = Dialect.getDialect((Properties)this.hibernateProperties);
        String[] dropSequenceSql = dialect.getDropSequenceStrings(this.sequenceName);
        String[] createSequenceSql = dialect.getCreateSequenceStrings(this.sequenceName);
        this.updateSequenceSql = new String[dropSequenceSql.length + createSequenceSql.length];
        int index = 0;
        for (i = 0; i < dropSequenceSql.length; ++i) {
            this.updateSequenceSql[index] = dropSequenceSql[i];
            ++index;
        }
        for (i = 0; i < createSequenceSql.length; ++i) {
            this.updateSequenceSql[index] = createSequenceSql[i];
            ++index;
        }
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public Properties getHibernateProperties() {
        return this.hibernateProperties;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

