/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.VPIDFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.GenerateQRYZ11MessagingService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.impl.GenerateQRYZ11MessagingServiceImpl;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.util.List;
import org.apache.commons.lang.Validate;

public class QueryVBAOnSelectedPersonsProcess
extends AbstractDataFileIncrementalProcess {
    private TriggerRouter triggerRouter;
    private GenerateQRYZ11MessagingService messagingService = null;
    private PersonService personService;
    private LookupService lookupService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List beans) {
        if (this.logger.isDebugEnabled()) {
            int listSize = 0;
            if (beans != null) {
                listSize = beans.size();
            }
            this.logger.error((Object)("Processing VPID  " + listSize));
        }
        for (int i = 0; beans != null && i < beans.size(); ++i) {
            VPIDFileData vpidDataRecord = (VPIDFileData)((Object)beans.get(i));
            String VPID2 = vpidDataRecord.getVpid();
            try {
                VPIDEntityKey vpidEntityKey = CommonEntityKeyFactory.createVPIDEntityKey(vpidDataRecord.getVpid());
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)("Processing VPID  " + vpidDataRecord.getVpid()));
                }
                this.processRecord(vpidEntityKey, VPID2);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during Sending Query Z11 From a file process for  VPID " + vpidDataRecord.getVpid()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
    }

    protected void processRecord(PersonEntityKey key, String VPID2) throws Exception {
        this.messagingService.generateMessage(key, VPID2);
        Person person = this.personService.getPerson(key);
        if (person == null) {
            throw new RuntimeException("Unable to find Person for VPID: " + VPID2);
        }
        if (person.getEligibilityVerification() == null) {
            EligibilityVerification eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        person.getEligibilityVerification().setAacIndicator(this.getLookupService().getAACIndicatorByCode(AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
        this.personService.save(person);
    }

    public void setMessagingService(GenerateQRYZ11MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected GenerateQRYZ11MessagingService getMessagingService() {
        return this.messagingService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService);
        Validate.notNull((Object)this.lookupService);
        Validate.notNull((Object)this.messagingService, (String)"A MessagingService is needed");
        Validate.isTrue((!(this.messagingService instanceof GenerateQRYZ11MessagingServiceImpl) ? 1 : 0) != 0, (String)"A GenerateQRYZ11 Messaging Service is required");
    }

    private TriggerEvent getTriggerEvent(PersonEntityKey key) {
        PersonTriggerEvent triggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY);
        triggerEvent.setPersonId(key);
        return triggerEvent;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }
}

