/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.PCMMImportData;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PCMMUpdateProcess
extends AbstractDataFileSingleRowIncrementProcess {
    private LookupService lookupService = null;
    private PreferredFacilityService preferredFacilityService;

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        boolean success = false;
        try {
            this.preferredFacilityService.processPCMMData((PCMMImportData)((Object)bean));
            success = true;
        }
        catch (Exception e) {
            this.handleFailure(context, (PCMMImportData)((Object)bean), e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"PCMMUpdateProcess: Processing complete.");
            this.logger.debug((Object)("PCMMUpdateProcess: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("PCMMUpdateProcess: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
        if (context.getProcessStatistics().isTotalNumberMod(5)) {
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        return success;
    }

    private void handleFailure(DataFileProcessExecutionContext context, PCMMImportData pcmmData, Exception e) {
        String exceptionText = null;
        exceptionText = e == null ? "Error: Unable to process PCMM data: " + (Object)((Object)pcmmData) : "Error: Unable process PCMM data: " + (Object)((Object)pcmmData) + " because of exception: " + e;
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getExceptionData().add(pcmmData);
        context.getExceptionData().add(exceptionText + "\n\n");
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            context.getExceptionData().add(trackTrace);
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }
}

