/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.OPPExtractProcessStatistics;
import gov.va.med.esr.common.report.data.CommonExtractFileCriteria;
import gov.va.med.esr.common.report.data.MainFileCriteria;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.StandardReportService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.batchprocess.DataProcessCompletedHandler;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import org.springframework.context.MessageSource;

public class OPPExtractProcessCompletedHandler
extends AbstractComponent
implements DataProcessCompletedHandler {
    private StandardReportService standardReportService;
    private CommsEmailBulletinService bulletinService;
    private MessageSource messageSource;

    public StandardReportService getStandardReportService() {
        return this.standardReportService;
    }

    public void setStandardReportService(StandardReportService standardReportService) {
        this.standardReportService = standardReportService;
    }

    public void dataProcessingComplete(DataProcessExecutionContext context) {
        OPPExtractProcessStatistics statistics = (OPPExtractProcessStatistics)context.getProcessStatistics();
        if (StringUtils.equals((String)"OPPExtractProcess-Main File", (String)statistics.getProcessName())) {
            this.generateMainFileExtractReport(statistics);
        }
        if (StringUtils.equals((String)"OPPExtractProcess-Eligibility", (String)statistics.getProcessName())) {
            this.generateCommonExtractReport(CommonExtractFileCriteria.ELIGIBILITY_FILE, statistics.getNumberOfEligibilityFileRecords());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-PeriodOfService", (String)statistics.getProcessName())) {
            this.generateCommonExtractReport(CommonExtractFileCriteria.PERIODOFSERVICE_FILE, statistics.getNumberOfPeriodOfServiceFileRecords());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-RatedDisability", (String)statistics.getProcessName())) {
            this.generateCommonExtractReport(CommonExtractFileCriteria.RATEDDISABILITIES_FILE, statistics.getNumberOfRatedDisabilitiesFileRecords());
        }
        if (StringUtils.equals((String)"OPPExtractProcess-CombatEpisode", (String)statistics.getProcessName())) {
            this.generateCommonExtractReport(CommonExtractFileCriteria.COMBATEPISODES_FILE, statistics.getNumberOfCombatEpisodeFileRecords());
        }
        if (this.bulletinService != null) {
            try {
                HashMap<String, Date> bulletinData = new HashMap<String, Date>();
                bulletinData.put("StartTime", statistics.getProcessingStartDate());
                bulletinData.put("EndTime", new Date());
                this.bulletinService.sendEmailBulletin(BulletinTrigger.DataType.OPP_EXTRACT_COMPLETED, bulletinData, null);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Exception while handling the completion of OPP processing", e);
            }
        }
    }

    private void generateMainFileExtractReport(OPPExtractProcessStatistics statistics) {
        MainFileCriteria criteria = new MainFileCriteria(this.getMessageSource());
        criteria.setRecords(new Integer(statistics.getNumberOfMainFileRecords()));
        criteria.setAutoEnrolledRecords(new Integer(statistics.getNumberOfAutoEnrolledRecords()));
        criteria.setCancelledDeclinedEnrollees(new Integer(statistics.getNumberOfCanceledDeclinedEnrollees()));
        criteria.setDeceasedBeneficiaries(new Integer(statistics.getNumberOfDeceasedBeneficiaries()));
        criteria.setIneligibleBeneficiaries(new Integer(statistics.getNumberOfIneligibleEnrolees()));
        criteria.setInsurances(new Integer(statistics.getNumberOfActiveHealthInsuranceRecords()));
        criteria.setOfficialEnrollees(new Integer(statistics.getNumberOfOfficialEnrollees()));
        criteria.setRequiredMeansTests(new Integer(statistics.getNumberOfPendingMeansTestRecords()));
        criteria.setTotalEnrollees(new Integer(statistics.getNumberOfTotalEnrollees()));
        criteria.setUnOfficialEnrollees(new Integer(statistics.getNumberOfUnOfficialEnrollees()));
        this.logger.info((Object)"Calling Report Service to generate report for Main File Extract ");
        this.generateReport(criteria);
    }

    private void generateCommonExtractReport(CommonExtractFileCriteria.Type criteriaType, int countOfRecords) {
        CommonExtractFileCriteria criteria = new CommonExtractFileCriteria(criteriaType, this.getMessageSource());
        criteria.setRecords(new Integer(countOfRecords));
        this.logger.info((Object)("Calling Report Service to generate report for process " + criteriaType.getName()));
        this.generateReport(criteria);
    }

    private void generateReport(CommonExtractFileCriteria criteria) {
        try {
            UserPrincipal user = SecurityContextHelper.getSecurityContext().getUserPrincipal();
            this.logger.info((Object)("OPP Extract generating reports logged in as " + SecurityContextHelper.getUserName((UserPrincipal)user)));
            this.getStandardReportService().generateOPPReport(user, criteria);
        }
        catch (Exception e) {
            String errorMessage = "Could not generate report for OPP Extract process " + (Object)((Object)criteria);
            this.logger.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }
}

