/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.MigrateBulkEEProcessStatistics;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.EEResult;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataProcessWorker;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.springframework.util.StopWatch;

public class MigrateBulkEEProcessWorker
extends AbstractDataProcessWorker {
    private PersonService personService;

    public ProcessStatistics processData(Object o) throws Exception {
        MigrateBulkEEProcessStatistics stats = new MigrateBulkEEProcessStatistics();
        List<Object> personIds = null;
        if (o instanceof List) {
            personIds = (List<Object>)o;
        } else if (o instanceof Object[]) {
            personIds = Arrays.asList((Object[])o);
        } else {
            throw new IllegalArgumentException("Input is not a List or Object[] or Person Ids");
        }
        Iterator itr = personIds.iterator();
        PersonIdEntityKey key = null;
        StopWatch timer = new StopWatch();
        timer.setKeepTaskList(false);
        EEResult result = null;
        while (itr.hasNext()) {
            key = CommonEntityKeyFactory.createPersonIdEntityKey((Serializable)itr.next());
            try {
                timer.start(key.getKeyValueAsString());
                result = this.personService.processEEForMigratedPerson(key);
                timer.stop();
                if (!result.isCalculated()) {
                    stats.incrementNumberOfRecordsNotNeedingEEMigrated();
                    continue;
                }
                stats.incrementTotalSuccessfulDuration((float)((double)timer.getLastTaskTimeMillis() / 1000.0));
                if (!result.isEeChange()) {
                    stats.incrementNumberOfEEDidNotChangeRecords();
                }
                if (result.getTriggerEventsForBulletins() != null) {
                    stats.incrementNumberOfBulletinsTriggered(result.getTriggerEventsForBulletins().size());
                }
                if (result.getTriggerEventsForLetters() != null) {
                    stats.incrementNumberOfLettersTriggered(result.getTriggerEventsForLetters().size());
                }
                if (result.getTriggerEventsForHL7Messages() == null) continue;
                stats.incrementNumberOfHL7MessagesTriggered(result.getTriggerEventsForHL7Messages().size());
            }
            catch (Throwable e) {
                timer.stop();
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Unable to migrate/calculate EE for Person Id: " + key.getKeyValueAsString()), e);
                }
                stats.incrementNumberOfErrorRecords();
            }
        }
        return stats;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.personService, (String)"personService is required");
    }
}

