/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import java.io.Serializable;

public class LoadVSSCDataResult
implements Serializable {
    private static final long serialVersionUID = -4885368055508908441L;
    public static final String EXCEPTION_REASON_NO_MATCH = "EXCEPTION_REASON_NO_MATCH";
    public static final String EXCEPTION_REASON_FAILED = "EXCEPTION_REASON_FAILED";
    public static final String EXCEPTION_REASON_NEW_PERSON = "EXCEPTION_REASON_NEW_PERSON";
    public static String EXP_REQUIRED_FIELDS_MISSING_INVALID = "Required Fields are missing or inavlid";
    public static String EXP_CONSISTENCY_CHECKS_FAILED = "Consistency Checks Failed";
    private int countOEFAccepted = 0;
    private int countOEFRejected = 0;
    private int countOIFAccepted = 0;
    private int countOIFRejected = 0;
    private int countUnknownAccepted = 0;
    private int countUnknownRejected = 0;
    private int countUnspecifiedAccepted = 0;
    private int countUnspecifiedRejected = 0;
    private int countNewPersonRejected = 0;
    private int countNoMatchRejected = 0;
    private int countCCRejected = 0;
    private int countMissingInvalidRejected = 0;

    public void incrementRejected(CombatEpisode combatEpisode) {
        String locationCode = combatEpisode.getConflictLocation().getCode();
        if (ConflictLocation.CODE_OEF.getCode().equals(locationCode)) {
            this.incrementCountOEFRejected();
        } else if (ConflictLocation.CODE_OIF.getCode().equals(locationCode)) {
            this.incrementCountOIFRejected();
        } else if (ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(locationCode)) {
            this.incrementCountUnknownRejected();
        } else if (ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(locationCode)) {
            this.incrementCountUnspecifiedRejected();
        }
    }

    public void incrementAccepted(CombatEpisode combatEpisode) {
        String locationCode = combatEpisode.getConflictLocation().getCode();
        if (ConflictLocation.CODE_OEF.getCode().equals(locationCode)) {
            this.incrementCountOEFAccepted();
        } else if (ConflictLocation.CODE_OIF.getCode().equals(locationCode)) {
            this.incrementCountOIFAccepted();
        } else if (ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(locationCode)) {
            this.incrementCountUnknownAccepted();
        } else if (ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(locationCode)) {
            this.incrementCountUnspecifiedAccepted();
        }
    }

    public void incrementCountOEFAccepted() {
        ++this.countOEFAccepted;
    }

    public void incrementCountOEFRejected() {
        ++this.countOEFRejected;
    }

    public void incrementCountOIFAccepted() {
        ++this.countOIFAccepted;
    }

    public void incrementCountOIFRejected() {
        ++this.countOIFRejected;
    }

    public void incrementCountUnknownAccepted() {
        ++this.countUnknownAccepted;
    }

    public void incrementCountUnknownRejected() {
        ++this.countUnknownRejected;
    }

    public void incrementCountUnspecifiedAccepted() {
        ++this.countUnspecifiedAccepted;
    }

    public void incrementCountUnspecifiedRejected() {
        ++this.countUnspecifiedRejected;
    }

    public int getCountOEFAccepted() {
        return this.countOEFAccepted;
    }

    public int getCountOEFRejected() {
        return this.countOEFRejected;
    }

    public int getCountOIFAccepted() {
        return this.countOIFAccepted;
    }

    public int getCountOIFRejected() {
        return this.countOIFRejected;
    }

    public int getCountUnknownAccepted() {
        return this.countUnknownAccepted;
    }

    public int getCountUnknownRejected() {
        return this.countUnknownRejected;
    }

    public int getCountUnspecifiedAccepted() {
        return this.countUnspecifiedAccepted;
    }

    public int getCountUnspecifiedRejected() {
        return this.countUnspecifiedRejected;
    }

    public int getCountNewPersonRejected() {
        return this.countNewPersonRejected;
    }

    public void incrementCountNewPersonRejected() {
        ++this.countNewPersonRejected;
    }

    public void incrementCountNewPersonRejected(int count) {
        this.countNewPersonRejected += count;
    }

    public int getCountCCRejected() {
        return this.countCCRejected;
    }

    public int getCountMissingInvalidRejected() {
        return this.countMissingInvalidRejected;
    }

    public void incrementCountCCRejected() {
        ++this.countCCRejected;
    }

    public void incrementCountMissingInvalidRejected() {
        ++this.countMissingInvalidRejected;
    }

    public int getCountNoMatchRejected() {
        return this.countNoMatchRejected;
    }

    public void incrementCountNoMatchRejected() {
        ++this.countNoMatchRejected;
    }

    public int getTotalAccepted() {
        return this.countOEFAccepted + this.countOIFAccepted + this.countUnknownAccepted + this.countUnspecifiedAccepted;
    }

    public int getTotalRejected() {
        return this.countMissingInvalidRejected + this.countCCRejected + this.countNoMatchRejected + this.countNewPersonRejected + this.countOEFRejected + this.countOIFRejected + this.countUnknownRejected + this.countUnspecifiedRejected;
    }

    public int getTotalNotFiled() {
        return this.countNewPersonRejected + this.countOEFRejected + this.countOIFRejected + this.countUnknownRejected + this.countUnspecifiedRejected;
    }
}

