/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.fw.batchprocess.DataFileProcessStatistics;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class LoadVSSCDataProcessStatistics
extends DataFileProcessStatistics {
    private static final long serialVersionUID = -5619317047208428159L;
    private int numberOfRecordsRead = 0;
    private int numberOfRecordsRejected = 0;
    private int numberOfRecordsAccepted = 0;
    private int numberOfOEFRecordsFiled = 0;
    private int numberOfOIFRecordsFiled = 0;
    private int numberOfUnknwonLocationRecordsFiled = 0;
    private int numberOfUnspecifiedLocationRecordsFiled = 0;
    private int numberOfRecordsNotMatched = 0;
    private int numberOfInvalidRecords = 0;
    private int numberOfInconsistentRecords = 0;
    private int numberOfRecordsNotFiled = 0;

    public int getNumberOfRecordsAccepted() {
        return this.numberOfRecordsAccepted;
    }

    public int getNumberOfRecordsRead() {
        return this.numberOfRecordsRead;
    }

    public int getNumberOfRecordsRejected() {
        return this.numberOfRecordsRejected;
    }

    public void setNumberOfRecordsAccepted(int numberOfRecordsAccepted) {
        this.numberOfRecordsAccepted = numberOfRecordsAccepted;
    }

    public void setNumberOfRecordsRead(int numberOfRecordsRead) {
        this.numberOfRecordsRead = numberOfRecordsRead;
    }

    public void setNumberOfRecordsRejected(int numberOfRecordsRejected) {
        this.numberOfRecordsRejected = numberOfRecordsRejected;
    }

    public int getNumberOfInconsistentRecords() {
        return this.numberOfInconsistentRecords;
    }

    public int getNumberOfInvalidRecords() {
        return this.numberOfInvalidRecords;
    }

    public int getNumberOfOEFRecordsFiled() {
        return this.numberOfOEFRecordsFiled;
    }

    public int getNumberOfOIFRecordsFiled() {
        return this.numberOfOIFRecordsFiled;
    }

    public int getNumberOfRecordsNotFiled() {
        return this.numberOfRecordsNotFiled;
    }

    public int getNumberOfRecordsNotMatched() {
        return this.numberOfRecordsNotMatched;
    }

    public int getNumberOfUnknwonLocationRecordsFiled() {
        return this.numberOfUnknwonLocationRecordsFiled;
    }

    public int getNumberOfUnspecifiedLocationRecordsFiled() {
        return this.numberOfUnspecifiedLocationRecordsFiled;
    }

    public void setNumberOfInconsistentRecords(int numberOfInconsistentRecords) {
        this.numberOfInconsistentRecords = numberOfInconsistentRecords;
    }

    public void setNumberOfInvalidRecords(int numberOfInvalidRecords) {
        this.numberOfInvalidRecords = numberOfInvalidRecords;
    }

    public void setNumberOfOEFRecordsFiled(int numberOfOEFRecordsFiled) {
        this.numberOfOEFRecordsFiled = numberOfOEFRecordsFiled;
    }

    public void setNumberOfOIFRecordsFiled(int numberOfOIFRecordsFiled) {
        this.numberOfOIFRecordsFiled = numberOfOIFRecordsFiled;
    }

    public void setNumberOfRecordsNotFiled(int numberOfRecordsNotFiled) {
        this.numberOfRecordsNotFiled = numberOfRecordsNotFiled;
    }

    public void setNumberOfRecordsNotMatched(int numberOfRecordsNotMatched) {
        this.numberOfRecordsNotMatched = numberOfRecordsNotMatched;
    }

    public void setNumberOfUnknwonLocationRecordsFiled(int numberOfUnknwonLocationRecordsFiled) {
        this.numberOfUnknwonLocationRecordsFiled = numberOfUnknwonLocationRecordsFiled;
    }

    public void setNumberOfUnspecifiedLocationRecordsFiled(int numberOfUnspecifiedLocationRecordsFiled) {
        this.numberOfUnspecifiedLocationRecordsFiled = numberOfUnspecifiedLocationRecordsFiled;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        this.buildToString(builder);
        return builder.toString();
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append((Object)this.getProcessName());
        builder.append("Processing Start Date", (Object)this.getProcessingStartDate());
        builder.append("Processing End Date", (Object)this.getProcessingEndDate());
        builder.append("Total Records Processed", this.getNumberOfRecordsRead());
        builder.append("Total Records Filed", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfRecordsAccepted()));
        builder.append("Total Records Not Filed", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfRecordsRejected()));
        builder.append((Object)"Breakdown of successfull records by location");
        builder.append("OEF", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfOEFRecordsFiled()));
        builder.append("OIF", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfOIFRecordsFiled()));
        builder.append("Unknown OEF/OIF", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfUnknwonLocationRecordsFiled()));
        builder.append("Conflict Unspecified", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfUnspecifiedLocationRecordsFiled()));
        builder.append((Object)"Breakdown of failed records by reason");
        builder.append("Records Not Matched", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfRecordsNotMatched()));
        builder.append("Invalid Records", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfInvalidRecords()));
        builder.append("Inconsistent Records", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfInconsistentRecords()));
        builder.append("Records that could not be filed", (Object)this.getPercent(this.getNumberOfRecordsRead(), this.getNumberOfRecordsNotFiled()));
        builder.append("Total files processed", this.getProcessedFiles().size());
        builder.append("Directory Path", (Object)this.getProcessedFilePath());
        builder.append("Processed Files", (Object)this.getProcessedFiles());
    }

    public void updateStatistics(LoadVSSCDataResult result) {
        this.setNumberOfRecordsRead(this.getNumberOfRecordsRead() + result.getTotalAccepted() + result.getTotalRejected());
        this.setNumberOfRecordsRejected(this.getNumberOfRecordsRejected() + result.getTotalRejected());
        this.setNumberOfRecordsAccepted(this.getNumberOfRecordsAccepted() + result.getTotalAccepted());
        this.setNumberOfOEFRecordsFiled(this.getNumberOfOEFRecordsFiled() + result.getCountOEFAccepted());
        this.setNumberOfOIFRecordsFiled(this.getNumberOfOIFRecordsFiled() + result.getCountOIFAccepted());
        this.setNumberOfUnknwonLocationRecordsFiled(this.getNumberOfUnknwonLocationRecordsFiled() + result.getCountUnknownAccepted());
        this.setNumberOfUnspecifiedLocationRecordsFiled(this.getNumberOfUnspecifiedLocationRecordsFiled() + result.getCountUnspecifiedAccepted());
        this.setNumberOfInvalidRecords(this.getNumberOfInvalidRecords() + result.getCountMissingInvalidRejected());
        this.setNumberOfInconsistentRecords(this.getNumberOfInconsistentRecords() + result.getCountCCRejected());
        this.setNumberOfRecordsNotMatched(this.getNumberOfRecordsNotMatched() + result.getCountNoMatchRejected());
        this.setNumberOfRecordsNotFiled(this.getNumberOfRecordsNotFiled() + result.getTotalNotFiled());
    }

    private String getPercent(int total, int processed) {
        String out = String.valueOf(processed);
        if (total > 0) {
            out = out + " ( " + String.valueOf(Math.round(100 * processed / total)) + "% )";
        }
        return out;
    }
}

