/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.LoadVSSCDataException;
import gov.va.med.esr.common.batchprocess.LoadVSSCDataProcessStatistics;
import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.batchprocess.VSSCFileData;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.MilitaryInfoService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import java.util.ArrayList;

public class LoadVSSCDataProcess
extends AbstractDataFileSingleRowIncrementProcess {
    public static final String PUNCTUATION_CHARS = "[,.'`]";
    private FormattedFileWriter exceptionFileWriter;
    private MilitaryInfoService militaryService = null;
    private PersonService personService = null;
    private LookupService lookupService = null;

    protected ProcessStatistics createProcessStatistics() {
        return new LoadVSSCDataProcessStatistics();
    }

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        try {
            VSSCFileData fileData = (VSSCFileData)((Object)bean);
            LoadVSSCDataResult result = null;
            LoadVSSCDataProcessStatistics statistics = (LoadVSSCDataProcessStatistics)context.getProcessStatistics();
            Person person = this.getMathcingPerson(fileData);
            this.getPersonService().checkAndAddESRCorrelation(person);
            if (person == null) {
                this.writeExceptionToFile(context, "EXCEPTION_REASON_NO_MATCH");
                result = new LoadVSSCDataResult();
                result.incrementCountNoMatchRejected();
                this.setStatisticalData(result, statistics);
                return false;
            }
            person.getMilitaryService().removeAllCombatEpisodes();
            person.getMilitaryService().addCombatEpisode(fileData.getCombatEpisode());
            result = this.militaryService.processVSSCData(person);
            this.setStatisticalData(result, statistics);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to process VSSC file record ", (Throwable)e);
            this.throwIllegalStateException("Unable to process VSSC file record ", e);
            return true;
        }
    }

    public FormattedFileWriter getExceptionFileWriter() {
        return this.exceptionFileWriter;
    }

    public void setExceptionFileWriter(FormattedFileWriter exceptionFileWriter) {
        this.exceptionFileWriter = exceptionFileWriter;
    }

    public MilitaryInfoService getMilitaryService() {
        return this.militaryService;
    }

    public void setMilitaryService(MilitaryInfoService militaryService) {
        this.militaryService = militaryService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public boolean beanCreationFailure(DataFileProcessExecutionContext context, String nextRowRawData, Exception e) {
        LoadVSSCDataProcessStatistics statistics = (LoadVSSCDataProcessStatistics)context.getProcessStatistics();
        LoadVSSCDataResult result = new LoadVSSCDataResult();
        String reason = e.getMessage();
        if (LoadVSSCDataResult.EXP_CONSISTENCY_CHECKS_FAILED.equals(reason)) {
            result.incrementCountCCRejected();
        } else if (LoadVSSCDataResult.EXP_REQUIRED_FIELDS_MISSING_INVALID.equals(reason)) {
            result.incrementCountMissingInvalidRejected();
        } else {
            result.incrementCountMissingInvalidRejected();
        }
        this.writeExceptionToFile(context, reason);
        this.setStatisticalData(result, statistics);
        return true;
    }

    private void setStatisticalData(LoadVSSCDataResult result, LoadVSSCDataProcessStatistics statistics) {
        statistics.updateStatistics(result);
    }

    private void writeExceptionToFile(DataFileProcessExecutionContext context, String exceptionReason) {
        LoadVSSCDataException exceptionData = new LoadVSSCDataException();
        exceptionData.setInputRawData(context.getCurrentRowRawData());
        exceptionData.setExceptionReason(exceptionReason);
        ArrayList<LoadVSSCDataException> exceptionOutputDataList = new ArrayList<LoadVSSCDataException>();
        exceptionOutputDataList.add(exceptionData);
        this.exceptionFileWriter.appendData(exceptionOutputDataList);
    }

    private Person getMathcingPerson(VSSCFileData vsscFileData) throws Exception {
        PersonIdentityTraits traits = new PersonIdentityTraits();
        SSN officialSSN = new SSN();
        officialSSN.setSsnText(vsscFileData.getSsn().replaceAll("-", ""));
        officialSSN.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getCode()));
        traits.setSsn(officialSSN);
        Person person = this.getPersonService().find(traits);
        return this.matchPerson(person, vsscFileData) ? person : null;
    }

    private boolean matchPerson(Person person, VSSCFileData vsscFileData) {
        if (this.getICN(person.getVPIDEntityKey()).equals(vsscFileData.getIcn())) {
            return true;
        }
        String firstNamefromFile = vsscFileData.getFirstName() == null ? "" : vsscFileData.getFirstName();
        String lastNamefromFile = vsscFileData.getLastName() == null ? "" : vsscFileData.getLastName();
        String yearFromFile = vsscFileData.getDateOfBirth().getYear();
        Name name = person.getLegalName();
        String firstNamefromDB = name.getGivenName() == null ? "" : name.getGivenName();
        String lastNamefromDB = name.getFamilyName() == null ? "" : name.getFamilyName();
        String yearFromDB = person.getBirthRecord().getBirthDate().getYear();
        firstNamefromFile = firstNamefromFile.toUpperCase().replaceAll(PUNCTUATION_CHARS, "");
        firstNamefromDB = firstNamefromDB.toUpperCase().replaceAll(PUNCTUATION_CHARS, "");
        lastNamefromFile = lastNamefromFile.toUpperCase().replaceAll(PUNCTUATION_CHARS, "");
        lastNamefromDB = lastNamefromDB.toUpperCase().replaceAll(PUNCTUATION_CHARS, "");
        if (this.match(firstNamefromFile, firstNamefromDB) && yearFromFile.equals(yearFromDB)) {
            return true;
        }
        if (this.match(lastNamefromFile, lastNamefromDB) && yearFromFile.equals(yearFromDB)) {
            return true;
        }
        return this.match(lastNamefromFile, lastNamefromDB) && this.match(firstNamefromFile, firstNamefromDB);
    }

    private boolean match(String src, String dest) {
        if (src.equals(dest)) {
            return true;
        }
        String[] srcList = src.split("-");
        String[] destList = dest.split("-");
        if (srcList.length > 1 && destList.length > 1) {
            return false;
        }
        if (srcList.length == 2 && (dest.equals(srcList[0]) || dest.equals(srcList[1]))) {
            return true;
        }
        return destList.length == 2 && (src.equals(destList[0]) || src.equals(destList[1]));
    }

    private String getICN(VPIDEntityKey vpidKey) {
        String vpid = vpidKey.getShortVPID();
        int loc = vpid.indexOf(86);
        return vpid.substring(0, loc);
    }
}

