/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.LoadRegistryFileData;
import gov.va.med.esr.common.batchprocess.LoadRegistryProcessStatistics;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.service.LoadRegistryResult;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.ServiceException;
import java.util.HashMap;
import java.util.Map;

public class LoadRegistryProcess
extends AbstractDataFileSingleRowIncrementProcess {
    private static Map registryTypes = new HashMap(){
        private static final long serialVersionUID = -1190015544065810633L;
        {
            this.put("ProcessPOWRegistryFile", RegistryType.CODE_POW_REGISTRY.getCode());
            this.put("ProcessPurpleHeartRegistryFile", RegistryType.CODE_PH_REGISTRY.getCode());
            this.put("ProcessSHADRegistryFile", RegistryType.CODE_SHAD_REGISTRY.getCode());
        }
    };
    private FormattedFileWriter exceptionFileWriter;
    private RegistryService registryService;
    private LookupService lookupService;

    public FormattedFileWriter getExceptionFileWriter() {
        return this.exceptionFileWriter;
    }

    public void setExceptionFileWriter(FormattedFileWriter exceptionFileWriter) {
        this.exceptionFileWriter = exceptionFileWriter;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new LoadRegistryProcessStatistics();
    }

    public boolean beanCreationFailure(DataFileProcessExecutionContext context, String nextRowRawData, Exception e) {
        LoadRegistryProcessStatistics statistics = (LoadRegistryProcessStatistics)context.getProcessStatistics();
        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
        statistics.incrementRecordsRead();
        statistics.incrementRecordsFailedConsistencyCheck();
        try {
            statistics.setRegistryType((RegistryType)this.getLookupService().getByCode(RegistryType.class, (String)registryTypes.get(this.getAuditId())));
            statistics.addRegistryExceptionDetail((ReportExceptionType)this.getLookupService().getByCode(ReportExceptionType.class, ReportExceptionType.R1), context.getCurrentRowRawData());
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Could not lookup code while adding consistency check failure record" + ReportExceptionType.R1.getCode()), (Throwable)ex);
        }
        return true;
    }

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        LoadRegistryProcessStatistics statistics = (LoadRegistryProcessStatistics)context.getProcessStatistics();
        Registry registry = null;
        try {
            LoadRegistryFileData fileData = (LoadRegistryFileData)((Object)bean);
            registry = fileData.getRegistry();
            LoadRegistryResult result = this.registryService.processRegistry(registry);
            this.setStatisticalData(context, registry, result, statistics);
        }
        catch (Throwable e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Error processing data record: " + context.getCurrentRowRawData()), e);
            }
            this.setSystemErrorStatisticalData(context, registry, e);
        }
        return true;
    }

    private void setStatisticalData(DataFileProcessExecutionContext context, Registry registry, LoadRegistryResult result, LoadRegistryProcessStatistics statistics) {
        statistics.setRegistryType(registry.getRegistryTrait().getRegistryType());
        statistics.incrementRecordsRead();
        statistics.incrementRecordsPassedConsistencyCheck();
        if (result != null) {
            if (!result.isExactMatch()) {
                statistics.incrementRecordsNotMatchedToExistingRecords();
            }
            if (result.isAmbiguousMatch()) {
                statistics.incrementRecordsAmbigouslyMatched();
            }
            if (result.isExactMatch()) {
                statistics.incrementRecordsMatchedToExistingRecords();
            }
            if (result.isNewRegistry()) {
                statistics.incrementNewRegistryEntriesInserted();
            }
            if (result.getExceptionType() != null) {
                statistics.addRegistryExceptionDetail(result.getExceptionType(), context.getCurrentRowRawData());
            }
        }
    }

    private void setSystemErrorStatisticalData(DataFileProcessExecutionContext context, Registry registry, Throwable e) {
        LoadRegistryProcessStatistics statistics = (LoadRegistryProcessStatistics)context.getProcessStatistics();
        statistics.setRegistryType(registry.getRegistryTrait().getRegistryType());
        statistics.incrementRecordsRead();
        statistics.incrementRecordsPassedConsistencyCheck();
        statistics.addRegistryExceptionDetail(null, context.getCurrentRowRawData() + "^[Error message - " + (e.getMessage() == null ? "Unknown system exception" : e.getMessage()) + "]");
    }
}

