/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.HandbookMailingResponseErrorFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.HandbookMailingResponseErrorFileProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class HandbookMailingResponseErrorFileProcess
extends AbstractDataFileSingleRowIncrementProcess
implements Serializable {
    private PersonService personService;
    private DemographicService demographicService;
    private HandBookService handBookService;
    private LookupService lookupService;
    private String rawData = null;
    private HandbookMailingResponseErrorFileProcessStatistics stats;

    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (acquiredData.isEmpty()) {
            this.logger.info((Object)"no records");
            return;
        }
        this.logger.info((Object)"processing a new record");
        if (this.stats == null) {
            try {
                this.stats = (HandbookMailingResponseErrorFileProcessStatistics)context.getProcessStatistics();
            }
            catch (ClassCastException cex) {
                this.logger.error((Object)"ClassCastException : ", (Throwable)cex);
            }
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            try {
                Object obj = acquiredData.get(i);
                if (this.processDataRecord(context, obj)) {
                    if (this.isKeepProcessedData()) {
                        context.getProcessedData().add(obj);
                        this.logger.info((Object)("adding processDataRecord " + i));
                        continue;
                    }
                    this.logger.info((Object)"NO MORE DATA run any clean up");
                    this.updateJobResultsLast(context);
                    continue;
                }
                this.logger.info((Object)"one record sent back false - stopping processDataRecords");
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                this.updateJobResultsLast(context);
                break;
            }
            catch (RuntimeException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("RuntimeException processDataRecords^" + e.getMessage() + "^" + this.rawData));
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                context.getExceptionData().add(this.createExceptionObject("RuntimeException processDataRecords^" + this.rawData + "^" + e.fillInStackTrace()));
            }
        }
    }

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        HandbookMailingResponseErrorFileData dataRecord = (HandbookMailingResponseErrorFileData)((Object)bean);
        boolean success = true;
        this.rawData = context.getCurrentRowRawData();
        this.addReason(dataRecord.getProdNumText(), dataRecord.getFailed());
        try {
            if (dataRecord.validateData().size() > 0) {
                List invalidData = dataRecord.validateData();
                String errMsg = "";
                for (int i = 0; i < invalidData.size(); ++i) {
                    errMsg = errMsg + "^" + (String)invalidData.get(i);
                }
                this.logger.error((Object)("Failed - Missing Required Fields" + errMsg));
                context.getExceptionData().add(this.createExceptionObject("Failed - Missing Required Fields" + errMsg + "^" + this.rawData));
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return success;
            }
            String formName = dataRecord.getProdNumText();
            if (formName.equals("F400H")) {
                this.stats.incrementH400HRecordsProcessed();
            } else if (formName.equals("F400B")) {
                this.stats.incrementH400BRecords();
            } else if (formName.equals("F400F")) {
                this.stats.incrementH400FRecords();
            } else {
                this.logger.info((Object)("Invalid Product ID^" + this.rawData));
                context.getExceptionData().add(this.createExceptionObject("Invalid Product ID^" + this.rawData));
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return success;
            }
            HandBookMailQueue mailQueue = new HandBookMailQueue();
            String errorText = null;
            try {
                mailQueue = this.handBookService.findHandBookByIdentifier(dataRecord.getUID());
                errorText = mailQueue.getHandBookMailStatus().getErrorText();
                errorText = errorText == null || errorText.length() == 0 ? "Invalid fields in the CMS data extract^" + dataRecord.getFailed() + "^" : errorText + dataRecord.getFailed() + "^";
                mailQueue.getHandBookMailStatus().setErrorText(errorText);
            }
            catch (Exception ex) {
                this.logger.error((Object)("Invalid Request ID^Exception - handBookService.findHandBookByIdentifier^" + ex.getMessage() + "^" + this.rawData));
                context.getExceptionData().add("Invalid Request ID^Exception - handBookService.findHandBookByIdentifier^" + this.rawData + "^" + ex.fillInStackTrace());
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return success;
            }
            if (mailQueue == null) {
                this.logger.error((Object)("Invalid Request ID^mailQueue is null^" + this.rawData));
                context.getExceptionData().add("Invalid Request ID^mailQueue is null^" + this.rawData);
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return success;
            }
            String vpidCompare = null;
            String icnCompare = null;
            try {
                String personId = String.valueOf(mailQueue.getPersonId());
                PersonIdEntityKey pkey = CommonEntityKeyFactory.createPersonIdEntityKey(personId);
                vpidCompare = this.personService.getVPIDByPersonId(pkey).getVPID();
                icnCompare = this.handBookService.getICNChecksumForVpid(vpidCompare);
                this.logger.info((Object)("does [" + dataRecord.getVPID() + "] = [" + icnCompare + "]"));
            }
            catch (Exception ex) {
                this.logger.error((Object)("Exception - getVPIDByPersonId failed^" + this.rawData + "^" + ex.fillInStackTrace()));
                context.getExceptionData().add("Exception - getVPIDByPersonId failed^" + this.rawData + "^" + ex.fillInStackTrace());
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return success;
            }
            if (!icnCompare.equals(dataRecord.getVPID())) {
                this.logger.error((Object)("Invalid Veteran ID^" + this.rawData));
                context.getExceptionData().add("Invalid Veteran Id^" + this.rawData);
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return success;
            }
            String uid = dataRecord.getUID();
            try {
                HandBookMailStatusType statusType = this.lookupService.getHandBookMailingStatusTypeByCode(HandBookMailStatusType.ERROR_BY_CMS.getCode());
                this.handBookService.saveHandbookMailStatus(mailQueue, statusType);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            }
            catch (Exception ex) {
                this.logger.error((Object)("processDataRecord updateStatus update Exception uid=" + uid + " : " + this.rawData), (Throwable)ex);
                context.getExceptionData().add("Exception - updateStatus^" + this.rawData + "^" + ex.fillInStackTrace());
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
        }
        catch (Exception ex) {
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            this.logger.error((Object)("processDataRecord - Exception processing data record^" + this.rawData + "^" + ex.fillInStackTrace()));
            context.getExceptionData().add(this.createExceptionObject("processDataRecord - Exception processing data record^" + this.rawData + "^" + ex.fillInStackTrace()));
        }
        return success;
    }

    private void setCustomStats(DataFileProcessExecutionContext context) {
        this.stats = new HandbookMailingResponseErrorFileProcessStatistics();
        this.stats.appendStats(context.getProcessStatistics());
        context.setProcessStatistics((ProcessStatistics)this.stats);
    }

    private void addReason(String formType, String reason) {
        if (formType.equals("F400H")) {
            this.stats.appendH400HReason(reason);
        } else if (formType.equals("F400B")) {
            this.stats.appendH400BReason(reason);
        } else {
            this.stats.appendH400FReason(reason);
        }
    }

    private void updateJobResultsLast(DataFileProcessExecutionContext context) {
        this.stats.setProcessingEndDate(new Date());
        this.updateJobResult((DataProcessExecutionContext)context);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new HandbookMailingResponseErrorFileProcessStatistics();
    }
}

