/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CommsExportStatistics;
import gov.va.med.esr.common.batchprocess.HandbookBatchProcess;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.DeliveryPreferenceEmail;
import gov.va.med.esr.common.model.comms.HandBookDocument;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HandBookMailStatus;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;

public class HandbookBatchProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private LookupService lookupService;
    private HandBookService handBookService;
    private PreferredFacilityService preferredFacilityService;
    private PersonService personService;
    private PersonHelperService personHelperService;
    private DemographicService demographicService;
    private EligibilityEnrollmentService eligibilityEnrollmentService;
    private CommsEmailBulletinService commsEmailBulletinService;
    private PersonMergeService personMergeService;
    private Object[] acquiredData;
    private final String HANDBOOK_TYPE = "742-400B";
    private final String FORM_HEADER = "FORM=H";
    private static DataQueryProcessExecutionContext context = null;
    private static String processName = null;
    private final String SEP = "^";
    private final String EOL = "\n";
    private final String EMPTY_STRING = "";
    private final String YES = "Y";
    private final String NO = "N";
    private final String Yes_STRING = "Yes";
    private final String No_STRING = "No";
    private final String REJECT_REASON = "Rejected at HEC";
    private final String ERROR_REASON = "Exception during Handbook Batch Process";
    private final String REJECT_ERROR_DURING_PROCESS_CODE = "1";
    private final String REJECT_ERROR_DEPRECATED_PERSON_CODE = "7";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        BigDecimal personId = (BigDecimal)this.acquiredData[0];
        String mailingId = (String)this.acquiredData[1];
        String formNumber = (String)this.acquiredData[2];
        Person person = null;
        HandBookMailQueue mailQ = null;
        Writer extractWriter = (Writer)context.getContextData().get("ExtractDataWriter");
        Writer exceptionWriter = (Writer)context.getContextData().get("ExceptionDataWriter");
        try {
            person = this.personService.getPerson(new PersonIdEntityKeyImpl(personId));
            if (person == null) {
                throw new ServiceException("Unable to find Person with personId= " + personId);
            }
            mailQ = this.getHandBookService().findHandBookByIdentifier(mailingId);
            if (mailQ == null) {
                throw new ServiceException("Unable to find HandBookMailQueue with mailingId= " + mailingId);
            }
            String errorMessages = this.validateFields(person, mailingId, formNumber);
            boolean deprecated = this.personMergeService.hasDeprecatedRecord((PersonIdEntityKey)person.getEntityKey());
            if (deprecated) {
                errorMessages = this.addDeprecatedMsg(errorMessages);
            }
            if (errorMessages != null && errorMessages.length() > 0) {
                this.updateHandbookRejectEntry(mailQ, errorMessages, deprecated);
                HandbookBatchProcess.stats.updateRejectPerReasonPerformTable(errorMessages, formNumber);
                HandbookBatchProcess.stats.incrementNumberRejected();
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Rejected at HEC (personId= " + personId + " HandBook Mail Queue Id= " + mailingId + " Form Number= " + formNumber + ") Reject Reasons= " + errorMessages;
                context.getExceptionData().add(errMsg);
                Writer writer = exceptionWriter;
                synchronized (writer) {
                    exceptionWriter.write(errMsg + "\n");
                }
                return;
            }
            Address mailingAddress = this.getDemographicService().getLetterAddress(person);
            String aLine = this.produceText(person, mailQ, formNumber, context.getProcessStatistics().getProcessingStartDate(), mailingAddress);
            this.updateHandbookSuccessEntry(mailQ, person, mailingAddress, aLine);
            this.sendEmailNotice(person);
            HandbookBatchProcess.stats.addToCountPerFormTable(formNumber);
            HandbookBatchProcess.stats.incrementNumberSent();
            context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            Writer writer = extractWriter;
            synchronized (writer) {
                extractWriter.write(aLine);
            }
        }
        catch (Exception ex) {
            try {
                String errMsg;
                String errText = errMsg = "Exception during Handbook Batch Process (personId= " + personId + " HandBook Mail Queue Id= " + mailingId + " Form Number= " + formNumber + ") ";
                if (errMsg != null && errMsg.length() > 400) {
                    errText = errMsg.substring(0, 350);
                }
                this.updateHandbookRejectEntry(mailQ, errText, false);
                errMsg = ExceptionUtils.getRootCause((Throwable)ex) == null || ex instanceof NullPointerException ? errMsg + "Exception = " + ex : errMsg + "Root Cause = " + ExceptionUtils.getRootCause((Throwable)ex);
                context.getExceptionData().add(errMsg);
                this.logger.error((Object)errMsg, (Throwable)ex);
                HandbookBatchProcess.stats.incrementNumberWithException();
                HandbookBatchProcess.stats.updateRejectPerReasonPerformTable("Exception during Handbook Batch Process", formNumber);
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                Writer writer = exceptionWriter;
                synchronized (writer) {
                    exceptionWriter.write(errMsg + "\n");
                }
            }
            catch (ServiceException se) {
                this.logger.error((Object)"Cannot Update Handbook Error While Catch the Application Exception:", (Throwable)se);
            }
        }
        finally {
            Object threadCreator;
            HandbookBatchProcess.adjustTaskCount((DataProcessExecutionContext)context, -1);
            Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)context);
            synchronized (object) {
                threadCreator.notifyAll();
            }
        }
    }

    private String addDeprecatedMsg(String errorMessages) {
        return errorMessages != null ? errorMessages + "DEPRECATED PERSON RECORD" + CommsExportStatistics.LINE_BREAK : "DEPRECATED PERSON RECORD" + CommsExportStatistics.LINE_BREAK;
    }

    private String validateFields(Person person, String mailingId, String formNumber) throws ServiceException {
        String missingTraits;
        StringBuffer errorMessage = new StringBuffer();
        if (formNumber == null || formNumber.equals("")) {
            errorMessage.append("FORM TYPE IS REQUIRED").append(CommsExportStatistics.LINE_BREAK);
        }
        if (!this.calculateNewEnrolee(person)) {
            errorMessage.append("NOT ENROLLED").append(CommsExportStatistics.LINE_BREAK);
        }
        if (mailingId == null || mailingId.equals("")) {
            errorMessage.append("UNIQUE IDENTIFIER IS REQUIRED").append(CommsExportStatistics.LINE_BREAK);
        }
        if ((missingTraits = this.hasReqIdentityTraitData(person)).length() > 0) {
            errorMessage.append("MISSING REQUIRED IDENTITY TRAITS INFO - ").append(missingTraits).append(CommsExportStatistics.LINE_BREAK);
        }
        if (!this.hasValidAddress(person)) {
            errorMessage.append("INVALID ADDRESS").append(CommsExportStatistics.LINE_BREAK);
        }
        if (!this.hasPreferredFacility(person)) {
            errorMessage.append("NO PREFERRED FACILITY LISTED").append(CommsExportStatistics.LINE_BREAK);
        }
        if (!this.hasPriority(person)) {
            errorMessage.append("NO PRIORITY GROUP").append(CommsExportStatistics.LINE_BREAK);
        }
        if (this.hasDOD(person)) {
            errorMessage.append("HAS DATE OF DEATH\n");
        }
        return errorMessage.toString();
    }

    private boolean calculateNewEnrolee(Person person) {
        return person.getEnrollmentDetermination() != null;
    }

    private String hasReqIdentityTraitData(Person person) {
        String msg = "";
        if (person == null || person.getIdentityTraits() == null) {
            return "person or person traits null";
        }
        if (person.getIdentityTraits().getLegalName() == null || person.getIdentityTraits().getLegalName().getFamilyName() == null || person.getIdentityTraits().getLegalName().getFamilyName().length() == 0) {
            msg = msg + "last name | ";
        }
        if (person.getIdentityTraits().getGender() == null) {
            msg = msg + "gender | ";
        }
        if (person.getIdentityTraits().getBirthRecord() == null || person.getIdentityTraits().getBirthRecord().getBirthDate() == null || person.getIdentityTraits().getBirthRecord().getBirthDate().equals("")) {
            msg = msg + "DOB | ";
        }
        if (person.getIdentityTraits().getVpid() == null) {
            msg = msg + "UID";
        }
        return msg;
    }

    private boolean hasValidAddress(Person person) throws ServiceException {
        Address mailingAddress = this.getDemographicService().getLetterAddress(person);
        if (mailingAddress != null && mailingAddress.getLine1() != null && mailingAddress.getLine1().trim().length() > 0 && mailingAddress.getCity() != null && mailingAddress.getCity().trim().length() > 0 && mailingAddress.getCountryObject() != null) {
            if (Country.CODE_USA.equals(mailingAddress.getCountryObject().getAlpha3Code())) {
                return mailingAddress.getState() != null && mailingAddress.getZipCode() != null;
            }
            return true;
        }
        return false;
    }

    private boolean hasPreferredFacility(Person person) throws ServiceException {
        return !this.preferredFacilityService.getPreferredFacilitySites(person).isEmpty();
    }

    private boolean hasPriority(Person person) {
        if (person.getEnrollmentDetermination() != null && person.getEnrollmentDetermination().getPriorityGroup() != null) {
            if (person.getEnrollmentDetermination().getPriorityGroup().equals((Object)EnrollmentPriorityGroup.GROUP_7) || person.getEnrollmentDetermination().getPriorityGroup().equals((Object)EnrollmentPriorityGroup.GROUP_8)) {
                if (person.getEnrollmentDetermination().getPrioritySubGroup() != null) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean hasDOD(Person person) {
        boolean hasDod = false;
        if (person.getDeathRecord() != null && person.getDeathRecord().getDeathDate() != null) {
            hasDod = true;
        }
        return hasDod;
    }

    protected String produceText(Person person, HandBookMailQueue mailQ, String formNumber, Date startDt, Address mailingAddress) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering produceText()...");
        }
        StringBuffer aLine = new StringBuffer(1024);
        this.populateHeader(formNumber, mailQ.getHandBookReleaseControl().getCode(), this.outputDate(startDt), aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateQ_N01()...");
        }
        this.populateQ_N01(person, mailQ, formNumber, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateA_N03()...");
        }
        this.populateA_N03(person, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateB_P01()...");
        }
        this.populateB_P01(person, mailingAddress, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateE()...");
        }
        this.populateE(person, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateF()...");
        }
        this.populateF(person, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateG()...");
        }
        this.populateG(person, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entering populateM_N05()...");
        }
        this.populateM_N05(person, startDt, aLine);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Leaving produceText()...");
        }
        return aLine.toString();
    }

    private String outputDate(Date incomingDate) {
        String date = DateUtils.format((Date)incomingDate, (String)"MM/dd/yyyy");
        return date == null ? "" : date.replaceAll("/", "");
    }

    private void populateHeader(String formNumber, String releaseControlNum, String createDate, StringBuffer aLine) {
        String formSuffix = formNumber;
        int index = formNumber.indexOf("-");
        if (index > 0) {
            formSuffix = formNumber.substring(index + 1);
        }
        aLine.append("FORM=H").append(formSuffix).append("^").append(releaseControlNum).append("^").append(createDate).append("^");
    }

    private void populateQ_N01(Person person, HandBookMailQueue mailQ, String formNumber, StringBuffer aLine) throws ServiceException {
        aLine.append("Q01=").append(this.getPreferredFacilityType(person)).append("^").append("Q02=").append(mailQ.getId()).append("^").append("N01=").append(this.isNewEnrollee(mailQ, person, formNumber)).append("^");
    }

    private void populateA_N03(Person person, StringBuffer aLine) throws ServiceException {
        Name name = person.getIdentityTraits().getLegalName();
        aLine.append("A00=").append(name.getPrefix() == null ? "" : name.getPrefix()).append("^").append("A01=").append(name.getFamilyName()).append("^").append("A02=").append(name.getGivenName()).append("^").append("A03=").append(name.getMiddleName() == null ? "" : name.getMiddleName()).append("^").append("A04=").append(name.getSuffix() == null ? "" : name.getSuffix()).append("^").append("A15=").append(person.getIdentityTraits().getVpid().getShortVPID()).append("^").append("N02=").append(person.getIdentityTraits().getGender().getCode()).append("^").append("N03=").append(this.outputDate(ImpreciseDateUtils.getDateWithDefault(person.getIdentityTraits().getBirthRecord().getBirthDate()))).append("^");
    }

    private void populateB_P01(Person person, Address mailingAddress, StringBuffer aLine) throws ServiceException {
        aLine.append("B01=").append(mailingAddress.getLine1()).append("^").append("B02=").append(mailingAddress.getLine2() == null ? "" : mailingAddress.getLine2()).append("^").append("B03=").append(mailingAddress.getLine3() == null ? "" : mailingAddress.getLine3()).append("^").append("B04=").append(mailingAddress.getCity() == null ? "" : mailingAddress.getCity()).append("^").append("B05=").append(mailingAddress.getState() == null ? "" : mailingAddress.getState()).append("^").append("B06=").append(mailingAddress.getCountryObject().getAlpha3Code()).append("^").append("B06=").append(mailingAddress.getZipCode() == null ? "" : this.buildZipCode(mailingAddress)).append("^").append("B07=").append(mailingAddress.getPostalCode() == null ? "" : mailingAddress.getPostalCode()).append("^").append("B08=").append(mailingAddress.getCounty() == null ? "" : mailingAddress.getCounty()).append("^").append("B09=").append(mailingAddress.getProvince() == null ? "" : mailingAddress.getProvince()).append("^").append("B10=").append(this.getEmailAddress(person)).append("^").append("B11=").append(mailingAddress.getBadAddressReason() == null ? "" : "Y").append("^").append("P01=");
        Set<VAFacility> preferredFacilitySites = this.preferredFacilityService.getPreferredFacilitySites(person);
        boolean first = true;
        VAFacility actualPF2 = null;
        HashSet<String> stations = new HashSet<String>();
        for (VAFacility actualPF2 : preferredFacilitySites) {
            String stationNum = actualPF2.getStationNumber();
            if (stations.contains(stationNum)) continue;
            stations.add(stationNum);
            if (first) {
                first = false;
            } else {
                aLine.append("|");
            }
            aLine.append(stationNum);
        }
        aLine.append("^");
    }

    private void populateE(Person person, StringBuffer aLine) throws ServiceException {
        aLine.append("E01=").append(this.getApplicationDate(person)).append("^").append("E02=").append(this.getEnrollmentDate(person)).append("^").append("E03=").append(this.getEnrollmentEndDate(person)).append("^").append("E04=").append(this.earliestChangeEffDate(person)).append("^").append("E05=").append(this.mostRecentEffDateOfChange(person)).append("^").append("E06=").append(this.getEnrollmentCategory(person)).append("^").append("E07=").append(this.getEnrollmentStatus(person)).append("^").append("E08=").append(person.getEnrollmentDetermination().getPriorityGroup().getCode()).append("^").append("E09=").append(this.getEnrollmentSubPriority(person)).append("^");
    }

    private void populateF(Person person, StringBuffer aLine) throws ServiceException {
        IncomeTest personIncomeTest = this.getCurrentIncomeTest(person);
        aLine.append("F01=").append(this.getServiceConnectedIndicator(person)).append("^").append("F02=").append(this.getServiceConnectedPercentage(person)).append("^").append("F03=").append(this.getCheckAmount(person)).append("^").append("F04=").append(this.getUnemployableIndicator(person)).append("^").append("F05=").append(this.getPTIndicator(person)).append("^").append("F06=").append(this.getVAPensionIndicator(person)).append("^").append("N06=").append(this.getAttributableIncome(personIncomeTest)).append("^").append("F07=").append(this.populatePhIndicator(person.getPurpleHeart())).append("^").append("F08=").append(person.getPurpleHeart() != null && person.getPurpleHeart().getStatus() != null ? person.getPurpleHeart().getStatus().getDescription() : "").append("^").append("F09=").append(this.populatePowIndicator(person.getPrisonerOfWar())).append("^").append("F10=").append(this.populateMohIndicator(person.getMedalOfHonor())).append("^");
    }

    private void populateG(Person person, StringBuffer aLine) throws ServiceException {
        IncomeTest personIncomeTest = this.getCurrentIncomeTest(person);
        aLine.append("G01=").append(this.getAAStatus(person)).append("^").append("G02=").append(this.getHouseBoundStatus(person)).append("^").append("G03=").append(this.getPrimaryEligCode(person)).append("^").append("G04=").append(this.getMTStatus(personIncomeTest)).append("^").append("G05=").append(this.getRXCopay(personIncomeTest)).append("^").append("G06=").append(this.getHardshipEndDate(personIncomeTest)).append("^").append("G07=").append(this.getMedicaidStatus(person)).append("^");
    }

    private void populateM_N05(Person person, Date startDt, StringBuffer aLine) throws ServiceException {
        MilitaryService ms = person.getMilitaryService();
        if (ms != null) {
            aLine.append("M01=").append(this.calculateCombatVeteranEligStatus(ms, startDt)).append("^").append("M02=").append(this.outputDate(ms.getCombatVeteranEligibilityEndDate())).append("^").append("M03=").append(this.getDischargeDueToDisability(ms)).append("^").append("M04=").append(this.getDisabilityRetirement(ms)).append("^");
        } else {
            aLine.append("M01=").append("").append("^").append("M02=").append("").append("^").append("M03=").append("").append("^").append("M04=").append("").append("^");
        }
        RadiationExposure re = person.getRadiationExposure();
        if (re != null) {
            aLine.append("M05=").append(this.populateExposureInd(re)).append("^").append("M06=").append(this.populateExposureMethod(re)).append("^");
        } else {
            aLine.append("M05=").append("").append("^").append("M06=").append("").append("^");
        }
        if (person.getShad() != null && person.getShad().getShadIndicator() != null) {
            aLine.append("M07=").append(this.convertIndicator(person.getShad().getShadIndicator().getCode())).append("^");
        } else {
            aLine.append("M07=").append("").append("^");
        }
        NoseThroatRadium ntr = person.getNoseThroatRadium();
        if (ntr != null) {
            aLine.append("M08=").append(this.cancerDiagnose(ntr)).append("^").append("M09=").append(ntr.getVerificationFacility() != null ? ntr.getVerificationFacility().getStationNumber() : "").append("^").append("M10=").append(ntr.getVerificationMethod() != null ? ntr.getVerificationMethod().getDescription() : "").append("^");
        } else {
            aLine.append("M08=").append("").append("^").append("M09=").append("").append("^").append("M10=").append("").append("^");
        }
        AgentOrangeExposure aoe = person.getAgentOrangeExposure();
        if (aoe != null) {
            aLine.append("M11=").append(this.populateOrangeExposureInd(aoe)).append("^").append("M12=").append(this.populateOrangeExposureMethod(aoe)).append("^");
        } else {
            aLine.append("M11=").append("").append("^").append("M12=").append("").append("^");
        }
        aLine.append("M13=").append(this.getEnvironementalContaminationExposure(person)).append("^");
        aLine.append("M14=").append(person.getCatastrophicDisability() != null ? this.catastrophicallyDisabledInd(person.getCatastrophicDisability()) : "").append("^").append("N05=").append(this.getVADisabilityComp(person)).append("^").append("\n");
    }

    private String isNewEnrollee(HandBookMailQueue mailQ, Person person, String formNumber) throws ServiceException {
        if (this.calculateNewEnrolleeData(mailQ, person, formNumber)) {
            return "Yes";
        }
        return "No";
    }

    private String buildZipCode(Address mailingAddress) {
        String zipCode = mailingAddress.getZipPlus4() != null ? mailingAddress.getZipCode() + "-" + mailingAddress.getZipPlus4() : mailingAddress.getZipCode();
        return zipCode;
    }

    private String getEmailAddress(Person person) {
        Email vemail;
        ArrayList emails = new ArrayList(person.getEmails());
        String emailaddress = "";
        Iterator iterator = emails.iterator();
        while (iterator.hasNext() && ((emailaddress = (vemail = (Email)((Object)iterator.next())).getAddress()) == null || !StringUtils.isNotEmpty((String)emailaddress))) {
        }
        return emailaddress;
    }

    private boolean calculateNewEnrolleeData(HandBookMailQueue mailQ, Person person, String formNumber) throws ServiceException {
        if (!formNumber.equals("742-400B")) {
            Date mailQRecordCreatedDate = mailQ.getCreatedOn();
            Date recModifiedDate = person.getEnrollmentDetermination().getModifiedOn();
            return !this.getEligibilityEnrollmentService().getPriorToEnrDetermHistory(person.getEntityKey(), mailQRecordCreatedDate, recModifiedDate);
        }
        return false;
    }

    private String getCheckAmount(Person person) {
        if (person.getMonetaryBenefitAward() != null && person.getMonetaryBenefitAward().getCheckAmount() != null) {
            return person.getMonetaryBenefitAward().getCheckAmount().toString();
        }
        return "";
    }

    private String getVAPensionIndicator(Person person) {
        return this.getMonetaryBenefitIndicator(person, MonetaryBenefitType.CODE_VA_PENSION);
    }

    private String getAAStatus(Person person) {
        return this.getMonetaryBenefitIndicator(person, MonetaryBenefitType.CODE_AID_AND_ATTENDANCE);
    }

    private String getHouseBoundStatus(Person person) {
        return this.getMonetaryBenefitIndicator(person, MonetaryBenefitType.CODE_HOUSEBOUND);
    }

    private String getVADisabilityComp(Person person) {
        return this.getMonetaryBenefitIndicator(person, MonetaryBenefitType.CODE_DISABILITY_COMPENSATION);
    }

    private String getMonetaryBenefitIndicator(Person person, MonetaryBenefitType.Code mbt) {
        String indicator = "";
        if (person.getMonetaryBenefitAward() != null && person.getMonetaryBenefitAward().getMonetaryBenefitByType(mbt) != null && person.getMonetaryBenefitAward().getMonetaryBenefitByType(mbt).getMonetaryBenefitIndicator() != null) {
            if (person.getMonetaryBenefitAward().getMonetaryBenefitByType(mbt).getMonetaryBenefitIndicator().getCode().equals(Indicator.NO.getCode())) {
                indicator = "N";
            } else if (person.getMonetaryBenefitAward().getMonetaryBenefitByType(mbt).getMonetaryBenefitIndicator().getCode().equals(Indicator.YES.getCode())) {
                indicator = "Y";
            }
        }
        return indicator;
    }

    private String getServiceConnectedPercentage(Person person) {
        if (person.getServiceConnectionAward() != null) {
            Integer percentage;
            ServiceConnectionAward award = person.getServiceConnectionAward();
            Integer n = percentage = award != null ? award.getServiceConnectedPercentage() : null;
            if (percentage != null) {
                return percentage.toString();
            }
            return "";
        }
        return "";
    }

    private String getServiceConnectedIndicator(Person person) {
        ServiceConnectionAward award;
        if (person.getServiceConnectionAward() != null && (award = person.getServiceConnectionAward()).getServiceConnectedIndicator() != null) {
            return this.convertBoolean(award.getServiceConnectedIndicator());
        }
        return "";
    }

    private String getPTIndicator(Person person) {
        ServiceConnectionAward award;
        if (person.getServiceConnectionAward() != null && (award = person.getServiceConnectionAward()).getPermanentAndTotal() != null) {
            return this.convertBoolean(award.getPermanentAndTotal());
        }
        return "";
    }

    private String getUnemployableIndicator(Person person) {
        ServiceConnectionAward award;
        if (person.getServiceConnectionAward() != null && (award = person.getServiceConnectionAward()).getUnemployable() != null) {
            return this.convertBoolean(award.getUnemployable());
        }
        return "";
    }

    private String earliestChangeEffDate(Person person) throws ServiceException {
        EnrollmentDetermination ed;
        Iterator iter = this.getEligibilityEnrollmentService().getEnrollmentDeterminationHistory(person.getEntityKey()).iterator();
        EnrollmentDetermination enrollmentDetermination = ed = iter.hasNext() ? (EnrollmentDetermination)((Object)iter.next()) : null;
        if (ed != null) {
            return this.outputDate(ed.getEffectiveDate());
        }
        return "";
    }

    private IncomeTest getCurrentIncomeTest(Person person) {
        return this.getPersonHelperService().getCurrentIncomeTest(person);
    }

    private void updateHandbookRejectEntry(HandBookMailQueue mailQ, String errMessage, boolean deprecated) throws ServiceException {
        if (mailQ == null) {
            return;
        }
        HandBookMailStatus status = mailQ.getHandBookMailStatus();
        HandBookMailStatusType statusType = this.getLookupService().getHandBookMailingStatusTypeByCode(HandBookMailStatusType.REJECT_AT_HEC.getCode());
        status.setStatusType(statusType);
        if (deprecated) {
            status.setRejectReasonType(this.getLookupService().getComAACRejectReasonTypeByCode("7"));
        } else {
            status.setRejectReasonType(this.getLookupService().getComAACRejectReasonTypeByCode("1"));
        }
        status.setErrorText(errMessage);
        try {
            this.getHandBookService().saveHandBookMailQueue(mailQ);
        }
        catch (ServiceException se) {
            throw new ServiceException("Error while updating REJECT_AT_HEC with Handbook Mail Queue Id" + mailQ.getId(), (Throwable)se);
        }
    }

    private void updateHandbookErrorEntry(HandBookMailQueue mailQ, String errMessage) throws ServiceException {
        if (mailQ == null) {
            return;
        }
        mailQ.getHandBookMailStatus().setErrorText(errMessage);
        try {
            this.getHandBookService().saveHandBookMailQueue(mailQ);
        }
        catch (ServiceException se) {
            throw new ServiceException("Error while updating REJECT_AT_HEC with Handbook Mail Queue Id" + mailQ.getId(), (Throwable)se);
        }
    }

    private void updateHandbookSuccessEntry(HandBookMailQueue mailQ, Person person, Address mailingAddr, String aLine) throws ServiceException {
        HandBookMailStatus status = mailQ.getHandBookMailStatus();
        HandBookMailStatusType statusType = this.getLookupService().getHandBookMailingStatusTypeByCode(HandBookMailStatusType.SENT_TO_CMS.getCode());
        status.setStatusType(statusType);
        Date today = DateUtils.getCurrentDateTime();
        status.setCmsFileGeneratedDate(today);
        status.setErrorText(null);
        status.setRejectReasonType(null);
        mailQ.setAddressId((BigDecimal)mailingAddr.getEntityKey().getKeyValue());
        HandBookDocument doc = new HandBookDocument();
        doc.setDocumentText(aLine);
        doc.setMailStatus(status);
        status.setDocument(doc);
        try {
            this.getHandBookService().saveHandBookMailQueue(mailQ);
        }
        catch (ServiceException se) {
            throw new ServiceException("Error while updating SENT_TO_CMS with Handbook Mail Queue Id" + mailQ.getId(), (Throwable)se);
        }
    }

    private void sendEmailNotice(Person person) throws ServiceException {
        String personId = person.getPersonEntityKey().getKeyValueAsString();
        DeliveryPreference deliveryPreference = this.handBookService.findDeliveryPreferenceByPersonId(personId);
        if (deliveryPreference != null) {
            DeliveryPreferenceType deliveryPreferenceType = deliveryPreference.getDeliveryPreferenceType();
            if (DeliveryPreferenceType.CODE_ONLINE.getCode().equals(deliveryPreferenceType.getCode())) {
                Set<DeliveryPreferenceEmail> deliveryPreferenceEmailSet = deliveryPreference.getDeliveryPreferenceEmail();
                for (DeliveryPreferenceEmail deliveryPreferenceEmail : deliveryPreferenceEmailSet) {
                    String emailAddress = deliveryPreferenceEmail.getAddress();
                    this.commsEmailBulletinService.sendEmailBulletin(BulletinTrigger.DataType.TRIGGER_HANDBOOK_COMMUNICATION, emailAddress);
                }
            }
        }
    }

    private String getPreferredFacilityType(Person person) throws ServiceException {
        String personId = person.getPersonEntityKey().getKeyValueAsString();
        DeliveryPreference deliveryPreference = this.handBookService.findDeliveryPreferenceByPersonId(personId);
        if (deliveryPreference != null && deliveryPreference.getDeliveryPreferenceType() != null) {
            DeliveryPreferenceType deliveryPreferenceType = deliveryPreference.getDeliveryPreferenceType();
            return deliveryPreferenceType.getName();
        }
        return "Mail";
    }

    private String catastrophicallyDisabledInd(CatastrophicDisability cd) {
        if (cd.getCatastrophicallyDisabled() != null) {
            return this.convertBoolean(cd.getCatastrophicallyDisabled());
        }
        return "";
    }

    private String cancerDiagnose(NoseThroatRadium ntr) {
        if (ntr.getDiagnosedWithCancer() != null) {
            return this.convertBoolean(ntr.getDiagnosedWithCancer());
        }
        return "";
    }

    private String populateExposureInd(RadiationExposure ra) {
        if (ra.getRadiationExposureIndicator() != null) {
            return this.convertIndicator(ra.getRadiationExposureIndicator().getCode());
        }
        return "";
    }

    private String populateExposureMethod(RadiationExposure ra) {
        if (ra.getExposureMethod() != null) {
            return ra.getExposureMethod().getDescription();
        }
        return "";
    }

    private String populateOrangeExposureInd(AgentOrangeExposure ao) {
        if (ao.getAgentOrangeExposureIndicator() != null) {
            return this.convertIndicator(ao.getAgentOrangeExposureIndicator().getCode());
        }
        return "";
    }

    private String populateOrangeExposureMethod(AgentOrangeExposure ao) {
        if (ao.getLocation() != null) {
            return ao.getLocation().getDescription();
        }
        return "";
    }

    private String getDischargeDueToDisability(MilitaryService incomingMilitaryService) {
        if (incomingMilitaryService.getDischargeDueToDisability() != null) {
            return this.convertBoolean(incomingMilitaryService.getDischargeDueToDisability());
        }
        return "";
    }

    private String getDisabilityRetirement(MilitaryService incomingMilitaryService) {
        if (incomingMilitaryService.getDisabilityRetirementIndicator() != null) {
            return this.convertBoolean(incomingMilitaryService.getDisabilityRetirementIndicator());
        }
        return "";
    }

    private String calculateCombatVeteranEligStatus(MilitaryService militaryService, Date startDt) {
        if (militaryService.getCombatVeteranEligibilityEndDate() != null) {
            if (startDt.after(militaryService.getCombatVeteranEligibilityEndDate())) {
                return "N";
            }
            return "Y";
        }
        return "";
    }

    private String populatePhIndicator(PurpleHeart ph) {
        if (ph != null && ph.getPhIndicator() != null) {
            return this.convertBoolean(ph.getPhIndicator());
        }
        return "";
    }

    private String populatePowIndicator(PrisonerOfWar pw) {
        return pw != null && pw.getPowIndicator() != null ? this.convertIndicator(pw.getPowIndicator().getCode()) : "";
    }

    private String populateMohIndicator(MedalOfHonor moh) {
        return moh != null && moh.getMhIndicator() != null ? this.convertBoolean(moh.getMhIndicator()) : "";
    }

    private String convertIndicator(String code) {
        return code.equals("1") ? "Y" : "N";
    }

    private String convertBoolean(boolean value) {
        return value ? "Y" : "N";
    }

    private String getEnvironementalContaminationExposure(Person person) {
        String value = "";
        if (person.getEnvironmentalContaminationExposure() != null && person.getEnvironmentalContaminationExposure().getEnvironmentalContaminationExposureIndicator() != null) {
            String indicator = person.getEnvironmentalContaminationExposure().getEnvironmentalContaminationExposureIndicator().getCode();
            if (indicator.equals("0")) {
                value = "N";
            } else if (indicator.equals("1")) {
                value = "Y";
            }
        }
        return value;
    }

    private String getEnrollmentSubPriority(Person person) {
        if (person.getEnrollmentDetermination().getPrioritySubGroup() != null) {
            return person.getEnrollmentDetermination().getPrioritySubGroup().getDescription().toUpperCase();
        }
        return "";
    }

    private String getAttributableIncome(IncomeTest currentIncomeTest) throws ServiceException {
        return currentIncomeTest != null ? this.calculateNetIncome(currentIncomeTest).toString() : "";
    }

    private String getMTStatus(IncomeTest currentIncomeTest) {
        if (currentIncomeTest == null || currentIncomeTest.getStatus() == null || currentIncomeTest.getPrimaryTestType() != null && IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode().equals(currentIncomeTest.getPrimaryTestType().getCode())) {
            return "";
        }
        return currentIncomeTest.getStatus().getDescription();
    }

    private String getRXCopay(IncomeTest currentIncomeTest) {
        return currentIncomeTest != null && currentIncomeTest.getPharmacyCoPayStatus() != null ? currentIncomeTest.getPharmacyCoPayStatus().getStatus().getDescription() : "";
    }

    private String getHardshipEndDate(IncomeTest currentIncomeTest) {
        return currentIncomeTest != null && currentIncomeTest.getHardship() != null ? this.outputDate(currentIncomeTest.getHardship().getReviewDate()) : "";
    }

    private String getMedicaidStatus(Person person) {
        return person.getMedicaidFactor() != null && person.getMedicaidFactor().getEligibleForMedicaid() != false ? "Y" : "N";
    }

    protected BigDecimal calculateNetIncome(IncomeTest test) throws ServiceException {
        if (test != null) {
            BigDecimal netIncome = test.getNetIncome();
            if (netIncome != null) {
                return netIncome;
            }
            BigDecimal totalIncome = test.getTotalIncome();
            BigDecimal deductableExpenses = test.getDeductibleExpenses();
            if (totalIncome != null && deductableExpenses != null) {
                return this.isGreaterThan(totalIncome, deductableExpenses) ? totalIncome.subtract(deductableExpenses) : new BigDecimal(0);
            }
            if (totalIncome != null) {
                return totalIncome;
            }
        }
        return new BigDecimal(0);
    }

    public boolean isGreaterThan(BigDecimal value, BigDecimal lower) {
        boolean compare = false;
        if (value != null && lower != null) {
            boolean bl = compare = value.compareTo(lower) == 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" value: " + value));
            this.logger.debug((Object)(" Lower bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    private String getEnrollmentCategory(Person person) {
        if (this.hasEnrollment(person) && person.getEnrollmentDetermination().getEnrollmentStatus() != null && person.getEnrollmentDetermination().getEnrollmentStatus().getEnrollmentCategory() != null) {
            return person.getEnrollmentDetermination().getEnrollmentStatus().getEnrollmentCategory().getCode();
        }
        return "";
    }

    private String getEnrollmentStatus(Person person) {
        if (this.hasEnrollment(person) && person.getEnrollmentDetermination().getEnrollmentStatus() != null) {
            return person.getEnrollmentDetermination().getEnrollmentStatus().getDescription();
        }
        return "";
    }

    private String getPrimaryEligCode(Person person) {
        if (this.hasEnrollment(person) && person.getEnrollmentDetermination().getPrimaryEligibility() != null) {
            return person.getEnrollmentDetermination().getPrimaryEligibility().getType().getDescription();
        }
        return "";
    }

    private String getEnrollmentDate(Person person) {
        return this.hasEnrollment(person) ? this.outputDate(person.getEnrollmentDetermination().getEnrollmentDate()) : "";
    }

    private String getEnrollmentEndDate(Person person) {
        return this.hasEnrollment(person) ? this.outputDate(person.getEnrollmentDetermination().getEndDate()) : "";
    }

    private String mostRecentEffDateOfChange(Person person) {
        return this.hasEnrollment(person) ? this.outputDate(person.getEnrollmentDetermination().getEffectiveDate()) : "";
    }

    private boolean hasEnrollment(Person person) {
        return person.getEnrollmentDetermination() != null;
    }

    private String getApplicationDate(Person person) {
        if (person.getApplication() != null) {
            return this.outputDate(person.getApplication().getApplicationDate());
        }
        return "";
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    public Object[] getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(Object[] acquiredData) {
        this.acquiredData = acquiredData;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    public DataQueryProcessExecutionContext getContext() {
        return context;
    }

    public void setContext(DataQueryProcessExecutionContext context) {
        HandbookBatchProcessSpawnedThreadTask.context = context;
    }

    public String getProcessName() {
        return processName;
    }

    public void setProcessName(String processName) {
        HandbookBatchProcessSpawnedThreadTask.processName = processName;
    }

    public CommsEmailBulletinService getCommsEmailBulletinService() {
        return this.commsEmailBulletinService;
    }

    public void setCommsEmailBulletinService(CommsEmailBulletinService commsEmailBulletinService) {
        this.commsEmailBulletinService = commsEmailBulletinService;
    }

    public PersonMergeService getPersonMergeService() {
        return this.personMergeService;
    }

    public void setPersonMergeService(PersonMergeService personMergeService) {
        this.personMergeService = personMergeService;
    }
}

