/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.HBPRuleDeploymentProcessSpawnedThreadTask;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ExceptionWriterProcessCompletedHandler;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.ThreadPool;
import java.math.BigDecimal;
import java.util.List;

public class HBPRuleDeploymentProcess
extends AbstractDataQueryIncrementalProcess {
    LookupService lookupService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 100;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 100;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null || acquiredData.isEmpty()) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            Object[] row = (Object[])acquiredData.get(i);
            BigDecimal personId = (BigDecimal)row[0];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
            }
            this.processEntityData(context, personId);
        }
    }

    public void processEntityData(DataQueryProcessExecutionContext context, BigDecimal acquiredData) {
        if (this.isThreaded()) {
            this.spawnThread(context, acquiredData);
        }
    }

    private boolean isThreaded() {
        return StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    private void spawnThread(DataQueryProcessExecutionContext context, BigDecimal acquiredData) {
        try {
            while (HBPRuleDeploymentProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (!this.shouldWriteExceptionData((DataProcessExecutionContext)context)) continue;
                ((ExceptionWriterProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
            if (this.shouldUpdateJobResult(context)) {
                this.updateJobResult((DataProcessExecutionContext)context);
            }
            if (this.shouldWriteExceptionData((DataProcessExecutionContext)context)) {
                ((ExceptionWriterProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            HBPRuleDeploymentProcessSpawnedThreadTask task = (HBPRuleDeploymentProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAuditInfo(this.getAuditInfo());
            task.setAcquiredData(acquiredData);
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("HBPRuleDeploymentProcessSpawnedThreadTask was interrupted while it was spawning a thread. ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block11: {
            try {
                if (HBPRuleDeploymentProcess.getTaskCount(context) == 0) break block11;
                HBPRuleDeploymentProcess hBPRuleDeploymentProcess = this;
                synchronized (hBPRuleDeploymentProcess) {
                    boolean stillProcessing = true;
                    while (stillProcessing) {
                        ((Object)((Object)this)).wait();
                        if (HBPRuleDeploymentProcess.getTaskCount(context) != 0) continue;
                        stillProcessing = false;
                    }
                }
            }
            catch (InterruptedException e) {
                this.throwIllegalStateException("HBPRuleDeploymentProcess was interrupted while it was waiting for its spawned threads to complete", e);
            }
            finally {
                this.getThreadPool(context).stop();
                this.cleanThreadPool(context);
            }
        }
        if (this.shouldUpdateJobResult((DataQueryProcessExecutionContext)context)) {
            this.updateJobResult(context);
        }
        if (this.shouldWriteExceptionData(context)) {
            ((ExceptionWriterProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData(context);
        }
        super.handleDataProcessCompleted(context);
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"HBPRuleDeploymentProcessSpawnedThreadTask cleaned up the thread pool");
        }
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("HBPRuleDeploymentProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataQueryProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        HBPRuleDeploymentProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(HBPRuleDeploymentProcess.getTaskCount(context) + adjustment));
        }
    }

    private boolean shouldWriteExceptionData(DataProcessExecutionContext context) {
        int exceptionDataSize;
        int n = exceptionDataSize = context.getExceptionData() == null ? 0 : context.getExceptionData().size();
        return exceptionDataSize != 0 ? exceptionDataSize % 20 == 0 : false;
    }
}

