/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.GenerateQRYZ11MessagingService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.impl.GenerateQRYZ11MessagingServiceImpl;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatisticsHandler;
import gov.va.med.fw.batchprocess.model.JobConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class GenerateQueryVBAProcess
extends AbstractDataQueryIncrementalProcess {
    private GenerateQRYZ11MessagingService messagingService = null;
    private PersonService personService;
    private LookupService lookupService;
    private ProcessStatisticsHandler processStatisticsHandler;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block10: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal personId = (BigDecimal)row[0];
                PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(personId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
                }
                try {
                    this.processRecord(key, row);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing " + this.getProcessName() + " for person " + personId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block10;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
        this.processStatisticsHandler = this.getProcessStatisticsHandler();
        try {
            JobConfig config;
            if (this.processStatisticsHandler != null && ((config = this.getBatchProcessService().getJobConfig(this.getJobName((DataProcessExecutionContext)context), this.getJobGroupName((DataProcessExecutionContext)context))) == null || StringUtils.isBlank((String)config.getEmailDistributionList()))) {
                ArrayList<String> defaultEmailList = new ArrayList<String>();
                defaultEmailList.add("Corrie.Kittles@va.gov");
                this.processStatisticsHandler.processStatisticsWithDynamicRecipients(context.getProcessStatistics(), defaultEmailList);
                this.logger.info((Object)"GenerateQueryVBAProcess batch job - email of total query count was sent to corrie.kittles@va.gov\n");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"GenerateQueryVBAProcess - ERROR in sending email of VBA query count ", (Throwable)ex);
        }
    }

    protected void processRecord(PersonEntityKey key, Object[] dataRow) throws Exception {
        String VPID = (String)dataRow[1];
        this.messagingService.generateMessage(key, VPID);
        Person person = this.personService.getPerson(key);
        if (person == null) {
            throw new RuntimeException("Unable to find Person for VPID: " + VPID);
        }
        if (person.getEligibilityVerification() == null) {
            EligibilityVerification eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        person.getEligibilityVerification().setAacIndicator(this.getLookupService().getAACIndicatorByCode(AACIndicator.CODE_AAC_QUERIED_PENDING.getCode()));
        this.personService.save(person);
    }

    public void setMessagingService(GenerateQRYZ11MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected GenerateQRYZ11MessagingService getMessagingService() {
        return this.messagingService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService);
        Validate.notNull((Object)this.lookupService);
        Validate.notNull((Object)this.messagingService, (String)"A MessagingService is needed");
        Validate.isTrue((!(this.messagingService instanceof GenerateQRYZ11MessagingServiceImpl) ? 1 : 0) != 0, (String)"A GenerateQRYZ11 Messaging Service is required");
    }
}

