/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.GenerateQRYZ21Process;
import gov.va.med.esr.common.model.lookup.SeedStatus;
import gov.va.med.esr.common.model.messaging.SeedingLogEntry;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.messaging.SeedingLogEntryDAO;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.MilitaryInfoService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.Validate;

public class GenerateQRYZ21ProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private DataQueryProcessExecutionContext context;
    private BigDecimal acquiredData;
    private PersonService personService;
    private SeedingLogEntryDAO seedingLogEntryDAO = null;
    private LookupService lookupService = null;
    private MilitaryInfoService militaryService = null;
    private String processName;

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(this.acquiredData);
        try {
            this.militaryService.processSeeding(this.getPersonService().getPerson(key));
            this.context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            this.createSeedingLogEntry(this.acquiredData, SeedStatus.COMPLETE.getCode());
        }
        catch (Exception ex) {
            this.context.getProcessStatistics().incrementNumberOfErrorRecords();
            String errMsg = "Error while executing " + this.getProcessName() + " for person " + this.acquiredData;
            this.context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
            this.createSeedingLogEntry(this.acquiredData, SeedStatus.ERROR.getCode());
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
        }
        finally {
            Object threadCreator;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"GenerateQRYZ21ProcessSpawnedThreadTask ended");
            }
            GenerateQRYZ21Process.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
            Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
            synchronized (object) {
                threadCreator.notifyAll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"GenerateQRYZ21ProcessSpawnedThreadTask notified creator");
            }
            this.context = null;
        }
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    public BigDecimal getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(BigDecimal acquiredData) {
        this.acquiredData = acquiredData;
    }

    public DataQueryProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataQueryProcessExecutionContext context) {
        this.context = context;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public SeedingLogEntryDAO getSeedingLogEntryDAO() {
        return this.seedingLogEntryDAO;
    }

    public void setSeedingLogEntryDAO(SeedingLogEntryDAO seedingLogEntryDAO) {
        this.seedingLogEntryDAO = seedingLogEntryDAO;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public MilitaryInfoService getMilitaryService() {
        return this.militaryService;
    }

    public void setMilitaryService(MilitaryInfoService militaryService) {
        this.militaryService = militaryService;
    }

    private void updateSeedingLogEntry(BigDecimal person, String code) throws ServiceException {
        SeedingLogEntry sle = (SeedingLogEntry)((Object)this.getSeedingLogEntrybyPerson(person).get(0));
        sle.setOriginatingProcess("BatchProcess");
        sle.setStatus(this.getLookupService().getSeedStatusByCode(code));
        try {
            this.seedingLogEntryDAO.saveObject((Object)sle);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get seedingDAO  ", (Throwable)ex);
        }
    }

    private void createSeedingLogEntry(BigDecimal key, String code) {
        try {
            List personLogEntry = this.getSeedingLogEntrybyPerson(key);
            if (personLogEntry != null && !personLogEntry.isEmpty()) {
                this.updateSeedingLogEntry(key, code);
            } else {
                SeedingLogEntry sle = new SeedingLogEntry();
                sle.setOriginatingProcess("BatchProcess");
                sle.setPersonId(key);
                sle.setStatus(this.getLookupService().getSeedStatusByCode(code));
                this.logMessage(sle);
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("Error with seeding table insert and update:" + key));
        }
    }

    private List getSeedingLogEntrybyPerson(BigDecimal person) throws ServiceException {
        List seedingLogEntry = null;
        try {
            seedingLogEntry = this.seedingLogEntryDAO.findPersonId(person);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to log seeding  ", (Throwable)ex);
        }
        return seedingLogEntry;
    }

    public void logMessage(SeedingLogEntry entry) throws ServiceException {
        try {
            if (entry.getEntityKey() == null) {
                this.seedingLogEntryDAO.saveObject((Object)entry);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to log message ", (Throwable)ex);
        }
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.militaryService, (String)"A MilitaryService is needed");
        Validate.notNull((Object)this.personService, (String)"A MilitaryService is needed");
        Validate.notNull((Object)this.seedingLogEntryDAO, (String)"A seedingLogEntryDAO is needed");
        Validate.notNull((Object)this.lookupService, (String)"A lookupService is needed");
    }
}

