/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.esr.common.persistent.person.PersonTraitsDAO;
import gov.va.med.esr.service.IRSTransmissionService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class GenerateIRSTransmissionProcess
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 1;
    private static final int DEFAULT_FETCH_SIZE = 110;
    private static final int DEFAULT_JOB_RESULT_UPDATE_INTERVAL = 100;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    public static final String TRANSMISSION_SIZE = "IRS Transmission Size";
    private SystemParameterService systemParameterService = null;
    int maxBatchSize;
    private int threadPoolSize = 1;
    private int fetchSize = 110;
    private String spawnedTaskId;
    private String calendarYear = null;
    private String startDay = "-01-01";
    private ArrayList<BigDecimal> batch = null;
    private int numRecs = 0;
    private IRSTransmissionService irsTransmissionService = null;
    private PersonService personService;
    private MECPeriodDAO mecPeriodDAO = null;
    private PersonMergeService personMergeService;
    private String BATCH_TYPE = "V";
    private String CORRECTION_IND = "O";
    private boolean onLineTraits = true;
    private PersonTraitsDAO personTraitsDAO = null;
    private LookupService lookupService = null;

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        this.setThreadPoolSize(1);
        this.onLineTraits = true;
        String args = (String)context.getExecutionArguments();
        if (!StringUtils.isEmpty((String)args)) {
            String[] params = args.split(",");
            if (params != null && params.length == 2) {
                this.onLineTraits = false;
                this.calendarYear = params[1].trim();
            } else if (params != null && params.length == 1) {
                this.onLineTraits = false;
            }
        }
        if (this.calendarYear == null) {
            Calendar prevYear = Calendar.getInstance();
            prevYear.add(1, -1);
            this.calendarYear = Integer.toString(prevYear.get(1));
        }
        String startDate = this.calendarYear + this.startDay;
        String size = this.getSystemParameterService().getByName(TRANSMISSION_SIZE).getValue();
        this.maxBatchSize = Integer.valueOf(size);
        this.setFetchSize(this.maxBatchSize);
        this.batch = new ArrayList();
        this.logger.debug((Object)("threads: " + this.getThreadPoolSize()));
        this.logger.debug((Object)("year: " + this.calendarYear));
        this.setParamNames(new String[]{"startDate", "taxYear"});
        this.setParamValues(new String[]{startDate, this.calendarYear});
        this.setFetchSize(this.maxBatchSize);
        super.executeProcess(context);
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        List acquiredData = null;
        acquiredData = this.executeQuery(context);
        return acquiredData;
    }

    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        DataQueryDetail currentQuery = context.getCurrentDataQuery();
        List results = this.getDao().find(currentQuery.getQuery().getQuery(), currentQuery.getQuery().getParamNames(), currentQuery.getQuery().getParamValues(), this.numRecs, this.maxBatchSize, this.maxBatchSize);
        this.numRecs += this.maxBatchSize;
        return results;
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null) {
            return;
        }
        ArrayList<BigDecimal> submission = null;
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            if (acquiredData.get(i) instanceof Object[]) {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal val = (BigDecimal)row[0];
                this.batch.add(val);
                continue;
            }
            this.batch.add((BigDecimal)acquiredData.get(i));
        }
        submission = new ArrayList<BigDecimal>(this.batch);
        this.batch.clear();
        this.processEntityData(context, submission, this.calendarYear);
    }

    public void processEntityData(DataQueryProcessExecutionContext context, ArrayList<BigDecimal> submitBatch, String calendarYear) {
        this.processBatch(context, submitBatch, calendarYear);
    }

    public void processBatch(DataQueryProcessExecutionContext context, ArrayList<BigDecimal> submitBatch, String calendarYear) {
        BigDecimal personId = null;
        ArrayList<IRS1095B> list = new ArrayList<IRS1095B>();
        IRS1095B vetRecord = null;
        MECPeriod period = null;
        try {
            for (int i = 0; i < submitBatch.size(); ++i) {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                try {
                    personId = submitBatch.get(i);
                    if (this.getPersonMergeService().hasDeprecatedRecord(CommonEntityKeyFactory.createPersonIdEntityKey(personId))) {
                        this.logger.error((Object)("Skipping Deprecated record found for person: " + personId));
                        continue;
                    }
                    period = new MECPeriod();
                    period = this.getIrsTransmissionService().combineAllPeriods(personId, Integer.valueOf(calendarYear));
                    if (!period.isCoveredAll12Months() && period.getCoverageMonths().isEmpty()) continue;
                    vetRecord = new IRS1095B();
                    vetRecord = this.build1095(period);
                    if (vetRecord == null) {
                        this.logger.error((Object)("Failed to build 1095 from person: " + personId));
                        context.getProcessStatistics().incrementNumberOfErrorRecords();
                        continue;
                    }
                    list.add(vetRecord);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    continue;
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Batch sumission failed to process record: " + personId + " " + ex.getMessage()));
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                }
            }
            if (list != null && list.size() > 0) {
                this.getIrsTransmissionService().sendSubmit(list, this.BATCH_TYPE, this.CORRECTION_IND, calendarYear);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown Exception in GenerateIRSSubmission: " + ex.getMessage()));
        }
    }

    private IRS1095B build1095(MECPeriod period) {
        IRS1095B rec = null;
        if (period != null) {
            try {
                Person person = null;
                if (this.onLineTraits) {
                    person = this.personService.getPerson(new PersonIdEntityKeyImpl(period.getPersonId()));
                } else {
                    PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(period.getPersonId());
                    VPIDEntityKey vpid = this.getPersonService().getVPIDByPersonId(personKey);
                    person = this.personService.getPersonWithoutIdentityTraits(vpid);
                    PersonTraits pt = this.getPersonTraitsDAO().getPersonTraitsByVPID(person.getVPIDValue());
                    if (pt == null) {
                        throw new Exception("Failed to Retrieve Person");
                    }
                    PersonIdentityTraits traits = new PersonIdentityTraits();
                    Name name = new Name();
                    name.setFamilyName(pt.getFamilyName());
                    name.setGivenName(pt.getGivenName());
                    name.setMiddleName(pt.getMiddleName());
                    name.setType(this.lookupService.getNameTypeByCode(NameType.LEGAL_NAME.getName()));
                    traits.addName(name);
                    SSN ssn = new SSN();
                    ssn.setSsnText(pt.getSsn());
                    ssn.setType(this.lookupService.getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
                    traits.setSsn(ssn);
                    BirthRecord birthRecord = new BirthRecord();
                    birthRecord.setBirthDate(new ImpreciseDate(pt.getBirthDate()));
                    traits.setBirthRecord(birthRecord);
                    traits.setGender(this.lookupService.getGenderByCode(pt.getGender()));
                    person.setIdentityTraits(traits);
                }
                if (person == null) {
                    throw new ServiceException("failed to retrieve person");
                }
                rec = new IRS1095B(person);
                rec.setMecPeriod(period);
            }
            catch (ServiceException e) {
                this.logger.error((Object)("Generate IRS Process Failed to Retrieve person by id:" + period.getPersonId() + " , message:" + e.getMessage()));
            }
            catch (Exception ex) {
                this.logger.error((Object)("GenerateIRSSubmitProcess Failed to build1095 for person: " + period.getPersonId() + " reason:" + ex.getMessage()));
            }
        }
        return rec;
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(100);
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public IRSTransmissionService getIrsTransmissionService() {
        return this.irsTransmissionService;
    }

    public void setIrsTransmissionService(IRSTransmissionService irsTransmissionService) {
        this.irsTransmissionService = irsTransmissionService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public MECPeriodDAO getMecPeriodDAO() {
        return this.mecPeriodDAO;
    }

    public void setMecPeriodDAO(MECPeriodDAO mecPeriodDAO) {
        this.mecPeriodDAO = mecPeriodDAO;
    }

    public PersonMergeService getPersonMergeService() {
        return this.personMergeService;
    }

    public void setPersonMergeService(PersonMergeService personMergeService) {
        this.personMergeService = personMergeService;
    }

    public PersonTraitsDAO getPersonTraitsDAO() {
        return this.personTraitsDAO;
    }

    public void setPersonTraitsDAO(PersonTraitsDAO personTraitsDAO) {
        this.personTraitsDAO = personTraitsDAO;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

