/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.ACAExportStatistics;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.CorrespondenceStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.esr.common.persistent.person.PersonTraitsDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.CorrespondenceService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.IRSTransmissionService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class GenerateACAMailExtract
extends AbstractDataQueryProcess {
    private PersonService personService;
    private CorrespondenceService correspondenceService;
    private DemographicService demographicService;
    private LookupService lookupService;
    private MECPeriodDAO mecPeriodDAO = null;
    private PersonTraitsDAO personTraitsDAO = null;
    private IRSTransmissionService irsTransmissionService = null;
    private CommsEmailBulletinService bulletinService = null;
    public final int DEFAULT_JOB_RESULT_UPDATE_INTERVAL = 100;
    private String outputFileLocation;
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String ERR_DUPE = "Duplicate Mailing Request";
    public static final String ERR_ADDRESS = "Letter Address is Invalid or Missing";
    public static final String ERR_SUPPRESS_DECEASED = "Mail Correspondence Suppressed (Presumed Deceased)";
    public static final String ERR_RETRIEVE = "Failed to Retrieve Record";
    public static final String formnumA = "FORM=742-800A";
    public static final String formnumD = "FORM=742-800D";
    private Writer extractWriter;
    private Writer correctionWriter;
    private boolean onLineTraits = false;
    private String year;
    ACAExportStatistics origStats = null;
    ACAExportStatistics corrStats = null;

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        this.onLineTraits = false;
        String args = (String)context.getExecutionArguments();
        if (!StringUtils.isEmpty((String)args)) {
            this.onLineTraits = true;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.add(1, -4);
        int lastfour = cal.get(1);
        cal.add(1, 1);
        int lastthree = cal.get(1);
        cal.add(1, 1);
        int lasttwo = cal.get(1);
        cal.add(1, 1);
        int lastone = cal.get(1);
        cal.add(1, 1);
        int curYear = cal.get(1);
        cal.add(1, 1);
        int nextYear = cal.get(1);
        String[] years = new String[]{String.valueOf(lastfour), String.valueOf(lastthree), String.valueOf(lasttwo), String.valueOf(lastone), String.valueOf(curYear), String.valueOf(nextYear)};
        for (int i = 0; i < years.length; ++i) {
            this.year = years[i];
            this.setParamNames(new String[]{"year"});
            this.setParamValues(new String[]{years[i]});
            this.origStats = new ACAExportStatistics();
            this.corrStats = new ACAExportStatistics();
            super.executeProcess(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        SimpleDateFormat sdf2 = new SimpleDateFormat("MMddyyyy");
        String shortdate = sdf2.format(new Date());
        if (acquiredData == null || acquiredData.size() == 0) {
            return;
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            block44: {
                Correspondence form = null;
                Correspondence letter = null;
                boolean isDeceasedType = false;
                boolean isCorrectionType = false;
                try {
                    Address mailingAddress;
                    Person onFile;
                    block43: {
                        if (this.isInterrupted(context)) {
                            this.handleDataProcessCompleted(context);
                        }
                        BigDecimal personId = (BigDecimal)acquiredData.get(i);
                        PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(personId);
                        VPIDEntityKey vpid = this.getPersonService().getVPIDByPersonId(personKey);
                        onFile = this.onLineTraits ? this.getPersonService().getPerson(vpid) : this.getPersonService().getPersonWithoutIdentityTraits(vpid);
                        if (onFile == null) {
                            this.setRejectAndError(letter, form, personId.toString(), ERR_RETRIEVE, context);
                            this.origStats.incrementNumberErrIdentity();
                            continue;
                        }
                        isDeceasedType = this.determineLetterType(onFile);
                        ArrayList<Correspondence> entries = this.getCorrespondenceService().getPendingPersonCorrespondence(personId, ComLetterTemplateType.FORM_NUMBER_800);
                        if (entries != null && entries.size() > 1) {
                            Collections.sort(entries, new Comparator<Correspondence>(){

                                @Override
                                public int compare(Correspondence o1, Correspondence o2) {
                                    if (o1.getStatusDate() == null || o2.getStatusDate() == null) {
                                        return 0;
                                    }
                                    return o1.getStatusDate().compareTo(o2.getStatusDate());
                                }
                            });
                            Collections.reverse(entries);
                            form = entries.get(0);
                            for (int x = 1; x < entries.size(); ++x) {
                                Correspondence dupe = entries.get(x);
                                this.setRejectAndError(null, dupe, onFile.getPersonEntityKey().getKeyValueAsString(), ERR_DUPE, context);
                                this.origStats.incrementNumberErrDuplicate();
                            }
                        } else if (entries != null && entries.size() == 1) {
                            form = entries.get(0);
                        }
                        if (entries == null || form == null) {
                            this.setRejectAndError(letter, form, onFile.getPersonEntityKey().getKeyValueAsString(), ERR_RETRIEVE, context);
                            this.origStats.incrementNumberErrOther();
                            continue;
                        }
                        mailingAddress = this.getDemographicService().getLetterAddress(onFile);
                        form.setMailingAdress(mailingAddress);
                        this.getCorrespondenceService().updateACACorrespondence(form, CorrespondenceStatus.SENT_TO_CMS, null);
                        isCorrectionType = this.determineCorrectionType(form);
                        this.initializeWriters(isCorrectionType);
                        letter = new Correspondence(onFile);
                        letter.setEffectiveDate(form.getEffectiveDate());
                        letter.setAddressId(form.getAddressId());
                        if (isDeceasedType) {
                            this.getCorrespondenceService().associateACALetterType(letter, ComLetterTemplateType.FORM_NUMBER_800D);
                            if (isCorrectionType) {
                                this.corrStats.incrementNumberForm800D();
                            } else {
                                this.origStats.incrementNumberForm800D();
                            }
                        } else {
                            this.getCorrespondenceService().associateACALetterType(letter, ComLetterTemplateType.FORM_NUMBER_800A);
                            if (isCorrectionType) {
                                this.corrStats.incrementNumberForm800A();
                            } else {
                                this.origStats.incrementNumberForm800A();
                            }
                        }
                        try {
                            if (!this.isAddressValid(mailingAddress)) {
                                this.setRejectAndError(letter, form, onFile.getPersonEntityKey().getKeyValueAsString(), ERR_ADDRESS, context);
                                if (isCorrectionType) {
                                    this.corrStats.incrementNumberErrAddress();
                                    continue;
                                }
                                this.origStats.incrementNumberErrAddress();
                                continue;
                            }
                            if (!form.getCreatedBy().getName().contains("Job-") && this.getCorrespondenceService().shouldSuppressMailCorrespondence(onFile)) {
                                this.setRejectAndError(letter, form, onFile.getPersonEntityKey().getKeyValueAsString(), ERR_SUPPRESS_DECEASED, context);
                                if (isCorrectionType) {
                                    this.corrStats.incrementNumberErrSuppress();
                                    continue;
                                }
                                this.origStats.incrementNumberErrSuppress();
                            }
                            break block43;
                        }
                        catch (Exception ex) {
                            this.setRejectAndError(letter, form, onFile.getPersonEntityKey().getKeyValueAsString(), ex.getMessage(), context);
                            if (isCorrectionType) {
                                this.corrStats.incrementNumberErrOther();
                                continue;
                            }
                            this.origStats.incrementNumberErrOther();
                        }
                        continue;
                    }
                    try {
                        Writer writer;
                        String mecData;
                        IrsTransmissionLogDetailEntry submittedEntry = null;
                        if (isCorrectionType) {
                            submittedEntry = this.getIrsTransmissionService().getMostRecentTransmissionForYear(onFile.getPersonEntityKey(), this.year, true);
                        }
                        if (isCorrectionType && submittedEntry == null) {
                            this.setRejectAndError(letter, form, onFile.getPersonEntityKey().getKeyValueAsString(), ERR_RETRIEVE, context);
                            this.corrStats.incrementNumberErrOther();
                            continue;
                        }
                        String dataLine = "";
                        dataLine = isDeceasedType ? dataLine + "FORM=742-800D^" + shortdate + "^" : dataLine + "FORM=742-800A^" + shortdate + "^";
                        dataLine = dataLine + this.genTraitsData(onFile);
                        dataLine = dataLine + this.genAddressData(onFile, mailingAddress);
                        if (isCorrectionType) {
                            mecData = this.genMECData(onFile, submittedEntry.getSubmittedData().getMecPeriod());
                            if (mecData == null) {
                                throw new Exception("Invalid Coverage Period for Tax Year");
                            }
                            dataLine = dataLine + mecData;
                            writer = this.correctionWriter;
                            synchronized (writer) {
                                this.correctionWriter.write(dataLine + "\n");
                                this.corrStats.incrementNumberSent();
                            }
                        }
                        mecData = this.genMECData(onFile, null);
                        if (mecData == null) {
                            throw new Exception("Invalid Coverage Period for Tax Year");
                        }
                        dataLine = dataLine + mecData;
                        writer = this.extractWriter;
                        synchronized (writer) {
                            this.extractWriter.write(dataLine + "\n");
                            this.origStats.incrementNumberSent();
                        }
                        context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                        break block44;
                    }
                    catch (Exception ex) {
                        this.setRejectAndError(letter, form, onFile.getPersonEntityKey().getKeyValueAsString(), ex.getMessage(), context);
                        if (isCorrectionType) {
                            this.corrStats.incrementNumberErrOther();
                            continue;
                        }
                        this.origStats.incrementNumberErrOther();
                    }
                }
                catch (Exception ex) {
                    this.setRejectAndError(letter, form, null, ex.getMessage(), context);
                    if (isCorrectionType) {
                        if (this.corrStats == null) continue;
                        this.corrStats.incrementNumberErrOther();
                        continue;
                    }
                    if (this.origStats == null) continue;
                    this.origStats.incrementNumberErrOther();
                }
                continue;
            }
            if (i % this.DEFAULT_JOB_RESULT_UPDATE_INTERVAL != 0) continue;
            this.updateJobResult(context);
        }
        try {
            if (this.extractWriter != null) {
                this.extractWriter.flush();
                this.extractWriter.close();
            }
            if (this.correctionWriter != null) {
                this.correctionWriter.flush();
                this.correctionWriter.close();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown Exception in GenerateACAMailExtract:" + ex.getMessage()));
            context.getProcessStatistics().incrementNumberOfErrorRecords();
        }
        this.extractWriter = null;
        this.correctionWriter = null;
    }

    private String genMECData(Person onFile, MECPeriod mp) {
        String mecSegment = "";
        MECPeriod finalone = null;
        if (mp != null) {
            finalone = mp;
        } else {
            finalone = new MECPeriod();
            finalone = this.getIrsTransmissionService().combineAllPeriods((BigDecimal)onFile.getPersonEntityKey().getKeyValue(), Integer.valueOf(this.year));
        }
        if (!finalone.isCoveredAll12Months() && finalone.getCoverageMonths().isEmpty()) {
            return null;
        }
        if (finalone.isCoveredAll12Months()) {
            mecSegment = mecSegment + "H01=Y^H02=^H03=^H04=^H05=^H06=^H07=^H08=^H09=^H10=^H11=^H12=^H13=";
        } else {
            mecSegment = mecSegment + "H01=^";
            mecSegment = mecSegment + "H02=" + (finalone.getCoverageMonths().containsKey("1") && (Boolean)finalone.getCoverageMonths().get("1") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H03=" + (finalone.getCoverageMonths().containsKey("2") && (Boolean)finalone.getCoverageMonths().get("2") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H04=" + (finalone.getCoverageMonths().containsKey("3") && (Boolean)finalone.getCoverageMonths().get("3") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H05=" + (finalone.getCoverageMonths().containsKey("4") && (Boolean)finalone.getCoverageMonths().get("4") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H06=" + (finalone.getCoverageMonths().containsKey("5") && (Boolean)finalone.getCoverageMonths().get("5") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H07=" + (finalone.getCoverageMonths().containsKey("6") && (Boolean)finalone.getCoverageMonths().get("6") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H08=" + (finalone.getCoverageMonths().containsKey("7") && (Boolean)finalone.getCoverageMonths().get("7") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H09=" + (finalone.getCoverageMonths().containsKey("8") && (Boolean)finalone.getCoverageMonths().get("8") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H10=" + (finalone.getCoverageMonths().containsKey("9") && (Boolean)finalone.getCoverageMonths().get("9") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H11=" + (finalone.getCoverageMonths().containsKey("10") && (Boolean)finalone.getCoverageMonths().get("10") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H12=" + (finalone.getCoverageMonths().containsKey("11") && (Boolean)finalone.getCoverageMonths().get("11") != false ? "Y" : "") + "^";
            mecSegment = mecSegment + "H13=" + (finalone.getCoverageMonths().containsKey("12") && (Boolean)finalone.getCoverageMonths().get("12") != false ? "Y" : "");
        }
        return mecSegment;
    }

    private String genAddressData(Person onFile, Address letterAddress) {
        String eeSegment = "";
        eeSegment = eeSegment + "B01=" + (letterAddress.getLine1() != null ? letterAddress.getLine1() : "") + "^";
        eeSegment = eeSegment + "B02=" + (letterAddress.getLine2() != null ? letterAddress.getLine2() : "") + "^";
        eeSegment = eeSegment + "B03=" + (letterAddress.getLine3() != null ? letterAddress.getLine3() : "") + "^";
        eeSegment = eeSegment + "B04=" + (letterAddress.getCity() != null ? letterAddress.getCity() : "") + "^";
        eeSegment = eeSegment + "B05=" + (letterAddress.getState() != null ? letterAddress.getState() : "") + "^";
        eeSegment = eeSegment + "B06=" + (letterAddress.getCountry() != null ? letterAddress.getCountry() : "USA") + "^";
        eeSegment = eeSegment + "B07=" + (letterAddress.getZipCode() != null ? letterAddress.getZipCode() : "") + (letterAddress.getZipPlus4() != null ? "-" + letterAddress.getZipPlus4() : "") + "^";
        eeSegment = eeSegment + "B08=" + (letterAddress.getPostalCode() != null ? letterAddress.getPostalCode() : "") + "^";
        eeSegment = eeSegment + "B09=" + (letterAddress.getCounty() != null ? letterAddress.getCounty() : "") + "^";
        eeSegment = eeSegment + "B10=" + (letterAddress.getProvince() != null ? letterAddress.getProvince() : "") + "^";
        return eeSegment;
    }

    private String genTraitsData(Person onFile) throws Exception {
        String traitsSegment = "";
        if (!this.onLineTraits) {
            PersonTraits pt = this.getPersonTraitsDAO().getPersonTraitsByVPID(onFile.getVPIDValue());
            if (pt == null) {
                throw new Exception("Failed to Retrieve Person");
            }
            PersonIdentityTraits traits = new PersonIdentityTraits();
            Name name = new Name();
            name.setFamilyName(pt.getFamilyName());
            name.setGivenName(pt.getGivenName());
            name.setMiddleName(pt.getMiddleName());
            name.setType(this.lookupService.getNameTypeByCode(NameType.LEGAL_NAME.getName()));
            traits.addName(name);
            SSN ssn = new SSN();
            ssn.setSsnText(pt.getSsn());
            ssn.setType(this.lookupService.getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
            traits.setSsn(ssn);
            BirthRecord birthRecord = new BirthRecord();
            birthRecord.setBirthDate(new ImpreciseDate(pt.getBirthDate()));
            traits.setBirthRecord(birthRecord);
            traits.setGender(this.lookupService.getGenderByCode(pt.getGender()));
            onFile.setIdentityTraits(traits);
        }
        traitsSegment = traitsSegment + "A00=" + (onFile.getIdentityTraits().getLegalName().getPrefix() != null ? onFile.getIdentityTraits().getLegalName().getPrefix() : "") + "^";
        traitsSegment = traitsSegment + "A01=" + (onFile.getIdentityTraits().getLegalName().getFamilyName() != null ? onFile.getIdentityTraits().getLegalName().getFamilyName() : "") + "^";
        traitsSegment = traitsSegment + "A02=" + (onFile.getIdentityTraits().getLegalName().getGivenName() != null ? onFile.getIdentityTraits().getLegalName().getGivenName() : "") + "^";
        traitsSegment = traitsSegment + "A03=" + (onFile.getIdentityTraits().getLegalName().getMiddleName() != null ? onFile.getIdentityTraits().getLegalName().getMiddleName() : "") + "^";
        traitsSegment = traitsSegment + "A04=" + (onFile.getIdentityTraits().getLegalName().getSuffix() != null ? onFile.getIdentityTraits().getLegalName().getSuffix() : "") + "^";
        traitsSegment = traitsSegment + "A05=" + (onFile.getIdentityTraits().getGender() != null ? onFile.getIdentityTraits().getGender().getCode() : "") + "^";
        traitsSegment = traitsSegment + "A15=" + onFile.getVPIDValue() + "^";
        traitsSegment = traitsSegment + "A16=" + onFile.getIdentityTraits().getSsnText() + "^";
        traitsSegment = traitsSegment + "N03=" + onFile.getBirthRecord().getBirthDate().getyyyyMMddFormat() + "^";
        return traitsSegment;
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    private void setRejectAndError(Correspondence letter, Correspondence form, String personId, String errMsg, DataProcessExecutionContext context) {
        try {
            if (letter != null) {
                this.getCorrespondenceService().updateACACorrespondence(letter, CorrespondenceStatus.ENROLLMENT_REJECT, errMsg);
            }
            if (form != null) {
                this.getCorrespondenceService().updateACACorrespondence(form, CorrespondenceStatus.ENROLLMENT_REJECT, errMsg);
            }
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            this.logger.error((Object)("Failed to generate ACA extract mail entry for person: " + personId + ": " + errMsg));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Failed to update ACA correspondence for person: " + personId), (Throwable)ex);
        }
    }

    private void initializeWriters(boolean isCorrection) {
        if (isCorrection) {
            if (this.correctionWriter == null) {
                Date now = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String ts = sdf.format(now);
                String fileName = "MEC_DataExtract_C_" + this.year + "_V_" + ts + ".txt";
                this.correctionWriter = this.getOutputWriter(this.getOutputFileLocation(), fileName);
                this.corrStats.setFilename(fileName);
                this.corrStats.setStartTime(now);
            }
        } else if (this.extractWriter == null) {
            Date now = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String ts = sdf.format(now);
            String fileName = "MEC_DataExtract_O_" + this.year + "_V_" + ts + ".txt";
            this.extractWriter = this.getOutputWriter(this.getOutputFileLocation(), fileName);
            this.origStats.setFilename(fileName);
            this.origStats.setStartTime(now);
        }
    }

    private boolean determineLetterType(Person onFile) {
        if (onFile.getDeathRecord() != null && onFile.getDeathRecord().getDeathDate() != null) {
            return true;
        }
        return onFile.getEnrollmentDetermination().getEnrollmentStatus().getCode().equals(EnrollmentStatus.CODE_DECEASED.getName());
    }

    private boolean determineCorrectionType(Correspondence corr) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(corr.getEffectiveDate());
        return cal.get(6) > 1;
    }

    private boolean isAddressValid(Address address) {
        if (address == null) {
            return false;
        }
        if (address.getLine1() == null || address.getLine1().trim().isEmpty()) {
            return false;
        }
        if (address.getState() == null && address.getProvince() == null) {
            return false;
        }
        return address.getBadAddressReason() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        CommsEmailBulletinService emailSrv;
        File file;
        block24: {
            try {
                if (GenerateACAMailExtract.getTaskCount(context) == 0) break block24;
                GenerateACAMailExtract generateACAMailExtract = this;
                synchronized (generateACAMailExtract) {
                    boolean stillProcessing = true;
                    while (stillProcessing) {
                        ((Object)((Object)this)).wait();
                        if (GenerateACAMailExtract.getTaskCount(context) != 0) continue;
                        stillProcessing = false;
                    }
                }
            }
            catch (InterruptedException e) {
                this.throwIllegalStateException("GenerateACAMailExtract was interrupted while it was waiting for its tasks to complete", e);
            }
        }
        this.updateJobResult(context);
        try {
            if (this.extractWriter != null) {
                this.extractWriter.flush();
                this.extractWriter.close();
            }
        }
        catch (IOException e1) {
            this.logger.error((Object)("Unable to close Data Extract File" + e1.getMessage()));
        }
        try {
            if (this.correctionWriter != null) {
                this.correctionWriter.flush();
                this.correctionWriter.close();
            }
        }
        catch (IOException e1) {
            this.logger.error((Object)("Unable to close Data Extract File" + e1.getMessage()));
        }
        this.extractWriter = null;
        this.correctionWriter = null;
        if (this.origStats.getFilename() != null) {
            file = new File(this.getOutputFileLocation() + this.origStats.getFilename());
            if (this.origStats.getNumberSent() == 0) {
                file.delete();
            } else {
                file.renameTo(new File(this.getOutputFileLocation() + "/ToCMS/" + this.origStats.getFilename()));
            }
            this.origStats.setEndTime(new Date());
        }
        if (this.corrStats.getFilename() != null) {
            file = new File(this.getOutputFileLocation() + this.corrStats.getFilename());
            if (this.corrStats.getNumberSent() == 0) {
                file.delete();
            } else {
                file.renameTo(new File(this.getOutputFileLocation() + "/ToCMS/" + this.corrStats.getFilename()));
            }
            this.corrStats.setEndTime(new Date());
        }
        if (this.origStats.getFilename() != null && this.origStats.getNumberSent() > 0) {
            emailSrv = this.getBulletinService();
            HashMap<String, Object> bulletinData = new HashMap<String, Object>();
            bulletinData.put("CompletedDateTime", this.origStats.getEndTime());
            bulletinData.put("NumberOfFiles", 1);
            bulletinData.put("NumberLettersSent", this.origStats.getNumberSent());
            bulletinData.put("NumberLetterRejected", this.origStats.getNumberRejected());
            bulletinData.put("CommunicationsPerFormTxt", "Total Form 741-800A: " + this.origStats.getNumberForm800A() + "\n" + "Total Form 741-800D: " + this.origStats.getNumberForm800D());
            bulletinData.put("RejectPerReasonPerFormTxt", "Address Error: " + this.origStats.getNumberErrAddress() + "\n" + "Duplicate Mailing: " + this.origStats.getNumberErrDuplicate() + "\n" + "Identity Traits not Found: " + this.origStats.getNumberErrIdentity() + "\n" + "Presumed Deceased: " + this.origStats.getNumberErrSuppress() + "\n" + "Other: " + this.origStats.getNumberErrOther());
            bulletinData.put("FileNameRecordCountTxt", this.origStats.getFilename() + "\t" + this.origStats.getNumberSent());
            try {
                emailSrv.sendEmailBulletin(BulletinTrigger.DataType.MEC_LETTER_PROCESSING, bulletinData, null);
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("sendNotifySubmissionFailed - cannot send email notification" + ex.getMessage()));
            }
        }
        if (this.corrStats.getFilename() != null && this.corrStats.getNumberSent() > 0) {
            emailSrv = this.getBulletinService();
            HashMap<String, Object> bulletinData = new HashMap<String, Object>();
            bulletinData.put("CompletedDateTime", this.corrStats.getEndTime());
            bulletinData.put("NumberOfFiles", 1);
            bulletinData.put("NumberLettersSent", this.corrStats.getNumberSent());
            bulletinData.put("NumberLetterRejected", this.corrStats.getNumberRejected());
            bulletinData.put("CommunicationsPerFormTxt", "Total Form 741-800A: " + this.corrStats.getNumberForm800A() + "\n" + "Total Form 741-800D: " + this.corrStats.getNumberForm800D());
            bulletinData.put("RejectPerReasonPerFormTxt", "Address Error: " + this.corrStats.getNumberErrAddress() + "\n" + "Duplicate Mailing: " + this.corrStats.getNumberErrDuplicate() + "\n" + "Identity Traits not Found: " + this.corrStats.getNumberErrIdentity() + "\n" + "Presumed Deceased: " + this.corrStats.getNumberErrSuppress() + "\n" + "Other: " + this.corrStats.getNumberErrOther());
            bulletinData.put("FileNameRecordCountTxt", this.corrStats.getFilename() + "\t" + this.corrStats.getNumberSent());
            try {
                emailSrv.sendEmailBulletin(BulletinTrigger.DataType.MEC_LETTER_PROCESSING, bulletinData, null);
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("sendNotifySubmissionFailed - cannot send email notification" + ex.getMessage()));
            }
        }
        super.handleDataProcessCompleted(context);
    }

    private Writer getOutputWriter(String fileLocation, String fileName) {
        BufferedWriter output = null;
        try {
            File file = new File(fileLocation + fileName);
            output = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new RuntimeException("GenerateACAMailExtract is unable to generate file to CMS! File= " + fileLocation + fileName + "Exception: " + e);
        }
        return output;
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(100);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CorrespondenceService getCorrespondenceService() {
        return this.correspondenceService;
    }

    public void setCorrespondenceService(CorrespondenceService correspondenceService) {
        this.correspondenceService = correspondenceService;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public String getOutputFileLocation() {
        return this.outputFileLocation;
    }

    public void setOutputFileLocation(String outputFileLocation) {
        this.outputFileLocation = outputFileLocation;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public MECPeriodDAO getMecPeriodDAO() {
        return this.mecPeriodDAO;
    }

    public void setMecPeriodDAO(MECPeriodDAO mecPeriodDAO) {
        this.mecPeriodDAO = mecPeriodDAO;
    }

    public IRSTransmissionService getIrsTransmissionService() {
        return this.irsTransmissionService;
    }

    public void setIrsTransmissionService(IRSTransmissionService irsTransmissionService) {
        this.irsTransmissionService = irsTransmissionService;
    }

    public PersonTraitsDAO getPersonTraitsDAO() {
        return this.personTraitsDAO;
    }

    public void setPersonTraitsDAO(PersonTraitsDAO personTraitsDAO) {
        this.personTraitsDAO = personTraitsDAO;
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }
}

