/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.demographic.EmailDAO;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.util.List;

public class EmailDeletionProcess
extends AbstractDataQueryIncrementalProcess {
    private TriggerRouter triggerRouter;
    private EmailDAO emailDAO;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Email Deletion batch process: Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block7: {
                Object[] row = (Object[])acquiredData.get(i);
                Email email = (Email)((Object)row[0]);
                String vpid = email.getPerson().getVPIDValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person # " + (i + 1) + " with VPID = " + vpid));
                }
                try {
                    PersonEntityKey personKey = email.getPerson().getPersonEntityKey();
                    this.emailDAO.deleteEmailById(email);
                    this.getTriggerRouter().processTriggerEvent(this.getTriggerEventZ05Email(personKey));
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing Email Deletion batch process.  VPID=" + vpid;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block7;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"EmailDeletion: Processing of current batch complete.");
            this.logger.debug((Object)("EmailDeletion: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("EmailDeletion: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    private TriggerEvent getTriggerEventZ05Email(PersonEntityKey key) {
        PersonTriggerEvent triggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ADDRESS);
        triggerEvent.setPersonId(key);
        return triggerEvent;
    }

    public EmailDAO getEmailDAO() {
        return this.emailDAO;
    }

    public void setEmailDAO(EmailDAO emailDAO) {
        this.emailDAO = emailDAO;
    }
}

