/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.Validate;

public class DuplicateMergeBatchProcess
extends AbstractDataQueryIncrementalProcess {
    private PersonService personService;
    private LookupService lookupService;
    private PersonHelperService personHelperService;
    private PersonMergeService personMergeService;
    private TransactionTimestampManager timestampManager;

    public void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + "Duplicate Merge batch process: Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block7: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal primaryPersonId = (BigDecimal)row[0];
                BigDecimal deprecatedPersonId = (BigDecimal)row[1];
                PersonIdEntityKeyImpl primaryPersonKey = new PersonIdEntityKeyImpl(primaryPersonId);
                PersonIdEntityKeyImpl deprecatedPersonKey = new PersonIdEntityKeyImpl(deprecatedPersonId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person merge record # " + (i + 1) + " with primary person id =" + primaryPersonId + ", deprecated person id =" + deprecatedPersonId));
                }
                try {
                    this.getPersonMergeService().updatePersonMergeInfoByPrimaryDepIDs(primaryPersonKey, deprecatedPersonKey);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing " + this.getProcessName() + " for primary person id=" + primaryPersonId + ", deprecated person id =" + deprecatedPersonId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block7;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public PersonMergeService getPersonMergeService() {
        return this.personMergeService;
    }

    public void setPersonMergeService(PersonMergeService personMergeService) {
        this.personMergeService = personMergeService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService);
        Validate.notNull((Object)this.lookupService);
        Validate.notNull((Object)this.personHelperService);
        Validate.notNull((Object)this.timestampManager);
        Validate.notNull((Object)this.personMergeService);
    }
}

