/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.DateOfDeathImportData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import java.util.Date;
import java.util.List;

public class DateOfDeathFileData
extends AbstractDataFileIncrementalProcess {
    private PersonService personService;
    private LookupService lookupService;
    private DemographicService demographicService;
    private static final long serialVersionUID = 9062379406331204087L;

    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        for (int i = 0; acquiredData != null && i < acquiredData.size(); ++i) {
            DateOfDeathImportData dodData = (DateOfDeathImportData)((Object)acquiredData.get(i));
            this.processRecord(dodData, context);
        }
    }

    private void processRecord(DateOfDeathImportData dodData, DataFileProcessExecutionContext context) {
        Person onFile = null;
        try {
            VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(dodData.getVpid());
            PersonIdEntityKey personkey = this.getPersonService().getPersonIdByVPID(key);
            onFile = this.getPersonService().getPerson(personkey);
            if (onFile.getDeathRecord() != null && dodData.getDateOfDeath() == null || dodData.getDateOfDeath().isEmpty()) {
                onFile.getDeathRecord().setDataSource(null);
                onFile.getDeathRecord().setDeathReportDate(null);
                onFile.getDeathRecord().setDeathDate(null);
                onFile.getDeathRecord().setDeathReportedBy(null);
                onFile.getDeathRecord().setDodVerifiedInd(null);
                onFile.getDeathRecord().setFacilityReceived(null);
                onFile.getDeathRecord().setLazarusDate(new ImpreciseDate(new Date()));
            } else {
                DeathRecord deathRecord = new DeathRecord();
                deathRecord.setDeathDate(new ImpreciseDate(dodData.getDateOfDeath()));
                deathRecord.setDeathReportDate(new Date());
                try {
                    deathRecord.setDataSource(this.lookupService.getDeathDataSourceByCode(DeathDataSource.CODE_DEATH_CERT_ON_FILE.getCode()));
                    deathRecord.setFacilityReceived(this.lookupService.getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
                }
                catch (UnknownLookupTypeException e) {
                    this.logger.error((Object)e);
                }
                onFile.setDeathRecord(deathRecord);
            }
            this.getDemographicService().updateDemographicInformation(onFile);
            context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error processing the Death Record from Idm" + ex));
            context.getProcessStatistics().incrementNumberOfErrorRecords();
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }
}

