/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.VPIDFileData;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.ClinicalDeterminationService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.math.BigDecimal;
import java.util.List;

public class CdVeteranCleanupProcess
extends AbstractDataFileIncrementalProcess {
    private ClinicalDeterminationService clinicalDeterminationService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            int listSize = 0;
            if (acquiredData != null) {
                listSize = acquiredData.size();
            }
            this.logger.error((Object)("Processing VPID  " + listSize));
        }
        for (int i = 0; acquiredData != null && i < acquiredData.size(); ++i) {
            VPIDFileData dataRecord = (VPIDFileData)((Object)acquiredData.get(i));
            String personIdinString = dataRecord.getVpid();
            try {
                BigDecimal personId = new BigDecimal(personIdinString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)("Processing person ID  " + dataRecord.getVpid()));
                }
                this.getClinicalDeterminationService().processCdForCleanup(new PersonIdEntityKeyImpl(personId));
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during Cd Veteran clean up process for person ID " + dataRecord.getVpid()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
    }

    public ClinicalDeterminationService getClinicalDeterminationService() {
        return this.clinicalDeterminationService;
    }

    public void setClinicalDeterminationService(ClinicalDeterminationService clinicalDeterminationService) {
        this.clinicalDeterminationService = clinicalDeterminationService;
    }
}

