/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CDConversionStatistics;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StopWatchLogger;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;

public class CDConversionProcess
extends AbstractDataQueryIncrementalProcess {
    private PersonService personService = null;
    private MessagingService messagingService = null;

    protected ProcessStatistics createProcessStatistics() {
        return new CDConversionStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("CD Conversion Process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        StopWatchLogger watch = null;
        Person person = null;
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            if (this.logger.isDebugEnabled() && (watch = new StopWatchLogger(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + " processData[" + i + "]")) != null) {
                watch.start();
            }
            Object[] row = (Object[])acquiredData.get(i);
            BigDecimal personId = (BigDecimal)row[0];
            try {
                person = this.personService.getPerson(new PersonIdEntityKeyImpl(personId));
                if (person == null) {
                    throw new ServiceException("Unable to find Person with personId= " + personId);
                }
                boolean hasDescriptor = this.messagingService.processCDConversion(person);
                if (hasDescriptor) {
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    continue;
                }
                ((CDConversionStatistics)context.getProcessStatistics()).incrementNumberNotConverted();
                context.getExceptionData().add("Record not converted for person ID: " + personId);
                continue;
            }
            catch (Exception ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Error convertig CD data for person " + personId;
                context.getExceptionData().add(errMsg + ". Reason: " + ex.getMessage() + ".\n   Details: " + ex);
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                continue;
            }
            finally {
                if (this.logger.isDebugEnabled() && watch != null) {
                    watch.stopAndLog();
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"CDConversionProcess: Processing complete.");
            this.logger.debug((Object)("CDConversionProcess: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("CDConversionProcess: Person records not converted to CD Descriptors = " + ((CDConversionStatistics)context.getProcessStatistics()).getNumberNotConverted()));
            this.logger.debug((Object)("CDConversionProcess: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"A PersonService is needed");
        Validate.notNull((Object)this.messagingService, (String)"A MessagingService is needed");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }
}

