/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.PSIMCorrelationFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import org.apache.commons.lang.Validate;

public class AddPSIMCorrelationProcess
extends AbstractDataFileSingleRowIncrementProcess {
    protected PSDelegateService psDelegateService;
    protected PersonService personService;

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        PSIMCorrelationFileData dataRecord = (PSIMCorrelationFileData)((Object)bean);
        boolean success = false;
        try {
            VPIDEntityKey vpidEntityKey = CommonEntityKeyFactory.createVPIDEntityKey(dataRecord.getVpid());
            this.psDelegateService.getIdentityTraits(vpidEntityKey);
            success = true;
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Error adding PSIM Correlation for VPID " + dataRecord.getVpid()), (Throwable)e);
            }
            throw new RuntimeException("Error adding PSIM Correlation for VPID " + dataRecord.getVpid(), e);
        }
        return success;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.psDelegateService, (String)"psDelegateService is required");
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }
}

