/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.OPPExtractExecutionContext;
import gov.va.med.esr.common.batchprocess.OPPExtractOutputFileProducer;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public abstract class AbstractOPPExtractOutputFileProducer
extends AbstractComponent
implements OPPExtractOutputFileProducer {
    private FormattedFileWriter outputFileWriter;
    private PSDelegateService psDelegateService;
    private boolean lastRowStatisticalData;

    public boolean isLastRowStatisticalData() {
        return this.lastRowStatisticalData;
    }

    public void setLastRowStatisticalData(boolean lastRowStatisticalData) {
        this.lastRowStatisticalData = lastRowStatisticalData;
    }

    public FormattedFileWriter getOutputFileWriter() {
        return this.outputFileWriter;
    }

    public void setOutputFileWriter(FormattedFileWriter outputFileWriter) {
        this.outputFileWriter = outputFileWriter;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    @Override
    public void generateOutputFile(DataQueryProcessExecutionContext context, List acquiredData) {
        ArrayList<RawFileDataList> outputData = new ArrayList<RawFileDataList>();
        try {
            RawFileDataList rawFileData = null;
            for (Object[] queryData : acquiredData) {
                rawFileData = new RawFileDataList();
                rawFileData.addAll(Arrays.asList(queryData));
                outputData.add(rawFileData);
            }
            this.outputFileWriter.appendData(outputData);
            OPPExtractExecutionContext oppContext = (OPPExtractExecutionContext)context;
            this.incrementStatistics(oppContext, outputData);
        }
        catch (Exception e) {
            context.getProcessStatistics().incrementNumberOfErrorRecords(acquiredData.size());
            String errorMessage = "Error while executing OPP Extract Process  " + e.getMessage();
            context.getExceptionData().add(errorMessage);
            this.logger.info((Object)errorMessage, (Throwable)e);
        }
    }

    protected abstract RawFileDataList setIdentityTraitsOnOutputData(RawFileDataList var1, PersonIdentityTraits var2);

    protected abstract void incrementStatistics(OPPExtractExecutionContext var1, List var2);

    protected PersonIdentityTraits getIdentityTraits(String vpidValue, Map personTraitsMap) throws ServiceException {
        VPIDEntityKey vpidEntityKey = CommonEntityKeyFactory.createVPIDEntityKey(vpidValue);
        PersonIdentityTraits traits = null;
        if (personTraitsMap.containsKey(vpidEntityKey.getKeyValueAsString())) {
            traits = (PersonIdentityTraits)((Object)personTraitsMap.get(vpidEntityKey.getKeyValueAsString()));
            this.logger.info((Object)"Retrieving cached person Identity traits");
        } else {
            long startTime = Calendar.getInstance().getTimeInMillis();
            traits = this.psDelegateService.getIdentityTraits(vpidEntityKey);
            personTraitsMap.put(vpidEntityKey.getKeyValueAsString(), traits);
            this.logger.info((Object)("Calling PSIM to get Identity Traits - time for call " + (Calendar.getInstance().getTimeInMillis() - startTime)));
        }
        return traits;
    }

    protected String getCenturyFormattedDate(Date date) {
        String CENTURY_FORMAT = "CyyMMdd";
        String CENTURY_1800 = "1";
        String CENTURY_1900 = "2";
        String CENTURY_2000 = "3";
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.createCalendar((Date)date);
        String century = null;
        if (cal.get(1) >= 1800 && cal.get(1) < 1900) {
            century = CENTURY_1800;
        } else if (cal.get(1) >= 1900 && cal.get(1) < 2000) {
            century = CENTURY_1900;
        } else if (cal.get(1) > 2000) {
            century = CENTURY_2000;
        }
        return century + new SimpleDateFormat(CENTURY_FORMAT.substring(1)).format(date);
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.psDelegateService, (String)"psDelegateService cannot be null");
        Validate.notNull((Object)this.outputFileWriter, (String)"outputFileWriter cannot be null");
    }
}

