/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.AbandonedAppData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.FailedRecordWriterProcessCompletedHandler;
import gov.va.med.fw.service.ServiceException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class AbandonedApplicationCleanupProcess
extends AbstractDataFileIncrementalProcess {
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private PersonService personService = null;
    private LookupService lookupService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        for (int i = 0; acquiredData != null && i < acquiredData.size(); ++i) {
            AbandonedAppData dataRecord = (AbandonedAppData)((Object)acquiredData.get(i));
            PersonIdEntityKey personKey = null;
            String vpid_value = null;
            SimpleDateFormat input = new SimpleDateFormat("yyyyMMdd");
            Date effectiveDate = null;
            try {
                personKey = CommonEntityKeyFactory.createPersonIdEntityKey(dataRecord.getPersonId());
                vpid_value = dataRecord.getVpid();
                effectiveDate = input.parse(dataRecord.getDate());
                Person incoming = this.getPersonService().getPerson(personKey);
                if (incoming == null) {
                    throw new ServiceException("Person Not Found: " + vpid_value);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Abandoned Application Cleanup Process - Processing person " + incoming.toString()));
                }
                CancelDecline cancelDecline = new CancelDecline();
                cancelDecline.setCancelDeclineIndicator(Boolean.TRUE);
                cancelDecline.setReason(this.lookupService.getCancelDeclineReasonByCode(CancelDeclineReason.CODE_OTHER.getName()));
                cancelDecline.setEffectiveDate(effectiveDate);
                cancelDecline.setRemarks("Abandoned Application");
                incoming.setCancelDecline(cancelDecline);
                this.getEligibilityEnrollmentService().updateEnrollmentData(incoming);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Abandoned Application Cleanup Process - Completed Processing person " + incoming.toString()));
                }
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during Abandoned Application Cleanup Process for person ID " + dataRecord.getPersonId()), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String trace = sw.toString();
                int len = 1500;
                if (trace.length() < 1500) {
                    len = trace.length();
                }
                context.getExceptionData().add(personKey.getKeyValueAsString() + "^" + vpid_value + "^" + e.getMessage() + "^" + trace.substring(0, len - 1));
            }
            finally {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (this.isInterrupted(context)) break;
            }
        }
        FailedRecordWriterProcessCompletedHandler dataFileCompletedHandler = (FailedRecordWriterProcessCompletedHandler)this.getDataProcessCompletedHandler();
        dataFileCompletedHandler.writeExceptionData((DataProcessExecutionContext)context);
        dataFileCompletedHandler.writeFailedData((DataProcessExecutionContext)context);
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

