/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.AacExportCommand;
import gov.va.med.esr.common.batchprocess.CommsExportStatistics;
import gov.va.med.esr.common.batchprocess.InitiateAACLetterExportProcess;
import gov.va.med.esr.common.builder.comms.DocumentBuilder;
import gov.va.med.esr.common.builder.comms.EnrollTransmission;
import gov.va.med.esr.common.builder.comms.GeneralTransmission;
import gov.va.med.esr.common.builder.comms.GenerateValues;
import gov.va.med.esr.common.builder.comms.ITransmission;
import gov.va.med.esr.common.builder.comms.InsufficientDataException;
import gov.va.med.esr.common.builder.comms.SsnTransmission;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.CommsTransByFormNumber;
import gov.va.med.esr.common.model.comms.CommsTransLog;
import gov.va.med.esr.common.model.comms.ExportSnapshot;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.lookup.ComMailingTriggerType;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.comms.AacLetterRequestDAO;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.common.persistent.comms.CommsTransLogDAO;
import gov.va.med.esr.common.persistent.comms.ExportFileDAO;
import gov.va.med.esr.common.persistent.comms.ExportSnapshotDAO;
import gov.va.med.esr.common.util.LetterFormatHelper;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class AacExportCommandImpl
extends AbstractRuleAwareServiceImpl
implements AacExportCommand {
    private static final long serialVersionUID = 1203810770916319684L;
    private static ComMailingStatusType SENT_TO_AAC_STATUS = null;
    private static final String ZERO_SIZE_FILE_NAME = "     N/A     ";
    private static String EXPORT_TRANS_TYPE_CODE = "COMREQ-A";
    private static MessageType EXPORT_TRANSMISSION_TYPE = null;
    private static int DEFAULT_BATCH_SIZE = 1000;
    private final String BATCH_SIZE_ARG = "-size=";
    private static final String PROCESS_START_DATE_ARG = "-from=";
    private CommsLetterRequestService letterReqService = null;
    private EligibilityEnrollmentService eligibilityEnrollmentService;
    private CommsTransLogDAO transDAO = null;
    private CommsLogEntryDAO commsLogDAO = null;
    private CommsTemplateDAO templateDAO;
    private ExportSnapshotDAO snapShotDAO = null;
    private ExportFileDAO fileDAO = null;
    private AacLetterRequestDAO requestDAO = null;
    private PersonHelperService personHelperService;
    private FormattedFileWriter fileWriter;
    private int batchSize = DEFAULT_BATCH_SIZE;
    private Date requestStartDate = null;

    public AacExportCommandImpl() {
    }

    public AacExportCommandImpl(AbstractComponent component) throws ServiceException {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.commsLogDAO, (String)"A Comms Log Entry DAO must be configured");
        Validate.notNull((Object)this.requestDAO, (String)"An AAC Letter Request DAO must be configured");
        Validate.notNull((Object)this.transDAO, (String)"An Comms Transmission Log DAO must be configured");
        Validate.notNull((Object)this.snapShotDAO, (String)"An Comms Export Snapshot DAO must be configured");
        Validate.notNull((Object)this.eligibilityEnrollmentService, (String)"An eligibilityEnrollmentService must be configured");
        Validate.notNull((Object)this.templateDAO, (String)"A templateDAO must be configured");
        Validate.notNull((Object)this.personHelperService, (String)"A personHelperService must be configured");
    }

    private void printUsage() {
        System.out.println("USAGE:");
        System.out.println("   ExportFileCommand [-? | -B | -P ]");
        System.out.println("   Options");
        System.out.println("     -? Display this help message");
        System.out.println("     -B process and delete the processed print/cancel requests afterwards");
        System.out.println("     -P process only, default");
        System.out.println("     ");
        System.out.println("The default is just process the export batch, no delete.");
    }

    @Override
    public CommsExportStatistics execute(String[] args, DataProcessExecutionContext context, InitiateAACLetterExportProcess process) throws Exception {
        String option = null;
        this.requestStartDate = null;
        if (args == null || args.length == 0) {
            option = "-P";
        } else {
            for (int i = 0; i < args.length; ++i) {
                String currArg = args[i];
                if (currArg.startsWith("-size=")) {
                    try {
                        String reqPerBatchSize = currArg.substring("-size=".length());
                        this.batchSize = new Integer(reqPerBatchSize);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Exception to Parse the Args :" + e));
                    }
                    continue;
                }
                if (currArg.startsWith(PROCESS_START_DATE_ARG)) {
                    try {
                        String requestStartDateStr = currArg.substring(PROCESS_START_DATE_ARG.length());
                        this.requestStartDate = new ImpreciseDate(requestStartDateStr).getDate();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Exception to Parse the Args :" + e));
                    }
                    continue;
                }
                option = args[0].trim().toUpperCase();
            }
        }
        if (option == null || args == null || args.length == 0) {
            option = "-P";
        }
        if (option.toUpperCase(Locale.ENGLISH).equals("-?")) {
            this.printUsage();
            return null;
        }
        Boolean cleanUp = new Boolean(true);
        boolean done = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("executing with option option: " + option));
        }
        done = this.preProcess(option, cleanUp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Completed preprocess: " + done));
        }
        if (done) {
            return null;
        }
        CommsExportStatistics stats = new CommsExportStatistics();
        stats.setStartTime(new Date());
        ExportSnapshot currSnapShot = this.snapShotDAO.getCurrentSnapshot();
        ExportSnapshot prevSnapShot = null;
        prevSnapShot = this.requestStartDate == null ? this.snapShotDAO.getPreviousSnapshot() : this.snapShotDAO.getFirstSnapshotOnDate(this.requestStartDate);
        long currPrintRequestId = this.getPrintRequestId(currSnapShot);
        long prevPrintRequestId = this.getPrintRequestId(prevSnapShot);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("currPrintRequestId: " + currPrintRequestId));
            this.logger.debug((Object)("prevPrintRequestId: " + prevPrintRequestId));
        }
        if (currPrintRequestId == 0L || currPrintRequestId <= prevPrintRequestId) {
            stats.setFileName(null);
            this.updateCommsTransLog(stats);
            return stats;
        }
        this.init();
        long startReqId = prevPrintRequestId;
        long endReqId = currPrintRequestId;
        long lastProcessedReqId = startReqId;
        StringBuffer totalAacLetterText = new StringBuffer();
        String aacExtractId = this.fileDAO.getAacExtractId();
        stats.setFileName(this.fileDAO.getAacFileName(aacExtractId));
        stats.setOriginalFileName(this.fileDAO.getOriginalAacFileName(aacExtractId));
        while (startReqId < endReqId) {
            List requests = this.requestDAO.findAacLetterRequestBetweenRequestIdsByBatch(new BigDecimal(startReqId), new BigDecimal(endReqId), this.batchSize);
            startReqId = this.executeBatch(context, process, currSnapShot, requests, stats, lastProcessedReqId, totalAacLetterText, aacExtractId);
            if (!context.isInterrupted()) continue;
            break;
        }
        if (!process.isInterrupted(context)) {
            this.snapShotDAO.insert(currSnapShot);
        }
        if (stats.getNumberSent() <= 0) {
            stats.setFileName(ZERO_SIZE_FILE_NAME);
        }
        try {
            this.fileDAO.changeTmpFilesToLtr();
        }
        catch (IOException e) {
            this.logger.error((Object)"Exception occured while changing the files from .tmp to .ltr ", (Throwable)e);
        }
        stats.setEndTime(new Date());
        this.updateCommsTransLog(stats);
        this.sendEmailNotification(stats);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeBatch(DataProcessExecutionContext context, InitiateAACLetterExportProcess process, ExportSnapshot currSnapShot, List requests, CommsExportStatistics stats, long lastProcessedReqId, StringBuffer totalAacLetterText, String aacExtractId) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("requests.size(): " + (requests == null ? 0 : requests.size())));
        }
        AacLetterRequest request = null;
        for (int i = 0; i < requests.size(); ++i) {
            int entryCount = 0;
            try {
                boolean isValidRequest;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("processing requet: " + i));
                }
                if (!(isValidRequest = this.isValidRequest(request = (AacLetterRequest)((Object)requests.get(i)), stats, lastProcessedReqId))) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("requet is not valid: " + i));
                    continue;
                }
                AacExportCommand cmd = (AacExportCommand)this.getComponent("aacExportCommand");
                cmd.executeSingle(context, process, request, stats, aacExtractId);
                continue;
            }
            catch (Exception ex) {
                stats.setNumberWithException(stats.getNumberWithException() + 1);
                if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                    context.setInterrupted(true);
                }
                this.handleException(context, request, ex);
                continue;
            }
            finally {
                stats.setNumberSent(stats.getNumberSent() + entryCount);
                lastProcessedReqId = ((BigDecimal)request.getEntityKey().getKeyValue()).longValue();
                currSnapShot.setPrintRequestId((BigDecimal)request.getEntityKey().getKeyValue());
                currSnapShot.setCommsLogId((BigDecimal)request.getCommsLogEntry().getEntityKey().getKeyValue());
                this.snapShotDAO.insert(currSnapShot);
                if (process.isInterrupted(context)) break;
                process.updateLiveJobStatistics(context, stats);
            }
        }
        return lastProcessedReqId;
    }

    @Override
    public void executeSingle(DataProcessExecutionContext context, InitiateAACLetterExportProcess process, AacLetterRequest request, CommsExportStatistics stats, String aacExtractId) throws Exception {
        List errorMessageList;
        int entryCount = 0;
        StringBuffer aacLetterText = new StringBuffer();
        CommsLogEntry log = request.getCommsLogEntry();
        Person person = this.getPersonService().getPerson(new PersonIdEntityKeyImpl(request.getCommsLogEntry().getPersonId()));
        GenerateValues inputValues = this.getInputValues(person, request);
        inputValues.setAacExtractId(aacExtractId);
        log.setAddress(((GeneralTransmission)inputValues.getTransmission()).getMailingAdress());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"About to call letterReqService ");
        }
        if (this.containsErrors(errorMessageList = this.letterReqService.processLetterRulesForAACExport(person, this.getFormType(log.getFormNumber()), log.getWorkflowCaseId() == null ? null : log.getWorkflowCaseId().toString(), this.getTriggerType(log.getComMailingTriggerType()), log.getOverrideIndicator(), log, inputValues.getCategoryType()))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"has errors update log ");
            }
            stats.updateRejectPerReasonPerformTable(log);
            stats.setNumberRejected(stats.getNumberRejected() + 1);
        } else {
            List aacLetterTextEntryLst = this.buildLetterRequests(person, inputValues);
            String vetFileData = (String)aacLetterTextEntryLst.get(0);
            this.updateVeteranCommsLog(log, inputValues, vetFileData);
            aacLetterText.append(vetFileData);
            ++entryCount;
            List poasWithAddresses = inputValues.getTransmission().getPOAsWithAddresses();
            Association poa = null;
            for (int j = 1; j < aacLetterTextEntryLst.size(); ++j) {
                String poaFileData = (String)aacLetterTextEntryLst.get(j);
                poa = (Association)poasWithAddresses.get(j - 1);
                CommsLogEntry poaLogEntry = this.createPOACommsLog(log, poaFileData, poa);
                poaFileData = StringUtils.replace((String)poaFileData, (String)"-@barCode@-", (String)LetterFormatHelper.formatBarcode(poaLogEntry.getBarcode()));
                poaLogEntry.setLogXML(poaFileData);
                this.commsLogDAO.update(poaLogEntry);
                aacLetterText.append(poaFileData);
                ++entryCount;
            }
            if ("RESEND".equalsIgnoreCase(log.getRemailIndicator())) {
                stats.setNumberRemailed(stats.getNumberRemailed() + 1);
            }
            stats.addToCountPerFormTable(request);
        }
        request.setCommsPrintRequestDupeCheck(request.getEntityKey().getKeyValueAsString());
        this.requestDAO.mergeObject(request);
        if (aacLetterText.length() > 0) {
            this.fileDAO.save(aacLetterText.toString(), aacExtractId);
        }
        stats.setNumberSent(stats.getNumberSent() + entryCount);
    }

    private void handleException(DataProcessExecutionContext executionContext, AacLetterRequest request, Exception e) {
        String errorMessage = "Error processing record in AAC Letter Export:  Reason: " + e.getMessage();
        if (request != null && request.getCommsLogEntry() != null) {
            errorMessage = errorMessage + " Person ID: " + request.getCommsLogEntry().getPersonId() + " Form Number: " + request.getCommsLogEntry().getFormNumber();
        }
        executionContext.getExceptionData().add(errorMessage);
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)errorMessage, (Throwable)e);
        }
        ArrayList<String> exceptionData = new ArrayList<String>();
        exceptionData.add(errorMessage);
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            exceptionData.add(trackTrace);
        }
        try {
            this.getFileWriter().appendData(exceptionData);
        }
        catch (Exception e1) {
            this.logger.error((Object)"Unable to write the exception to .exception file ", (Throwable)e1);
        }
    }

    private boolean containsErrors(List errors) {
        boolean result = false;
        if (errors != null) {
            boolean bl = errors.size() >= 1 ? !((List)errors.get(0)).isEmpty() : (result = false);
            if (!result) {
                result = errors.size() >= 2 ? !((List)errors.get(1)).isEmpty() : false;
            }
        }
        return result;
    }

    private void init() throws ServiceException {
        LookupService lookupService = (LookupService)this.getComponent("lookupService");
        EXPORT_TRANSMISSION_TYPE = lookupService.getMessageTypeByCode(EXPORT_TRANS_TYPE_CODE);
        SENT_TO_AAC_STATUS = lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.SENT_TO_AAC.getCode());
        this.letterReqService = (CommsLetterRequestService)this.getComponent("commsLetterRequestService");
    }

    private long getPrintRequestId(ExportSnapshot snapshot) {
        if (snapshot == null || snapshot.getPrintRequestId() == null) {
            return 0L;
        }
        return snapshot.getPrintRequestId().longValue();
    }

    private GenerateValues getInputValues(Person person, AacLetterRequest request) throws ServiceException {
        CommsLogEntry log = request.getCommsLogEntry();
        CommsTemplate templ = log.getTemplate();
        String formNumber = templ.getCommsTemplateFormNumber();
        ITransmission trans = this.getTransmission(formNumber, person, request.getCommsLogEntry());
        GenerateValues inputValues = new GenerateValues(person, formNumber, null, log.getWorkflowCaseId(), trans);
        inputValues.setPrintLocationCd("01");
        inputValues.setOrigTemplate(templ);
        inputValues.setCommsLog(log);
        if (request.isVeteranLetter()) {
            inputValues.setCategoryType("V");
        } else if (request.isSpouseLetter()) {
            inputValues.setCategoryType("S");
        } else if (request.isDependentLetter()) {
            inputValues.setCategoryType("D");
        }
        return inputValues;
    }

    private ITransmission getTransmission(String formNumber, Person person, CommsLogEntry log) throws ServiceException {
        if (formNumber == null) {
            return null;
        }
        GeneralTransmission trans = null;
        if (ComLetterTemplateType.FORM_NUMBER_290.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_291.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_292.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_293.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_298.getCode().equals(formNumber) || ComLetterTemplateType.FORM_NUMBER_299.getCode().equals(formNumber)) {
            SsnTransmission ssnTrans = new SsnTransmission(person, log.getWorkflowCaseId());
            ssnTrans.setFormNumber(formNumber);
            ssnTrans.setHelperService(this.getHelperService());
            trans = ssnTrans;
        } else {
            Integer currentIncomeYear;
            EnrollTransmission enrTrans = new EnrollTransmission(person, log.getWorkflowCaseId());
            enrTrans.setFormNumber(formNumber);
            enrTrans.setHelperService(this.getHelperService());
            String mostRecentNonNullPriorityLevel = this.eligibilityEnrollmentService.getMostRecentNonNullPriorityLevelByDate(person.getEntityKey(), log.getCreatedOn());
            enrTrans.setMostRecentNonNullPriorityLevel(mostRecentNonNullPriorityLevel);
            IncomeTest currentIncomeTest = this.personHelperService.getCurrentIncomeTest(person);
            enrTrans.setLocalIncomeTest(currentIncomeTest);
            if (currentIncomeTest != null && (currentIncomeYear = currentIncomeTest.getIncomeYear()) != null) {
                Integer total = currentIncomeTest.getTotalNumberOfDependents() != null ? currentIncomeTest.getTotalNumberOfDependents() : new Integer(0);
                enrTrans.setIncomeThreshold(((FinancialsHelperService)this.getComponent("financialsHelperService")).calculateIncomeThresholds(currentIncomeYear, total));
            }
            trans = enrTrans;
        }
        return trans;
    }

    private List buildLetterRequests(Person person, GenerateValues inputValues) throws ServiceException {
        DocumentBuilder builder = new DocumentBuilder();
        List textLst = null;
        try {
            textLst = builder.build(person, inputValues);
        }
        catch (InsufficientDataException idex) {
            this.logger.error((Object)"ERROR: Insufficient Data to build a letter while requesting an AAC letter", (Throwable)idex);
            throw new ServiceException(idex.toString());
        }
        return textLst;
    }

    private void updateVeteranCommsLog(CommsLogEntry log, GenerateValues inputValues, String vetFileData) throws DAOException {
        log.setLogXML(vetFileData);
        log.setAacExtractNumber(inputValues.getAacExtractId());
    }

    private CommsLogEntry createPOACommsLog(CommsLogEntry vetLog, String poaFileData, Association poa) throws Exception {
        CommsLogEntry poaLog = new CommsLogEntry();
        poaLog.setAacExtractNumber(vetLog.getAacExtractNumber());
        poaLog.setAddress(poa.getAddress());
        poaLog.setRecipient("Power of Attorney");
        poaLog.setLogXML(poaFileData);
        poaLog.addMailingStatus(SENT_TO_AAC_STATUS);
        poaLog.setLetterType(vetLog.getLetterType());
        Name poaName = poa.getRepresentativeName();
        if (poaName == null) {
            poaName = new Name();
            poaName.setFamilyName(poa.getOrganizationName());
            poaName.setType(this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getCode()));
        }
        poaLog.setName(poaName);
        poaLog.setOverrideIndicator(vetLog.getOverrideIndicator());
        poaLog.setPersonId(vetLog.getPersonId());
        poaLog.setRemailIndicator(vetLog.getRemailIndicator());
        poaLog.setSsn(vetLog.getSsn());
        poaLog.setTemplate((CommsTemplate)this.templateDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_650A.getCode()).get(0));
        poaLog.setWorkflowCaseId(vetLog.getWorkflowCaseId());
        this.commsLogDAO.insert(poaLog);
        return poaLog;
    }

    private LetterTriggerEvent.MailType getTriggerType(ComMailingTriggerType triggerType) {
        if (triggerType != null) {
            String triggerTypeCode = triggerType.getCode();
            if (triggerTypeCode.equals("1")) {
                return LetterTriggerEvent.MANUAL_MAIL;
            }
            if (triggerTypeCode.equals("2")) {
                return LetterTriggerEvent.REMAIL_MAIL;
            }
            if (triggerTypeCode.equals("3")) {
                return LetterTriggerEvent.HISTORIC_MAIL;
            }
            if (triggerTypeCode.equals("4")) {
                return LetterTriggerEvent.AUTO_MAIL;
            }
        }
        return null;
    }

    private ComLetterTemplateType getFormType(String formNumber) throws Exception {
        if (formNumber == null) {
            return null;
        }
        return this.getLookupService().getComLetterTemplateTypeByCode(formNumber);
    }

    private void updateCommsTransLog(CommsExportStatistics stats) throws Exception {
        if (stats.getFileName() == null) {
            return;
        }
        Hashtable countPerformTab = stats.getCountPerFormTable();
        if (countPerformTab != null && countPerformTab.size() > 0) {
            Enumeration keys = countPerformTab.keys();
            String key = null;
            CommsTransLog entry = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                entry = new CommsTransLog();
                entry.setFileName(stats.getOriginalFileName());
                entry.setFileProcessStartDate(stats.getStartTime());
                entry.setFileProcessEndDate(stats.getEndTime());
                CommsTransByFormNumber transByFormNumber = new CommsTransByFormNumber();
                transByFormNumber.setFormNumber(key);
                transByFormNumber.setFormNumberRecordCount((Integer)countPerformTab.get(key));
                entry.addTransByFormNumber(transByFormNumber);
                entry.setTransmissionType(EXPORT_TRANSMISSION_TYPE);
                this.transDAO.save(entry);
            }
        }
    }

    private boolean isValidRequest(AacLetterRequest request, CommsExportStatistics stats, long lastProcessedReqId) {
        CommsLogEntry entry = request.getCommsLogEntry();
        boolean isValid = true;
        if (!entry.isSendToAAC()) {
            isValid = false;
        }
        return isValid;
    }

    private boolean preProcess(String option, Boolean cleanUp) throws ServiceException {
        if (option != null && option.toUpperCase(Locale.ENGLISH).equals("-A")) {
            this.deleteReuestEntries(true);
            return true;
        }
        if (option != null && option.toUpperCase(Locale.ENGLISH).equals("-D")) {
            this.deleteReuestEntries(false);
            return true;
        }
        if (option != null && option.toUpperCase(Locale.ENGLISH).equals("-B")) {
            cleanUp = new Boolean(true);
        } else if (option != null && option.toUpperCase(Locale.ENGLISH).equals("-P")) {
            cleanUp = new Boolean(false);
        } else {
            String errMsg = "### AAC Export process stopped. ExportFileCommand - Unknown option: " + option;
            this.printUsage();
            throw new ServiceException(errMsg);
        }
        return false;
    }

    private void sendEmailNotification(CommsExportStatistics stats) throws ServiceException {
        Hashtable<String, String> dataTab = new Hashtable<String, String>();
        dataTab.put("CompletedDateTime", stats.getEndTime().toString());
        dataTab.put("NumberOfFiles", "1");
        dataTab.put("NumberLettersSent", stats.getNumberSent() + "");
        dataTab.put("NumberLetterRejected", stats.getNumberRejected() + "");
        dataTab.put("NumberLettersRemailed", stats.getNumberRemailed() + "");
        dataTab.put("CommunicationsPerFormTxt", stats.getCountPerFormTableText());
        dataTab.put("RejectPerReasonPerFormTxt", stats.getRejectPerReasonPerFormText());
        dataTab.put("FileNameRecordCountTxt", stats.getOriginalFileName() + "          " + stats.getNumberSent());
        CommsEmailBulletinService emailSrv = null;
        emailSrv = (CommsEmailBulletinService)this.getComponent("commsEmailBulletinService");
        emailSrv.sendEmailBulletin(BulletinTrigger.DataType.ENROLLMENT_LETTER_PROCESSING, dataTab, null);
    }

    private void deleteReuestEntries(boolean isAll) throws ServiceException {
        this.requestDAO = (AacLetterRequestDAO)this.getComponent("printRequestDAO");
    }

    @Override
    public CommsLogEntryDAO getCommsLogDAO() {
        return this.commsLogDAO;
    }

    @Override
    public void setCommsLogDAO(CommsLogEntryDAO commsLogDAO) {
        this.commsLogDAO = commsLogDAO;
    }

    @Override
    public AacLetterRequestDAO getRequestDAO() {
        return this.requestDAO;
    }

    @Override
    public void setRequestDAO(AacLetterRequestDAO requestDAO) {
        this.requestDAO = requestDAO;
    }

    @Override
    public ExportSnapshotDAO getSnapShotDAO() {
        return this.snapShotDAO;
    }

    @Override
    public void setSnapShotDAO(ExportSnapshotDAO snapShotDAO) {
        this.snapShotDAO = snapShotDAO;
    }

    @Override
    public CommsTransLogDAO getTransDAO() {
        return this.transDAO;
    }

    @Override
    public void setTransDAO(CommsTransLogDAO transDAO) {
        this.transDAO = transDAO;
    }

    @Override
    public ExportFileDAO getFileDAO() {
        return this.fileDAO;
    }

    @Override
    public void setFileDAO(ExportFileDAO fileDAO) {
        this.fileDAO = fileDAO;
    }

    @Override
    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    @Override
    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    @Override
    public CommsTemplateDAO getTemplateDAO() {
        return this.templateDAO;
    }

    @Override
    public void setTemplateDAO(CommsTemplateDAO templateDAO) {
        this.templateDAO = templateDAO;
    }

    @Override
    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    @Override
    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public FormattedFileWriter getFileWriter() {
        return this.fileWriter;
    }

    @Override
    public void setFileWriter(FormattedFileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }
}

