/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredFacilityLite;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.external.DemographicSummaryFactory;
import gov.va.med.esr.service.external.EnrollmentDeterminationFactory;
import gov.va.med.esr.service.external.ExternalSummaryFactory;
import gov.va.med.esr.service.external.FinancialsSummaryFactory;
import gov.va.med.esr.service.external.MilitaryServiceFactory;
import gov.va.med.esr.service.external.ServiceConnectionAwardFactory;
import gov.va.med.esr.service.external.person.AssociationInfo;
import gov.va.med.esr.service.external.person.DeathRecondInfo;
import gov.va.med.esr.service.external.person.DemographicInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilityStatusInfo;
import gov.va.med.esr.service.external.person.EligibilityVerificationInfo;
import gov.va.med.esr.service.external.person.ExternalPerson;
import gov.va.med.esr.service.external.person.FeeBasisInfo;
import gov.va.med.esr.service.external.person.IncompetenceRulingInfo;
import gov.va.med.esr.service.external.person.InsuranceInfo;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.PIIData;
import gov.va.med.esr.service.external.person.PreferredFacilityInfo;
import gov.va.med.esr.service.external.person.RelationInfo;
import gov.va.med.esr.service.external.person.SpinalCordInjuryInfo;
import gov.va.med.esr.service.external.person.collections.AssociationCollection;
import gov.va.med.esr.service.external.person.collections.FeeBasisCollection;
import gov.va.med.esr.service.external.person.collections.InsuranceCollection;
import gov.va.med.esr.service.external.person.collections.PreferredFacilityCollection;
import gov.va.med.esr.service.external.person.collections.RelationCollection;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.DateUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ExternalSummaryFactoryImpl
extends AbstractComponent
implements ExternalSummaryFactory {
    private PersonHelperService personHelperService = null;
    private FinancialsSummaryFactory financialsSummaryFactory = null;
    private DemographicSummaryFactory demographicSummaryFactory = null;
    private MilitaryServiceFactory militaryServiceFactory;
    private ServiceConnectionAwardFactory serviceConnectionAwardFactory;
    private EnrollmentDeterminationFactory enrollmentDeterminationFactory;
    private PreferredFacilityService preferredFacilityService = null;

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public FinancialsSummaryFactory getFinancialsSummaryFactory() {
        return this.financialsSummaryFactory;
    }

    public void setFinancialsSummaryFactory(FinancialsSummaryFactory financialsSummaryFactory) {
        this.financialsSummaryFactory = financialsSummaryFactory;
    }

    public DemographicSummaryFactory getDemographicSummaryFactory() {
        return this.demographicSummaryFactory;
    }

    public void setDemographicSummaryFactory(DemographicSummaryFactory demographicSummaryFactory) {
        this.demographicSummaryFactory = demographicSummaryFactory;
    }

    public MilitaryServiceFactory getMilitaryServiceFactory() {
        return this.militaryServiceFactory;
    }

    public void setMilitaryServiceFactory(MilitaryServiceFactory militaryServiceFactory) {
        this.militaryServiceFactory = militaryServiceFactory;
    }

    public ServiceConnectionAwardFactory getServiceConnectionAwardFactory() {
        return this.serviceConnectionAwardFactory;
    }

    public void setServiceConnectionAwardFactory(ServiceConnectionAwardFactory serviceConnectionAwardFactory) {
        this.serviceConnectionAwardFactory = serviceConnectionAwardFactory;
    }

    public EnrollmentDeterminationFactory getEnrollmentDeterminationFactory() {
        return this.enrollmentDeterminationFactory;
    }

    public void setEnrollmentDeterminationFactory(EnrollmentDeterminationFactory enrollmentDeterminationFactory) {
        this.enrollmentDeterminationFactory = enrollmentDeterminationFactory;
    }

    private PIIData extractPII(Person person) {
        BirthRecord birthRec;
        PersonIdentityTraits traits;
        PIIData pii = new PIIData();
        Boolean veteranInd = person.isVeteran();
        if (veteranInd == null) {
            veteranInd = new Boolean(false);
        }
        pii.setVpid((traits = person.getIdentityTraits()).getVpid() != null ? traits.getVpid().getKeyValueAsString() : null);
        Name legalName = traits.getLegalName();
        if (legalName != null) {
            pii.setFirstName(legalName.getGivenName());
            pii.setLastName(legalName.getFamilyName());
            pii.setMiddleName(legalName.getMiddleName());
        }
        if ((birthRec = traits.getBirthRecord()) != null) {
            pii.setDob(birthRec.getBirthDate() != null ? birthRec.getBirthDate().toStandardFormat() : null);
        }
        pii.setGender(traits.getGender() != null ? traits.getGender().getDescription() : null);
        pii.setMaskedSsn(traits.getSsnText());
        return pii;
    }

    protected void applyCommonData(Person person, ExternalPerson result) {
        Boolean veteranInd = person.isVeteran();
        if (veteranInd == null) {
            veteranInd = new Boolean(false);
        }
        result.setVeteran(veteranInd);
        result.setPiiData(this.extractPII(person));
    }

    @Override
    public EESummary buildEESummary(Person person) {
        RelationInfo[] relations;
        if (person == null) {
            return null;
        }
        EESummary eeSummary = new EESummary();
        this.applyEligibilityVerificationInfo(person, eeSummary);
        this.demographicSummaryFactory.applyDemographicsInfo(person, eeSummary);
        this.enrollmentDeterminationFactory.applyEnrollmentDeterminationInfo(person, eeSummary);
        this.getFinancialsSummaryFactory().applyFinancialsInfo(person, eeSummary);
        eeSummary.setMilitaryServiceInfo(this.militaryServiceFactory.getMilitaryServiceInfo(person));
        this.applyIncompetenceRulingInfo(person, eeSummary);
        this.applyDeathRecord(person, eeSummary);
        eeSummary.setPrisonerOfWarInfo(this.militaryServiceFactory.getPOWInfo(person));
        eeSummary.setPurpleHeart(this.militaryServiceFactory.getPurpleHeartInfo(person));
        this.applySpinalCardInjury(person, eeSummary);
        AssociationInfo[] associations = this.demographicSummaryFactory.buildContacts(person);
        if (associations != null) {
            eeSummary.setAssociations(new AssociationCollection(associations));
        }
        if ((relations = this.demographicSummaryFactory.buildRelations(person)) != null && relations.length > 0) {
            eeSummary.setRelations(new RelationCollection(relations));
        }
        eeSummary.setEmploymentInfo(this.demographicSummaryFactory.buildEmployment(person));
        this.applyFeeBasis(person, eeSummary);
        InsuranceInfo[] insurances = this.demographicSummaryFactory.buildInsurance(person);
        if (insurances != null && insurances.length > 0) {
            eeSummary.setInsuranceList(new InsuranceCollection(insurances));
        }
        if (person.getMostRecentPreferredFacility() != null) {
            this.applyPreferredFacilities(person, eeSummary);
        }
        return eeSummary;
    }

    @Override
    public EESummary buildEDStatus(Person person) {
        EESummary eeSummary = new EESummary();
        if (person == null) {
            EligibilityStatusInfo info = new EligibilityStatusInfo();
            info.setEligibilityStatus("Not Found");
            eeSummary.setEligibilityStatusInfo(info);
            return eeSummary;
        }
        this.enrollmentDeterminationFactory.applyEligibilityStatusInfo(person, eeSummary);
        return eeSummary;
    }

    @Override
    public void buildEESummaryHistory(Person person, EESummary eeSummary, String categoryName) {
        InsuranceInfo[] insurances;
        if (person == null) {
            return;
        }
        if (categoryName.equals("ELIGIBILITY")) {
            this.applyEligibilityVerificationInfo(person, eeSummary);
        }
        if (categoryName.equals("ENROLLMENT")) {
            this.enrollmentDeterminationFactory.applyEnrollmentInfo(person, eeSummary);
        }
        if (categoryName.equals("PRIMARYELIGIBILITY")) {
            this.enrollmentDeterminationFactory.applyEligibilityInfo(person, eeSummary);
        }
        if (categoryName.equals("DISABILITY")) {
            this.enrollmentDeterminationFactory.applyDisabilityInfo(person, eeSummary);
        }
        if (categoryName.equals("INSURANCE") && (insurances = this.demographicSummaryFactory.buildInsurance(person)) != null && insurances.length > 0) {
            eeSummary.setInsuranceList(new InsuranceCollection(insurances));
        }
    }

    @Override
    public MSSummary buildMSSummary(Person person) {
        MilitaryService ms;
        if (person == null) {
            return null;
        }
        MSSummary summary = new MSSummary();
        this.applyCommonData(person, summary);
        if (person.getPrisonerOfWar() != null) {
            Indicator powIndicator = person.getPrisonerOfWar().getPowIndicator();
            summary.setPOWStatusIndicated(powIndicator != null ? powIndicator.toBoolean() : null);
        }
        if ((ms = person.getMilitaryService()) != null) {
            Set siteRecords = ms.getMilitaryServiceSiteRecords();
            Iterator itr = siteRecords != null ? siteRecords.iterator() : null;
            MilitaryServiceSiteRecord latestSiteRec = null;
            MilitaryServiceSiteRecord siteRec = null;
            while (itr != null && itr.hasNext()) {
                siteRec = (MilitaryServiceSiteRecord)itr.next();
                if (latestSiteRec == null) {
                    latestSiteRec = siteRec;
                    continue;
                }
                if (!latestSiteRec.getCreatedOn().before(siteRec.getCreatedOn())) continue;
                latestSiteRec = siteRec;
            }
            if (latestSiteRec != null) {
                summary.setPeriodOfServiceCode(latestSiteRec.getServicePeriod() != null ? latestSiteRec.getServicePeriod().getName() : null);
                Set episodes = latestSiteRec.getMilitaryServiceEpisodes();
                itr = episodes != null ? episodes.iterator() : null;
                MilitaryServiceEpisode latestEpisode = null;
                MilitaryServiceEpisode episode = null;
                while (itr != null && itr.hasNext()) {
                    episode = (MilitaryServiceEpisode)itr.next();
                    if (latestEpisode == null) {
                        latestEpisode = episode;
                        continue;
                    }
                    if (latestEpisode.getEndDate() == null || latestEpisode.getEndDate().compareTo(episode.getEndDate()) >= 0) continue;
                    latestEpisode = episode;
                }
                if (latestEpisode != null) {
                    summary.setLastServiceBranchCode(latestEpisode.getServiceBranch() != null ? latestEpisode.getServiceBranch().getDescription() : null);
                    summary.setLastServiceNumber(latestEpisode.getServiceNumber());
                    summary.setLastServiceEntryDate(latestEpisode.getStartDate() != null ? latestEpisode.getStartDate().toStandardFormat() : null);
                    summary.setLastServiceSeparationDate(latestEpisode.getEndDate() != null ? latestEpisode.getEndDate().toStandardFormat() : null);
                }
            }
        }
        return summary;
    }

    private void applyEligibilityVerificationInfo(Person person, EESummary summary) {
        EligibilityVerification ev = person.getEligibilityVerification();
        if (ev == null) {
            return;
        }
        EligibilityVerificationInfo evInfo = new EligibilityVerificationInfo();
        evInfo.setVerificationMethod(ev.getVerificationMethod());
        if (ev.getEligibilityStatus() != null) {
            evInfo.setEligibilityStatus(ev.getEligibilityStatus().getDescription());
        }
        if (ev.getEligibilityStatusDate() != null) {
            evInfo.setEligibilityStatusDate(ev.getEligibilityStatusDate().getStandardFormat());
        }
        summary.setEligibilityVerificationInfo(evInfo);
    }

    private void applyDeathRecord(Person person, EESummary eeSummary) {
        DeathRecord dr = person.getDeathRecord();
        if (dr == null) {
            return;
        }
        DeathRecondInfo drInfo = new DeathRecondInfo();
        drInfo.setDataSource(dr.getDataSource() != null ? dr.getDataSource().getDescription() : null);
        drInfo.setDeathDate(dr.getDeathDate() != null ? dr.getDeathDate().getStandardFormat() : null);
        drInfo.setDeathLastModified(dr.getDeathLastModified());
        drInfo.setDeathReportDate(dr.getDeathReportDate());
        drInfo.setFacilityReceived(dr.getFacilityReceived() != null ? dr.getFacilityReceived().getSiteNumberAndName() : null);
        eeSummary.setDeathRecond(drInfo);
    }

    private void applyIncompetenceRulingInfo(Person person, EESummary eeSummary) {
        IncompetenceRuling ruling = person.getIncompetenceRuling();
        if (ruling == null) {
            return;
        }
        IncompetenceRulingInfo rulingInfo = new IncompetenceRulingInfo();
        rulingInfo.setCivilRulingDate(ruling.getCivilRulingDate() != null ? ruling.getCivilRulingDate().getStandardFormat() : null);
        rulingInfo.setVaRulingDate(ruling.getVaRulingDate() != null ? ruling.getVaRulingDate().getStandardFormat() : null);
        rulingInfo.setIncompetent(ruling.getIncompetent());
        eeSummary.setIncompetenceRulingInfo(rulingInfo);
    }

    private void applyFeeBasis(Person person, EESummary summary) {
        Set feeBaseSet = person.getFeeBasis();
        if (feeBaseSet != null && feeBaseSet.size() > 0) {
            Iterator itr = feeBaseSet != null ? feeBaseSet.iterator() : null;
            int count = 0;
            FeeBasisInfo[] feeBasisInfoArray = new FeeBasisInfo[feeBaseSet.size()];
            while (itr != null && itr.hasNext()) {
                FeeBasis feeBasis = (FeeBasis)itr.next();
                if (feeBasis == null) continue;
                FeeBasisInfo feeBasisInfo = new FeeBasisInfo();
                feeBasisInfo.setAuthorizationFromDate(feeBasis.getAuthorizationFromDate());
                feeBasisInfo.setAuthorizationToDate(feeBasis.getAuthorizationToDate());
                feeBasisInfo.setReportDate(feeBasis.getReportDate());
                feeBasisInfo.setReportSite(feeBasis.getReportSite() != null ? feeBasis.getReportSite().getSiteNumberAndName() : null);
                feeBasisInfo.setTreatmentType(feeBasis.getTreatmentType() != null ? feeBasis.getTreatmentType().getDescription() : null);
                feeBasisInfo.setProgram(feeBasis.getProgram() != null ? feeBasis.getProgram().getDescription() : null);
                feeBasisInfoArray[count] = feeBasisInfo;
                ++count;
            }
            if (feeBasisInfoArray != null && feeBasisInfoArray.length > 0) {
                summary.setFeeBasisList(new FeeBasisCollection(feeBasisInfoArray));
            }
        }
    }

    private void applySpinalCardInjury(Person person, EESummary summary) {
        SpinalCordInjury sc = (SpinalCordInjury)this.enrollmentDeterminationFactory.getClinicalDetermination(SpinalCordInjury.class, person);
        if (sc == null) {
            return;
        }
        SpinalCordInjuryInfo scInfo = new SpinalCordInjuryInfo();
        scInfo.setDeterminationFacility(sc.getDeterminationFacility() != null ? sc.getDeterminationFacility().getSiteNumberAndName() : null);
        scInfo.setSpinalCordInjuryType(sc.getSpinalCordInjuryType() != null ? sc.getSpinalCordInjuryType().getDescription() : null);
        summary.setSpinalCordInjuryInfo(scInfo);
    }

    private void applyPreferredFacilities(Person person, EESummary summary) {
        PreferredFacilityInfo[] pfInfos;
        Set pfList = person.getPreferredFacilities();
        Set activePfs = this.getActivePreferredFacilities(pfList);
        DemographicInfo demographicInfo = summary.getDemographics();
        int i = 0;
        if (!activePfs.isEmpty()) {
            pfInfos = new PreferredFacilityInfo[activePfs.size()];
            for (PreferredFacility pf : activePfs) {
                pfInfos[i] = new PreferredFacilityInfo();
                pfInfos[i].setPreferredFacility(pf.getFacility().getSiteNumberAndName());
                if (pf.getAssignmentDate() != null) {
                    pfInfos[i].setAssignmentDate(pf.getAssignmentDate());
                }
                if (pf.getUnassignmentDate() != null) {
                    pfInfos[i].setUnassignmentDate(pf.getUnassignmentDate());
                }
                ++i;
            }
        } else {
            pfInfos = new PreferredFacilityInfo[1];
            PreferredFacility pf = this.getPreferredFacilityService().getMostRecentPreferredFacility(person);
            if (pf != null) {
                pfInfos[0] = new PreferredFacilityInfo();
                pfInfos[0].setPreferredFacility(person.getMostRecentPreferredFacility().getSiteNumberAndName());
                if (pf.getAssignmentDate() != null) {
                    pfInfos[0].setAssignmentDate(pf.getAssignmentDate());
                }
                if (pf.getUnassignmentDate() != null) {
                    pfInfos[0].setUnassignmentDate(pf.getUnassignmentDate());
                }
            } else {
                pfInfos[0] = new PreferredFacilityInfo();
                pfInfos[0].setPreferredFacility(null);
            }
        }
        if (pfInfos != null && pfInfos.length > 0) {
            demographicInfo.setPreferredFacilities(new PreferredFacilityCollection(pfInfos));
        }
        summary.setDemographics(demographicInfo);
    }

    private Set getActivePreferredFacilities(Set pfList) {
        HashSet<PreferredFacility> activePfs = new HashSet<PreferredFacility>();
        PreferredFacility pf2 = null;
        for (PreferredFacility pf2 : pfList) {
            if (!this.isPFActive((PreferredFacilityLite)pf2)) continue;
            activePfs.add(pf2);
        }
        return activePfs;
    }

    private boolean isPFActive(PreferredFacilityLite pf) {
        Date currentDate = DateUtils.getCurrentDateTime();
        return pf.getUnassignmentDate() == null || pf.getUnassignmentDate().after(currentDate);
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }
}

