/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AllTests {
    private static final String classpath_ = System.getProperty("java.class.path");
    private static final String pathsep_ = System.getProperty("path.separator");
    private static final String dirsep_ = System.getProperty("file.separator");
    private static boolean verbose_ = false;
    private static TestSuite suite_ = null;
    private static String rootPackageName_ = AllTests.myPackageName_();
    static String testClassPrefix_ = "Test";
    static /* synthetic */ Class class$test$AllTests;

    private static String myPackageName_() {
        String result = (class$test$AllTests == null ? (class$test$AllTests = AllTests.class$("test.AllTests")) : class$test$AllTests).getName();
        int p = result.lastIndexOf(46);
        if (p > 0) {
            result = result.substring(0, p);
        }
        return result;
    }

    public static Test suite() {
        if (suite_ == null) {
            suite_ = new TestSuite("All Tests");
            File testPackage = AllTests.find(rootPackageName_, classpath_);
            AllTests.checkDirectory(testPackage, rootPackageName_.replace('/', '.'));
        }
        return suite_;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            int iArgs = 0;
            String arg = args[iArgs];
            if (arg.charAt(0) == '-') {
                switch (arg.charAt(1)) {
                    case 'p': {
                        testClassPrefix_ = arg.length() == 2 ? args[++iArgs] : arg.substring(2);
                    }
                    case 'v': {
                        verbose_ = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid command-line argument: " + arg);
                    }
                }
                ++iArgs;
            }
            if (iArgs < args.length) {
                rootPackageName_ = args[iArgs].replace('.', '/').replace('\\', '/');
            }
        }
        TestRunner.run((Test)AllTests.suite());
    }

    private static void checkDirectory(File directory, String packageName) {
        String dirname = directory.getAbsolutePath();
        if (dirname.endsWith("/.") || dirname.endsWith("\\.")) {
            dirname = dirname.substring(0, dirname.length() - 2);
        } else if (dirname.endsWith("/") || dirname.endsWith("\\")) {
            dirname = dirname.substring(0, dirname.length() - 1);
        }
        if (verbose_) {
            System.err.println("Checking directory " + dirname + "...");
        }
        String[] files = directory.list();
        for (int j = 0; j <= 1; ++j) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].startsWith(".")) continue;
                String filename = dirname + dirsep_ + files[i];
                if (verbose_) {
                    System.err.println("Looking at " + filename);
                }
                File file = new File(filename);
                if (j == 0 && file.isFile()) {
                    AllTests.checkFile(file, packageName);
                    continue;
                }
                if (j != 1 || !file.isDirectory()) continue;
                AllTests.checkDirectory(file, packageName + '.' + files[i]);
            }
        }
    }

    private static void checkFile(File file, String packageName) {
        block12: {
            String fileName = file.getAbsolutePath();
            int p = fileName.lastIndexOf(dirsep_);
            if (p != -1) {
                fileName = fileName.substring(p + 1);
            }
            if (!fileName.startsWith(testClassPrefix_) || !fileName.endsWith(".class") || fileName.indexOf(36) > -1) {
                return;
            }
            try {
                String className = fileName.substring(0, fileName.lastIndexOf(46));
                String fullName = packageName + '.' + className;
                if (verbose_) {
                    System.err.println("Loading " + fullName);
                }
                Class<?> theClass = Class.forName(fullName);
                try {
                    Method suiteMethod = theClass.getMethod("suite", null);
                    int modifiers = suiteMethod.getModifiers();
                    if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) break block12;
                    try {
                        Test suite = (Test)suiteMethod.invoke(null, null);
                        suite_.addTest(suite);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Internal error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access suite().", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Cannot invoke suite().", e);
                    }
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Cannot access suite().", e);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    suite_.addTestSuite(theClass);
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println(e.toString());
            }
        }
    }

    public static File find(String className) {
        String filename = className.replace('.', '/');
        filename = filename + ".class";
        return AllTests.find(filename, classpath_);
    }

    private static File find(String filepath, String searchpath) {
        StringTokenizer t = new StringTokenizer(searchpath, pathsep_);
        while (t.hasMoreTokens()) {
            String pathElement = t.nextToken();
            File maybe = new File(pathElement, filepath);
            if (!maybe.exists()) continue;
            return maybe;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

