/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class Settings {
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$util$Settings == null ? (class$gov$va$med$term$access$util$Settings = Settings.class$("gov.va.med.term.access.util.Settings")) : class$gov$va$med$term$access$util$Settings));
    private Loader loader_ = null;
    private static Settings settings_ = new Settings(Settings.createDefaultLoader());
    static /* synthetic */ Class class$gov$va$med$term$access$util$Settings;
    static /* synthetic */ Class class$gov$va$med$term$access$util$Settings$Loader;
    static /* synthetic */ Class class$gov$va$med$term$access$util$Settings$SettingsLoader;

    public Settings(Loader loader) {
        this.loader_ = loader;
    }

    public static synchronized Settings instance() {
        return settings_;
    }

    public static synchronized void instance(Settings settings) {
        settings_ = settings;
    }

    private static Loader createDefaultLoader() {
        SettingsLoader systemLoader = new SettingsLoader(System.getProperties());
        String loaderType = systemLoader.value((class$gov$va$med$term$access$util$Settings == null ? (class$gov$va$med$term$access$util$Settings = Settings.class$("gov.va.med.term.access.util.Settings")) : class$gov$va$med$term$access$util$Settings).getName(), "loader");
        if (loaderType != null) {
            Class<?> loaderClass = null;
            try {
                loaderClass = Class.forName(loaderType);
                if (!(class$gov$va$med$term$access$util$Settings$Loader == null ? (class$gov$va$med$term$access$util$Settings$Loader = Settings.class$("gov.va.med.term.access.util.Settings$Loader")) : class$gov$va$med$term$access$util$Settings$Loader).isAssignableFrom(loaderClass)) {
                    String msg = loaderClass.getName() + " must implement " + (class$gov$va$med$term$access$util$Settings$Loader == null ? (class$gov$va$med$term$access$util$Settings$Loader = Settings.class$("gov.va.med.term.access.util.Settings$Loader")) : class$gov$va$med$term$access$util$Settings$Loader).getName();
                    logger_.warn((Object)msg);
                    throw new RuntimeException(msg);
                }
                return (Loader)loaderClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "A ClassNotFoundException was thrown  while trying to find the class " + loaderClass.getName();
                logger_.warn((Object)msg);
                throw new RuntimeException(msg, cnfe);
            }
            catch (IllegalAccessException iae) {
                String msg = "An IllegalAccessException has been thrown while trying to create the class " + loaderClass.getName();
                logger_.warn((Object)msg);
                throw new RuntimeException(msg, iae);
            }
            catch (InstantiationException ie) {
                String msg = "An InstantiationException was thrown while creating the class " + loaderClass.getName();
                logger_.warn((Object)msg);
                throw new RuntimeException(msg, ie);
            }
        }
        String propertyFilename = systemLoader.value((class$gov$va$med$term$access$util$Settings == null ? (class$gov$va$med$term$access$util$Settings = Settings.class$("gov.va.med.term.access.util.Settings")) : class$gov$va$med$term$access$util$Settings).getName(), "propertyFilename");
        if (propertyFilename == null) {
            propertyFilename = "/application.properties";
        }
        return new SettingsLoader(propertyFilename);
    }

    private String value(String classname, String name, String defaultValue, boolean isDefaultSpecified) throws SettingNotFoundException {
        String value = this.loader_.value(classname, name);
        if (value == null) {
            if (!isDefaultSpecified) {
                String message = "The setting " + name + " for class " + classname + " was not found.";
                logger_.warn((Object)message);
                throw new SettingNotFoundException(message);
            }
            value = defaultValue;
        }
        return value;
    }

    private String[] values(String classname, String name, String delimiters, String[] defaultValue, boolean isDefaultSpecified) throws SettingNotFoundException {
        String value = this.loader_.value(classname, name);
        if (value == null) {
            if (!isDefaultSpecified) {
                String message = "The setting " + name + " for class " + classname + " was not found.";
                logger_.warn((Object)message);
                throw new SettingNotFoundException(message);
            }
            return defaultValue;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
        Vector<String> values = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values.toArray(new String[0]);
    }

    public String value(String classname, String name) throws SettingNotFoundException {
        return this.value(classname, name, null, false);
    }

    public String value(String classname, String name, String defaultValue) {
        return this.value(classname, name, defaultValue, true);
    }

    public String[] values(String classname, String name, String delimiters) throws SettingNotFoundException {
        return this.values(classname, name, delimiters, null, false);
    }

    public String[] values(String classname, String name, String delimiters, String[] defaultValue) {
        return this.values(classname, name, delimiters, defaultValue, true);
    }

    public String[] getNames(String classname) {
        return this.loader_.names(classname);
    }

    public Properties propertiesFor(String classname) {
        return this.loader_.propertiesFor(classname);
    }

    public String value(Class cls, String name) throws SettingNotFoundException {
        return this.value(cls.getName(), name, null, false);
    }

    public String value(Class cls, String name, String defaultValue) {
        return this.value(cls.getName(), name, defaultValue, true);
    }

    public String[] values(Class cls, String name, String delimiters) throws SettingNotFoundException {
        return this.values(cls.getName(), name, delimiters, null, false);
    }

    public String[] values(Class cls, String name, String delimiters, String[] defaultValue) {
        return this.values(cls.getName(), name, delimiters, defaultValue, true);
    }

    public String[] getNames(Class cls) {
        return this.loader_.names(cls.getName());
    }

    public Properties propertiesFor(Class cls) {
        return this.loader_.propertiesFor(cls.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ServletContextLoader
    implements Loader {
        private ServletContext servletContext_;

        public ServletContextLoader(ServletContext servletContext) {
            this.servletContext_ = servletContext;
        }

        private String buildSettingName(String classname, String name) {
            StringBuffer settingName = new StringBuffer();
            settingName.append(classname);
            settingName.append("/");
            settingName.append(name);
            return settingName.toString();
        }

        public String value(String classname, String name) {
            String settingName = this.buildSettingName(classname, name);
            return this.servletContext_.getInitParameter(settingName);
        }

        public String[] names(String classname) {
            Enumeration e = this.servletContext_.getInitParameterNames();
            ArrayList<String> list = new ArrayList<String>();
            String prefix = this.buildSettingName(classname, "");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(prefix)) continue;
                list.add(name);
            }
            return list.toArray(new String[0]);
        }

        public Properties propertiesFor(String classname) {
            Enumeration e = this.servletContext_.getInitParameterNames();
            Properties properties = new Properties();
            String prefix = this.buildSettingName(classname, "");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(prefix)) continue;
                properties.setProperty(name.substring(prefix.length()), this.servletContext_.getInitParameter(name));
            }
            return properties;
        }
    }

    public static class SettingsLoader
    implements Loader {
        public static final String SEPARATOR = "/";
        private Properties properties_;

        public SettingsLoader(String propertyFilename) {
            this.properties_ = new Properties();
            InputStream stream = (class$gov$va$med$term$access$util$Settings$SettingsLoader == null ? (class$gov$va$med$term$access$util$Settings$SettingsLoader = Settings.class$("gov.va.med.term.access.util.Settings$SettingsLoader")) : class$gov$va$med$term$access$util$Settings$SettingsLoader).getResourceAsStream(propertyFilename);
            if (stream == null) {
                logger_.warn((Object)("Unable to locate " + propertyFilename));
            } else {
                try {
                    this.properties_.load(stream);
                }
                catch (IOException e) {
                    logger_.warn((Object)("Unable to load " + propertyFilename + ": " + e.getMessage()));
                }
            }
        }

        public SettingsLoader(Properties properties) {
            this.properties_ = properties;
        }

        private String buildSettingName(String classname, String name) {
            StringBuffer settingName = new StringBuffer();
            settingName.append(classname);
            settingName.append(SEPARATOR);
            settingName.append(name);
            return settingName.toString();
        }

        public String value(String classname, String name) {
            String settingName = this.buildSettingName(classname, name);
            return (String)this.properties_.get(settingName);
        }

        public String[] names(String classname) {
            Set<Object> keys = this.properties_.keySet();
            ArrayList<String> list = new ArrayList<String>(keys.size());
            String prefix = this.buildSettingName(classname, "");
            Iterator<Object> i = keys.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!name.startsWith(prefix)) continue;
                list.add(name);
            }
            return list.toArray(new String[0]);
        }

        public Properties propertiesFor(String classname) {
            Set<Map.Entry<Object, Object>> entries = this.properties_.entrySet();
            Properties properties = new Properties();
            String prefix = this.buildSettingName(classname, "");
            Iterator<Map.Entry<Object, Object>> i = entries.iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                properties.setProperty(key.substring(prefix.length()), (String)entry.getValue());
            }
            return properties;
        }
    }

    public static class SettingNotFoundException
    extends RuntimeException {
        public SettingNotFoundException(String message) {
            super(message);
        }

        public SettingNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public SettingNotFoundException(Throwable cause) {
            super(cause);
        }
    }

    public static interface Loader {
        public String value(String var1, String var2);

        public String[] names(String var1);

        public Properties propertiesFor(String var1);
    }
}

