/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesLoader {
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$util$PropertiesLoader == null ? (class$gov$va$med$term$access$util$PropertiesLoader = PropertiesLoader.class$("gov.va.med.term.access.util.PropertiesLoader")) : class$gov$va$med$term$access$util$PropertiesLoader));
    private static final Object NULL = new Properties();
    private static final Hashtable mappings_ = new Hashtable();
    static /* synthetic */ Class class$gov$va$med$term$access$util$PropertiesLoader;

    private static String packagePrefix(String className) {
        int p = className.lastIndexOf(46);
        className = p >= 0 ? className.substring(0, p) : null;
        return className;
    }

    private static String pathPrefix(String path) {
        int p = path.lastIndexOf(47);
        path = p >= 0 ? path.substring(0, p) : null;
        return path;
    }

    private static String simpleClassName(Class c) {
        String result = c.getName();
        int i = result.lastIndexOf(46);
        if (i > 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    public static Properties find(Class c) {
        return PropertiesLoader.find(PropertiesLoader.packagePrefix(c.getName()), PropertiesLoader.simpleClassName(c) + ".properties", null);
    }

    public static Properties find(Class c, Properties defaultProperties) {
        return PropertiesLoader.find(PropertiesLoader.packagePrefix(c.getName()), PropertiesLoader.simpleClassName(c) + ".properties", defaultProperties);
    }

    public static Properties find(Class c, String fileName, Properties defaultProperties) {
        return PropertiesLoader.find(PropertiesLoader.packagePrefix(c.getName()), fileName, defaultProperties);
    }

    public static Properties find(String packageName, String fileName, Properties defaultProperties) {
        Properties result = null;
        String pathPrefix = packageName.length() == 0 ? "" : "/" + packageName.replace('.', '/');
        String currentName = null;
        InputStream s = null;
        while (s == null && pathPrefix != null) {
            currentName = pathPrefix + "/" + fileName;
            result = (Properties)mappings_.get(currentName);
            if (result != null) {
                return result == NULL ? null : result;
            }
            s = (class$gov$va$med$term$access$util$PropertiesLoader == null ? PropertiesLoader.class$("gov.va.med.term.access.util.PropertiesLoader") : class$gov$va$med$term$access$util$PropertiesLoader).getResourceAsStream(currentName);
            pathPrefix = PropertiesLoader.pathPrefix(pathPrefix);
        }
        if (s == null) {
            result = defaultProperties;
            if (logger_.isInfoEnabled()) {
                logger_.info((Object)("Did not find '" + fileName + "' in path '" + packageName + "'" + (defaultProperties != null ? ", loading default" : "")));
            }
        } else {
            result = new Properties();
            try {
                result.load(s);
                if (logger_.isInfoEnabled()) {
                    logger_.info((Object)("Loaded " + (class$gov$va$med$term$access$util$PropertiesLoader == null ? (class$gov$va$med$term$access$util$PropertiesLoader = PropertiesLoader.class$("gov.va.med.term.access.util.PropertiesLoader")) : class$gov$va$med$term$access$util$PropertiesLoader).getResource(currentName).toString()));
                }
            }
            catch (IOException x) {
                throw new Exception("Could not load " + currentName, x);
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException x) {}
            }
        }
        mappings_.put(currentName, result == null ? NULL : result);
        return result;
    }

    public static Properties load(String path) {
        return PropertiesLoader.load(class$gov$va$med$term$access$util$PropertiesLoader == null ? (class$gov$va$med$term$access$util$PropertiesLoader = PropertiesLoader.class$("gov.va.med.term.access.util.PropertiesLoader")) : class$gov$va$med$term$access$util$PropertiesLoader, path);
    }

    public static Properties load(Class forClass) {
        return PropertiesLoader.load(forClass, PropertiesLoader.simpleClassName(forClass) + ".properties");
    }

    public static Properties load(Class relative, String path) {
        Properties result = null;
        InputStream s = relative.getResourceAsStream(path);
        if (s == null) {
            if (logger_.isInfoEnabled()) {
                logger_.info((Object)("PropertiesLoader: Could not locate '" + path + "'" + (!path.startsWith("/") ? " relative to " + relative : "") + " in class path"));
            }
        } else {
            try {
                result = new Properties();
                result.load(s);
                if (logger_.isInfoEnabled()) {
                    logger_.info((Object)("Loaded " + relative.getResource(path).toString()));
                }
            }
            catch (IOException x) {
                if (logger_.isInfoEnabled()) {
                    logger_.info((Object)("Could not load " + path + ": " + x.toString()));
                }
                throw new Exception("Could not load " + path, x);
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException x) {}
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Exception
    extends RuntimeException {
        public Exception(String message, Throwable x) {
            super(message, x);
        }

        public Exception(String message) {
            super(message);
        }
    }
}

