/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.util;

import gov.va.med.term.access.util.Is;
import gov.va.med.term.access.util.Settings;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ImplementorRegistry {
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$util$ImplementorRegistry == null ? (class$gov$va$med$term$access$util$ImplementorRegistry = ImplementorRegistry.class$("gov.va.med.term.access.util.ImplementorRegistry")) : class$gov$va$med$term$access$util$ImplementorRegistry));
    private MutableImplementorFinder cache_;
    private static final String[] emptyStringArray_ = new String[0];
    private static ImplementorRegistry registry_ = new ImplementorRegistry();
    static /* synthetic */ Class class$gov$va$med$term$access$util$ImplementorRegistry;
    static /* synthetic */ Class class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule;

    public ImplementorRegistry() {
        this(Settings.instance().propertiesFor(class$gov$va$med$term$access$util$ImplementorRegistry == null ? (class$gov$va$med$term$access$util$ImplementorRegistry = ImplementorRegistry.class$("gov.va.med.term.access.util.ImplementorRegistry")) : class$gov$va$med$term$access$util$ImplementorRegistry));
    }

    public ImplementorRegistry(String[] rules) {
        this.cache_ = new CachingImplementorFinder(new MemoryImplementorFinder(), new RuleImplementorFinder(rules));
    }

    public ImplementorRegistry(Properties rules) {
        this.cache_ = new CachingImplementorFinder(new MemoryImplementorFinder(), new RuleImplementorFinder(rules));
    }

    public Object implementorFor(Class expectedType) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType));
        }
        return this.implementorFor(expectedType, emptyStringArray_, null);
    }

    public Object implementorFor(Class expectedType, Object defaultImplementor) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " DefaultImplementor " + defaultImplementor));
        }
        return this.implementorFor(expectedType, emptyStringArray_, defaultImplementor);
    }

    public Object implementorFor(Class expectedType, String discriminator) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator));
        }
        return this.implementorFor(expectedType, new String[]{discriminator}, null);
    }

    public Object implementorFor(Class expectedType, Class discriminator) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator));
        }
        return this.implementorFor(expectedType, new String[]{discriminator.getName()}, null);
    }

    public Object implementorFor(Class expectedType, String discriminator, Object defaultImplementor) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator + " DefaultImplementor " + defaultImplementor));
        }
        return this.implementorFor(expectedType, new String[]{discriminator}, defaultImplementor);
    }

    public Object implementorFor(Class expectedType, Class discriminator, Object defaultImplementor) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator + " DefaultImplementor " + defaultImplementor));
        }
        return this.implementorFor(expectedType, new String[]{discriminator.getName()}, defaultImplementor);
    }

    public Object implementorFor(Class expectedType, String[] discriminators) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators));
        }
        return this.implementorFor(expectedType, discriminators, null);
    }

    public Object implementorFor(Class expectedType, Class[] discriminators) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators));
        }
        return this.implementorFor(expectedType, discriminators, null);
    }

    public Object implementorFor(Class expectedType, String[] discriminators, Object defaultImplementor) {
        Object[] implementors;
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators + " DefaultImplementor " + defaultImplementor));
        }
        if ((implementors = this.cache_.implementorsFor(expectedType, discriminators)) != null) {
            if (implementors.length != 1) {
                logger_.warn((Object)("Multiple implementors defined for (" + expectedType + Arrays.asList(discriminators) + ")"));
            }
            return implementors[0];
        }
        return defaultImplementor;
    }

    public Object implementorFor(Class expectedType, Class[] discriminators, Object defaultImplementor) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators + " DefaultImplementor " + defaultImplementor));
        }
        int length = discriminators.length;
        String[] classnames = new String[length];
        for (int i = 0; i < length; ++i) {
            classnames[i] = discriminators[i].getName();
        }
        Object[] implementors = this.cache_.implementorsFor(expectedType, classnames);
        if (implementors != null) {
            if (implementors.length != 1) {
                logger_.warn((Object)("Multiple implementors defined for (" + expectedType + Arrays.asList(discriminators) + ")"));
            }
            return implementors[0];
        }
        return defaultImplementor;
    }

    public Object[] implementorsFor(Class expectedType) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType));
        }
        return this.implementorsFor(expectedType, new Class[0], null);
    }

    public Object[] implementorsFor(Class expectedType, Object[] defaultImplementors) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " DefaultImplementors " + defaultImplementors));
        }
        return this.implementorsFor(expectedType, new Class[0], defaultImplementors);
    }

    public Object[] implementorsFor(Class expectedType, String discriminator) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator));
        }
        return this.implementorsFor(expectedType, new String[]{discriminator}, null);
    }

    public Object[] implementorsFor(Class expectedType, Class discriminator) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator));
        }
        return this.implementorsFor(expectedType, new String[]{discriminator.getName()}, null);
    }

    public Object[] implementorsFor(Class expectedType, String discriminator, Object[] defaultImplementors) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator + " DefaultImplementors " + defaultImplementors));
        }
        return this.implementorsFor(expectedType, new String[]{discriminator}, defaultImplementors);
    }

    public Object[] implementorsFor(Class expectedType, Class discriminator, Object[] defaultImplementors) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminator " + discriminator + " DefaultImplementors " + defaultImplementors));
        }
        return this.implementorsFor(expectedType, new String[]{discriminator.getName()}, defaultImplementors);
    }

    public Object[] implementorsFor(Class expectedType, String[] discriminators) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators));
        }
        return this.implementorsFor(expectedType, discriminators, null);
    }

    public Object[] implementorsFor(Class expectedType, Class[] discriminators) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators));
        }
        return this.implementorsFor(expectedType, discriminators, null);
    }

    public Object[] implementorsFor(Class expectedType, String[] discriminators, Object[] defaultImplementors) {
        Object[] implementors;
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators + " DefaultImplementors " + defaultImplementors));
        }
        if ((implementors = this.cache_.implementorsFor(expectedType, discriminators)) != null) {
            return implementors;
        }
        return defaultImplementors;
    }

    public Object[] implementorsFor(Class expectedType, Class[] discriminators, Object[] defaultImplementors) {
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("ImplementorRegistry: Class " + expectedType + " Discriminators " + discriminators + " DefaultImplementors " + defaultImplementors));
        }
        int length = discriminators.length;
        String[] classnames = new String[length];
        for (int i = 0; i < length; ++i) {
            classnames[i] = discriminators[i].getName();
        }
        Object[] implementors = this.cache_.implementorsFor(expectedType, classnames);
        if (implementors != null) {
            return implementors;
        }
        return defaultImplementors;
    }

    public void setImplementorFor(Class expectedType, Object implementor) {
        Object[] objectArray;
        if (implementor == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = implementor;
        }
        this.cache_.setImplementorsFor(expectedType, emptyStringArray_, objectArray);
    }

    public void setImplementorsFor(Class expectedType, Object[] implementors) {
        this.cache_.setImplementorsFor(expectedType, emptyStringArray_, implementors);
    }

    public void setImplementorFor(Class expectedType, String discriminator, Object implementor) {
        Object[] objectArray;
        String[] stringArray = new String[]{discriminator};
        if (implementor == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = implementor;
        }
        this.cache_.setImplementorsFor(expectedType, stringArray, objectArray);
    }

    public void setImplementorFor(Class expectedType, Class discriminator, Object implementor) {
        Object[] objectArray;
        String[] stringArray = new String[]{discriminator.getName()};
        if (implementor == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = implementor;
        }
        this.cache_.setImplementorsFor(expectedType, stringArray, objectArray);
    }

    public void setImplementorsFor(Class expectedType, String discriminator, Object[] implementors) {
        this.cache_.setImplementorsFor(expectedType, new String[]{discriminator}, implementors);
    }

    public void setImplementorsFor(Class expectedType, Class discriminator, Object[] implementors) {
        this.cache_.setImplementorsFor(expectedType, new String[]{discriminator.getName()}, implementors);
    }

    public void setImplementorFor(Class expectedType, String[] discriminators, Object implementor) {
        Object[] objectArray;
        if (implementor == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = implementor;
        }
        this.cache_.setImplementorsFor(expectedType, discriminators, objectArray);
    }

    public void setImplementorFor(Class expectedType, Class[] discriminators, Object implementor) {
        Object[] objectArray;
        int length = discriminators.length;
        String[] classnames = new String[length];
        for (int i = 0; i < length; ++i) {
            classnames[i] = discriminators[i].getName();
        }
        if (implementor == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = implementor;
        }
        this.cache_.setImplementorsFor(expectedType, classnames, objectArray);
    }

    public void setImplementorsFor(Class expectedType, String[] discriminators, Object[] implementors) {
        this.cache_.setImplementorsFor(expectedType, discriminators, implementors);
    }

    public void setImplementorsFor(Class expectedType, Class[] discriminators, Object[] implementors) {
        int length = discriminators.length;
        String[] classnames = new String[length];
        for (int i = 0; i < length; ++i) {
            classnames[i] = discriminators[i].getName();
        }
        this.cache_.setImplementorsFor(expectedType, classnames, implementors);
    }

    public static synchronized ImplementorRegistry instance() {
        return registry_;
    }

    public static synchronized void instance(ImplementorRegistry registry) {
        registry_ = registry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CachingImplementorFinder
    implements MutableImplementorFinder {
        private final MutableImplementorFinder cache_;
        private final ImplementorFinder finder_;

        public CachingImplementorFinder(MutableImplementorFinder cache, ImplementorFinder finder) {
            this.cache_ = cache;
            this.finder_ = finder;
        }

        public Object[] implementorsFor(Class expectedType, String[] discriminators) {
            Object[] implementors = this.cache_.implementorsFor(expectedType, discriminators);
            if (implementors == null) {
                implementors = this.finder_.implementorsFor(expectedType, discriminators);
                if (implementors != null) {
                    this.setImplementorsFor(expectedType, discriminators, implementors);
                }
                if (logger_.isInfoEnabled()) {
                    logger_.info((Object)("implementorsFor(" + expectedType + Arrays.asList(discriminators) + "): " + (implementors != null ? Arrays.asList(implementors) : null)));
                }
            }
            return implementors;
        }

        public void setImplementorsFor(Class expectedType, String[] discriminators, Object[] implementors) {
            if (logger_.isInfoEnabled()) {
                logger_.info((Object)("setImplementorsFor(" + expectedType + Arrays.asList(discriminators) + "): " + (implementors != null ? Arrays.asList(implementors) : null)));
            }
            this.cache_.setImplementorsFor(expectedType, discriminators, implementors);
        }
    }

    public static class MemoryImplementorFinder
    implements MutableImplementorFinder {
        private Node root_ = new Node();

        public Object[] implementorsFor(Class expectedType, String[] discriminators) {
            Node current = this.root_.getChild(expectedType);
            if (current == null) {
                return null;
            }
            if (discriminators != null) {
                for (int i = 0; i < discriminators.length; ++i) {
                    if ((current = current.getChild(discriminators[i])) != null) continue;
                    return null;
                }
            }
            return current.getImplementors();
        }

        public void setImplementorsFor(Class expectedType, String[] discriminators, Object[] implementors) {
            Node current = this.root_.getChild(expectedType);
            if (current == null) {
                current = this.root_.addChild(expectedType);
            }
            if (discriminators != null) {
                for (int i = 0; i < discriminators.length; ++i) {
                    Node child = current.getChild(discriminators[i]);
                    if (child == null) {
                        child = current.addChild(discriminators[i]);
                    }
                    current = child;
                }
            }
            current.setImplementors(implementors);
        }

        private static class Node {
            private Object[] implementors_;
            private Map children_;

            private Node() {
            }

            public Node getChild(Object key) {
                if (this.children_ != null) {
                    return (Node)this.children_.get(key);
                }
                return null;
            }

            public Node addChild(Object key) {
                Node child = new Node();
                if (this.children_ == null) {
                    this.children_ = new HashMap();
                }
                this.children_.put(key, child);
                return child;
            }

            public Object[] getImplementors() {
                return this.implementors_;
            }

            public void setImplementors(Object[] implementors) {
                this.implementors_ = implementors;
            }
        }
    }

    protected static class RuleImplementorFinder
    implements ImplementorFinder {
        private Rule[] rules_;

        public RuleImplementorFinder(String[] rules) {
            this.rules_ = new Rule[rules.length];
            for (int i = 0; i < rules.length; ++i) {
                this.rules_[i] = Rule.valueOf(rules[i]);
            }
            Arrays.sort(this.rules_, new RuleComparator());
        }

        public RuleImplementorFinder(Properties rules) {
            this.rules_ = new Rule[rules.size()];
            Iterator<Map.Entry<Object, Object>> i = rules.entrySet().iterator();
            int index = 0;
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String rule = entry.getKey() + "=" + entry.getValue();
                this.rules_[index++] = Rule.valueOf(rule);
            }
            Arrays.sort(this.rules_, new RuleComparator());
        }

        public Object[] implementorsFor(Class expectedType, String[] discriminators) {
            for (int i = 0; i < this.rules_.length; ++i) {
                Rule rule = this.rules_[i];
                Object[] implementors = rule.implementorsFor(expectedType, discriminators);
                if (implementors == null) continue;
                return implementors;
            }
            return null;
        }

        private static class RuleComparator
        implements Comparator {
            private RuleComparator() {
            }

            public int compare(Object o1, Object o2) {
                Rule r1 = (Rule)o1;
                Rule r2 = (Rule)o2;
                if (r1 instanceof StaticRule) {
                    if (r2 instanceof StaticRule) {
                        return r2.rule_.length() - r1.rule_.length();
                    }
                    return -1;
                }
                if (r2 instanceof StaticRule) {
                    return 1;
                }
                return r2.rule_.indexOf(42) - r1.rule_.indexOf(42);
            }
        }

        public static class WildcardRule
        extends Rule {
            private final String expectedType_;
            private final String[] discriminators_;
            private final String[] implementors_;

            public WildcardRule(String rule, String expectedType, String[] discriminators, String[] implementors) {
                super(rule);
                this.expectedType_ = expectedType;
                this.discriminators_ = discriminators;
                this.implementors_ = implementors;
            }

            public Object[] implementorsFor(Class expectedType, String[] discriminators) {
                int length;
                String wildcard = null;
                int index = -1;
                String expectedTypeName = expectedType.getName();
                index = this.expectedType_.indexOf(42);
                if (index == -1) {
                    if (!this.expectedType_.equals(expectedTypeName)) {
                        return null;
                    }
                } else {
                    String prefix = this.expectedType_.substring(0, index);
                    String suffix = this.expectedType_.substring(index + 1);
                    if (!expectedTypeName.startsWith(prefix) || !expectedTypeName.endsWith(suffix)) {
                        return null;
                    }
                    wildcard = expectedTypeName.substring(prefix.length(), expectedTypeName.length() - suffix.length());
                }
                if ((length = this.discriminators_.length) != discriminators.length) {
                    return null;
                }
                for (int i = 0; i < length; ++i) {
                    String d0 = this.discriminators_[i];
                    String d1 = discriminators[i];
                    index = d0.indexOf(42);
                    if (index == -1) {
                        if (Is.equal(d0, d1)) continue;
                        return null;
                    }
                    String prefix = d0.substring(0, index);
                    String suffix = d0.substring(index + 1);
                    if (wildcard == null) {
                        if (!d1.startsWith(prefix) || !d1.endsWith(suffix)) {
                            return null;
                        }
                        wildcard = d1.substring(prefix.length(), d1.length() - suffix.length());
                        continue;
                    }
                    String r = prefix + wildcard + suffix;
                    if (Is.equal(r, d1)) continue;
                    return null;
                }
                int numImplementors = this.implementors_.length;
                String[] implementors = new String[numImplementors];
                for (int i = 0; i < numImplementors; ++i) {
                    String classname;
                    String implementor = this.implementors_[i];
                    index = implementor.indexOf(42);
                    implementors[i] = index == -1 ? implementor : implementor.substring(0, index) + wildcard + implementor.substring(index + 1);
                    if ((class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule == null ? ImplementorRegistry.class$("gov.va.med.term.access.util.ImplementorRegistry$RuleImplementorFinder$Rule") : class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule).getResource(classname = "/" + implementors[i].replace('.', '/') + ".class") != null) continue;
                    return null;
                }
                return this.createInstances(expectedType, implementors);
            }

            private static class WildcardRuleParser
            implements Rule.Parser {
                private WildcardRuleParser() {
                }

                public boolean canParse(String rule) {
                    return rule.indexOf(42) != -1;
                }

                private static boolean checkClassname(String classname) {
                    int firstIndex = classname.indexOf(42);
                    if (firstIndex == -1) {
                        classname = "/" + classname.replace('.', '/') + ".class";
                        return (class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule == null ? (class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule = ImplementorRegistry.class$("gov.va.med.term.access.util.ImplementorRegistry$RuleImplementorFinder$Rule")) : class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule).getResource(classname) != null;
                    }
                    return firstIndex == classname.lastIndexOf(42);
                }

                public Rule parse(String rule) {
                    int indexOfEquals;
                    if (logger_.isInfoEnabled()) {
                        logger_.info((Object)("Parsing rule: " + rule));
                    }
                    if ((indexOfEquals = rule.indexOf(61)) == -1) {
                        throw new RuntimeException("Invalid wildcard rule: " + rule);
                    }
                    String lhs = rule.substring(0, indexOfEquals);
                    String rhs = rule.substring(indexOfEquals + 1);
                    StringTokenizer lhsTokenizer = new StringTokenizer(lhs, ",[]", true);
                    if (!lhsTokenizer.hasMoreTokens()) {
                        throw new RuntimeException("Invalid wildcard rule: " + rule);
                    }
                    String expectedType = lhsTokenizer.nextToken();
                    if (!WildcardRuleParser.checkClassname(expectedType)) {
                        throw new RuntimeException("Invalid wildcard rule: Invalid class specifier '" + expectedType + "': " + rule);
                    }
                    boolean foundWildcard = expectedType.indexOf(42) != -1;
                    Vector<String> discriminators = new Vector<String>();
                    if (lhsTokenizer.hasMoreTokens()) {
                        String token = lhsTokenizer.nextToken();
                        if (!"[".equals(token)) {
                            throw new RuntimeException("Invalid wildcard rule: Expected '[' but found '" + token + "': " + rule);
                        }
                        do {
                            if (!lhsTokenizer.hasMoreTokens()) {
                                throw new RuntimeException("Invalid wildcard rule: Expected class name: " + rule);
                            }
                            token = lhsTokenizer.nextToken();
                            if (!foundWildcard) {
                                foundWildcard = token.indexOf(42) != -1;
                            }
                            discriminators.add(token);
                            if (lhsTokenizer.hasMoreTokens()) continue;
                            throw new RuntimeException("Invalid wildcard rule: Expected ']' or ',': " + rule);
                        } while (",".equals(token = lhsTokenizer.nextToken()));
                        if (!"]".equals(token)) {
                            throw new RuntimeException("Invalid wildcard rule: Expected ']' but found '" + token + "': " + rule);
                        }
                    }
                    if (!foundWildcard) {
                        throw new RuntimeException("Invalid wildcard rule: No wildcard in the left hand side: " + rule);
                    }
                    StringTokenizer rhsTokenizer = new StringTokenizer(rhs, ",", false);
                    if (!rhsTokenizer.hasMoreTokens()) {
                        throw new RuntimeException("Invalid wildcard rule: No implementors specified: " + rule);
                    }
                    Vector<String> implementors = new Vector<String>();
                    while (rhsTokenizer.hasMoreTokens()) {
                        String implementor = rhsTokenizer.nextToken();
                        if (!WildcardRuleParser.checkClassname(implementor)) {
                            throw new RuntimeException("Invalid wildcard rule: Class not found '" + implementor + "': " + rule);
                        }
                        implementors.add(implementor);
                    }
                    return new WildcardRule(rule, expectedType, discriminators.toArray(new String[0]), implementors.toArray(new String[0]));
                }
            }
        }

        public static class StaticRule
        extends Rule {
            private final String expectedType_;
            private final String[] discriminators_;
            private final String[] implementors_;

            public StaticRule(String rule, String expectedType, String[] discriminators, String[] implementors) {
                super(rule);
                this.expectedType_ = expectedType;
                this.discriminators_ = discriminators;
                this.implementors_ = implementors;
            }

            public Object[] implementorsFor(Class expectedType, String[] discriminators) {
                if (!this.expectedType_.equals(expectedType.getName())) {
                    return null;
                }
                int length = this.discriminators_.length;
                if (length != discriminators.length) {
                    return null;
                }
                for (int i = 0; i < length; ++i) {
                    String d0 = this.discriminators_[i];
                    String d1 = discriminators[i];
                    if (Is.equal(d0, d1)) continue;
                    return null;
                }
                return this.createInstances(expectedType, this.implementors_);
            }

            private static class StaticRuleParser
            implements Rule.Parser {
                private StaticRuleParser() {
                }

                public boolean canParse(String rule) {
                    return rule.indexOf(42) == -1;
                }

                private static boolean checkClassname(String classname) {
                    classname = "/" + classname.replace('.', '/') + ".class";
                    return (class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule == null ? (class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule = ImplementorRegistry.class$("gov.va.med.term.access.util.ImplementorRegistry$RuleImplementorFinder$Rule")) : class$gov$va$med$term$access$util$ImplementorRegistry$RuleImplementorFinder$Rule).getResource(classname) != null;
                }

                public Rule parse(String rule) {
                    StringTokenizer rhsTokenizer;
                    int indexOfEquals;
                    if (logger_.isInfoEnabled()) {
                        logger_.info((Object)("Parsing rule: " + rule));
                    }
                    if ((indexOfEquals = rule.indexOf(61)) == -1) {
                        throw new RuntimeException("Invalid static rule: " + rule);
                    }
                    String lhs = rule.substring(0, indexOfEquals);
                    String rhs = rule.substring(indexOfEquals + 1);
                    StringTokenizer lhsTokenizer = new StringTokenizer(lhs, ",[]", true);
                    if (!lhsTokenizer.hasMoreTokens()) {
                        throw new RuntimeException("Invalid static rule: " + rule);
                    }
                    String expectedType = lhsTokenizer.nextToken();
                    if (!StaticRuleParser.checkClassname(expectedType)) {
                        throw new RuntimeException("Invalid static rule: Class not found '" + expectedType + "': " + rule);
                    }
                    Vector<String> discriminators = new Vector<String>();
                    if (lhsTokenizer.hasMoreTokens()) {
                        String token = lhsTokenizer.nextToken();
                        if (!"[".equals(token)) {
                            throw new RuntimeException("Invalid static rule: Expected '[' but found '" + token + "': " + rule);
                        }
                        do {
                            if (!lhsTokenizer.hasMoreTokens()) {
                                throw new RuntimeException("Invalid static rule: Expected class name: " + rule);
                            }
                            token = lhsTokenizer.nextToken();
                            discriminators.add(token);
                            if (lhsTokenizer.hasMoreTokens()) continue;
                            throw new RuntimeException("Invalid static rule: Expected ']' or ',': " + rule);
                        } while (",".equals(token = lhsTokenizer.nextToken()));
                        if (!"]".equals(token)) {
                            throw new RuntimeException("Invalid static rule: Expected ']' but found '" + token + "': " + rule);
                        }
                    }
                    if (!(rhsTokenizer = new StringTokenizer(rhs, ",", false)).hasMoreTokens()) {
                        throw new RuntimeException("Invalid static rule: No implementors specified: " + rule);
                    }
                    Vector<String> implementors = new Vector<String>();
                    while (rhsTokenizer.hasMoreTokens()) {
                        String implementor = rhsTokenizer.nextToken();
                        if (!StaticRuleParser.checkClassname(implementor)) {
                            throw new RuntimeException("Invalid static rule: Class not found '" + implementor + "': " + rule);
                        }
                        implementors.add(implementor);
                    }
                    return new StaticRule(rule, expectedType, discriminators.toArray(new String[0]), implementors.toArray(new String[0]));
                }
            }
        }

        public static abstract class Rule
        implements ImplementorFinder {
            private final String rule_;
            private static final Parser[] parsers_ = new Parser[]{new StaticRule.StaticRuleParser(), new WildcardRule.WildcardRuleParser()};

            public Rule(String rule) {
                this.rule_ = rule;
            }

            public String getRule() {
                return this.rule_;
            }

            public static Rule valueOf(String rule) {
                int i;
                int length = rule.length();
                StringBuffer buffer = new StringBuffer(length);
                for (i = 0; i < length; ++i) {
                    char c = rule.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    buffer.append(c);
                }
                rule = buffer.toString();
                for (i = 0; i < parsers_.length; ++i) {
                    Parser parser = parsers_[i];
                    if (!parser.canParse(rule)) continue;
                    return parser.parse(rule);
                }
                throw new IllegalArgumentException("Unsupported rule format: " + rule);
            }

            public Object[] createInstances(Class expectedType, String[] classnames) {
                int length = classnames.length;
                Object[] instances = (Object[])Array.newInstance(expectedType, length);
                for (int i = 0; i < length; ++i) {
                    String classname = classnames[i];
                    try {
                        Class<?> clazz = Class.forName(classname);
                        if (!expectedType.isAssignableFrom(clazz)) {
                            throw new IllegalArgumentException("Cannot assign " + classname + " to " + expectedType.getName() + ": " + this.getRule());
                        }
                        instances[i] = clazz.newInstance();
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Class not found '" + classname + "': " + this.getRule(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Default constructor inaccessible '" + classname + "': " + this.getRule(), e);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("Instantiation error '" + classname + "': " + this.getRule(), e);
                    }
                }
                return instances;
            }

            private static interface Parser {
                public boolean canParse(String var1);

                public Rule parse(String var1);
            }
        }
    }

    private static interface MutableImplementorFinder
    extends ImplementorFinder {
        public void setImplementorsFor(Class var1, String[] var2, Object[] var3);
    }

    private static interface ImplementorFinder {
        public Object[] implementorsFor(Class var1, String[] var2);
    }
}

