/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public class ArrayUtils {
    public static Object[] append(Object[] array, Object object) {
        Object[] result = ArrayUtils.newArray(array, 1 + array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = object;
        return result;
    }

    public static Comparable[] insert(Comparable[] array, Comparable object) {
        int i = Arrays.binarySearch(array, object);
        int insert = i <= 0 ? -i - 1 : i;
        Comparable[] result = (Comparable[])ArrayUtils.newArray(array, 1 + array.length);
        System.arraycopy(array, 0, result, 0, insert);
        result[insert] = object;
        System.arraycopy(array, insert, result, insert + 1, array.length - insert);
        return result;
    }

    public static Object[] remove(Object[] array, int offset) {
        Object[] result = ArrayUtils.newArray(array, array.length - 1);
        System.arraycopy(array, 0, result, 0, offset);
        System.arraycopy(array, offset + 1, result, offset, result.length - offset);
        return result;
    }

    public static Comparable[] remove(Comparable[] array, Object object) {
        int i = Arrays.binarySearch(array, object);
        if (i >= 0) {
            return (Comparable[])ArrayUtils.remove((Object[])array, i);
        }
        return array;
    }

    public static Object[] remove(Object[] array, Object object) {
        int i = -1;
        while (++i < array.length) {
            if (!array[i].equals(object)) continue;
            return ArrayUtils.remove(array, i);
        }
        return array;
    }

    public static Object[] remove(Object[] array, Object[] unwanted) {
        if (unwanted.length == 0) {
            return array;
        }
        Object[] sparse = (Object[])array.clone();
        int iUnwanted = unwanted.length;
        block0: while (--iUnwanted >= 0) {
            Object o = unwanted[iUnwanted];
            int iArray = -1;
            while (++iArray < array.length) {
                if (!o.equals(array[iArray])) continue;
                sparse[iArray] = null;
                continue block0;
            }
        }
        return ArrayUtils.unsparse(sparse);
    }

    public static Comparable[] remove(Comparable[] set, Comparable[] unwanted) {
        if (unwanted.length == 0) {
            return set;
        }
        Object[] sparse = (Comparable[])set.clone();
        int iUnwanted = unwanted.length;
        while (--iUnwanted >= 0) {
            int iSet = Arrays.binarySearch(set, unwanted[iUnwanted]);
            if (iSet < 0) continue;
            sparse[iSet] = null;
        }
        return (Comparable[])ArrayUtils.unsparse(sparse);
    }

    public static Object[] subtract(Object[] set, Object[] unwanted, Comparator comparator) {
        if (unwanted.length == 0) {
            return set;
        }
        Object[] sparse = (Object[])set.clone();
        int iUnwanted = unwanted.length;
        while (--iUnwanted >= 0) {
            int iSet = Arrays.binarySearch(set, unwanted[iUnwanted], comparator);
            if (iSet < 0) continue;
            sparse[iSet] = null;
        }
        return ArrayUtils.unsparse(sparse);
    }

    public static Comparable[] subtract(Comparable[] set, Comparable[] subset) {
        if (subset.length == 0) {
            return set;
        }
        Comparable[] result = (Comparable[])ArrayUtils.newArray(set, set.length - subset.length);
        int iSubset = subset.length;
        int prev_iSet = set.length;
        int iResult = result.length;
        int length = result.length;
        while (--iSubset >= 0) {
            int iSet = Arrays.binarySearch(set, subset[iSubset]);
            length = prev_iSet - iSet - 1;
            System.arraycopy(set, iSet + 1, result, iResult -= length, length);
            prev_iSet = iSet;
        }
        return result;
    }

    public static Object[] unsparse(Object[] array) {
        Object[] work = (Object[])array.clone();
        int i = -1;
        int lim = work.length;
        while (++i < lim) {
            if (work[i] != null) continue;
            System.arraycopy(work, i + 1, work, i, lim - (i + 1));
            --i;
            --lim;
        }
        if (lim == work.length) {
            return array;
        }
        Object[] result = ArrayUtils.newArray(work, lim);
        System.arraycopy(work, 0, result, 0, lim);
        return result;
    }

    private static Object[] newArray(Object[] template, int length) {
        return (Object[])Array.newInstance(template.getClass().getComponentType(), length);
    }
}

