/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.types;

import gov.va.med.term.access.util.Is;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ImpreciseDate
implements Cloneable,
Serializable {
    private final String date_;

    public ImpreciseDate(String date) {
        if (!ImpreciseDate.isValid(date)) {
            throw new IllegalArgumentException("Date format must be YYYY[MM[DD]]: " + date);
        }
        this.date_ = date;
    }

    public String getDate() {
        return this.date_;
    }

    public int getYear() {
        return Integer.parseInt(this.date_.substring(0, 4));
    }

    public int getMonth() {
        return this.date_.length() > 4 ? Integer.parseInt(this.date_.substring(4, 6)) : 0;
    }

    public int getDay() {
        return this.date_.length() > 6 ? Integer.parseInt(this.date_.substring(6, 8)) : 0;
    }

    public static boolean isValid(String date) {
        boolean okay = false;
        try {
            if (date != null) {
                if (date.length() == 4) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy");
                    format.setLenient(false);
                    if (format.parse(date) != null) {
                        okay = true;
                    }
                } else if (date.length() == 6) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                    format.setLenient(false);
                    if (format.parse(date) != null) {
                        okay = true;
                    }
                } else if (date.length() == 8) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    format.setLenient(false);
                    if (format.parse(date) != null) {
                        okay = true;
                    }
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return okay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImpreciseDate other = (ImpreciseDate)o;
        return Is.equal(this.getDate(), other.getDate());
    }

    public int hashCode() {
        return this.date_.hashCode();
    }

    public Object clone() {
        try {
            ImpreciseDate result = (ImpreciseDate)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.date_;
    }

    public static ImpreciseDate valueOf(String date) {
        return new ImpreciseDate(date);
    }
}

