/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.types;

import gov.va.med.term.access.util.ThreadLocale;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Day
extends Date {
    private static final ThreadLocal format_ = new ThreadLocal();
    private static final ThreadLocal locale_ = new ThreadLocal();

    public static Day today() {
        return new Day();
    }

    public Day() {
        super(Day.truncate(System.currentTimeMillis()));
    }

    public Day(long value) {
        super(Day.truncate(value));
    }

    public Day(Date value) {
        super(Day.truncate(value));
    }

    private Day(long value, boolean skipTruncate) {
        super(skipTruncate ? value : Day.truncate(value));
    }

    private static long truncate(Date value) {
        try {
            return Day.valueOf(Day.format().format(value)).getTime();
        }
        catch (ParseException x) {
            throw new RuntimeException("Unexpected Exception", x);
        }
    }

    private static long truncate(long value) {
        return Day.truncate(new Date(value));
    }

    private static DateFormat format() {
        DateFormat result;
        Locale locale = ThreadLocale.get();
        if (locale != locale_.get()) {
            locale_.set(locale);
            result = DateFormat.getDateInstance(3, ThreadLocale.get());
            result.setLenient(false);
            format_.set(result);
        } else {
            result = (DateFormat)format_.get();
        }
        return result;
    }

    public String toString() {
        return Day.format().format(this);
    }

    public static Day valueOf(String value) throws ParseException {
        ParsePosition position = new ParsePosition(0);
        Date result = Day.format().parse(value, position);
        if (position.getIndex() != value.length()) {
            throw new ParseException(((SimpleDateFormat)Day.format()).toLocalizedPattern(), position.getIndex());
        }
        return new Day(result.getTime(), true);
    }
}

