/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.criteria;

import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.types.Referenceable;
import gov.va.med.term.access.util.Settings;
import java.util.Enumeration;
import java.util.Hashtable;

public class SQLQueryGenerator
implements Criteria.Visitor,
Criteria.Equal.Visitor,
Criteria.EqualIgnoreCase.Visitor,
Criteria.NotEqual.Visitor,
Criteria.LessThan.Visitor,
Criteria.GreaterThan.Visitor,
Criteria.LessThanOrEqual.Visitor,
Criteria.GreaterThanOrEqual.Visitor,
Criteria.And.Visitor,
Criteria.Or.Visitor,
Criteria.Not.Visitor,
Criteria.Any.Visitor,
Criteria.None.Visitor,
Criteria.Soundex.Visitor,
Criteria.StartsWith.Visitor,
Criteria.EndsWith.Visitor,
Criteria.Like.Visitor,
Criteria.OneOf.Visitor,
Criteria.Null.Visitor,
Criteria.ValidTime.Visitor {
    private Hashtable nameMap_ = new Hashtable();
    private Hashtable formatterMap_ = new Hashtable();
    private SQLQueryGenerator validTimeGenerator_ = null;
    private String driver = Settings.instance().propertiesFor("gov.va.med.term.access.maint.factory.db.hibernate.TransactionFactory").getProperty("hibernate.connection.driver_class");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void setNameMapping(String criteriaName, String columnName) {
        this.nameMap_.put(criteriaName, columnName);
    }

    public void setFormatter(Class valueClass, Formatter formatter) {
        this.formatterMap_.put(valueClass, formatter);
    }

    public void setFormatter(String criteriaName, Formatter formatter) {
        this.formatterMap_.put(criteriaName, formatter);
    }

    public void setValidTimeGenerator(SQLQueryGenerator generator) {
        this.validTimeGenerator_ = generator;
    }

    public String generate(Criteria criteria) {
        return this.generate(criteria, null);
    }

    public String generate(Criteria criteria, String alias) {
        Result result = new Result(alias);
        criteria.apply(this, result);
        return result.buffer.toString();
    }

    public String columnNameFor(String criteriaName, String alias) {
        String columnName;
        StringBuffer qualifiedColumnName = new StringBuffer();
        if (alias != null) {
            qualifiedColumnName.append(alias);
            qualifiedColumnName.append('.');
        }
        qualifiedColumnName.append((columnName = (String)this.nameMap_.get(criteriaName)) == null ? criteriaName : columnName);
        return qualifiedColumnName.toString();
    }

    private static String replace_(String source, String from, String to) {
        int pos = 0;
        int prevpos = 0;
        int limit = source.length();
        StringBuffer result = new StringBuffer(limit);
        while ((pos = source.indexOf(from, pos)) >= 0) {
            if (pos > 0) {
                result.append(source.substring(prevpos, pos));
            }
            result.append(to);
            prevpos = pos += from.length();
        }
        if (prevpos >= 0 && prevpos < source.length()) {
            result.append(source.substring(prevpos));
        }
        return result.toString();
    }

    private static String format_(String value) {
        StringBuffer s = new StringBuffer("'");
        s.append(SQLQueryGenerator.escape_(value.toString()));
        s.append("'");
        return s.toString();
    }

    private static String escape_(String value) {
        String result = value;
        if (result.indexOf(39) > -1) {
            result = SQLQueryGenerator.replace_(value, "'", "''");
        }
        return result;
    }

    private static String toSqlLike(String value) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '\\') {
                c = value.charAt(++i);
                if (i == value.length() || c != '?' && c != '*' && c != '\\') {
                    throw new RuntimeException("Escape character must be followed by ?, *, or another escape character");
                }
                buffer.append('\\');
                buffer.append(c);
            } else if (c == '?') {
                buffer.append('_');
            } else if (c == '*') {
                buffer.append('%');
            } else if (c == '_') {
                buffer.append("\\_");
            } else if (c == '%') {
                buffer.append("\\%");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String renderValue(String name, Object value) {
        if (value == null) {
            return "NULL";
        }
        String result = null;
        Class<?> c = value.getClass();
        Formatter formatter = (Formatter)this.formatterMap_.get(value.getClass());
        if (formatter != null) {
            result = formatter.format(value);
        } else {
            formatter = (Formatter)this.formatterMap_.get(name);
            if (formatter != null) {
                result = formatter.format(value);
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == c) {
                    result = SQLQueryGenerator.format_(value.toString());
                } else {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2 == c) {
                        result = value.equals(Boolean.TRUE) ? "'1'" : "'0'";
                    } else {
                        Class<?> clazz3 = class$2;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$2 = Class.forName("java.sql.Date");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3.isAssignableFrom(c)) {
                            result = "to_date('" + value.toString() + "','YYYY-MM-DD')";
                        } else {
                            Class<?> clazz4 = class$3;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = class$3 = Class.forName("java.sql.Time");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz4.isAssignableFrom(c)) {
                                result = "TIME '" + value.toString() + "'";
                            } else {
                                Class<?> clazz5 = class$4;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = class$4 = Class.forName("java.sql.Timestamp");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz5.isAssignableFrom(c)) {
                                    result = this.driver != null && this.driver.substring(1).toUpperCase().indexOf("oracle".toUpperCase()) > 0 ? "TO_TIMESTAMP('" + value.toString() + "','YYYY-MM-DD HH24:MI:SS.FF')" : "'" + value.toString() + "'";
                                } else {
                                    Class<?> clazz6 = class$5;
                                    if (clazz6 == null) {
                                        try {
                                            clazz6 = class$5 = Class.forName("gov.va.med.term.access.types.Referenceable");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    result = clazz6.isAssignableFrom(c) ? ((Referenceable)value).getKeyString() : value.toString();
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private void addLogicalCriteria(Criteria.Logical criteria, String operator, Object extra) {
        Result result = (Result)extra;
        result.buffer.append('(');
        boolean firstTime = true;
        Enumeration e = criteria.elements();
        while (e.hasMoreElements()) {
            if (!firstTime) {
                result.buffer.append(' ');
                result.buffer.append(operator);
                result.buffer.append(' ');
            } else {
                firstTime = false;
            }
            ((Criteria)e.nextElement()).apply(this, extra);
        }
        result.buffer.append(')');
    }

    public final Object visit(Criteria.And criteria, Object extra) {
        this.addLogicalCriteria(criteria, "AND", extra);
        return null;
    }

    public final Object visit(Criteria.Or criteria, Object extra) {
        this.addLogicalCriteria(criteria, "OR", extra);
        return null;
    }

    public final Object visit(Criteria.Not criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append(" NOT ");
        criteria.element().apply(this, extra);
        return null;
    }

    public final Object visit(Criteria.Any criteria, Object extra) {
        return null;
    }

    public final Object visit(Criteria.None criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append("0 = 1");
        return null;
    }

    protected void addComparisonCriteria(Criteria.Comparison criteria, String operator, Object extra) {
        Result result = (Result)extra;
        result.buffer.append(this.columnNameFor(criteria.name(), result.alias));
        result.buffer.append(operator);
        result.buffer.append(this.renderValue(criteria.name(), criteria.value()));
    }

    public final Object visit(Criteria.Equal criteria, Object extra) {
        this.addComparisonCriteria(criteria, " = ", extra);
        return null;
    }

    public final Object visit(Criteria.NotEqual criteria, Object extra) {
        this.addComparisonCriteria(criteria, " <> ", extra);
        return null;
    }

    public final Object visit(Criteria.LessThan criteria, Object extra) {
        this.addComparisonCriteria(criteria, " < ", extra);
        return null;
    }

    public final Object visit(Criteria.GreaterThan criteria, Object extra) {
        this.addComparisonCriteria(criteria, " > ", extra);
        return null;
    }

    public final Object visit(Criteria.LessThanOrEqual criteria, Object extra) {
        this.addComparisonCriteria(criteria, " <= ", extra);
        return null;
    }

    public final Object visit(Criteria.GreaterThanOrEqual criteria, Object extra) {
        this.addComparisonCriteria(criteria, " >= ", extra);
        return null;
    }

    public final Object visit(Criteria.Soundex criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append("soundex(" + this.columnNameFor(criteria.name(), result.alias) + ")");
        result.buffer.append('=');
        result.buffer.append("soundex(" + this.renderValue(criteria.name(), criteria.value()) + ")");
        return null;
    }

    public final Object visit(Criteria.StartsWith criteria, Object extra) {
        return this.visit(new Criteria.Like(criteria.name(), String.valueOf((String)criteria.value()) + "*"), extra);
    }

    public final Object visit(Criteria.EndsWith criteria, Object extra) {
        return this.visit(new Criteria.Like(criteria.name(), "*" + (String)criteria.value()), extra);
    }

    public final Object visit(Criteria.Like criteria, Object extra) {
        Result result = (Result)extra;
        if (criteria.ignoreCase()) {
            result.buffer.append("UPPER(");
            result.buffer.append(this.columnNameFor(criteria.name(), result.alias));
            result.buffer.append(")");
            result.buffer.append(" LIKE ");
            result.buffer.append(SQLQueryGenerator.toSqlLike(this.renderValue(criteria.name(), criteria.value()).toUpperCase()));
            result.buffer.append(" ESCAPE '\\'");
        } else {
            result.buffer.append(this.columnNameFor(criteria.name(), result.alias));
            result.buffer.append(" LIKE ");
            result.buffer.append(SQLQueryGenerator.toSqlLike(this.renderValue(criteria.name(), criteria.value())));
            result.buffer.append(" ESCAPE '\\'");
        }
        return null;
    }

    public final Object visit(Criteria.OneOf criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append(this.columnNameFor(criteria.name(), result.alias));
        result.buffer.append(" IN (");
        String comma = "";
        Enumeration e = criteria.values();
        while (e.hasMoreElements()) {
            result.buffer.append(comma);
            result.buffer.append(this.renderValue(criteria.name(), e.nextElement()));
            comma = ",";
        }
        result.buffer.append(")");
        return null;
    }

    public final Object visit(Criteria.Null criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append(this.columnNameFor(criteria.name(), result.alias));
        result.buffer.append(" is NULL");
        return null;
    }

    public final Object visit(Criteria.EqualIgnoreCase criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append("UPPER(");
        result.buffer.append(this.columnNameFor(criteria.name(), result.alias));
        result.buffer.append(")");
        result.buffer.append(" = ");
        result.buffer.append(this.renderValue(criteria.name(), criteria.value()).toUpperCase());
        return null;
    }

    public final Object visit(Criteria.ValidTime criteria, Object extra) {
        Result result = (Result)extra;
        result.buffer.append(this.columnNameFor("id", result.alias));
        result.buffer.append(" IN (select ");
        result.buffer.append(this.validTimeGenerator_.columnNameFor("owner", "h"));
        result.buffer.append(" from ");
        result.buffer.append(this.columnNameFor("_history", null));
        result.buffer.append(" h where ");
        Result condition = new Result("h");
        criteria.condition().apply(this.validTimeGenerator_, condition);
        result.buffer.append(condition.buffer.toString());
        result.buffer.append(')');
        return null;
    }

    public static interface Formatter {
        public String format(Object var1);
    }

    private static class Result {
        public final StringBuffer buffer = new StringBuffer();
        public final String alias;

        public Result(String aliasSansSeparator) {
            this.alias = aliasSansSeparator;
        }
    }
}

