/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.criteria;

import java.sql.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Criteria {
    private static final String DEFAULT_NAME = "value";
    public static Any ANY = new Any();
    public static None NONE = new None();

    protected Criteria() {
    }

    public abstract Object apply(Visitor var1, Object var2);

    public static class ValidTime
    extends Criteria {
        private And condition_ = new And();

        public ValidTime() {
            this(new Date(System.currentTimeMillis()));
        }

        public ValidTime(Date when) {
            if (when != null) {
                this.condition_.add(new LessThanOrEqual("effectiveDate", when));
                this.condition_.add(new GreaterThan("expirationDate", when));
            }
        }

        public ValidTime(Criteria[] criteria) {
            this(new Date(System.currentTimeMillis()), criteria);
        }

        public ValidTime(Date when, Criteria[] criteria) {
            this(when);
            this.condition_.add(criteria);
        }

        public ValidTime(Vector criteria) {
            this(new Date(System.currentTimeMillis()), criteria);
        }

        public ValidTime(Date when, Vector criteria) {
            this(when);
            this.condition_.add(criteria);
        }

        public ValidTime(Criteria one) {
            this(new Date(System.currentTimeMillis()), one);
        }

        public ValidTime(Date when, Criteria one) {
            this(when);
            this.condition_.add(one);
        }

        public ValidTime(Criteria one, Criteria two) {
            this(new Date(System.currentTimeMillis()), one, two);
        }

        public ValidTime(Date when, Criteria one, Criteria two) {
            this(when);
            this.condition_.add(one);
            this.condition_.add(two);
        }

        public ValidTime(Criteria one, Criteria two, Criteria three) {
            this(new Date(System.currentTimeMillis()), one, two, three);
        }

        public ValidTime(Date when, Criteria one, Criteria two, Criteria three) {
            this(when);
            this.condition_.add(one);
            this.condition_.add(two);
            this.condition_.add(three);
        }

        public ValidTime(Criteria one, Criteria two, Criteria three, Criteria four) {
            this(new Date(System.currentTimeMillis()), one, two, three, four);
        }

        public ValidTime(Date when, Criteria one, Criteria two, Criteria three, Criteria four) {
            this(when);
            this.condition_.add(one);
            this.condition_.add(two);
            this.condition_.add(three);
            this.condition_.add(four);
        }

        public void add(Criteria criteria) {
            this.condition_.add(criteria);
        }

        public void add(Criteria[] criteria) {
            this.condition_.add(criteria);
        }

        public void add(Vector criteria) {
            this.condition_.add(criteria);
        }

        public And condition() {
            return this.condition_;
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("ValidTime(");
            buf.append(this.condition_.toString());
            buf.append(')');
            return buf.toString();
        }

        public static interface Visitor {
            public Object visit(ValidTime var1, Object var2);
        }
    }

    public static class Soundex
    extends SoundsLike {
        private String soundexCode_;

        public Soundex(String pattern) {
            super(pattern);
            this.soundexCode_ = Soundex.soundexCodeFor(pattern);
        }

        public Soundex(String name, String pattern) {
            super(name, pattern);
            this.soundexCode_ = Soundex.soundexCodeFor(pattern);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public static String soundexCodeFor(String name) {
            if (name == null) {
                return null;
            }
            char[] result = new char[]{'0', '0', '0', '0'};
            char[] charname = name.toUpperCase().toCharArray();
            int lim = charname.length;
            int c = 48;
            int prevc = 126;
            int iResult = 0;
            int i = -1;
            while (++i < lim) {
                switch (charname[i]) {
                    case 'A': 
                    case 'E': 
                    case 'H': 
                    case 'I': 
                    case 'O': 
                    case 'U': 
                    case 'W': 
                    case 'Y': {
                        break;
                    }
                    case 'B': 
                    case 'F': 
                    case 'P': 
                    case 'V': {
                        c = 49;
                        break;
                    }
                    case 'C': 
                    case 'G': 
                    case 'J': 
                    case 'K': 
                    case 'Q': 
                    case 'S': 
                    case 'X': 
                    case 'Z': {
                        c = 50;
                        break;
                    }
                    case 'D': 
                    case 'T': {
                        c = 51;
                        break;
                    }
                    case 'L': {
                        c = 52;
                        break;
                    }
                    case 'M': 
                    case 'N': {
                        c = 53;
                        break;
                    }
                    case 'R': {
                        c = 54;
                        break;
                    }
                }
                if (c == prevc) continue;
                result[iResult] = c;
                if (++iResult >= result.length) break;
                prevc = c;
            }
            result[0] = charname[0];
            return new String(result);
        }

        public String soundexCode() {
            return this.soundexCode_;
        }

        public boolean match(String value) {
            return this.soundexCode_ == null ? value == null : this.soundexCode_.equals(Soundex.soundexCodeFor(value));
        }

        public String toString() {
            return "soundex(" + this.name() + ")==soundex(" + String.valueOf(this.value()) + ")";
        }

        public static interface Visitor {
            public Object visit(Soundex var1, Object var2);
        }
    }

    public static abstract class SoundsLike
    extends Comparison {
        public SoundsLike(String pattern) {
            super(pattern);
        }

        public SoundsLike(String name, String pattern) {
            super(name, pattern);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public static interface Visitor {
            public Object visit(SoundsLike var1, Object var2);
        }
    }

    public static class NotEqual
    extends Comparison {
        public NotEqual(Object value) {
            super(value);
        }

        public NotEqual(String name, Object value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + "!=" + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(NotEqual var1, Object var2);
        }
    }

    public static class Like
    extends Comparison {
        private char[] charPattern_;
        private boolean ignoreCase_;

        public Like(String pattern) {
            super(pattern);
            this.charPattern_ = pattern.toCharArray();
            this.ignoreCase_ = false;
        }

        public Like(String pattern, boolean ignoreCase) {
            super(pattern);
            this.charPattern_ = pattern.toCharArray();
            this.ignoreCase_ = ignoreCase;
        }

        public Like(String name, String pattern) {
            super(name, pattern);
            this.charPattern_ = pattern.toCharArray();
            this.ignoreCase_ = false;
        }

        public Like(String name, String pattern, boolean ignoreCase) {
            super(name, pattern);
            this.charPattern_ = pattern.toCharArray();
            this.ignoreCase_ = ignoreCase;
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public boolean ignoreCase() {
            return this.ignoreCase_;
        }

        public boolean match(String value) {
            return Like.match_(value.toCharArray(), 0, this.charPattern_, 0, this.ignoreCase_);
        }

        public static boolean match(String value, String pattern) {
            return Like.match_(value.toCharArray(), 0, pattern.toCharArray(), 0, false);
        }

        public static boolean match(String value, String pattern, boolean ignoreCase) {
            return Like.match_(value.toCharArray(), 0, pattern.toCharArray(), 0, ignoreCase);
        }

        private static boolean match_(char[] string, int iString, char[] pattern, int iPattern, boolean ignoreCase) {
            while (iString < string.length && iPattern < pattern.length) {
                char cPattern = pattern[iPattern];
                switch (cPattern) {
                    case '*': {
                        if (iPattern == pattern.length - 1) {
                            return true;
                        }
                        if (Like.match_(string, iString, pattern, iPattern + 1, ignoreCase)) {
                            return true;
                        }
                        return Like.match_(string, iString + 1, pattern, iPattern, ignoreCase);
                    }
                    case '?': {
                        return Like.match_(string, iString + 1, pattern, iPattern + 1, ignoreCase);
                    }
                }
                if (cPattern == '\\') {
                    if (++iPattern == pattern.length || pattern[iPattern] != '?' && pattern[iPattern] != '*' && pattern[iPattern] != '\\') {
                        throw new RuntimeException("Escape character must be followed by ?, *, or another escape character");
                    }
                    cPattern = pattern[iPattern];
                }
                if (!(cPattern == string[iString] || ignoreCase && Character.toUpperCase(cPattern) == Character.toUpperCase(string[iString]))) {
                    return false;
                }
                ++iString;
                ++iPattern;
            }
            if (iPattern == pattern.length) {
                return iString == string.length;
            }
            if (iString == string.length) {
                return pattern.length - 1 == iPattern && pattern[iPattern] == '*';
            }
            return false;
        }

        public String toString() {
            return this.name() + " like(" + String.valueOf(this.value()) + ")";
        }

        public static interface Visitor {
            public Object visit(Like var1, Object var2);
        }
    }

    public static class EndsWith
    extends Comparison {
        private boolean ignoreCase_;

        public EndsWith(String suffix) {
            super(suffix);
            this.ignoreCase_ = false;
        }

        public EndsWith(String suffix, boolean ignoreCase) {
            super(ignoreCase ? suffix.toUpperCase() : suffix);
            this.ignoreCase_ = ignoreCase;
        }

        public EndsWith(String name, String suffix) {
            super(name, suffix);
            this.ignoreCase_ = false;
        }

        public EndsWith(String name, String suffix, boolean ignoreCase) {
            super(name, ignoreCase ? suffix.toUpperCase() : suffix);
            this.ignoreCase_ = ignoreCase;
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public boolean ignoreCase() {
            return this.ignoreCase_;
        }

        public boolean match(String value) {
            return EndsWith.match(value, this.value().toString());
        }

        public static boolean match(String value, String suffix) {
            return EndsWith.match(value, suffix, false);
        }

        public static boolean match(String value, String suffix, boolean ignoreCase) {
            return ignoreCase ? value.toUpperCase().endsWith(suffix) : value.endsWith(suffix);
        }

        public String toString() {
            return this.name() + " ends with " + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(EndsWith var1, Object var2);
        }
    }

    public static class StartsWith
    extends Comparison {
        private boolean ignoreCase_;

        public StartsWith(String prefix) {
            super(prefix);
            this.ignoreCase_ = false;
        }

        public StartsWith(String prefix, boolean ignoreCase) {
            super(ignoreCase ? prefix.toUpperCase() : prefix);
            this.ignoreCase_ = ignoreCase;
        }

        public StartsWith(String name, String prefix) {
            super(name, prefix);
            this.ignoreCase_ = false;
        }

        public StartsWith(String name, String prefix, boolean ignoreCase) {
            super(name, ignoreCase ? prefix.toUpperCase() : prefix);
            this.ignoreCase_ = ignoreCase;
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public boolean ignoreCase() {
            return this.ignoreCase_;
        }

        public boolean match(String value) {
            return StartsWith.match(value, this.value().toString());
        }

        public static boolean match(String value, String suffix) {
            return StartsWith.match(value, suffix, false);
        }

        public static boolean match(String value, String prefix, boolean ignoreCase) {
            return ignoreCase ? value.toUpperCase().startsWith(prefix) : value.startsWith(prefix);
        }

        public String toString() {
            return this.name() + " starts with " + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(StartsWith var1, Object var2);
        }
    }

    public static class LessThanOrEqual
    extends Comparison {
        public LessThanOrEqual(Object value) {
            super(value);
        }

        public LessThanOrEqual(String name, Object value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + "<=" + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(LessThanOrEqual var1, Object var2);
        }
    }

    public static class LessThan
    extends Comparison {
        public LessThan(Object value) {
            super(value);
        }

        public LessThan(String name, Object value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + "<" + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(LessThan var1, Object var2);
        }
    }

    public static class GreaterThanOrEqual
    extends Comparison {
        public GreaterThanOrEqual(Object value) {
            super(value);
        }

        public GreaterThanOrEqual(String name, Object value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + ">=" + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(GreaterThanOrEqual var1, Object var2);
        }
    }

    public static class GreaterThan
    extends Comparison {
        public GreaterThan(Object value) {
            super(value);
        }

        public GreaterThan(String name, Object value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + ">" + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(GreaterThan var1, Object var2);
        }
    }

    public static class EqualIgnoreCase
    extends Comparison {
        public EqualIgnoreCase(String value) {
            super(value);
        }

        public EqualIgnoreCase(String name, String value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + " equalIgnoreCase(" + String.valueOf(this.value()) + ")";
        }

        public static interface Visitor {
            public Object visit(EqualIgnoreCase var1, Object var2);
        }
    }

    public static class Equal
    extends Comparison {
        public Equal(Object value) {
            super(value);
        }

        public Equal(String name, Object value) {
            super(name, value);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return this.name() + "==" + String.valueOf(this.value());
        }

        public static interface Visitor {
            public Object visit(Equal var1, Object var2);
        }
    }

    public static class InRange
    extends Criteria {
        private String name_;
        private Object lower_;
        private Object upper_;
        private boolean exclusive_;

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public InRange(String name, Object lower, Object upper) {
            this(name, lower, upper, false);
        }

        public InRange(String name, Object lower, Object upper, boolean exclusive) {
            this.name_ = name;
            this.lower_ = lower;
            this.upper_ = upper;
            this.exclusive_ = exclusive;
        }

        public InRange(Object lower, Object upper) {
            this(Criteria.DEFAULT_NAME, lower, upper, false);
        }

        public InRange(Object lower, Object upper, boolean exclusive) {
            this(Criteria.DEFAULT_NAME, lower, upper, exclusive);
        }

        public String name() {
            return this.name_;
        }

        public Object lower() {
            return this.lower_;
        }

        public Object upper() {
            return this.upper_;
        }

        public boolean isExclusive() {
            return this.exclusive_;
        }

        public String toString() {
            String op = this.exclusive_ ? "<" : "<=";
            return this.lower_.toString() + " " + op + " " + this.name() + " " + op + " " + this.upper_.toString();
        }

        public static interface Visitor {
            public Object visit(InRange var1, Object var2);
        }
    }

    public static class OneOf
    extends Criteria {
        private String name_;
        private Vector values_ = new Vector();

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public OneOf() {
            this(Criteria.DEFAULT_NAME);
        }

        public OneOf(Object[] values) {
            this(Criteria.DEFAULT_NAME, values);
        }

        public OneOf(Vector values) {
            this(Criteria.DEFAULT_NAME, values);
        }

        public OneOf(String name) {
            this.name_ = name;
        }

        public OneOf(String name, Object[] values) {
            this.name_ = name;
            this.add(values);
        }

        public OneOf(String name, Vector values) {
            this.name_ = name;
            this.add(values);
        }

        public String name() {
            return this.name_;
        }

        public Enumeration values() {
            return this.values_.elements();
        }

        public void add(Object value) {
            this.values_.addElement(value);
        }

        public void add(Object[] values) {
            int i = -1;
            while (++i < values.length) {
                this.values_.addElement(values[i]);
            }
        }

        public void add(Vector values) {
            int i = -1;
            while (++i < values.size()) {
                this.values_.addElement(values.elementAt(i));
            }
        }

        public int size() {
            return this.values_.size();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name());
            buf.append(" oneOf(");
            String comma = "";
            Enumeration e = this.values();
            while (e.hasMoreElements()) {
                buf.append(comma);
                buf.append("'");
                buf.append(String.valueOf(e.nextElement()));
                buf.append("'");
                comma = ",";
            }
            buf.append(")");
            return buf.toString();
        }

        public static interface Visitor {
            public Object visit(OneOf var1, Object var2);
        }
    }

    public static class Null
    extends Criteria {
        private String name_;

        public Null() {
            this(Criteria.DEFAULT_NAME);
        }

        public Null(String name) {
            this.name_ = name;
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String name() {
            return this.name_;
        }

        public String toString() {
            return this.name() + "==null";
        }

        public static interface Visitor {
            public Object visit(Null var1, Object var2);
        }
    }

    public static class Not
    extends Criteria {
        private Criteria criteria_;

        public Not(Criteria criteria) {
            this.criteria_ = criteria;
        }

        public Criteria element() {
            return this.criteria_;
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return "not(" + this.element() + ")";
        }

        public static interface Visitor {
            public Object visit(Not var1, Object var2);
        }
    }

    public static class Or
    extends Logical {
        public Or() {
        }

        public Or(Criteria[] criteria) {
            super(criteria);
        }

        public Or(Vector criteria) {
            super(criteria);
        }

        public Or(Criteria one, Criteria two) {
            super(one, two);
        }

        public Or(Criteria one, Criteria two, Criteria three) {
            super(one, two, three);
        }

        public Or(Criteria one, Criteria two, Criteria three, Criteria four) {
            super(one, two, three, four);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            boolean firstTime = true;
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                if (!firstTime) {
                    buf.append(' ');
                    buf.append("OR");
                    buf.append(' ');
                } else {
                    firstTime = false;
                }
                buf.append(e.nextElement().toString());
            }
            buf.append(')');
            return buf.toString();
        }

        public static interface Visitor {
            public Object visit(Or var1, Object var2);
        }
    }

    public static class And
    extends Logical {
        public And() {
        }

        public And(Criteria[] criteria) {
            super(criteria);
        }

        public And(Vector criteria) {
            super(criteria);
        }

        public And(Criteria one, Criteria two) {
            super(one, two);
        }

        public And(Criteria one, Criteria two, Criteria three) {
            super(one, two, three);
        }

        public And(Criteria one, Criteria two, Criteria three, Criteria four) {
            super(one, two, three, four);
        }

        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            boolean firstTime = true;
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                if (!firstTime) {
                    buf.append(" and ");
                } else {
                    firstTime = false;
                }
                buf.append(e.nextElement().toString());
            }
            buf.append(')');
            return buf.toString();
        }

        public static interface Visitor {
            public Object visit(And var1, Object var2);
        }
    }

    public static abstract class Logical
    extends Criteria {
        private Vector criteria_ = new Vector();

        protected Logical() {
        }

        protected Logical(Criteria[] criteria) {
            this.add(criteria);
        }

        protected Logical(Vector criteria) {
            this.add(criteria);
        }

        protected Logical(Criteria one, Criteria two) {
            this.add(one);
            this.add(two);
        }

        protected Logical(Criteria one, Criteria two, Criteria three) {
            this.add(one);
            this.add(two);
            this.add(three);
        }

        protected Logical(Criteria one, Criteria two, Criteria three, Criteria four) {
            this.add(one);
            this.add(two);
            this.add(three);
            this.add(four);
        }

        public void add(Criteria criteria) {
            this.criteria_.addElement(criteria);
        }

        public void add(Criteria[] criteria) {
            int i = -1;
            while (++i < criteria.length) {
                this.criteria_.addElement(criteria[i]);
            }
        }

        public void add(Vector criteria) {
            int i = -1;
            while (++i < criteria.size()) {
                this.criteria_.addElement(criteria.elementAt(i));
            }
        }

        public Enumeration elements() {
            return this.criteria_.elements();
        }

        public int size() {
            return this.criteria_.size();
        }
    }

    public static abstract class Comparison
    extends Criteria {
        String name_;
        Object value_;

        protected Comparison(Object value) {
            this.name_ = Criteria.DEFAULT_NAME;
            this.value_ = value;
        }

        protected Comparison(String name, Object value) {
            this.name_ = name;
            this.value_ = value;
        }

        public String name() {
            return this.name_;
        }

        public Object value() {
            return this.value_;
        }
    }

    public static class None
    extends Criteria {
        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return "NONE";
        }

        public static interface Visitor {
            public Object visit(None var1, Object var2);
        }
    }

    public static class Any
    extends Criteria {
        public Object apply(gov.va.med.term.access.criteria.Criteria$Visitor visitor, Object extra) {
            return ((Visitor)((Object)visitor)).visit(this, extra);
        }

        public String toString() {
            return "ANY";
        }

        public static interface Visitor {
            public Object visit(Any var1, Object var2);
        }
    }

    public static interface Visitor {
    }
}

