/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.webservice.impl;

import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.ee.VoaFileAttachmentDetail;
import gov.va.med.esr.common.model.ee.VoaFileAttachmentImage;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.model.person.VOAApplicationData;
import gov.va.med.esr.service.EnvironmentParamService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.VOAApplicationService;
import gov.va.med.esr.voa.validator.FormValidator;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.AuthenticationLevel;
import gov.va.med.esr.voa.webservice.DemographicInfo;
import gov.va.med.esr.voa.webservice.DependentFinancialsInfo;
import gov.va.med.esr.voa.webservice.DependentInfo;
import gov.va.med.esr.voa.webservice.Document;
import gov.va.med.esr.voa.webservice.EeSummary;
import gov.va.med.esr.voa.webservice.EmailInfo;
import gov.va.med.esr.voa.webservice.ExpenseInfo;
import gov.va.med.esr.voa.webservice.FinancialsInfo;
import gov.va.med.esr.voa.webservice.Form;
import gov.va.med.esr.voa.webservice.IncomeInfo;
import gov.va.med.esr.voa.webservice.InsuranceCollection;
import gov.va.med.esr.voa.webservice.InsuranceInfo;
import gov.va.med.esr.voa.webservice.Message;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceSiteRecordInfo;
import gov.va.med.esr.voa.webservice.ObjectFactory;
import gov.va.med.esr.voa.webservice.PersonInfo;
import gov.va.med.esr.voa.webservice.PhoneInfo;
import gov.va.med.esr.voa.webservice.RetrieveFormSubmissionStatusRequest;
import gov.va.med.esr.voa.webservice.RetrieveFormSubmissionStatusResponse;
import gov.va.med.esr.voa.webservice.SpouseFinancialsInfo;
import gov.va.med.esr.voa.webservice.SpouseInfo;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.SubmitFormResponse;
import gov.va.med.esr.voa.webservice.VeteranIdentifier;
import gov.va.med.esr.voa.webservice.VoaFault;
import gov.va.med.esr.voa.webservice.VoaFaultException;
import gov.va.med.esr.voa.webservice.builder.impl.BuildHelper;
import gov.va.med.esr.voa.webservice.builder.impl.DemographicsBuilderFactoryImpl;
import gov.va.med.esr.voa.webservice.builder.impl.EnrollmentDeterminationBuilderFactoryImpl;
import gov.va.med.esr.voa.webservice.builder.impl.FinancialsBuilderFactoryImpl;
import gov.va.med.esr.voa.webservice.builder.impl.MilitaryServiceBuilderFactoryImpl;
import gov.va.med.esr.voa.webservice.builder.impl.TypesHelper;
import gov.va.med.esr.voa.webservice.impl.VOAESRService;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.config.SingletonApplicationContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.login.LoginException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class VOAESRServiceImpl
extends AbstractComponent
implements VOAESRService {
    private VOAApplicationService voaApplicationService = null;
    private SystemParameterService systemParameterService = null;
    private EnvironmentParamService environmentParamService = null;
    public static final String VOA_MESSAGE_INITIATER = "VOA event";
    private static final String REDIRECT_URL_DEV = "http://vaww.1010ez.webdeve.va.gov/sec/vha/1010ez/submitXML.asp";
    private static final String REDIRECT_URL_PROD = "https://www.1010ez.med.va.gov/sec/vha/1010ez/submitPost.asp";
    private LoginManager loginManager;
    private TypesHelper typesHelper = new TypesHelper();
    private static final String ANONYMOUS = "100";
    private static final String DS_LOGON_LEVEL1 = "101";
    private static final String TYPE_21526EZ = "105";
    private static final String VOA_FACILITIES = "VOA_FACILITIES";

    @Override
    public void saveVOAForm(SubmitFormRequest submitFormRequest, SubmitFormResponse response) throws VoaFault {
        block16: {
            try {
                this.processAuthenticate(VOA_MESSAGE_INITIATER);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block16;
                this.logger.debug((Object)("VOA Form authentication exception: " + ex.getMessage()));
            }
        }
        String sid = this.generateSid();
        try {
            Boolean voaInd = this.getSystemParameterService().getVOAAnonymousLevel1ProcessIndicator();
            if (voaInd == null || !voaInd.booleanValue()) {
                BigDecimal applicationId = this.saveApplicationData(submitFormRequest, response, sid);
                this.redirectToLegacy1010(submitFormRequest, applicationId, sid);
                return;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception lookin up VOA Anonymous Indicator", (Throwable)ex);
            return;
        }
        String[] siteList = null;
        BigDecimal applicationId = this.saveApplicationData(submitFormRequest, response, null);
        try {
            siteList = this.getSystemParameterService().getByName(VOA_FACILITIES).getValue().split(",");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown exception retrieving VOA site list parameter during saveVOAForm:" + ex.getMessage()));
        }
        boolean accept = false;
        if (siteList != null) {
            if (siteList[0].trim().equalsIgnoreCase("ALL")) {
                accept = true;
            } else {
                try {
                    String facilityNumber = submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility();
                    for (int i = 0; i < siteList.length; ++i) {
                        if (!siteList[i].trim().equalsIgnoreCase(facilityNumber)) continue;
                        accept = true;
                    }
                }
                catch (Exception ex) {
                    this.logger.error((Object)"VOA site list lookup failed:", (Throwable)ex);
                    accept = false;
                }
            }
        }
        if (!accept) {
            this.redirectToLegacy1010(submitFormRequest, applicationId, sid);
            return;
        }
        if (submitFormRequest.getForm() != null) {
            Form submittedForm = submitFormRequest.getForm();
            this.validate(submittedForm, applicationId);
        }
        if (submitFormRequest.getForm().getFormIdentifier().getType().equalsIgnoreCase(TYPE_21526EZ)) {
            this.updateApplicationFacility(applicationId, submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility());
        }
        BuildHelper bh = new BuildHelper();
        response.setTimeStamp(bh.getDateJavatoXML(new Date()));
    }

    @Override
    public void processVOAForm(SubmitFormRequest submitFormRequest, BigInteger applicationId) {
        try {
            this.processAuthenticate(VOA_MESSAGE_INITIATER);
        }
        catch (Exception ex) {
            this.logger.error((Object)("VOA Form authentication exception: " + ex.getMessage()));
        }
        Person person = this.buildPerson(submitFormRequest);
        System.out.println("about to call app service with person date:" + person.getAppointmentRequestDate());
        try {
            this.getVoaApplicationService().processVoaApplication(new BigDecimal(applicationId), person);
        }
        catch (Exception e) {
            this.updateApplicationFormSubmitStatus(new BigDecimal(applicationId), e.getMessage());
        }
    }

    @Override
    public void getVOAFormSubmissionStatus(RetrieveFormSubmissionStatusRequest retrieveFormSubmissionStatusRequest, RetrieveFormSubmissionStatusResponse response) throws VoaFault {
        VOAApplication voaApp = new VOAApplication();
        Message msg = new Message();
        try {
            voaApp = this.getVoaApplicationService().findVoaApplicationByApplicationId(new BigDecimal(retrieveFormSubmissionStatusRequest.getFormSubmissionId()));
            response.setStatus(voaApp.getApplicationStatus().getCode());
            if (voaApp.getErrorText() != null) {
                msg.setDetail(voaApp.getErrorText());
            }
            response.setFormSubmissionId(new BigInteger(voaApp.getEntityKey().getKeyValue().toString()));
        }
        catch (Exception ex) {
            msg.setDetail(ex.getMessage());
            response.setMessage(msg);
        }
        BuildHelper bh = new BuildHelper();
        response.setFormSubmissionId(retrieveFormSubmissionStatusRequest.getFormSubmissionId());
        response.setTimeStamp(bh.getDateJavatoXML(new Date()));
    }

    private String makeSid(Calendar now) {
        return String.format("%02d", now.get(13)) + String.format("%02d", now.get(12)) + "-" + String.format("%02d", now.get(11)) + String.format("%02d", now.get(5)) + String.format("%02d", now.get(2) + 1) + "-" + String.format("%04d", now.get(1));
    }

    private String generateSid() {
        String sid = "";
        Calendar now = Calendar.getInstance();
        List res = null;
        do {
            sid = this.makeSid(now);
            try {
                res = this.getVoaApplicationService().findByFQID(sid);
            }
            catch (ServiceException e) {
                this.logger.error((Object)e);
            }
            if (res == null || res.isEmpty()) break;
            now.add(13, 1);
        } while (res != null && res.size() > 0);
        return sid;
    }

    private BigDecimal saveApplicationData(SubmitFormRequest submitFormRequest, SubmitFormResponse response, String sid) throws VoaFault {
        VeteranIdentifier vid;
        AuthenticationLevel auth;
        PersonInfo personInfo;
        TypesHelper typesHelper = new TypesHelper();
        BuildHelper bh = new BuildHelper();
        BigDecimal applicationId = null;
        VOAApplication voaApp = new VOAApplication();
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getSummary() != null && submitFormRequest.getForm().getSummary().getPersonInfo() != null && (personInfo = submitFormRequest.getForm().getSummary().getPersonInfo()) != null) {
            if (personInfo.getFirstName() != null) {
                voaApp.setFirstName(personInfo.getFirstName());
            }
            if (personInfo.getLastName() != null) {
                voaApp.setLastName(personInfo.getLastName());
            }
            if (personInfo.getMiddleName() != null) {
                voaApp.setMiddleName(personInfo.getMiddleName());
            }
            if (personInfo.getDob() != null) {
                voaApp.setDateOfBirth(bh.stringToDate(personInfo.getDob()));
            }
            if (personInfo.getGender() != null) {
                voaApp.setGender(typesHelper.getGender(personInfo.getGender()));
            }
            if (personInfo.getSsnText() != null) {
                voaApp.setSsn(personInfo.getSsnText());
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility() != null) {
            voaApp.setPreferredFacility(typesHelper.getVAFacility(submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility()));
        }
        if (submitFormRequest.getIdentity() != null && submitFormRequest.getIdentity().getAuthenticationLevel() != null && (auth = submitFormRequest.getIdentity().getAuthenticationLevel()) != null && auth.getType() != null) {
            voaApp.setAuthenticationLevel(typesHelper.getAuthenticationLevel(auth.getType()));
        }
        if (submitFormRequest.getIdentity() != null && submitFormRequest.getIdentity().getVeteranIdentifier() != null && (vid = submitFormRequest.getIdentity().getVeteranIdentifier()) != null && vid.getType() != null) {
            voaApp.setFullQualifiedId(vid.getValue());
            voaApp.setIdentityType(typesHelper.getVeteranIdentifierType(vid.getType()));
        }
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getFormIdentifier() != null && submitFormRequest.getForm().getFormIdentifier().getType() != null) {
            voaApp.setFormType(typesHelper.getVOAFormType(submitFormRequest.getForm().getFormIdentifier().getType()));
        }
        voaApp.setReceiveTimeStamp(new Date());
        voaApp.setResponseTimeStamp(new Date());
        if (sid != null) {
            voaApp.setFullQualifiedId(sid);
        }
        if (submitFormRequest.getForm().getAttachments() != null && submitFormRequest.getForm().getAttachments().getDocument() != null) {
            List<Document> documentList = submitFormRequest.getForm().getAttachments().getDocument();
            for (Document document : documentList) {
                voaApp.addFileAttachment(this.createFileAttachment(document));
            }
        }
        voaApp.setVOAApplicationData(this.createApplicationData(submitFormRequest));
        Message msg = new Message();
        voaApp.setApplicationStatus(typesHelper.getVOAApplicationStatus(VOAApplicationStatus.FORM_SUBMITTED.getCode()));
        VOAApplication newVoaApp = null;
        try {
            newVoaApp = this.getVoaApplicationService().save(voaApp);
            applicationId = (BigDecimal)newVoaApp.getEntityKey().getKeyValue();
            response.setStatus(voaApp.getApplicationStatus().getCode());
            response.setFormSubmissionId(applicationId.toBigInteger());
            msg.setType("Form successfully received for EE processing");
            response.setMessage(msg);
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Form Save exception: " + ex.getMessage()));
            }
            ObjectFactory factory = new ObjectFactory();
            VoaFaultException voaFaultException = factory.createVoaFaultException();
            VoaFaultException.FaultExceptions faultExceptions = factory.createVoaFaultExceptionFaultExceptions();
            VoaFaultException.FaultExceptions.FaultException faultException = factory.createVoaFaultExceptionFaultExceptionsFaultException();
            faultException.setCode("VOA_0240");
            faultException.setMessage("Form data is failed to save in the system");
            faultExceptions.getFaultException().add(faultException);
            voaFaultException.setFaultExceptions(faultExceptions);
            throw new VoaFault("formSubmissionException", voaFaultException);
        }
        return applicationId;
    }

    private Person buildPerson(SubmitFormRequest submitFormRequest) {
        Person person = new Person();
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getSummary() != null) {
            DemographicsBuilderFactoryImpl demographicBuilderFactory = new DemographicsBuilderFactoryImpl();
            FinancialsBuilderFactoryImpl financialsBuildFactory = new FinancialsBuilderFactoryImpl();
            EnrollmentDeterminationBuilderFactoryImpl enrollmentDeterminationBuilderFactory = new EnrollmentDeterminationBuilderFactoryImpl();
            MilitaryServiceBuilderFactoryImpl militaryServiceBuilderFactory = new MilitaryServiceBuilderFactoryImpl();
            enrollmentDeterminationBuilderFactory.buildEntrollmentDeterminationServices(person, submitFormRequest);
            demographicBuilderFactory.buildDemographics(person, submitFormRequest);
            financialsBuildFactory.buildFinancialServices(person, submitFormRequest, this.voaApplicationService);
            militaryServiceBuilderFactory.buildMilitaryServices(person, submitFormRequest);
        }
        return person;
    }

    private String convertToXML(Form form) {
        String xml;
        block2: {
            xml = null;
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Form.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                StringWriter sw = new StringWriter();
                jaxbMarshaller.marshal((Object)form, (Writer)sw);
                xml = sw.toString();
            }
            catch (JAXBException ex) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Form Save exception: " + ex.getMessage() + ex.getErrorCode()));
            }
        }
        return xml;
    }

    private VOAApplicationData createApplicationData(SubmitFormRequest submitFormRequest) {
        Form form = new Form();
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getSummary() != null) {
            form.setSummary(submitFormRequest.getForm().getSummary());
        }
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getFormIdentifier() != null) {
            form.setFormIdentifier(submitFormRequest.getForm().getFormIdentifier());
        }
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getApplications() != null) {
            form.setApplications(submitFormRequest.getForm().getApplications());
        }
        VOAApplicationData appdata = new VOAApplicationData();
        appdata.setApplicationData(this.convertToXML(form));
        return appdata;
    }

    private VoaFileAttachment createFileAttachment(Document doc) {
        VoaFileAttachment attachment = new VoaFileAttachment();
        if (doc != null) {
            attachment.addVoaAttachmentDetail(this.createAttachmentDetail(doc));
            attachment.setAttachmentImage(this.createAttachmentImage(doc));
            if (doc.getName() != null) {
                attachment.setFileName(doc.getName());
            }
            if (doc.getFormat() != null) {
                attachment.setFileMimeType(doc.getFormat().value());
            }
        }
        return attachment;
    }

    private VoaFileAttachmentImage createAttachmentImage(Document doc) {
        VoaFileAttachmentImage image;
        block3: {
            image = new VoaFileAttachmentImage();
            try {
                if (doc.getContent() != null && doc.getContent().length > 0) {
                    image.setFileImage(doc.getContent());
                }
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("createAttachmentImage error : " + ex.getMessage()));
            }
        }
        return image;
    }

    private VoaFileAttachmentDetail createAttachmentDetail(Document doc) {
        VoaFileAttachmentDetail detail = new VoaFileAttachmentDetail();
        if (doc.getType() != null) {
            detail.setEligibilityDocType(new TypesHelper().getEligibilityDocType(doc.getType()));
        }
        return detail;
    }

    private void validate(Form submittedForm, BigDecimal applicationId) throws VoaFault {
        this.logger.debug((Object)"validate form data.");
        boolean isNewOMBApprovedForm = true;
        BindException errors = new BindException((Object)submittedForm, "form");
        FormValidator validator = new FormValidator();
        validator.setNewOMBApprovedForm(isNewOMBApprovedForm);
        validator.validate(submittedForm, (Errors)errors);
        this.processError(errors, applicationId);
    }

    private void processError(BindException errors, BigDecimal applicationId) throws VoaFault {
        if (errors.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"form has errors.");
            }
            StringBuffer errCode = new StringBuffer();
            ObjectFactory factory = new ObjectFactory();
            VoaFaultException voaFaultException = factory.createVoaFaultException();
            VoaFaultException.FaultExceptions faultExceptions = factory.createVoaFaultExceptionFaultExceptions();
            for (Object iter : errors.getAllErrors()) {
                ObjectError error = (ObjectError)iter;
                String code = error.getCode();
                String msg = error.getDefaultMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("error code = " + code + " message = " + msg));
                }
                if (errCode.toString().length() <= 0 || errCode.toString().isEmpty()) {
                    errCode.append(code);
                } else {
                    errCode.append("," + code);
                }
                VoaFaultException.FaultExceptions.FaultException faultException = factory.createVoaFaultExceptionFaultExceptionsFaultException();
                faultException.setCode(code);
                faultException.setMessage(msg);
                faultExceptions.getFaultException().add(faultException);
            }
            if (applicationId != null) {
                this.updateApplicationFormSubmitStatus(applicationId, errCode.toString());
            }
            voaFaultException.setFaultExceptions(faultExceptions);
            throw new VoaFault("formSubmissionException", voaFaultException);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"validate form data - Done.");
        }
    }

    public VOAApplicationService getVoaApplicationService() {
        if (this.voaApplicationService == null) {
            this.voaApplicationService = (VOAApplicationService)SingletonApplicationContext.getInstance().getSingletonContext().getBean("voaApplicationService");
        }
        return this.voaApplicationService;
    }

    public void setVoaApplicationService(VOAApplicationService voaApplicationService) {
        this.voaApplicationService = voaApplicationService;
    }

    public EnvironmentParamService getEnvironmentParamService() {
        if (this.environmentParamService == null) {
            this.environmentParamService = (EnvironmentParamService)SingletonApplicationContext.getInstance().getSingletonContext().getBean("common.environmentParamService");
        }
        return this.environmentParamService;
    }

    public void setEnvironmentParamService(EnvironmentParamService environmentParamService) {
        this.environmentParamService = environmentParamService;
    }

    public SystemParameterService getSystemParameterService() {
        if (this.systemParameterService == null) {
            this.systemParameterService = (SystemParameterService)SingletonApplicationContext.getInstance().getSingletonContext().getBean("systemParameterService");
        }
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    private void processAuthenticate(String logicalID) throws LoginException {
        UserCredentials creds = new UserCredentials();
        creds.setAnonymous(true);
        creds.setLogicalID(logicalID);
        SecurityContextHelper.initSecurityContextOnThread((LoginManager)this.getLoginManager(), (UserCredentials)creds);
    }

    private void updateApplicationFormSubmitStatus(BigDecimal applicationId, String errTxt) {
        block3: {
            try {
                VOAApplication voaAppErr = this.getVoaApplicationService().findVoaApplicationByApplicationId(applicationId);
                TypesHelper typesHelper = new TypesHelper();
                voaAppErr.setApplicationStatus(typesHelper.getVOAApplicationStatus(VOAApplicationStatus.FORM_SUBMISSION_FAILED.getCode()));
                if (errTxt != null) {
                    voaAppErr.setErrorText(errTxt);
                }
                voaAppErr.setResponseTimeStamp(new Date());
                this.getVoaApplicationService().updateVOAApplication(voaAppErr);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Update VOA application status exception: " + ex.getStackTrace()));
            }
        }
    }

    private void updateApplicationForRedirect(BigDecimal applicationId, String errTxt) {
        block3: {
            try {
                VOAApplication voaAppErr = this.getVoaApplicationService().findVoaApplicationByApplicationId(applicationId);
                TypesHelper typesHelper = new TypesHelper();
                voaAppErr.setApplicationStatus(typesHelper.getVOAApplicationStatus(VOAApplicationStatus.FORM_RESUBMITTED.getCode()));
                if (errTxt != null) {
                    voaAppErr.setErrorText(errTxt);
                }
                voaAppErr.setResponseTimeStamp(new Date());
                this.getVoaApplicationService().updateVOAApplication(voaAppErr);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Update VOA application status exception: " + ex.getStackTrace()));
            }
        }
    }

    private void updateApplicationFacility(BigDecimal applicationId, String facility) {
        block2: {
            try {
                VOAApplication voaApp = this.getVoaApplicationService().findVoaApplicationByApplicationId(applicationId);
                TypesHelper typesHelper = new TypesHelper();
                voaApp.setPreferredFacility(typesHelper.getVAFacility(facility));
                this.getVoaApplicationService().updateVOAApplication(voaApp);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Update VOA application facility exception: " + ex.getStackTrace()));
            }
        }
    }

    public LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = (LoginManager)SingletonApplicationContext.getInstance().getSingletonContext().getBean("edbLoginManager");
        }
        return this.loginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void redirectToLegacy1010(SubmitFormRequest submitFormRequest, BigDecimal applicationId, String sid) throws VoaFault {
        try {
            org.jdom2.Document convertedDoc;
            boolean isProd;
            block14: {
                isProd = this.getEnvironmentParamService().isProdEnv();
                Element root = new Element("form1");
                this.setPersonInfo(root, submitFormRequest.getForm().getSummary().getPersonInfo());
                this.setDemographics(root, submitFormRequest.getForm().getSummary().getDemographics(), isProd);
                this.setMilitaryService(root, submitFormRequest.getForm().getSummary().getMilitaryServiceInfo());
                this.setSpecialFactors(root, submitFormRequest.getForm().getSummary());
                this.setInsurance(root, submitFormRequest.getForm().getSummary().getInsuranceList());
                if (submitFormRequest.getForm().getSummary().getFinancialsInfo() != null && submitFormRequest.getForm().getSummary().getFinancialsInfo().getIncomeTest() != null && submitFormRequest.getForm().getSummary().getFinancialsInfo().getIncomeTest().isDiscloseFinancialInformation() != null) {
                    Element discloseDetails;
                    Boolean disclose = submitFormRequest.getForm().getSummary().getFinancialsInfo().getIncomeTest().isDiscloseFinancialInformation();
                    if (disclose.booleanValue()) {
                        this.setSpouseFinancials(root, submitFormRequest.getForm().getSummary().getFinancialsInfo());
                        this.setChildFinancials(root, submitFormRequest.getForm().getSummary().getFinancialsInfo());
                        this.setVetIncomeAndExpenses(root, submitFormRequest.getForm().getSummary().getFinancialsInfo());
                        discloseDetails = new Element("ProvideDetails");
                        discloseDetails.addContent("Y");
                        root.addContent((Content)discloseDetails);
                    } else {
                        discloseDetails = new Element("ProvideDetails");
                        discloseDetails.addContent("N");
                        root.addContent((Content)discloseDetails);
                    }
                } else {
                    Element discloseDetails = new Element("ProvideDetails");
                    discloseDetails.addContent("N");
                    root.addContent((Content)discloseDetails);
                }
                this.setSid(root, sid);
                convertedDoc = new org.jdom2.Document();
                convertedDoc.setRootElement(root);
                if (!isProd) {
                    XMLOutputter outter = new XMLOutputter();
                    outter.setFormat(Format.getPrettyFormat());
                    FileOutputStream fstream = null;
                    try {
                        fstream = new FileOutputStream(new File("forwardedXML_" + sid + ".xml"));
                        outter.output(convertedDoc, (OutputStream)fstream);
                        IOUtils.closeQuietly((OutputStream)fstream);
                    }
                    catch (FileNotFoundException e) {
                        this.logger.error((Object)("Cannot write output xml file" + e));
                    }
                    catch (IOException e2) {
                        this.logger.error((Object)("Cannot write output xml file" + e2));
                        break block14;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        IOUtils.closeQuietly(fstream);
                    }
                }
            }
            this.postConvertedSubmission(convertedDoc, isProd);
            this.updateApplicationForRedirect(applicationId, "Application Not Processed by ES. Forwarded to legacy 1010 with SID:" + sid);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown Exception Forwarding to online1010 for application id:" + applicationId), (Throwable)ex);
            this.updateApplicationFormSubmitStatus(applicationId, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postConvertedSubmission(org.jdom2.Document document, boolean isProd) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter();
        outputter.output(document, (OutputStream)outputStream);
        byte[] docBytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(docBytes);
        PostMethod post = null;
        post = isProd ? new PostMethod(REDIRECT_URL_PROD) : new PostMethod(REDIRECT_URL_DEV);
        try {
            post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)inputStream, (long)docBytes.length));
            post.setRequestHeader("Content-type", "text/xml; charset=ISO-8859-1");
            HttpClient httpclient = new HttpClient();
            httpclient.getParams().setSoTimeout(20000);
            httpclient.getParams().setConnectionManagerTimeout(20000L);
            int result = httpclient.executeMethod((HttpMethod)post);
            this.logger.warn((Object)("VOA Redirect Status Response:" + post.getResponseBodyAsString()));
            if (result >= 400) {
                this.logger.error((Object)("Failed Response from 1010 Redirect:" + post.getResponseBodyAsString()));
                throw new Exception("HTTP Status Response: " + result);
            }
        }
        finally {
            post.releaseConnection();
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void setVetIncomeAndExpenses(Element root, FinancialsInfo fin) {
        if (fin == null || fin.getFinancialStatement() == null) {
            return;
        }
        try {
            if (fin.getFinancialStatement().getIncomes() != null && fin.getFinancialStatement().getIncomes().getIncome() != null) {
                List<IncomeInfo> incomes = fin.getFinancialStatement().getIncomes().getIncome();
                Iterator<IncomeInfo> incomeIter = incomes.iterator();
                boolean grossAdded = false;
                boolean propAdded = false;
                boolean otherAdded = false;
                while (incomeIter.hasNext()) {
                    Element vetOtherIncome;
                    Element vetPropIncome;
                    Element vetGrossIncome;
                    IncomeInfo income = incomeIter.next();
                    if (income != null && income.getType().equalsIgnoreCase("7")) {
                        vetGrossIncome = new Element("VetGrossIncome");
                        vetGrossIncome.addContent(income.getAmount().toString());
                        root.addContent((Content)vetGrossIncome);
                        grossAdded = true;
                    }
                    if (income != null && income.getType().equalsIgnoreCase("13")) {
                        vetPropIncome = new Element("VetPropertyIncome");
                        vetPropIncome.addContent(income.getAmount().toString());
                        root.addContent((Content)vetPropIncome);
                        propAdded = true;
                    }
                    if (income != null && income.getType().equalsIgnoreCase("10")) {
                        vetOtherIncome = new Element("VetOtherIncome");
                        vetOtherIncome.addContent(income.getAmount().toString());
                        root.addContent((Content)vetOtherIncome);
                        otherAdded = true;
                    }
                    if (!grossAdded) {
                        vetGrossIncome = new Element("VetGrossIncome");
                        vetGrossIncome.addContent("0");
                        root.addContent((Content)vetGrossIncome);
                    }
                    if (!propAdded) {
                        vetPropIncome = new Element("VetPropertyIncome");
                        vetPropIncome.addContent("0");
                        root.addContent((Content)vetPropIncome);
                    }
                    if (otherAdded) continue;
                    vetOtherIncome = new Element("VetOtherIncome");
                    vetOtherIncome.addContent("0");
                    root.addContent((Content)vetOtherIncome);
                }
            }
            if (fin.getFinancialStatement().getExpenses() != null && fin.getFinancialStatement().getExpenses().getExpense() != null) {
                List<ExpenseInfo> expenses = fin.getFinancialStatement().getExpenses().getExpense();
                for (ExpenseInfo expense : expenses) {
                    if (expense != null && expense.getExpenseType() != null && expense.getExpenseType().equalsIgnoreCase("18")) {
                        Element med = new Element("MedicalExpenses");
                        med.addContent(expense.getAmount().toString());
                        root.addContent((Content)med);
                    }
                    if (expense != null && expense.getExpenseType() != null && expense.getExpenseType().equalsIgnoreCase("3")) {
                        Element school = new Element("VetSelfSchool");
                        school.addContent(expense.getAmount().toString());
                        root.addContent((Content)school);
                    }
                    if (expense == null || expense.getExpenseType() == null || !expense.getExpenseType().equalsIgnoreCase("19")) continue;
                    Element funeral = new Element("FuneralExpenses");
                    funeral.addContent(expense.getAmount().toString());
                    root.addContent((Content)funeral);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA vet expenses", (Throwable)ex);
        }
    }

    private void setChildFinancials(Element root, FinancialsInfo fin) {
        if (fin == null || fin.getFinancialStatement() == null) {
            return;
        }
        try {
            if (fin.getFinancialStatement().getDependentFinancialsList() != null && fin.getFinancialStatement().getDependentFinancialsList().getDependentFinancials() != null) {
                List<DependentFinancialsInfo> dependents = fin.getFinancialStatement().getDependentFinancialsList().getDependentFinancials();
                Iterator<DependentFinancialsInfo> dependIter = dependents.iterator();
                int count = 0;
                while (dependIter.hasNext()) {
                    Element other;
                    ++count;
                    DependentFinancialsInfo dependent = dependIter.next();
                    if (dependent.getDependentInfo() != null) {
                        Element depSuf;
                        Element depMname;
                        DependentInfo dependentInfo = dependent.getDependentInfo();
                        Element depname = new Element("ChildNameLast");
                        depname.addContent(dependentInfo.getFamilyName());
                        root.addContent((Content)depname);
                        Element depFname = new Element("ChildNameFirst");
                        depFname.addContent(dependentInfo.getGivenName());
                        root.addContent((Content)depFname);
                        if (dependentInfo.getMiddleName() != null) {
                            depMname = new Element("ChildNameMiddle");
                            depMname.addContent(dependentInfo.getMiddleName());
                            root.addContent((Content)depMname);
                        } else {
                            depMname = new Element("ChildNameMiddle");
                            depMname.addContent("");
                            root.addContent((Content)depMname);
                        }
                        if (dependentInfo.getSuffix() != null) {
                            depSuf = new Element("ChildNameSuffix");
                            depSuf.addContent(dependentInfo.getSuffix());
                            root.addContent((Content)depSuf);
                        } else {
                            depSuf = new Element("ChildNameSuffix");
                            depSuf.addContent("");
                            root.addContent((Content)depSuf);
                        }
                        Element depDob = new Element("ChildDateOfBirth");
                        depDob.addContent(dependentInfo.getDob());
                        root.addContent((Content)depDob);
                        if (dependentInfo.getSsns() != null && dependentInfo.getSsns().getSsn() != null && dependentInfo.getSsns().getSsn().get(0) != null) {
                            String ssnText = dependentInfo.getSsns().getSsn().get(0).getSsnText();
                            String formattedSSN = String.format("%s-%s-%s", ssnText.substring(0, 3), ssnText.substring(3, 5), ssnText.substring(5, 9));
                            Element depSsn = new Element("ChildSocialSecurityNumber");
                            depSsn.addContent(formattedSSN);
                            root.addContent((Content)depSsn);
                        }
                        Element depStart = new Element("ChildDependentDate");
                        depStart.addContent(dependentInfo.getStartDate());
                        root.addContent((Content)depStart);
                        String relationship = dependentInfo.getRelationship();
                        if (relationship != null) {
                            Element rel = new Element("ChildRelationshipSon");
                            if (relationship.equalsIgnoreCase("3")) {
                                rel.addContent("1");
                            } else {
                                rel.addContent("0");
                            }
                            root.addContent((Content)rel);
                            Element rel2 = new Element("ChildRelationshipDaughter");
                            if (relationship.equalsIgnoreCase("4")) {
                                rel2.addContent("1");
                            } else {
                                rel2.addContent("0");
                            }
                            root.addContent((Content)rel2);
                            Element rel3 = new Element("ChildRelationshipStepson");
                            if (relationship.equalsIgnoreCase("5")) {
                                rel3.addContent("1");
                            } else {
                                rel3.addContent("0");
                            }
                            root.addContent((Content)rel3);
                            Element rel4 = new Element("ChildRelationshipStepdaughter");
                            if (relationship.equalsIgnoreCase("6")) {
                                rel4.addContent("1");
                            } else {
                                rel4.addContent("0");
                            }
                            root.addContent((Content)rel4);
                        }
                    }
                    if (dependent.isContributedToSupport() != null) {
                        Element contrib;
                        Boolean isContrib = dependent.isContributedToSupport();
                        if (isContrib.booleanValue()) {
                            contrib = new Element("ChildSupportAmount");
                            contrib.addContent("600.00");
                            root.addContent((Content)contrib);
                        } else {
                            contrib = new Element("ChildSupportAmount");
                            contrib.addContent("0");
                            root.addContent((Content)contrib);
                        }
                    }
                    if (dependent.getExpenses() != null && dependent.getExpenses().getExpense() != null) {
                        List<ExpenseInfo> expenses = dependent.getExpenses().getExpense();
                        for (ExpenseInfo expense : expenses) {
                            Element college = new Element("ChildSelfSchool");
                            if (expense.getExpenseType().equalsIgnoreCase("16")) {
                                college.addContent(expense.getAmount().toString());
                            } else {
                                college.addContent("0");
                            }
                            root.addContent((Content)college);
                        }
                    } else {
                        Element college = new Element("ChildSelfSchool");
                        college.addContent("0");
                        root.addContent((Content)college);
                    }
                    if (dependent.isAttendedSchool() != null) {
                        Element att2;
                        Element att;
                        Boolean didAttend = dependent.isAttendedSchool();
                        if (didAttend.booleanValue()) {
                            att = new Element("ChildAttendSchoolYes");
                            att.addContent("1");
                            root.addContent((Content)att);
                            att2 = new Element("ChildAttendSchoolNo");
                            att2.addContent("0");
                            root.addContent((Content)att2);
                        } else {
                            att = new Element("ChildAttendSchoolNo");
                            att.addContent("1");
                            root.addContent((Content)att);
                            att2 = new Element("ChildAttendSchoolYes");
                            att2.addContent("0");
                            root.addContent((Content)att2);
                        }
                    }
                    if (dependent.isIncapableOfSelfSupport() != null) {
                        Element dis2;
                        Element dis;
                        Boolean disabled = dependent.isIncapableOfSelfSupport();
                        if (disabled.booleanValue()) {
                            dis = new Element("ChildTotalDisabledYes");
                            dis.addContent("1");
                            root.addContent((Content)dis);
                            dis2 = new Element("ChildTotalDisabledNo");
                            dis2.addContent("0");
                            root.addContent((Content)dis2);
                        } else {
                            dis = new Element("ChildTotalDisabledNo");
                            dis.addContent("1");
                            root.addContent((Content)dis);
                            dis2 = new Element("ChildTotalDisabledYes");
                            dis2.addContent("0");
                            root.addContent((Content)dis2);
                        }
                    }
                    if (dependent.getIncomes() == null || dependent.getIncomes().getIncome() == null) continue;
                    List<IncomeInfo> incomes = dependent.getIncomes().getIncome();
                    boolean grossAdded = false;
                    boolean propAdded = false;
                    boolean otherAdded = false;
                    for (IncomeInfo income : incomes) {
                        Element other2;
                        if (income != null && income.getType().equalsIgnoreCase("7")) {
                            Element gross;
                            if (count == 1) {
                                gross = new Element("Child1GrossIncome");
                                gross.addContent(income.getAmount().toString());
                                root.addContent((Content)gross);
                                grossAdded = true;
                            } else {
                                gross = new Element("ChildGrossIncome");
                                gross.addContent(income.getAmount().toString());
                                root.addContent((Content)gross);
                                grossAdded = true;
                            }
                        }
                        if (income != null && income.getType().equalsIgnoreCase("13")) {
                            Element prop;
                            if (count == 1) {
                                prop = new Element("Child1PropertyIncome");
                                prop.addContent(income.getAmount().toString());
                                root.addContent((Content)prop);
                                propAdded = true;
                            } else {
                                prop = new Element("ChildPropertyIncome");
                                prop.addContent(income.getAmount().toString());
                                root.addContent((Content)prop);
                                propAdded = true;
                            }
                        }
                        if (income == null || !income.getType().equalsIgnoreCase("10")) continue;
                        if (count == 1) {
                            other2 = new Element("Child1OtherIncome");
                            other2.addContent(income.getAmount().toString());
                            root.addContent((Content)other2);
                            otherAdded = true;
                            continue;
                        }
                        other2 = new Element("ChildOtherIncome");
                        other2.addContent(income.getAmount().toString());
                        root.addContent((Content)other2);
                        otherAdded = true;
                    }
                    if (!grossAdded) {
                        Element gross;
                        if (count == 1) {
                            gross = new Element("Child1GrossIncome");
                            gross.addContent("0");
                            root.addContent((Content)gross);
                        } else {
                            gross = new Element("ChildGrossIncome");
                            gross.addContent("0");
                            root.addContent((Content)gross);
                        }
                    }
                    if (!propAdded) {
                        Element prop;
                        if (count == 1) {
                            prop = new Element("Child1PropertyIncome");
                            prop.addContent("0");
                            root.addContent((Content)prop);
                        } else {
                            prop = new Element("ChildPropertyIncome");
                            prop.addContent("0");
                            root.addContent((Content)prop);
                        }
                    }
                    if (otherAdded) continue;
                    if (count == 1) {
                        other = new Element("Child1OtherIncome");
                        other.addContent("0");
                        root.addContent((Content)other);
                        continue;
                    }
                    other = new Element("ChildOtherIncome");
                    other.addContent("0");
                    root.addContent((Content)other);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA child financials", (Throwable)ex);
        }
    }

    private void setSpouseFinancials(Element root, FinancialsInfo fin) {
        if (fin == null || fin.getFinancialStatement() == null) {
            return;
        }
        try {
            if (fin.getFinancialStatement().getSpouseFinancialsList() != null && fin.getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials() != null && fin.getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials().get(0) != null) {
                Boolean isContrib;
                SpouseInfo spouseInfo = fin.getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials().get(0).getSpouse();
                SpouseFinancialsInfo spouseFins = fin.getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials().get(0);
                if (spouseInfo != null) {
                    Element spLname = new Element("SpouseNameLast");
                    spLname.addContent(spouseInfo.getFamilyName());
                    root.addContent((Content)spLname);
                    Element spFname = new Element("SpouseNameFirst");
                    spFname.addContent(spouseInfo.getGivenName());
                    root.addContent((Content)spFname);
                    if (spouseInfo.getMiddleName() != null) {
                        Element spMname = new Element("SpouseNameMiddle");
                        spMname.addContent(spouseInfo.getMiddleName());
                        root.addContent((Content)spMname);
                    }
                    if (spouseInfo.getSuffix() != null) {
                        Element spSuf = new Element("SpouseNameSuffix");
                        spSuf.addContent(spouseInfo.getSuffix());
                        root.addContent((Content)spSuf);
                    }
                    if (spouseInfo.getMaidenName() != null) {
                        Element spMn = new Element("SpouseMaidenName");
                        spMn.addContent(spouseInfo.getMaidenName());
                        root.addContent((Content)spMn);
                    }
                    if (spouseInfo.getSsns() != null && spouseInfo.getSsns().getSsn() != null && spouseInfo.getSsns().getSsn().get(0) != null) {
                        String ssnText = spouseInfo.getSsns().getSsn().get(0).getSsnText();
                        String formattedSSN = String.format("%s-%s-%s", ssnText.substring(0, 3), ssnText.substring(3, 5), ssnText.substring(5, 9));
                        Element spSsn = new Element("SpouseSocialSecurityNumber");
                        spSsn.addContent(formattedSSN);
                        root.addContent((Content)spSsn);
                    }
                    Element spDob = new Element("SpouseDateOfBirth");
                    spDob.addContent(spouseInfo.getDob());
                    root.addContent((Content)spDob);
                    AddressInfo spAddress = spouseInfo.getAddress();
                    Element line1 = new Element("SpouseAddress");
                    line1.addContent(spAddress.getLine1());
                    root.addContent((Content)line1);
                    Element cityCountry = new Element("SpouseCity");
                    String city = "";
                    city = spAddress.getCountry().equalsIgnoreCase("USA") ? spAddress.getCity() : spAddress.getCity() + ", " + spAddress.getCountry();
                    if (city.length() > 30) {
                        city = city.substring(0, 30);
                    }
                    cityCountry.addContent(city);
                    root.addContent((Content)cityCountry);
                    Element state = new Element("SpouseState");
                    if (spAddress.getCountry().equalsIgnoreCase("USA")) {
                        String st = spAddress.getState();
                        if (st != null && st.length() > 2) {
                            st = st.substring(0, 2);
                        }
                        state.addContent(st);
                    } else {
                        state.addContent("FG");
                    }
                    root.addContent((Content)state);
                    Element zip = new Element("SpouseZip");
                    if (spAddress.getCountry().equalsIgnoreCase("USA")) {
                        zip.addContent(spAddress.getZipCode());
                    } else {
                        zip.addContent(spAddress.getPostalCode());
                    }
                    root.addContent((Content)zip);
                    if (spAddress.getPhoneNumber() != null) {
                        Element spPhone = new Element("SpousePhone");
                        String num = String.format("(%s) %s-%s", spAddress.getPhoneNumber().substring(0, 3), spAddress.getPhoneNumber().substring(3, 6), spAddress.getPhoneNumber().substring(6, 10));
                        spPhone.addContent(num);
                        root.addContent((Content)spPhone);
                    }
                    Element marrDate = new Element("MarraigeDate");
                    marrDate.addContent(spouseInfo.getStartDate());
                    root.addContent((Content)marrDate);
                }
                if (spouseFins != null && spouseFins.getIncomes() != null && spouseFins.getIncomes().getIncome() != null) {
                    List<IncomeInfo> spouseIncomes = spouseFins.getIncomes().getIncome();
                    Iterator<IncomeInfo> finsIter = spouseIncomes.iterator();
                    boolean grossAdded = false;
                    boolean propAdded = false;
                    boolean otherAdded = false;
                    while (finsIter.hasNext()) {
                        IncomeInfo income = finsIter.next();
                        if (income.getType().equalsIgnoreCase("7")) {
                            Element spGrossIncome = new Element("SpouseGrossIncome");
                            spGrossIncome.addContent(income.getAmount().toString());
                            root.addContent((Content)spGrossIncome);
                            grossAdded = true;
                        }
                        if (income.getType().equalsIgnoreCase("13")) {
                            Element spPropIncome = new Element("SpousePropertyIncome");
                            spPropIncome.addContent(income.getAmount().toString());
                            root.addContent((Content)spPropIncome);
                            propAdded = true;
                        }
                        if (!income.getType().equalsIgnoreCase("10")) continue;
                        Element spOtherIncome = new Element("SpouseOtherIncome");
                        spOtherIncome.addContent(income.getAmount().toString());
                        root.addContent((Content)spOtherIncome);
                        otherAdded = true;
                    }
                    if (!grossAdded) {
                        Element spGrossIncome = new Element("SpouseGrossIncome");
                        spGrossIncome.addContent("0");
                        root.addContent((Content)spGrossIncome);
                    }
                    if (!propAdded) {
                        Element spPropIncome = new Element("SpousePropertyIncome");
                        spPropIncome.addContent("0");
                        root.addContent((Content)spPropIncome);
                    }
                    if (!otherAdded) {
                        Element spOtherIncome = new Element("SpouseOtherIncome");
                        spOtherIncome.addContent("0");
                        root.addContent((Content)spOtherIncome);
                    }
                }
                if (spouseFins.isContributedToSpousalSupport() != null && (isContrib = spouseFins.isContributedToSpousalSupport()).booleanValue()) {
                    Element contrib = new Element("SpouseSupportAmount");
                    contrib.addContent("600.00");
                    root.addContent((Content)contrib);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA financials", (Throwable)ex);
        }
    }

    private void setInsurance(Element root, InsuranceCollection insurance) {
        try {
            List<InsuranceInfo> insList;
            if (insurance != null && (insList = insurance.getInsurance()) != null) {
                for (InsuranceInfo ins : insList) {
                    Boolean isEnrolledInPartA;
                    if (ins == null) continue;
                    if (ins.getInsuranceMappingTypeName().equalsIgnoreCase("MDCR") && ins.isEnrolledInPartA() != null && (isEnrolledInPartA = ins.isEnrolledInPartA()).booleanValue()) {
                        Element medA = new Element("MedicareEnrolledA");
                        medA.addContent("Y");
                        root.addContent((Content)medA);
                        Element medADate = new Element("DateMedicarePartA");
                        medADate.addContent(ins.getPartAEffectiveDate());
                        root.addContent((Content)medADate);
                    }
                    Element vetIns = new Element("VetHealthInsurance");
                    vetIns.addContent("Y");
                    root.addContent((Content)vetIns);
                    Element vetInsCo = new Element("VetHealthInsureCompany");
                    vetInsCo.addContent(ins.getCompanyName());
                    root.addContent((Content)vetInsCo);
                    Element vetInsHolder = new Element("VetHealthPolicyHolder");
                    vetInsHolder.addContent(ins.getPolicyHolderName());
                    root.addContent((Content)vetInsHolder);
                    Element vetInsNumber = new Element("VetHealthPolicyNumber");
                    vetInsNumber.addContent(ins.getPolicyNumber());
                    root.addContent((Content)vetInsNumber);
                    Element vetInsGroup = new Element("VetHealthGroupCode");
                    vetInsGroup.addContent(ins.getGroupNumber());
                    root.addContent((Content)vetInsGroup);
                    if (ins.getInsAddress() != null) {
                        Element vetInsLine1 = new Element("VetHealthInsureAddress");
                        vetInsLine1.addContent(ins.getInsAddress().getLine1());
                        root.addContent((Content)vetInsLine1);
                        Element vetInsCity = new Element("VetHealthInsureCity");
                        String insCity = "";
                        insCity = ins.getInsAddress().getCountry().equalsIgnoreCase("USA") ? ins.getInsAddress().getCity() : ins.getInsAddress().getCity() + ", " + ins.getInsAddress().getCountry();
                        vetInsCity.addContent(insCity);
                        root.addContent((Content)vetInsCity);
                        Element vetInsState = new Element("VetHealthInsureState");
                        if (ins.getInsAddress().getCountry().equalsIgnoreCase("USA")) {
                            vetInsState.addContent(ins.getInsAddress().getState());
                        } else {
                            vetInsState.addContent("FG");
                        }
                        root.addContent((Content)vetInsState);
                        Element vetInsZip = new Element("VetHealthInsureZip");
                        if (ins.getInsAddress().getCountry().equalsIgnoreCase("USA")) {
                            vetInsZip.addContent(ins.getInsAddress().getZipCode());
                        } else {
                            vetInsZip.addContent(ins.getInsAddress().getPostalCode());
                        }
                        root.addContent((Content)vetInsZip);
                    }
                    Element vetInsPhone = new Element("VetHealthInsurePhone");
                    if (ins.getInsurancePhones() == null || ins.getInsurancePhones().getPhone() == null || ins.getInsurancePhones().getPhone().get(0) == null) continue;
                    vetInsPhone.addContent(ins.getInsurancePhones().getPhone().get(0).getPhoneNumber());
                    root.addContent((Content)vetInsPhone);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA Insurance", (Throwable)ex);
        }
    }

    private void setSpecialFactors(Element root, EeSummary summary) {
        try {
            Boolean isPh;
            if (summary.getPurpleHeart() != null && summary.getPurpleHeart().isIndicator() != null && (isPh = summary.getPurpleHeart().isIndicator()).booleanValue()) {
                Element ph = new Element("PurpleHeart");
                ph.addContent("Y");
                root.addContent((Content)ph);
            }
            if (summary.getPrisonerOfWarInfo() != null) {
                Element pow = new Element("FormerPOW");
                if (summary.getPrisonerOfWarInfo().getPowIndicator().equalsIgnoreCase("True")) {
                    pow.addContent("Y");
                } else {
                    pow.addContent("N");
                }
                root.addContent((Content)pow);
            }
            if (summary.getEnrollmentDeterminationInfo().getSpecialFactors().isEnvContaminantsInd().booleanValue()) {
                Element toxin = new Element("GulfWarToxinExposure");
                toxin.addContent("Y");
                root.addContent((Content)toxin);
            }
            if (summary.getEnrollmentDeterminationInfo().getSpecialFactors().isAgentOrangeInd().booleanValue()) {
                Element aoe = new Element("AgentOrangeExposure");
                aoe.addContent("Y");
                root.addContent((Content)aoe);
            }
            if (summary.getEnrollmentDeterminationInfo().getSpecialFactors().isRadiationExposureInd().booleanValue()) {
                Element rad = new Element("RadiationExposure");
                rad.addContent("Y");
                root.addContent((Content)rad);
            }
            if (summary.getEnrollmentDeterminationInfo().getNoseThroatRadiumInfo() != null && summary.getEnrollmentDeterminationInfo().getNoseThroatRadiumInfo().getReceivingTreatment().equalsIgnoreCase("True")) {
                Element radium = new Element("MilitaryRadiumTreatments");
                radium.addContent("Y");
                root.addContent((Content)radium);
            }
            if (summary.getEnrollmentDeterminationInfo().isEligibleForMedicaid().booleanValue()) {
                Element medicaid = new Element("MedicaidEligible");
                medicaid.addContent("Y");
                root.addContent((Content)medicaid);
            }
            if (summary.getEnrollmentDeterminationInfo().getSpecialFactors().isCampLejeuneInd().booleanValue()) {
                Element clv = new Element("CampLejeune");
                clv.addContent("Y");
                root.addContent((Content)clv);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA special factors", (Throwable)ex);
        }
    }

    private void setMilitaryService(Element root, MilitaryServiceInfo milSvc) {
        try {
            MilitaryServiceSiteRecordInfo lastEpisode;
            Boolean dis;
            if (milSvc != null && milSvc.isDischargeDueToDisability() != null && (dis = milSvc.isDischargeDueToDisability()).booleanValue()) {
                Element sca = new Element("RetiredMilitaryDisability");
                sca.addContent("Y");
                root.addContent((Content)sca);
            }
            if (milSvc.getMilitaryServiceSiteRecords() != null && milSvc.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord() != null && milSvc.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord().get(0) != null && (lastEpisode = milSvc.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord().get(0)).getMilitaryServiceEpisodes() != null && lastEpisode.getMilitaryServiceEpisodes().getMilitaryServiceEpisode() != null && lastEpisode.getMilitaryServiceEpisodes().getMilitaryServiceEpisode().get(0) != null) {
                MilitaryServiceEpisodeInfo episode = lastEpisode.getMilitaryServiceEpisodes().getMilitaryServiceEpisode().get(0);
                if (episode.getServiceBranch() != null) {
                    ServiceBranch sb = this.typesHelper.getServiceBranch(episode.getServiceBranch());
                    Element branch = new Element("LastServiceBranch");
                    branch.addContent(sb.getDescription());
                    root.addContent((Content)branch);
                }
                Element start = new Element("LastEntryDate");
                start.addContent(episode.getStartDate());
                root.addContent((Content)start);
                Element end = new Element("LastDischargeDate");
                end.addContent(episode.getEndDate());
                root.addContent((Content)end);
                if (episode.getDischargeType() != null) {
                    DischargeType dt = this.typesHelper.getDischargeType(episode.getDischargeType());
                    Element type = new Element("DischargeType");
                    type.addContent(dt.getDescription());
                    root.addContent((Content)type);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA Military Service", (Throwable)ex);
        }
    }

    private void setDemographics(Element root, DemographicInfo demoInfo, boolean isProd) {
        try {
            Boolean isAppt;
            Element spanish = new Element("Spanish");
            if (demoInfo.getEthnicity() != null) {
                if (demoInfo.getEthnicity().equalsIgnoreCase("2135-2")) {
                    spanish.addContent("Y");
                } else if (demoInfo.getEthnicity().equalsIgnoreCase("2186-5")) {
                    spanish.addContent("N");
                } else {
                    spanish.addContent("U");
                }
            } else {
                spanish.addContent("U");
            }
            root.addContent((Content)spanish);
            boolean hasRaces = false;
            List<String> races = null;
            if (demoInfo.getRaces() != null && demoInfo.getRaces().getRace() != null && demoInfo.getRaces().getRace().size() > 0) {
                hasRaces = true;
                races = demoInfo.getRaces().getRace();
            }
            Element race1 = new Element("Race1");
            if (hasRaces && this.isRace("1002-5", races)) {
                race1.addContent("1");
            } else {
                race1.addContent("0");
            }
            root.addContent((Content)race1);
            Element race2 = new Element("Race2");
            if (hasRaces && this.isRace("2054-5", races)) {
                race2.addContent("1");
            } else {
                race2.addContent("0");
            }
            root.addContent((Content)race2);
            Element race3 = new Element("Race3");
            if (hasRaces && this.isRace("2028-9", races)) {
                race3.addContent("1");
            } else {
                race3.addContent("0");
            }
            root.addContent((Content)race3);
            Element race4 = new Element("Race4");
            if (hasRaces && this.isRace("2106-3", races)) {
                race4.addContent("1");
            } else {
                race4.addContent("0");
            }
            root.addContent((Content)race4);
            Element race5 = new Element("Race5");
            if (hasRaces && this.isRace("2076-8", races)) {
                race5.addContent("1");
            } else {
                race5.addContent("0");
            }
            root.addContent((Content)race5);
            if (demoInfo.getContactInfo() != null && demoInfo.getContactInfo().getAddresses() != null && demoInfo.getContactInfo().getAddresses().getAddress() != null && demoInfo.getContactInfo().getAddresses().getAddress().get(0) != null) {
                AddressInfo address = demoInfo.getContactInfo().getAddresses().getAddress().get(0);
                Element line1 = new Element("CurrentAddress");
                line1.addContent(address.getLine1());
                root.addContent((Content)line1);
                Element cityCountry = new Element("CurrentCity");
                String city = "";
                city = address.getCountry().equalsIgnoreCase("USA") ? address.getCity() : address.getCity() + ", " + address.getCountry();
                if (city.length() > 30) {
                    city = city.substring(0, 30);
                }
                cityCountry.addContent(city);
                root.addContent((Content)cityCountry);
                Element state = new Element("CurrentState");
                if (address.getCountry().equalsIgnoreCase("USA")) {
                    String st = address.getState();
                    if (st != null && st.length() > 2) {
                        st = st.substring(0, 2);
                    }
                    state.addContent(st);
                } else {
                    state.addContent("FG");
                }
                root.addContent((Content)state);
                Element zip = new Element("CurrentZip");
                if (address.getCountry().equalsIgnoreCase("USA")) {
                    zip.addContent(address.getZipCode());
                } else {
                    zip.addContent(address.getPostalCode());
                }
                root.addContent((Content)zip);
                if (address.getCounty() != null) {
                    Element county = new Element("CurrentCounty");
                    county.addContent(address.getCounty());
                    root.addContent((Content)county);
                }
            }
            if (demoInfo.getContactInfo() != null && demoInfo.getContactInfo().getPhones() != null && demoInfo.getContactInfo().getPhones().getPhone() != null) {
                List<PhoneInfo> phones = demoInfo.getContactInfo().getPhones().getPhone();
                Iterator<PhoneInfo> phoneIter = phones.iterator();
                boolean homeSet = false;
                boolean cellSet = false;
                while (phoneIter.hasNext()) {
                    String num;
                    PhoneInfo pi = phoneIter.next();
                    if (!homeSet && pi.getType().equalsIgnoreCase("1")) {
                        Element homePhone = new Element("CurrentHomePhone");
                        num = String.format("(%s) %s-%s", pi.getPhoneNumber().substring(0, 3), pi.getPhoneNumber().substring(3, 6), pi.getPhoneNumber().substring(6, 10));
                        homePhone.addContent(num);
                        root.addContent((Content)homePhone);
                        homeSet = true;
                    }
                    if (cellSet || !pi.getType().equalsIgnoreCase("4")) continue;
                    Element cellPhone = new Element("CellPhone");
                    num = String.format("(%s) %s-%s", pi.getPhoneNumber().substring(0, 3), pi.getPhoneNumber().substring(3, 6), pi.getPhoneNumber().substring(6, 10));
                    cellPhone.addContent(num);
                    root.addContent((Content)cellPhone);
                    cellSet = true;
                }
            }
            if (demoInfo.getContactInfo() != null && demoInfo.getContactInfo().getEmails() != null && demoInfo.getContactInfo().getEmails().getEmail() != null && demoInfo.getContactInfo().getEmails().getEmail().get(0) != null) {
                EmailInfo emailInfo = demoInfo.getContactInfo().getEmails().getEmail().get(0);
                Element email = new Element("Email");
                email.addContent(emailInfo.getAddress());
                root.addContent((Content)email);
            }
            if (demoInfo.isAppointmentRequestResponse() != null && (isAppt = demoInfo.isAppointmentRequestResponse()).booleanValue()) {
                Element appt = new Element("Appointment");
                appt.addContent("Y");
                root.addContent((Content)appt);
            }
            Element aca = new Element("ACA");
            if (demoInfo.isAcaIndicator() != null) {
                Boolean isACA = demoInfo.isAcaIndicator();
                if (isACA.booleanValue()) {
                    aca.addContent("Y");
                } else {
                    aca.addContent("N");
                }
            } else {
                aca.addContent("N");
            }
            root.addContent((Content)aca);
            if (demoInfo.getMaritalStatus() != null) {
                Element marStatus = new Element("CurrentMaritalStatus");
                if (demoInfo.getMaritalStatus().equalsIgnoreCase("M")) {
                    marStatus.addContent("MARRIED");
                } else if (demoInfo.getMaritalStatus().equalsIgnoreCase("S")) {
                    marStatus.addContent("NEVER MARRIED");
                } else if (demoInfo.getMaritalStatus().equalsIgnoreCase("L")) {
                    marStatus.addContent("SEPARATED");
                } else if (demoInfo.getMaritalStatus().equalsIgnoreCase("W")) {
                    marStatus.addContent("WIDOWED");
                } else if (demoInfo.getMaritalStatus().equalsIgnoreCase("D")) {
                    marStatus.addContent("DIVORCED");
                }
                root.addContent((Content)marStatus);
            }
            Element facility = new Element("MedCenter");
            if (!isProd) {
                facility.addContent("999");
            } else {
                facility.addContent(demoInfo.getPreferredFacility());
            }
            root.addContent((Content)facility);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA Demographics", (Throwable)ex);
        }
    }

    private boolean isRace(String race, List<String> races) {
        for (String racestring : races) {
            if (!racestring.equalsIgnoreCase(race)) continue;
            return true;
        }
        return false;
    }

    private void setSid(Element root, String sid) {
        try {
            Element submitId = new Element("SID");
            submitId.addContent(sid);
            root.addContent((Content)submitId);
            Element resendId = new Element("Resend");
            resendId.addContent("N");
            root.addContent((Content)resendId);
            Element confirm = new Element("Confirm");
            confirm.addContent("VAToPrint");
            root.addContent((Content)confirm);
            Element version = new Element("formVersion");
            version.addContent("19");
            root.addContent((Content)version);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA SID", (Throwable)ex);
        }
    }

    private void setPersonInfo(Element root, PersonInfo personInfo) {
        try {
            Element lName = new Element("VetNameLast");
            lName.addContent(personInfo.getLastName());
            root.addContent((Content)lName);
            Element fName = new Element("VetNameFirst");
            fName.addContent(personInfo.getFirstName());
            root.addContent((Content)fName);
            Element mName = new Element("VetNameMiddle");
            mName.addContent(personInfo.getMiddleName());
            root.addContent((Content)mName);
            if (personInfo.getSuffix() != null) {
                Element nameSuffix = new Element("VetNameSuffix");
                nameSuffix.addContent(personInfo.getSuffix());
                root.addContent((Content)nameSuffix);
            }
            Element maidenName = new Element("MotherMaidenName");
            String mmn = personInfo.getMothersMaidenName();
            if (mmn != null && mmn.length() > 35) {
                mmn = mmn.substring(0, 35);
            }
            maidenName.addContent(mmn);
            root.addContent((Content)maidenName);
            Element gender = new Element("Gender");
            gender.addContent(personInfo.getGender());
            root.addContent((Content)gender);
            Element ssn = new Element("VetSocialSecurityNumber");
            String vetSSN = String.format("%s-%s-%s", personInfo.getSsnText().substring(0, 3), personInfo.getSsnText().substring(3, 5), personInfo.getSsnText().substring(5, 9));
            ssn.addContent(vetSSN);
            root.addContent((Content)ssn);
            Element dob = new Element("DateOfBirth");
            dob.addContent(personInfo.getDob());
            root.addContent((Content)dob);
            Element birthCity = new Element("PlaceOfBirthCity");
            String pobCity = personInfo.getPlaceOfBirthCity();
            if (pobCity != null && pobCity.length() > 20) {
                pobCity = pobCity.substring(0, 20);
            }
            birthCity.addContent(pobCity);
            root.addContent((Content)birthCity);
            Element birthState = new Element("PlaceOfBirthState");
            String pobState = personInfo.getPlaceOfBirthState();
            if (pobState != null && pobState.length() > 2) {
                pobState = pobState.substring(0, 2);
            }
            birthState.addContent(pobState);
            root.addContent((Content)birthState);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unknown error translating VOA PersonInfo", (Throwable)ex);
        }
    }
}

