/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.voa.webservice.CombatEpisodeInfo;
import gov.va.med.esr.voa.webservice.ConflictExperienceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceSiteRecordInfo;
import gov.va.med.esr.voa.webservice.PrisonerOfWarInfo;
import gov.va.med.esr.voa.webservice.PurpleHeartInfo;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.builder.MilitaryServiceBuilderFactory;
import gov.va.med.esr.voa.webservice.builder.impl.TypesHelper;
import gov.va.med.fw.service.config.SingletonApplicationContext;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class MilitaryServiceBuilderFactoryImpl
implements MilitaryServiceBuilderFactory {
    private LookupService lookupService = null;
    private TypesHelper typesHelper = new TypesHelper();

    @Override
    public void buildMilitaryServices(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getSummary().getMilitaryServiceInfo() != null) {
            MilitaryServiceInfo msInfo;
            MilitaryService militaryService = person.getMilitaryService();
            if (militaryService == null) {
                militaryService = new MilitaryService();
            }
            if ((msInfo = submitFormRequest.getForm().getSummary().getMilitaryServiceInfo()) != null) {
                if (msInfo.isDisabilityRetirementIndicator() != null) {
                    militaryService.setDisabilityRetirementIndicator(msInfo.isDisabilityRetirementIndicator());
                }
                if (msInfo.isDischargeDueToDisability() != null) {
                    militaryService.setDischargeDueToDisability(msInfo.isDischargeDueToDisability());
                }
                if (msInfo.getCombatEpisodes() != null && msInfo.getCombatEpisodes().getCombatEpisode() != null) {
                    this.getCombatEpisodes(msInfo.getCombatEpisodes().getCombatEpisode(), militaryService);
                }
                if (msInfo.getMilitaryServiceSiteRecords() != null && msInfo.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord() != null) {
                    this.getMilitaryService(msInfo.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord(), militaryService);
                }
                person.setMilitaryService(militaryService);
            }
        }
        if (submitFormRequest.getForm().getSummary().getPrisonerOfWarInfo() != null) {
            this.getPOWInfo(person, submitFormRequest);
        }
        if (submitFormRequest.getForm().getSummary().getPurpleHeart() != null) {
            this.getPurpleHeartInfo(person, submitFormRequest);
        }
    }

    private void getCombatEpisodes(List<CombatEpisodeInfo> combatList, MilitaryService militaryService) {
        if (combatList != null) {
            for (CombatEpisodeInfo combatInfo : combatList) {
                CombatEpisode ce = new CombatEpisode();
                if (combatInfo.getEndDate() != null && !combatInfo.getEndDate().isEmpty()) {
                    ce.setEndDate(new ImpreciseDate(combatInfo.getEndDate()));
                }
                if (combatInfo.getStartDate() != null && !combatInfo.getStartDate().isEmpty()) {
                    ce.setStartDate(new ImpreciseDate(combatInfo.getStartDate()));
                }
                militaryService.addCombatEpisode(ce);
            }
        }
    }

    private MilitaryService getMilitaryService(List<MilitaryServiceSiteRecordInfo> msList, MilitaryService militaryService) {
        if (msList != null) {
            for (MilitaryServiceSiteRecordInfo mrInfo : msList) {
                MilitaryServiceSiteRecord mr = new MilitaryServiceSiteRecord();
                if (mrInfo.getSite() != null) {
                    mr.setSite(this.typesHelper.getVAFacility(mrInfo.getSite()));
                }
                if (mrInfo.getServicePeriod() != null) {
                    mr.setServicePeriod(this.typesHelper.getServicePeriod(mrInfo.getServicePeriod()));
                }
                if (mrInfo.getMilitaryServiceEpisodes() != null && mrInfo.getMilitaryServiceEpisodes().getMilitaryServiceEpisode() != null) {
                    this.getMSEpisodes(mrInfo.getMilitaryServiceEpisodes().getMilitaryServiceEpisode(), mr);
                }
                if (mrInfo.getConflictExperiences() != null && mrInfo.getConflictExperiences().getConflictExperience() != null) {
                    this.getConflictExperiences(mrInfo.getConflictExperiences().getConflictExperience(), mr);
                }
                if (mr == null) continue;
                militaryService.addMilitaryServiceSiteRecord(mr);
            }
        }
        return militaryService;
    }

    private void getMSEpisodes(List<MilitaryServiceEpisodeInfo> mseList, MilitaryServiceSiteRecord mr) {
        for (MilitaryServiceEpisodeInfo mseInfo : mseList) {
            MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
            if (mseInfo.getDischargeType() != null) {
                mse.setDischargeType(this.typesHelper.getDischargeType(mseInfo.getDischargeType()));
            }
            if (mseInfo.getServiceBranch() != null) {
                mse.setServiceBranch(this.typesHelper.getServiceBranch(mseInfo.getServiceBranch()));
            }
            if (mseInfo.getStartDate() != null && !mseInfo.getStartDate().isEmpty()) {
                mse.setStartDate(new ImpreciseDate(mseInfo.getStartDate()));
            }
            if (mseInfo.getEndDate() != null && !mseInfo.getEndDate().isEmpty()) {
                mse.setEndDate(new ImpreciseDate(mseInfo.getEndDate()));
            }
            mr.addMilitaryServiceEpisode(mse);
        }
    }

    private void getConflictExperiences(List<ConflictExperienceInfo> confList, MilitaryServiceSiteRecord mr) {
        for (ConflictExperienceInfo confInfo : confList) {
            ConflictExperience conflict = new ConflictExperience();
            if (confInfo.getStartDate() != null && !confInfo.getStartDate().isEmpty()) {
                conflict.setStartDate(new ImpreciseDate(confInfo.getStartDate()));
            }
            if (confInfo.getEndDate() != null && !confInfo.getEndDate().isEmpty()) {
                conflict.setEndDate(new ImpreciseDate(confInfo.getEndDate()));
            }
            if (confInfo.getConflictLocation() != null) {
                conflict.setConflictLocation(this.typesHelper.getConflictLocation(confInfo.getConflictLocation()));
            }
            mr.addConflictExperience(conflict);
        }
    }

    private void getPOWInfo(Person person, SubmitFormRequest submitFormRequest) {
        PrisonerOfWarInfo powInfo;
        PrisonerOfWar pow = person.getPrisonerOfWar();
        if (pow == null) {
            pow = new PrisonerOfWar();
        }
        if ((powInfo = submitFormRequest.getForm().getSummary().getPrisonerOfWarInfo()).getPowIndicator() != null) {
            try {
                if (powInfo.getPowIndicator() != null && powInfo.getPowIndicator().equalsIgnoreCase("true")) {
                    pow.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
                } else {
                    pow.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
                }
                if (powInfo.getPowIndicator() == null) {
                    pow.setPowIndicator(this.getLookupService().getIndicatorByCode(Indicator.UNKNOWN));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        person.setPrisonerOfWar(pow);
    }

    private void getPurpleHeartInfo(Person person, SubmitFormRequest submitFormRequest) {
        PurpleHeartInfo phInfo;
        PurpleHeart ph = person.getPurpleHeart();
        if (ph == null) {
            ph = new PurpleHeart();
        }
        if ((phInfo = submitFormRequest.getForm().getSummary().getPurpleHeart()).isIndicator() != null && phInfo.isIndicator().booleanValue()) {
            ph.setPhIndicator(Boolean.TRUE);
        } else {
            ph.setPhIndicator(Boolean.FALSE);
        }
        person.setPurpleHeart(ph);
    }

    private Date getDateXMLtoJava(XMLGregorianCalendar xdate) {
        Date date = null;
        if (xdate != null) {
            date = new Date(xdate.getMillisecond());
        }
        return date;
    }

    public LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = (LookupService)SingletonApplicationContext.getInstance().getSingletonContext().getBean("lookupService");
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

