/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.service.VOAApplicationService;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.AssetInfo;
import gov.va.med.esr.voa.webservice.AuthenticationLevel;
import gov.va.med.esr.voa.webservice.DependentFinancialsInfo;
import gov.va.med.esr.voa.webservice.DependentInfo;
import gov.va.med.esr.voa.webservice.ExpenseInfo;
import gov.va.med.esr.voa.webservice.FinancialStatementInfo;
import gov.va.med.esr.voa.webservice.FinancialsInfo;
import gov.va.med.esr.voa.webservice.IncomeInfo;
import gov.va.med.esr.voa.webservice.IncomeTestInfo;
import gov.va.med.esr.voa.webservice.PersonInfo;
import gov.va.med.esr.voa.webservice.SpouseFinancialsInfo;
import gov.va.med.esr.voa.webservice.SpouseInfo;
import gov.va.med.esr.voa.webservice.SsnInfo;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.VeteranIdentifier;
import gov.va.med.esr.voa.webservice.builder.DemographicsBuilderFactory;
import gov.va.med.esr.voa.webservice.builder.FinancialsBuilderFactory;
import gov.va.med.esr.voa.webservice.builder.impl.BuildHelper;
import gov.va.med.esr.voa.webservice.builder.impl.DemographicsBuilderFactoryImpl;
import gov.va.med.esr.voa.webservice.builder.impl.TypesHelper;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class FinancialsBuilderFactoryImpl
extends AbstractComponent
implements FinancialsBuilderFactory {
    private TypesHelper typesHelper = new TypesHelper();
    private BuildHelper buildHelper = new BuildHelper();
    private DemographicsBuilderFactory demographicsBuilderFactory = new DemographicsBuilderFactoryImpl();

    @Override
    public void buildFinancialServices(Person person, SubmitFormRequest submitFormRequest, VOAApplicationService voaApplicationService) {
        this.buildFinancials(person, submitFormRequest, voaApplicationService);
    }

    public void buildFinancials(Person person, SubmitFormRequest submitFormRequest, VOAApplicationService voaApplicationService) {
        if (person != null) {
            this.getIncomeTestInfo(person, submitFormRequest, voaApplicationService);
            this.getFinancialStatement(person, submitFormRequest);
        }
    }

    private void getIncomeTestInfo(Person person, SubmitFormRequest submitFormRequest, VOAApplicationService voaApplicationService) {
        IncomeTestInfo incomeTestInfo;
        IncomeTest currIncomeTest = new IncomeTest();
        FinancialsInfo financialsInfo = submitFormRequest.getForm().getSummary().getFinancialsInfo();
        if (financialsInfo == null) {
            this.logger.info((Object)"incomeTestInfo - isDisclosed = No");
            this.logger.info((Object)"incomeTestInfo - Agrees to pay deductible = Yes");
            VOAApplication voaApplicationDTO = this.getVoaApplicationDTO(submitFormRequest);
            Person incomingPerson = this.demographicsBuilderFactory.getPartialPerson(submitFormRequest);
            Object adrPerson = null;
            if (voaApplicationService == null) {
                adrPerson = null;
            }
            IncomeTest onFileIncomeTest = null;
            if (adrPerson != null) {
                onFileIncomeTest = adrPerson.getIncomeTest(this.typesHelper.getIncomeYear());
            }
            if (adrPerson == null || onFileIncomeTest == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"no income test exists for current income year or person does not exist");
                }
                currIncomeTest.setDiscloseFinancialInformation(Boolean.FALSE);
                currIncomeTest.setAgreesToPayDeductible(Boolean.TRUE);
                currIncomeTest.setSendForAdjudication(Boolean.FALSE);
                currIncomeTest.setSiteConductingTest(this.typesHelper.getVAFacility(VAFacility.CODE_HEC.getCode()));
                currIncomeTest.setSource(this.typesHelper.getIncomeTestSource(IncomeTestSource.CODE_HEC.getCode()));
                Date rightNow = Calendar.getInstance().getTime();
                currIncomeTest.setCompletedDate(rightNow);
                Date applicationDate = null;
                if (person != null && person.getApplication() != null) {
                    applicationDate = person.getApplication().getApplicationDate();
                }
                if (applicationDate != null) {
                    currIncomeTest.setEffectiveDate(applicationDate);
                } else {
                    currIncomeTest.setEffectiveDate(rightNow);
                }
                currIncomeTest.setIncomeYear(this.typesHelper.getIncomeYear());
                person.setIncomeTest(this.typesHelper.getIncomeYear(), currIncomeTest);
            }
        } else if (submitFormRequest.getForm().getSummary().getFinancialsInfo().getIncomeTest() != null && (incomeTestInfo = submitFormRequest.getForm().getSummary().getFinancialsInfo().getIncomeTest()) != null) {
            currIncomeTest.setDiscloseFinancialInformation(Boolean.TRUE);
            currIncomeTest.setAgreesToPayDeductible(Boolean.TRUE);
            currIncomeTest.setSendForAdjudication(Boolean.FALSE);
            if (incomeTestInfo.getTotalIncome() != null) {
                currIncomeTest.setTotalIncome(incomeTestInfo.getTotalIncome());
            }
            if (incomeTestInfo.getNetIncome() != null) {
                currIncomeTest.setNetIncome(incomeTestInfo.getNetIncome());
            }
            if (incomeTestInfo.getIncomeYear() != null) {
                currIncomeTest.setIncomeYear(incomeTestInfo.getIncomeYear());
                person.setIncomeTest(incomeTestInfo.getIncomeYear(), currIncomeTest);
            } else {
                currIncomeTest.setIncomeYear(this.typesHelper.getIncomeYear());
                person.setIncomeTest(this.typesHelper.getIncomeYear(), currIncomeTest);
            }
        }
    }

    private void getFinancialStatement(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getSummary().getFinancialsInfo() != null && submitFormRequest.getForm().getSummary().getFinancialsInfo().getFinancialStatement() != null) {
            FinancialStatementInfo fStatementInfo = submitFormRequest.getForm().getSummary().getFinancialsInfo().getFinancialStatement();
            FinancialStatement statement = new FinancialStatement();
            if (fStatementInfo != null) {
                List<ExpenseInfo> expenseList;
                List<AssetInfo> assetList;
                List<IncomeInfo> incomeList;
                if (fStatementInfo.isMarriedLastCalendarYear() != null) {
                    statement.setMarriedLastCalendarYear(fStatementInfo.isMarriedLastCalendarYear());
                }
                if (fStatementInfo.getNumberOfDependentChildren() != null) {
                    statement.setNumberOfDependentChildren(fStatementInfo.getNumberOfDependentChildren());
                }
                if (fStatementInfo.isContributedToSpouse() != null) {
                    statement.setContributedToSpouseInd(fStatementInfo.isContributedToSpouse());
                }
                this.getDependentFinInfo(statement, fStatementInfo);
                if (fStatementInfo.getIncomes() != null && fStatementInfo.getIncomes().getIncome() != null && (incomeList = fStatementInfo.getIncomes().getIncome()) != null) {
                    for (IncomeInfo incomeinfo : incomeList) {
                        if (incomeinfo == null || incomeinfo.getType() == null) continue;
                        Income income = this.buildHelper.buildIncomeInfo(incomeinfo);
                        statement.addIncome(this.typesHelper.getIncomeType(incomeinfo.getType()), income);
                    }
                }
                if (fStatementInfo.getAssets() != null && fStatementInfo.getAssets().getAsset() != null && (assetList = fStatementInfo.getAssets().getAsset()) != null) {
                    for (AssetInfo assetInfo : assetList) {
                        if (assetInfo == null || assetInfo.getAssetType() == null) continue;
                        Asset asset = this.buildHelper.buildAssetInfo(assetInfo);
                        statement.addAsset(this.typesHelper.getAssetType(assetInfo.getAssetType()), asset);
                    }
                }
                if (fStatementInfo.getExpenses() != null && fStatementInfo.getExpenses().getExpense() != null && (expenseList = fStatementInfo.getExpenses().getExpense()) != null) {
                    for (ExpenseInfo expenseInfo : expenseList) {
                        if (expenseInfo == null) continue;
                        Expense expense = this.buildHelper.buildExpenseInfo(expenseInfo);
                        statement.addExpense(this.typesHelper.getExpenseType(expenseInfo.getExpenseType()), expense);
                    }
                }
                Integer incomeYear = null;
                incomeYear = fStatementInfo.getIncomeYear() == null ? this.typesHelper.getIncomeYear() : fStatementInfo.getIncomeYear();
                statement.setIncomeYear(incomeYear);
                this.getSpouseFinInfo(statement, fStatementInfo);
            }
            if (fStatementInfo.getIncomeYear() != null) {
                person.setFinancialStatement(fStatementInfo.getIncomeYear(), statement);
            } else {
                person.setFinancialStatement(this.typesHelper.getIncomeYear(), statement);
            }
        } else {
            FinancialStatement statement = new FinancialStatement();
            statement.setIncomeYear(this.typesHelper.getIncomeYear());
            person.setFinancialStatement(this.typesHelper.getIncomeYear(), statement);
        }
    }

    private void getDependentFinInfo(FinancialStatement statement, FinancialStatementInfo fStatementInfo) {
        if (fStatementInfo.getDependentFinancialsList() != null && fStatementInfo.getDependentFinancialsList().getDependentFinancials() != null) {
            Iterator<DependentFinancialsInfo> itr;
            List<DependentFinancialsInfo> dependentFinanList = fStatementInfo.getDependentFinancialsList().getDependentFinancials();
            Iterator<DependentFinancialsInfo> iterator = itr = dependentFinanList != null ? dependentFinanList.iterator() : null;
            while (itr != null && itr.hasNext()) {
                List<ExpenseInfo> expenseList;
                List<AssetInfo> assetList;
                List<IncomeInfo> incomeList;
                DependentFinancialsInfo dependentFinInfo = itr.next();
                DependentFinancials dependentFinancials = new DependentFinancials();
                if (dependentFinInfo != null && dependentFinInfo.getDependentInfo() != null) {
                    dependentFinancials.setReportedOn(this.buildDependent(dependentFinInfo.getDependentInfo()));
                }
                if (dependentFinInfo.isAttendedSchool() != null) {
                    dependentFinancials.setAttendedSchool(dependentFinInfo.isAttendedSchool());
                }
                if (dependentFinInfo.isHasIncome() != null) {
                    dependentFinancials.setHasIncome(dependentFinInfo.isHasIncome());
                }
                if (dependentFinInfo.isContributedToSupport() != null) {
                    dependentFinancials.setContributedToSupport(dependentFinInfo.isContributedToSupport());
                }
                if (dependentFinInfo.isIncapableOfSelfSupport() != null) {
                    dependentFinancials.setIncapableOfSelfSupport(dependentFinInfo.isIncapableOfSelfSupport());
                }
                if (dependentFinInfo.isIncomeAvailableToPatient() != null) {
                    dependentFinancials.setIncomeAvailableToPatient(dependentFinInfo.isIncomeAvailableToPatient());
                }
                if (dependentFinInfo.getIncomes() != null && dependentFinInfo.getIncomes().getIncome() != null && (incomeList = dependentFinInfo.getIncomes().getIncome()) != null) {
                    for (IncomeInfo incomeinfo : incomeList) {
                        if (incomeinfo == null || incomeinfo.getType() == null) continue;
                        Income income = this.buildHelper.buildIncomeInfo(incomeinfo);
                        dependentFinancials.addIncome(this.typesHelper.getIncomeType(incomeinfo.getType()), income);
                    }
                }
                if (dependentFinInfo.getAssets() != null && dependentFinInfo.getAssets().getAsset() != null && (assetList = dependentFinInfo.getAssets().getAsset()) != null) {
                    for (AssetInfo assetInfo : assetList) {
                        if (assetInfo == null || assetInfo.getAssetType() == null) continue;
                        Asset asset = this.buildHelper.buildAssetInfo(assetInfo);
                        dependentFinancials.addAsset(this.typesHelper.getAssetType(assetInfo.getAssetType()), asset);
                    }
                }
                if (dependentFinInfo.getExpenses() != null && dependentFinInfo.getExpenses().getExpense() != null && (expenseList = dependentFinInfo.getExpenses().getExpense()) != null) {
                    for (ExpenseInfo expenseInfo : expenseList) {
                        if (expenseInfo == null) continue;
                        Expense expense = this.buildHelper.buildExpenseInfo(expenseInfo);
                        dependentFinancials.addExpense(this.typesHelper.getExpenseType(expenseInfo.getExpenseType()), expense);
                    }
                }
                if (dependentFinInfo.isLivedWithPatient() != null) {
                    dependentFinancials.setLivedWithPatient(dependentFinInfo.isLivedWithPatient());
                }
                statement.addDependentFinancials(dependentFinancials);
            }
        }
    }

    private void getSpouseFinInfo(FinancialStatement statement, FinancialStatementInfo fStatementInfo) {
        if (fStatementInfo.getSpouseFinancialsList() != null && fStatementInfo.getSpouseFinancialsList().getSpouseFinancials() != null) {
            Iterator<SpouseFinancialsInfo> itr;
            this.logger.info((Object)"Spouse financial info is not null");
            List<SpouseFinancialsInfo> spouseList = fStatementInfo.getSpouseFinancialsList().getSpouseFinancials();
            this.logger.info((Object)("spouse list size is " + spouseList.size()));
            Iterator<SpouseFinancialsInfo> iterator = itr = spouseList != null ? spouseList.iterator() : null;
            while (itr != null && itr.hasNext()) {
                List<ExpenseInfo> expenseList;
                List<AssetInfo> assetList;
                List<IncomeInfo> incomeList;
                SpouseFinancialsInfo spouseFinInfo = itr.next();
                SpouseFinancials spouseFinancials = new SpouseFinancials();
                if (spouseFinInfo.isLivedWithPatient() != null) {
                    spouseFinancials.setLivedWithPatient(spouseFinInfo.isLivedWithPatient());
                }
                if (spouseFinancials.getValidDependent() != null) {
                    spouseFinancials.setValidDependent(spouseFinancials.getValidDependent());
                }
                if (spouseFinInfo.getSpouse() != null) {
                    Spouse spouse = this.buildSpouse(spouseFinInfo.getSpouse());
                    spouseFinancials.setReportedOn(spouse);
                }
                if (spouseFinInfo.getIncomes() != null && spouseFinInfo.getIncomes().getIncome() != null && (incomeList = spouseFinInfo.getIncomes().getIncome()) != null) {
                    for (IncomeInfo incomeinfo : incomeList) {
                        if (incomeinfo == null || incomeinfo.getType() == null) continue;
                        Income income = this.buildHelper.buildIncomeInfo(incomeinfo);
                        spouseFinancials.addIncome(this.typesHelper.getIncomeType(incomeinfo.getType()), income);
                    }
                }
                if (spouseFinInfo.getAssets() != null && spouseFinInfo.getAssets().getAsset() != null && (assetList = spouseFinInfo.getAssets().getAsset()) != null) {
                    for (AssetInfo assetInfo : assetList) {
                        if (assetInfo == null || assetInfo.getAssetType() == null) continue;
                        Asset asset = this.buildHelper.buildAssetInfo(assetInfo);
                        spouseFinancials.addAsset(this.typesHelper.getAssetType(assetInfo.getAssetType()), asset);
                    }
                }
                if (spouseFinInfo.getExpenses() != null && spouseFinInfo.getExpenses().getExpense() != null && (expenseList = spouseFinInfo.getExpenses().getExpense()) != null) {
                    for (ExpenseInfo expenseInfo : expenseList) {
                        if (expenseInfo == null) continue;
                        Expense expense = this.buildHelper.buildExpenseInfo(expenseInfo);
                        spouseFinancials.addExpense(this.typesHelper.getExpenseType(expenseInfo.getExpenseType()), expense);
                    }
                }
                statement.addSpouseFinancials(spouseFinancials);
            }
        }
    }

    public Dependent buildDependent(DependentInfo dependentInfo) {
        Dependent dependent = new Dependent();
        dependent = this.populateDependentInfo(dependent, dependentInfo);
        return dependent;
    }

    private Spouse buildSpouse(SpouseInfo spouseInfo) {
        Spouse spouse = new Spouse();
        spouse = this.populateSpouseInfo(spouse, spouseInfo);
        if (spouseInfo.getAddress() != null) {
            AddressInfo addressInfo = spouseInfo.getAddress();
            Address address = this.buildHelper.buildAddressInfo(addressInfo);
            spouse.setAddress(address);
        }
        return spouse;
    }

    private Dependent populateDependentInfo(Dependent relation, DependentInfo relationInfo) {
        List<SsnInfo> ssnList;
        Name name = new Name();
        if (relationInfo != null) {
            if (relationInfo.getFamilyName() != null) {
                name.setFamilyName(relationInfo.getFamilyName());
            }
            if (relationInfo.getGivenName() != null) {
                name.setGivenName(relationInfo.getGivenName());
            }
            if (relationInfo.getMiddleName() != null) {
                name.setMiddleName(relationInfo.getMiddleName());
            }
            if (relationInfo.getSuffix() != null) {
                name.setSuffix(relationInfo.getSuffix());
            }
            relation.setName(name);
        }
        if (relationInfo.getDob() != null && !relationInfo.getDob().isEmpty()) {
            relation.setDob(new ImpreciseDate(relationInfo.getDob()));
        }
        if (relationInfo.getGender() != null) {
            relation.setGender(this.typesHelper.getGender(relationInfo.getGender()));
        }
        if (relationInfo.getStartDate() != null && !relationInfo.getStartDate().isEmpty()) {
            relation.setStartDate(new ImpreciseDate(relationInfo.getStartDate()));
        }
        if (relationInfo.getRelationship() != null) {
            relation.setRelationship(this.typesHelper.getRelationship(relationInfo.getRelationship()));
        }
        if (relationInfo.getSsns() != null && relationInfo.getSsns().getSsn() != null && (ssnList = relationInfo.getSsns().getSsn()) != null && ssnList.size() > 0) {
            Iterator<SsnInfo> ssnItr;
            Iterator<SsnInfo> iterator = ssnItr = ssnList != null ? ssnList.iterator() : null;
            while (ssnItr != null && ssnItr.hasNext()) {
                SsnInfo ssnInfo = ssnItr.next();
                SSN ssn = new SSN();
                if (ssnInfo.getSsnText() != null) {
                    ssn.setSsnText(ssnInfo.getSsnText());
                    ssn.setType(this.typesHelper.getSSNType(SSNType.CODE_ACTIVE.getCode()));
                }
                relation.addSsn(ssn);
            }
        }
        return relation;
    }

    private Spouse populateSpouseInfo(Spouse relation, SpouseInfo relationInfo) {
        List<SsnInfo> ssnList;
        Name name = new Name();
        if (relationInfo != null) {
            if (relationInfo.getFamilyName() != null) {
                name.setFamilyName(relationInfo.getFamilyName());
            }
            if (relationInfo.getGivenName() != null) {
                name.setGivenName(relationInfo.getGivenName());
            }
            if (relationInfo.getMiddleName() != null) {
                name.setMiddleName(relationInfo.getMiddleName());
            }
            if (relationInfo.getSuffix() != null) {
                name.setSuffix(relationInfo.getSuffix());
            }
            relation.setName(name);
        }
        if (relationInfo.getDob() != null && !relationInfo.getDob().isEmpty()) {
            relation.setDob(new ImpreciseDate(relationInfo.getDob()));
        }
        if (relationInfo.getGender() != null) {
            relation.setGender(this.typesHelper.getGender(relationInfo.getGender()));
        }
        if (relationInfo.getStartDate() != null && !relationInfo.getStartDate().isEmpty()) {
            relation.setStartDate(new ImpreciseDate(relationInfo.getStartDate()));
        }
        if (relationInfo.getRelationship() != null) {
            relation.setRelationship(this.typesHelper.getRelationship(relationInfo.getRelationship()));
        }
        if (relationInfo.getSsns() != null && relationInfo.getSsns().getSsn() != null && (ssnList = relationInfo.getSsns().getSsn()) != null && ssnList.size() > 0) {
            Iterator<SsnInfo> ssnItr;
            Iterator<SsnInfo> iterator = ssnItr = ssnList != null ? ssnList.iterator() : null;
            while (ssnItr != null && ssnItr.hasNext()) {
                SsnInfo ssnInfo = ssnItr.next();
                SSN ssn = new SSN();
                if (ssnInfo.getSsnText() != null) {
                    ssn.setSsnText(ssnInfo.getSsnText());
                    ssn.setType(this.typesHelper.getSSNType(SSNType.CODE_ACTIVE.getCode()));
                }
                relation.addSsn(ssn);
            }
        }
        return relation;
    }

    private VOAApplication getVoaApplicationDTO(SubmitFormRequest submitFormRequest) {
        VeteranIdentifier vid;
        AuthenticationLevel auth;
        PersonInfo personInfo;
        TypesHelper typesHelper = new TypesHelper();
        BuildHelper bh = new BuildHelper();
        VOAApplication voaApp = new VOAApplication();
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getSummary() != null && submitFormRequest.getForm().getSummary().getPersonInfo() != null && (personInfo = submitFormRequest.getForm().getSummary().getPersonInfo()) != null) {
            if (personInfo.getFirstName() != null) {
                voaApp.setFirstName(personInfo.getFirstName());
            }
            if (personInfo.getLastName() != null) {
                voaApp.setLastName(personInfo.getLastName());
            }
            if (personInfo.getMiddleName() != null) {
                voaApp.setMiddleName(personInfo.getMiddleName());
            }
            if (personInfo.getDob() != null) {
                voaApp.setDateOfBirth(bh.stringToDate(personInfo.getDob()));
            }
            if (personInfo.getGender() != null) {
                voaApp.setGender(typesHelper.getGender(personInfo.getGender()));
            }
            if (personInfo.getSsnText() != null) {
                voaApp.setSsn(personInfo.getSsnText());
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility() != null) {
            voaApp.setPreferredFacility(typesHelper.getVAFacility(submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility()));
        }
        if (submitFormRequest.getIdentity() != null && submitFormRequest.getIdentity().getAuthenticationLevel() != null && (auth = submitFormRequest.getIdentity().getAuthenticationLevel()) != null && auth.getType() != null) {
            voaApp.setAuthenticationLevel(typesHelper.getAuthenticationLevel(auth.getType()));
            this.logger.info((Object)("auth level code in convertToVoaApplication(): " + voaApp.getAuthenticationLevel().getCode()));
            this.logger.info((Object)("auth level desc  in convertToVoaApplication(): " + voaApp.getAuthenticationLevel().getDescription()));
        }
        if (submitFormRequest.getIdentity() != null && submitFormRequest.getIdentity().getVeteranIdentifier() != null && (vid = submitFormRequest.getIdentity().getVeteranIdentifier()) != null && vid.getType() != null) {
            voaApp.setFullQualifiedId(vid.getValue());
            voaApp.setIdentityType(typesHelper.getVeteranIdentifierType(vid.getType()));
            this.logger.info((Object)("FQID in convertToVoaApplication(): " + voaApp.getFullQualifiedId()));
            this.logger.info((Object)("FQID Type in convertToVoaApplication(): " + voaApp.getIdentityType().getCode()));
        }
        if (submitFormRequest.getForm() != null && submitFormRequest.getForm().getFormIdentifier() != null && submitFormRequest.getForm().getFormIdentifier().getType() != null) {
            voaApp.setFormType(typesHelper.getVOAFormType(submitFormRequest.getForm().getFormIdentifier().getType()));
        }
        return voaApp;
    }
}

