/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.SpinalCordInjuryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.voa.webservice.EligibilityVerificationInfo;
import gov.va.med.esr.voa.webservice.NoseThroatRadiumInfo;
import gov.va.med.esr.voa.webservice.ServiceConnectionAwardInfo;
import gov.va.med.esr.voa.webservice.SpinalCordInjuryInfo;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.builder.EnrollmentDeterminationBuilderFactory;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.config.SingletonApplicationContext;
import java.util.Date;
import java.util.Set;

public class EnrollmentDeterminationBuilderFactoryImpl
extends AbstractComponent
implements EnrollmentDeterminationBuilderFactory {
    private LookupService lookupService = null;

    @Override
    public void buildEntrollmentDeterminationServices(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo() != null) {
            this.buildSpecialFactors(person, submitFormRequest);
            this.buildNSTData(person, submitFormRequest);
            this.buildServiceConnectionAward(person, submitFormRequest);
            MedicaidFactor mf = new MedicaidFactor();
            if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().isEligibleForMedicaid() != null && submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().isEligibleForMedicaid().booleanValue()) {
                mf.setEligibleForMedicaid(Boolean.TRUE);
                person.setMedicaidFactor(mf);
                mf.setLastUpdateDate(new Date());
            } else {
                mf.setEligibleForMedicaid(Boolean.FALSE);
                person.setMedicaidFactor(mf);
            }
        }
    }

    private void buildSpecialFactors(Person person, SubmitFormRequest submitFormRequest) {
        RadiationExposure re = new RadiationExposure();
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors() != null && submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isRadiationExposureInd() != null) {
            try {
                if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isRadiationExposureInd().booleanValue()) {
                    re.setRadiationExposureIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
                } else {
                    re.setRadiationExposureIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)"Exception @buildSpecialFactors-RadiationExposure  :", (Throwable)ex);
            }
            RadiationExposure sf = re;
            person.addSpecialFactor((SpecialFactor)sf);
        }
        AgentOrangeExposure aoe = new AgentOrangeExposure();
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors() != null && submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isAgentOrangeInd() != null) {
            try {
                if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isAgentOrangeInd().booleanValue()) {
                    aoe.setAgentOrangeExposureIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
                } else {
                    aoe.setAgentOrangeExposureIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)"Exception @buildSpecialFactors-AgentOrangeExposure  :", (Throwable)ex);
            }
            AgentOrangeExposure sfa = aoe;
            person.addSpecialFactor((SpecialFactor)sfa);
        }
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors() != null && submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isCampLejeuneInd() != null) {
            try {
                CampLejeuneVerification cl = new CampLejeuneVerification();
                cl.setChangeSource(this.getLookupService().getCampLejeuneChangeSourceByCode(CampLejeuneChangeSource.CODE_VOA.getCode()));
                if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isCampLejeuneInd().booleanValue()) {
                    cl.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
                    cl.setRegistrationDate(new ImpreciseDate(new Date()));
                } else {
                    cl.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
                }
                CampLejeuneVerification sfa = cl;
                person.addSpecialFactor((SpecialFactor)sfa);
            }
            catch (Exception ex) {
                this.logger.error((Object)"Exception @buildSpecialFactors-Camp Lejeune  :", (Throwable)ex);
            }
        }
        EnvironmentalContaminationExposure ece = new EnvironmentalContaminationExposure();
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors() != null && submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isEnvContaminantsInd() != null) {
            try {
                if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getSpecialFactors().isEnvContaminantsInd().booleanValue()) {
                    ece.setEnvironmentalContaminationExposureIndicator(this.getLookupService().getIndicatorByCode(Indicator.YES));
                } else {
                    ece.setEnvironmentalContaminationExposureIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)"Exception @buildSpecialFactors-EnvironmentalContaminationExposure  :", (Throwable)ex);
            }
            EnvironmentalContaminationExposure sfe = ece;
            person.addSpecialFactor((SpecialFactor)sfe);
        }
    }

    private void buildNSTData(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getNoseThroatRadiumInfo() != null) {
            NoseThroatRadiumInfo ntrinfo;
            NoseThroatRadium ntr = (NoseThroatRadium)this.getClinicalDetermination(NoseThroatRadium.class, person);
            if (ntr == null) {
                ntr = new NoseThroatRadium();
            }
            if ((ntrinfo = submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getNoseThroatRadiumInfo()).getReceivingTreatment() != null && ntrinfo.getReceivingTreatment().equalsIgnoreCase("true")) {
                ntr.setReceivingTreatment(TriState.TRUE);
            } else {
                ntr.setReceivingTreatment(TriState.FALSE);
            }
            if (ntrinfo.getReceivingTreatment() == null) {
                ntr.setReceivingTreatment(TriState.UNKNOWN);
            }
            person.addClinicalDetermination((ClinicalDetermination)ntr);
        }
    }

    private void buildSpinalCardInjury(Person person, SubmitFormRequest submitFormRequest) {
        SpinalCordInjuryInfo scInfo;
        SpinalCordInjury sc = (SpinalCordInjury)this.getClinicalDetermination(SpinalCordInjury.class, person);
        if (sc == null) {
            sc = new SpinalCordInjury();
        }
        if ((scInfo = submitFormRequest.getForm().getSummary().getSpinalCordInjuryInfo()) != null) {
            try {
                sc.setSpinalCordInjuryType(this.getLookupService().getSpinalCordInjuryTypeByCode(SpinalCordInjuryType.CODE_PARAPLEGIA_TRAUMATIC.getCode()));
            }
            catch (Exception ex) {
                this.logger.error((Object)"Exception @buildSpinalCardInjury :", (Throwable)ex);
            }
            person.addClinicalDetermination((ClinicalDetermination)sc);
        }
    }

    private void buildServiceConnectionAward(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getServiceConnectionAward() != null) {
            ServiceConnectionAward scAward = new ServiceConnectionAward();
            ServiceConnectionAwardInfo scaInfo = submitFormRequest.getForm().getSummary().getEnrollmentDeterminationInfo().getServiceConnectionAward();
            if (scaInfo != null) {
                if (scaInfo.isServiceConnectedIndicator() != null && scaInfo.isServiceConnectedIndicator().booleanValue()) {
                    scAward.setServiceConnectedIndicator(Boolean.TRUE);
                } else {
                    scAward.setServiceConnectedIndicator(Boolean.FALSE);
                }
                person.setServiceConnectionAward(scAward);
            }
        }
    }

    public ClinicalDetermination getClinicalDetermination(Class classObject, Person person) {
        if (person == null) {
            return null;
        }
        Set clinicalDeterminations = person.getClinicalDeterminations();
        ClinicalDetermination clinicalDetermination = null;
        if (clinicalDeterminations != null && clinicalDeterminations.size() > 0) {
            for (ClinicalDetermination temp : clinicalDeterminations) {
                if (temp == null || !temp.getClass().isAssignableFrom(classObject)) continue;
                clinicalDetermination = temp;
                break;
            }
        }
        return clinicalDetermination;
    }

    private void buildEligibilityVerification(Person person, SubmitFormRequest submitFormRequest) {
        EligibilityVerificationInfo evInfo = submitFormRequest.getForm().getSummary().getEligibilityVerificationInfo();
        if (evInfo != null) {
            EligibilityVerification ev = new EligibilityVerification();
            ev.setVerificationMethod(evInfo.getVerificationMethod());
            if (evInfo.getEligibilityStatus() != null) {
                String code = null;
                EligibilityStatus status = new EligibilityStatus();
                status.setDescription(evInfo.getEligibilityStatus());
                code = status != null ? status.getCode() : null;
                try {
                    ev.setEligibilityStatus(this.getLookupService().getEligibilityStatusByCode(code));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (evInfo.getEligibilityStatusDate() != null && !evInfo.getEligibilityStatusDate().isEmpty()) {
                ev.setEligibilityStatusDate(new ImpreciseDate(evInfo.getEligibilityStatusDate()));
            }
            person.setEligibilityVerification(ev);
        }
    }

    public LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = (LookupService)SingletonApplicationContext.getInstance().getSingletonContext().getBean("lookupService");
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

