/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.ApplicationInfo;
import gov.va.med.esr.voa.webservice.EmailInfo;
import gov.va.med.esr.voa.webservice.EmploymentInfo;
import gov.va.med.esr.voa.webservice.InsuranceInfo;
import gov.va.med.esr.voa.webservice.PersonInfo;
import gov.va.med.esr.voa.webservice.PhoneInfo;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.VeteranIdentifier;
import gov.va.med.esr.voa.webservice.builder.DemographicsBuilderFactory;
import gov.va.med.esr.voa.webservice.builder.impl.BuildHelper;
import gov.va.med.esr.voa.webservice.builder.impl.TypesHelper;
import gov.va.med.ps.model.PersonVPID;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DemographicsBuilderFactoryImpl
implements DemographicsBuilderFactory {
    private TypesHelper typesHelper = new TypesHelper();
    private BuildHelper buildHelper = new BuildHelper();

    @Override
    public void buildDemographics(Person person, SubmitFormRequest submitFormRequest) {
        List<EmailInfo> emailList;
        Address address;
        List<String> races;
        BirthRecord birthRecord;
        PersonInfo personInfo = submitFormRequest.getForm().getSummary().getPersonInfo();
        VeteranIdentifier vid = submitFormRequest.getIdentity().getVeteranIdentifier();
        PersonIdentityTraits pidt = new PersonIdentityTraits();
        Name name = new Name();
        if (personInfo != null) {
            if (personInfo.getLastName() != null) {
                name.setFamilyName(personInfo.getLastName());
            }
            if (personInfo.getFirstName() != null) {
                name.setGivenName(personInfo.getFirstName());
            }
            name.setType(this.typesHelper.getNameType(NameType.LEGAL_NAME.getCode()));
            if (personInfo.getMiddleName() != null) {
                name.setMiddleName(personInfo.getMiddleName());
            }
            if (personInfo.getSuffix() != null) {
                name.setSuffix(personInfo.getSuffix());
            }
            person.addName(name);
            pidt.addName(name);
            if (personInfo.getMothersMaidenName() != null) {
                person.setMothersMaidenName(personInfo.getMothersMaidenName());
                pidt.setMothersMaidenName(personInfo.getMothersMaidenName());
            }
            if (vid != null) {
                PersonVPID vpid = new PersonVPID(vid.getValue());
                person.setVPID(vpid);
            }
            SSN ssn = new SSN();
            if (personInfo.getSsnText() != null) {
                ssn.setSsnText(personInfo.getSsnText());
                ssn.setType(this.typesHelper.getSSNType(SSNType.CODE_ACTIVE.getCode()));
            }
            pidt.setSsn(ssn);
            person.addSsn(ssn);
            if (personInfo.getGender() != null) {
                person.setGender(this.typesHelper.getGender(personInfo.getGender()));
                pidt.setGender(this.typesHelper.getGender(personInfo.getGender()));
            }
        }
        if ((birthRecord = person.getBirthRecord()) == null) {
            birthRecord = new BirthRecord();
        }
        if (personInfo.getPlaceOfBirthCity() != null) {
            birthRecord.setCity(personInfo.getPlaceOfBirthCity());
            pidt.setPlaceOfBirthCity(personInfo.getPlaceOfBirthCity());
        }
        if (personInfo.getPlaceOfBirthState() != null) {
            birthRecord.setState(personInfo.getPlaceOfBirthState());
            pidt.setPlaceOfBirthState(personInfo.getPlaceOfBirthState());
        }
        if (personInfo.getDob() != null) {
            ImpreciseDate id = new ImpreciseDate(this.buildHelper.stringToDate(personInfo.getDob()));
            birthRecord.setBirthDate(id);
        }
        person.setBirthRecord(birthRecord);
        pidt.setBirthRecord(birthRecord);
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getMaritalStatus() != null) {
            person.setMaritalStatus(this.typesHelper.getMaritalStatus(submitFormRequest.getForm().getSummary().getDemographics().getMaritalStatus()));
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().isAppointmentRequestResponse() != null) {
            person.setAppointmentRequestResponse(submitFormRequest.getForm().getSummary().getDemographics().isAppointmentRequestResponse());
            person.setAppointmentRequestDate(new Date());
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getEthnicity() != null) {
            Ethnicity et = new Ethnicity();
            et.setEthnicityType(this.typesHelper.getEthnicityType(submitFormRequest.getForm().getSummary().getDemographics().getEthnicity()));
            person.setEthnicity(et);
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getReligion() != null && !submitFormRequest.getForm().getSummary().getDemographics().getReligion().isEmpty()) {
            person.setReligion(this.typesHelper.getReligion(submitFormRequest.getForm().getSummary().getDemographics().getReligion()));
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getRaces() != null && (races = submitFormRequest.getForm().getSummary().getDemographics().getRaces().getRace()) != null) {
            for (String racestring : races) {
                Race race = new Race();
                race.setRaceType(this.typesHelper.getRaceType(racestring));
                person.addRace(race);
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility() != null) {
            PreferredFacility pf = new PreferredFacility();
            pf.setFacility(this.typesHelper.getVAFacility(submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility()));
            person.addPreferredFacility(pf);
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() == null || submitFormRequest.getForm().getSummary().getDemographics().isAcaIndicator() != null) {
            // empty if block
        }
        if ((address = person.getPermanentAddress()) == null) {
            address = new Address();
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getAddresses() != null) {
            List<AddressInfo> addressList = submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getAddresses().getAddress();
            for (AddressInfo addressInfo : addressList) {
                address = this.buildHelper.buildAddressInfo(addressInfo);
                try {
                    address.setChangeDate(this.buildHelper.getDateXMLtoJava(submitFormRequest.getForm().getApplications().getApplicationInfo().get(0).getAppDate()));
                    address.setChangeSource(this.typesHelper.getLookupService().getAddressChangeSourceByCode(AddressChangeSource.CODE_HEC.getName()));
                    address.setChangeSite(this.typesHelper.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                person.addAddress(address);
                pidt.addAddress(address);
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getPhones() != null) {
            List<PhoneInfo> phoneList = submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getPhones().getPhone();
            for (PhoneInfo phInfo : phoneList) {
                Phone phone = new Phone();
                if (phInfo == null) continue;
                if (phInfo.getType() != null) {
                    phone.setType(this.typesHelper.getPhoneType(phInfo.getType()));
                } else {
                    phone.setType(this.typesHelper.getPhoneType("1"));
                }
                if (phInfo.getPhoneNumber() != null) {
                    phone.setPhoneNumber(phInfo.getPhoneNumber());
                }
                try {
                    phone.setChangeDate(this.buildHelper.getDateXMLtoJava(submitFormRequest.getForm().getApplications().getApplicationInfo().get(0).getAppDate()));
                    phone.setSourceOfChange(this.typesHelper.getLookupService().getPhoneSourceOfChangeByCode(PhoneSourceOfChange.CODE_HEC.getName()));
                    phone.setSiteOfChange(this.typesHelper.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                person.addPhone(phone);
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getEmails() != null && (emailList = submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getEmails().getEmail()) != null) {
            for (EmailInfo emInfo : emailList) {
                Email email = new Email();
                if (emInfo == null) continue;
                if (emInfo.getType() != null) {
                    email.setType(this.typesHelper.getEmailType(emInfo.getType()));
                } else {
                    email.setType(this.typesHelper.getEmailType("1"));
                }
                if (emInfo.getAddress() != null) {
                    email.setAddress(emInfo.getAddress());
                }
                try {
                    email.setChangeDate(this.buildHelper.getDateXMLtoJava(submitFormRequest.getForm().getApplications().getApplicationInfo().get(0).getAppDate()));
                    email.setSourceOfChange(this.typesHelper.getLookupService().getEmailSourceOfChangeByCode(PhoneSourceOfChange.CODE_HEC.getName()));
                    email.setSiteOfChange(this.typesHelper.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                person.addEmail(email);
            }
        }
        if (submitFormRequest.getForm().getSummary().getEmploymentInfo() != null) {
            Employment employment = new Employment();
            EmploymentInfo employmentInfo = submitFormRequest.getForm().getSummary().getEmploymentInfo();
            if (employmentInfo != null) {
                employment = this.buildHelper.buildEmployment(employmentInfo);
                person.setEmployment(employment);
            }
        }
        this.buildApplication(person, submitFormRequest);
        this.buildInsurance(person, submitFormRequest);
    }

    private void buildApplication(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getApplications().getApplicationInfo() != null && submitFormRequest.getForm().getApplications().getApplicationInfo() != null) {
            List<ApplicationInfo> appList = submitFormRequest.getForm().getApplications().getApplicationInfo();
            Iterator<ApplicationInfo> itr = appList.iterator();
            while (itr != null && itr.hasNext()) {
                ApplicationInfo applicationInfo = itr.next();
                Application application = new Application();
                if (applicationInfo != null) {
                    if (applicationInfo.getAppMethod() != null) {
                        application.setAppliactionMethod(this.typesHelper.getApplicationMethod("1"));
                    }
                    if (applicationInfo.getAppDate() != null) {
                        application.setApplicationDate(this.buildHelper.getDateXMLtoJava(applicationInfo.getAppDate()));
                    }
                    if (applicationInfo.getBenefitType() != null) {
                        application.setBenefitType(this.typesHelper.getBenefitType(applicationInfo.getBenefitType()));
                    }
                }
                person.setApplication(application);
            }
        }
    }

    private void buildInsurance(Person person, SubmitFormRequest submitFormRequest) {
        if (submitFormRequest.getForm().getSummary().getInsuranceList() != null && submitFormRequest.getForm().getSummary().getInsuranceList().getInsurance() != null) {
            List<InsuranceInfo> insuranceList = submitFormRequest.getForm().getSummary().getInsuranceList().getInsurance();
            Iterator<InsuranceInfo> itr = insuranceList.iterator();
            while (itr != null && itr.hasNext()) {
                InsuranceSubscriber insubr;
                InsuranceInfo insuranceInfo = itr.next();
                PrivateInsurance insurance = null;
                if (insuranceInfo.getInsuranceMappingTypeName() != null) {
                    if (insuranceInfo.getInsuranceMappingTypeName().equalsIgnoreCase("MDCR") && insuranceInfo.isEnrolledInPartA() != null && insuranceInfo.isEnrolledInPartA().booleanValue()) {
                        insurance = new Medicare();
                    }
                    if (insuranceInfo.getInsuranceMappingTypeName().equalsIgnoreCase("PI")) {
                        insurance = new PrivateInsurance();
                    }
                }
                if (insurance == null) continue;
                if (insuranceInfo.getCompanyName() != null) {
                    insurance.setCompanyName(insuranceInfo.getCompanyName());
                }
                if (insuranceInfo.getGroupNumber() != null) {
                    insurance.setGroupNumber(insuranceInfo.getGroupNumber());
                }
                if (insuranceInfo.getGroupName() != null) {
                    insurance.setGroupName(insuranceInfo.getGroupName());
                }
                if ((insubr = insurance.getSubscriber()) == null) {
                    insubr = new InsuranceSubscriber();
                }
                if (insuranceInfo.getPolicyHolderName() != null) {
                    insubr.setName(insuranceInfo.getPolicyHolderName());
                }
                try {
                    insubr.setRelationship(this.typesHelper.getLookupService().getInsuredRelationshipByCode(InsuredRelationship.CODE_VETERAN.getCode()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                insurance.setSubscriber(insubr);
                AddressInfo addressInfo = insuranceInfo.getInsAddress();
                if (addressInfo != null) {
                    insurance.setAddress(this.buildHelper.buildAddressInfo(addressInfo));
                }
                if (insuranceInfo.getInsurancePhones() != null && insuranceInfo.getInsurancePhones().getPhone() != null) {
                    List<PhoneInfo> phoneList = insuranceInfo.getInsurancePhones().getPhone();
                    for (PhoneInfo pInfo : phoneList) {
                        Phone phone = new Phone();
                        if (pInfo.getPhoneNumber() != null) {
                            phone.setPhoneNumber(pInfo.getPhoneNumber());
                        }
                        if (pInfo.getType() == null) continue;
                        if (pInfo.getType().equalsIgnoreCase("2") || pInfo.getType().equalsIgnoreCase("6")) {
                            phone.setType(this.typesHelper.getPhoneType("2"));
                            insurance.setBusinessPhone(phone);
                        }
                        if (pInfo.getType().equalsIgnoreCase("3")) {
                            phone.setType(this.typesHelper.getPhoneType(pInfo.getType()));
                            insurance.setFax(phone);
                        }
                        if (!pInfo.getType().equalsIgnoreCase("7")) continue;
                        phone.setType(this.typesHelper.getPhoneType(pInfo.getType()));
                        insurance.setPreCertificationPhone(phone);
                    }
                }
                if (insurance instanceof PrivateInsurance) {
                    if (insuranceInfo.getPolicyEffectiveDate() != null) {
                        insurance.setPolicyEffectiveDate(new ImpreciseDate(insuranceInfo.getPolicyEffectiveDate()));
                    }
                    if (insuranceInfo.getPolicyExpirationDate() != null) {
                        insurance.setPolicyExpirationDate(new ImpreciseDate(insuranceInfo.getPolicyExpirationDate()));
                    }
                    if (insuranceInfo.getPolicyNumber() != null) {
                        insurance.setPolicyNumber(insuranceInfo.getPolicyNumber());
                    }
                    person.addInsurance((InsurancePolicy)insurance);
                    continue;
                }
                if (!(insurance instanceof Medicare) || insuranceInfo.isEnrolledInPartA() == null) continue;
                ((Medicare)insurance).setEnrolledInPartA(insuranceInfo.isEnrolledInPartA());
                if (insuranceInfo.isEnrolledInPartA().booleanValue()) {
                    if (insuranceInfo.getPartAEffectiveDate() != null) {
                        ((Medicare)insurance).setPartAEffectiveDate(new ImpreciseDate(insuranceInfo.getPartAEffectiveDate()));
                    }
                    if (insuranceInfo.getSubscriber() != null) {
                        ((Medicare)insurance).setNameOnMedicareCard(insuranceInfo.getSubscriber());
                    }
                    if (insuranceInfo.getPolicyNumber() != null) {
                        ((Medicare)insurance).setMedicareClaimNumber(insuranceInfo.getPolicyNumber());
                    }
                }
                try {
                    insurance.setReportSite(this.typesHelper.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_MHV.getCode()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                person.addInsurance((InsurancePolicy)insurance);
            }
        }
    }

    @Override
    public Person getPartialPerson(SubmitFormRequest submitFormRequest) {
        List<EmailInfo> emailList;
        Address address;
        BirthRecord birthRecord;
        PersonInfo personInfo = submitFormRequest.getForm().getSummary().getPersonInfo();
        Person person = new Person();
        VeteranIdentifier vid = submitFormRequest.getIdentity().getVeteranIdentifier();
        PersonIdentityTraits pidt = new PersonIdentityTraits();
        Name name = new Name();
        if (personInfo != null) {
            if (personInfo.getLastName() != null) {
                name.setFamilyName(personInfo.getLastName());
            }
            if (personInfo.getFirstName() != null) {
                name.setGivenName(personInfo.getFirstName());
            }
            name.setType(this.typesHelper.getNameType(NameType.LEGAL_NAME.getCode()));
            if (personInfo.getMiddleName() != null) {
                name.setMiddleName(personInfo.getMiddleName());
            }
            if (personInfo.getSuffix() != null) {
                name.setSuffix(personInfo.getSuffix());
            }
            person.addName(name);
            pidt.addName(name);
            if (personInfo.getMothersMaidenName() != null) {
                person.setMothersMaidenName(personInfo.getMothersMaidenName());
                pidt.setMothersMaidenName(personInfo.getMothersMaidenName());
            }
            if (vid != null) {
                PersonVPID vpid = new PersonVPID(vid.getValue());
                person.setVPID(vpid);
            }
            SSN ssn = new SSN();
            if (personInfo.getSsnText() != null) {
                ssn.setSsnText(personInfo.getSsnText());
                ssn.setType(this.typesHelper.getSSNType(SSNType.CODE_ACTIVE.getCode()));
            }
            pidt.setSsn(ssn);
            person.addSsn(ssn);
            if (personInfo.getGender() != null) {
                person.setGender(this.typesHelper.getGender(personInfo.getGender()));
                pidt.setGender(this.typesHelper.getGender(personInfo.getGender()));
            }
        }
        if ((birthRecord = person.getBirthRecord()) == null) {
            birthRecord = new BirthRecord();
        }
        if (personInfo.getPlaceOfBirthCity() != null) {
            birthRecord.setCity(personInfo.getPlaceOfBirthCity());
            pidt.setPlaceOfBirthCity(personInfo.getPlaceOfBirthCity());
        }
        if (personInfo.getPlaceOfBirthState() != null) {
            birthRecord.setState(personInfo.getPlaceOfBirthState());
            pidt.setPlaceOfBirthState(personInfo.getPlaceOfBirthState());
        }
        if (personInfo.getDob() != null) {
            ImpreciseDate id = new ImpreciseDate(this.buildHelper.stringToDate(personInfo.getDob()));
            birthRecord.setBirthDate(id);
        }
        person.setBirthRecord(birthRecord);
        pidt.setBirthRecord(birthRecord);
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getMaritalStatus() != null) {
            person.setMaritalStatus(this.typesHelper.getMaritalStatus(submitFormRequest.getForm().getSummary().getDemographics().getMaritalStatus()));
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().isAppointmentRequestResponse() != null) {
            person.setAppointmentRequestResponse(submitFormRequest.getForm().getSummary().getDemographics().isAppointmentRequestResponse());
            person.setAppointmentRequestDate(new Date());
            System.out.println("setting app request date:" + person.getAppointmentRequestDate());
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility() != null) {
            PreferredFacility pf = new PreferredFacility();
            pf.setFacility(this.typesHelper.getVAFacility(submitFormRequest.getForm().getSummary().getDemographics().getPreferredFacility()));
            person.addPreferredFacility(pf);
        }
        if ((address = person.getPermanentAddress()) == null) {
            address = new Address();
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getAddresses() != null) {
            List<AddressInfo> addressList = submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getAddresses().getAddress();
            for (AddressInfo addressInfo : addressList) {
                address = this.buildHelper.buildAddressInfo(addressInfo);
                person.addAddress(address);
                pidt.addAddress(address);
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getPhones() != null) {
            List<PhoneInfo> phoneList = submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getPhones().getPhone();
            for (PhoneInfo phInfo : phoneList) {
                Phone phone = new Phone();
                if (phInfo == null) continue;
                if (phInfo.getType() != null) {
                    phone.setType(this.typesHelper.getPhoneType(phInfo.getType()));
                } else {
                    phone.setType(this.typesHelper.getPhoneType("1"));
                }
                if (phInfo.getPhoneNumber() != null) {
                    phone.setPhoneNumber(phInfo.getPhoneNumber());
                }
                person.addPhone(phone);
            }
        }
        if (submitFormRequest.getForm().getSummary().getDemographics() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo() != null && submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getEmails() != null && (emailList = submitFormRequest.getForm().getSummary().getDemographics().getContactInfo().getEmails().getEmail()) != null) {
            for (EmailInfo emInfo : emailList) {
                Email email = new Email();
                if (emInfo == null) continue;
                if (emInfo.getType() != null) {
                    email.setType(this.typesHelper.getEmailType(emInfo.getType()));
                } else {
                    email.setType(this.typesHelper.getEmailType("1"));
                }
                if (emInfo.getAddress() != null) {
                    email.setAddress(emInfo.getAddress());
                }
                person.addEmail(email);
            }
        }
        return person;
    }
}

