/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.AssetInfo;
import gov.va.med.esr.voa.webservice.EmploymentInfo;
import gov.va.med.esr.voa.webservice.ExpenseInfo;
import gov.va.med.esr.voa.webservice.IncomeInfo;
import gov.va.med.esr.voa.webservice.builder.impl.TypesHelper;
import gov.va.med.fw.service.AbstractComponent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Base64;

public class BuildHelper
extends AbstractComponent {
    private TypesHelper typesHelper = new TypesHelper();

    public Address buildAddressInfo(AddressInfo addressInfo) {
        Address address = new Address();
        if (addressInfo.getLine1() != null) {
            address.setLine1(addressInfo.getLine1());
        }
        if (addressInfo.getLine2() != null) {
            address.setLine2(addressInfo.getLine2());
        }
        if (addressInfo.getLine3() != null) {
            address.setLine3(addressInfo.getLine3());
        }
        if (addressInfo.getPostalCode() != null) {
            address.setPostalCode(addressInfo.getPostalCode());
        }
        if (addressInfo.getZipCode() != null) {
            address.setZipCode(addressInfo.getZipCode());
        }
        if (addressInfo.getZipPlus4() != null) {
            address.setZipPlus4(addressInfo.getZipPlus4());
        }
        if (addressInfo.getCity() != null) {
            address.setCity(addressInfo.getCity());
        }
        if (addressInfo.getState() != null) {
            address.setState(addressInfo.getState());
        }
        if (addressInfo.getCounty() != null) {
            address.setCounty(addressInfo.getCounty());
        }
        if (addressInfo.getCountry() != null) {
            address.setCountry(addressInfo.getCountry());
        }
        if (addressInfo.getAddressTypeCode() != null) {
            address.setType(this.typesHelper.getAddressType(addressInfo.getAddressTypeCode()));
        }
        if (addressInfo.getPhoneNumber() != null) {
            address.setPhoneNumber(addressInfo.getPhoneNumber());
        }
        return address;
    }

    public Employment buildEmployment(EmploymentInfo employmentInfo) {
        Employment employment = new Employment();
        if (employmentInfo.getEmployerName() != null) {
            employment.setEmployerName(employmentInfo.getEmployerName());
        }
        if (employmentInfo.getEmployerPhone() != null) {
            employment.setEmployerPhone(employmentInfo.getEmployerPhone());
        }
        if (employmentInfo.getEmploymentStatus() != null) {
            employment.setEmploymentStatus(this.typesHelper.getEmploymentStatus(employmentInfo.getEmploymentStatus()));
        }
        if (employmentInfo.getRetirementDate() != null && !employmentInfo.getRetirementDate().isEmpty()) {
            employment.setRetirementDate(new ImpreciseDate(employmentInfo.getRetirementDate()));
        }
        if (employmentInfo.getEmployerAddress() != null) {
            AddressInfo empAddress = employmentInfo.getEmployerAddress();
            employment.setEmployerAddress(this.buildAddressInfo(empAddress));
        }
        return employment;
    }

    public Asset buildAssetInfo(AssetInfo assetInfo) {
        Asset asset = new Asset();
        if (assetInfo.getAmount() != null) {
            asset.setAmount(assetInfo.getAmount());
        }
        return asset;
    }

    public Income buildIncomeInfo(IncomeInfo incomeInfo) {
        Income income = new Income();
        if (incomeInfo.getAmount() != null) {
            income.setAmount(incomeInfo.getAmount());
        }
        return income;
    }

    public Expense buildExpenseInfo(ExpenseInfo expenseInfo) {
        Expense expense = new Expense();
        if (expenseInfo.getAmount() != null) {
            expense.setAmount(expenseInfo.getAmount());
        }
        return expense;
    }

    public Date getDateXMLtoJava(XMLGregorianCalendar xdate) {
        Date date = null;
        if (xdate != null) {
            date = xdate.toGregorianCalendar().getTime();
        }
        return date;
    }

    public XMLGregorianCalendar getDateJavatoXML(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        XMLGregorianCalendar mdate = null;
        try {
            DatatypeFactory df = null;
            df = DatatypeFactory.newInstance();
            mdate = df.newXMLGregorianCalendar(gc);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception @getDateJavatoXML  :", (Throwable)ex);
        }
        return mdate;
    }

    public Date stringToDate(String string) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            date = dateFormat.parse(string);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception @stringToDate  :", (Throwable)ex);
        }
        return date;
    }

    public byte[] encodeContent(byte[] dcontent) {
        byte[] content = null;
        try {
            content = Base64.encodeBase64((byte[])dcontent);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception @encodeContent  :", (Throwable)ex);
        }
        return content;
    }

    public byte[] decodeContent(byte[] content) {
        try {
            byte[] decode = Base64.decodeBase64((byte[])content);
            return decode;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error((Object)"Exception @decodeContent  :", (Throwable)ex);
            return null;
        }
    }
}

