/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.voa.validator;

import gov.va.med.esr.voa.util.ServiceUtils;
import gov.va.med.esr.voa.validator.AbstractValidator;
import gov.va.med.esr.voa.webservice.SpouseInfo;
import gov.va.med.esr.voa.webservice.SsnCollection;
import gov.va.med.esr.voa.webservice.SsnInfo;
import gov.va.med.fw.util.StringUtils;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class SpouseInfoValidator
extends AbstractValidator {
    public boolean supports(Class clazz) {
        return SpouseInfo.class.equals((Object)clazz);
    }

    public void validate(Object target, Errors errors) {
        this.logger.debug((Object)"Spouse info validation...");
        if (target != null) {
            SsnCollection ssnCollection;
            boolean isValid;
            SpouseInfo spouseInfo = (SpouseInfo)target;
            String lastName = spouseInfo.getFamilyName();
            if (StringUtils.isBlank((String)lastName)) {
                errors.reject("VOA_0113", "Missing required field:  Spouse last name.");
            } else {
                boolean isValid2 = ServiceUtils.hasLessThan30Chars(lastName);
                if (!isValid2) {
                    errors.reject("VOA_0114", "Invalid Spouse last name.");
                }
            }
            String firstName = spouseInfo.getGivenName();
            if (StringUtils.isBlank((String)firstName)) {
                ValidationUtils.rejectIfEmpty((Errors)errors, (String)"givenName", (String)"VOA_0115", (String)"Missing required field:  Spouse first name.");
            } else {
                boolean isValid3 = ServiceUtils.hasLessThan30Chars(firstName);
                if (!isValid3) {
                    errors.reject("VOA_0116", "Invalid Spouse first name.");
                }
            }
            String middleName = spouseInfo.getMiddleName();
            if (StringUtils.isNotBlank((String)middleName) && !(isValid = ServiceUtils.hasLessThan30Chars(middleName))) {
                errors.reject("VOA_0117", "Invalid Spouse middle name.");
            }
            if ((ssnCollection = spouseInfo.getSsns()) == null) {
                errors.reject("VOA_0120", "Missing required field:  Spouse Social Security Number.");
            } else {
                List<SsnInfo> ssnList = ssnCollection.getSsn();
                if (ssnList.isEmpty()) {
                    errors.reject("VOA_0120", "Missing required field:  Spouse Social Security Number.");
                } else {
                    for (SsnInfo ssnInfo : ssnList) {
                        String ssnTxt = ssnInfo.getSsnText();
                        boolean isValid4 = ServiceUtils.validateSsn(ssnTxt);
                        if (isValid4) continue;
                        errors.reject("VOA_0121", "Invalid value for Spouse's Social Security Number.");
                        break;
                    }
                }
            }
            String dob = spouseInfo.getDob();
            if (StringUtils.isBlank((String)dob)) {
                ValidationUtils.rejectIfEmpty((Errors)errors, (String)"dob", (String)"VOA_0122", (String)"Missing required field:  Spouse's Date of Birth.");
            } else {
                boolean isValid5 = ServiceUtils.validateDate(dob);
                if (!isValid5) {
                    errors.reject("VOA_0123", "Invalid Spouse date of birth.");
                } else {
                    boolean isFutureDate = ServiceUtils.isFutureDate(dob);
                    if (isFutureDate) {
                        errors.reject("VOA_0123", "Invalid Spouse date of birth.");
                    }
                }
            }
            String startDate = spouseInfo.getStartDate();
            if (StringUtils.isNotBlank((String)startDate)) {
                boolean isValidDate = ServiceUtils.validateDate(startDate);
                boolean isValidYear = ServiceUtils.isValidYear(startDate);
                if (isValidDate || isValidYear) {
                    boolean isFutureDate = false;
                    if (isValidDate) {
                        isFutureDate = ServiceUtils.isFutureDate(startDate);
                    } else if (isValidYear) {
                        isFutureDate = ServiceUtils.isFutureYear(startDate);
                    }
                    if (isFutureDate) {
                        errors.reject("VOA_0124", "Yr required if Marr/Sep, or spouse entered.");
                        this.logger.debug((Object)"Yr required if Marr/Sep, or spouse entered.");
                    }
                } else {
                    errors.reject("VOA_0124", "Yr required if Marr/Sep, or spouse entered.");
                }
            }
        }
        this.logger.debug((Object)"Spouse info validation - Done");
    }
}

